/*
 * Decompiled with CFR 0.152.
 */
package net.cnri.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TransferQueue;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class GrowBeforeTransferQueueThreadPoolExecutor
extends ThreadPoolExecutor {
    private volatile RejectedExecutionHandler handler;
    private final TransferQueue<Runnable> workQueue;

    public GrowBeforeTransferQueueThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, (TransferQueue<Runnable>)new LinkedTransferQueue<Runnable>());
    }

    public GrowBeforeTransferQueueThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, ThreadFactory threadFactory) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, (TransferQueue<Runnable>)new LinkedTransferQueue<Runnable>(), threadFactory);
    }

    public GrowBeforeTransferQueueThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, TransferQueue<Runnable> workQueue) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, new TransferOnOfferWrapper(workQueue));
        this.workQueue = workQueue;
        this.handler = super.getRejectedExecutionHandler();
        super.setRejectedExecutionHandler(new EnqueueUnlessShutdownRejectedExecutionHandlerWrapper(this.handler));
    }

    public GrowBeforeTransferQueueThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, TransferQueue<Runnable> workQueue, ThreadFactory threadFactory) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, (BlockingQueue<Runnable>)new TransferOnOfferWrapper(workQueue), threadFactory);
        this.workQueue = workQueue;
        this.handler = super.getRejectedExecutionHandler();
        super.setRejectedExecutionHandler(new EnqueueUnlessShutdownRejectedExecutionHandlerWrapper(this.handler));
    }

    public GrowBeforeTransferQueueThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, TransferQueue<Runnable> workQueue, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, (BlockingQueue<Runnable>)new TransferOnOfferWrapper(workQueue), new EnqueueUnlessShutdownRejectedExecutionHandlerWrapper(handler));
        this.workQueue = workQueue;
        this.handler = handler;
    }

    public GrowBeforeTransferQueueThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, TransferQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, new TransferOnOfferWrapper(workQueue), threadFactory, new EnqueueUnlessShutdownRejectedExecutionHandlerWrapper(handler));
        this.workQueue = workQueue;
        this.handler = handler;
    }

    public TransferQueue<Runnable> getQueue() {
        return this.workQueue;
    }

    @Override
    public RejectedExecutionHandler getRejectedExecutionHandler() {
        return this.handler;
    }

    @Override
    public void setRejectedExecutionHandler(RejectedExecutionHandler handler) {
        if (handler == null) {
            throw new NullPointerException();
        }
        this.handler = handler;
        super.setRejectedExecutionHandler(new EnqueueUnlessShutdownRejectedExecutionHandlerWrapper(handler));
    }

    private static class TransferOnOfferWrapper
    implements TransferQueue<Runnable> {
        private final TransferQueue<Runnable> delegate;

        public TransferOnOfferWrapper(TransferQueue<Runnable> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean offer(Runnable e) {
            return this.delegate.tryTransfer(e);
        }

        @Override
        public void forEach(Consumer<? super Runnable> action) {
            this.delegate.forEach(action);
        }

        @Override
        public boolean tryTransfer(Runnable e) {
            return this.delegate.tryTransfer(e);
        }

        @Override
        public void transfer(Runnable e) throws InterruptedException {
            this.delegate.transfer(e);
        }

        @Override
        public boolean tryTransfer(Runnable e, long timeout, TimeUnit unit) throws InterruptedException {
            return this.delegate.tryTransfer(e, timeout, unit);
        }

        @Override
        public boolean hasWaitingConsumer() {
            return this.delegate.hasWaitingConsumer();
        }

        @Override
        public int getWaitingConsumerCount() {
            return this.delegate.getWaitingConsumerCount();
        }

        @Override
        public boolean add(Runnable e) {
            return this.delegate.add(e);
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        @Override
        public Runnable remove() {
            return (Runnable)this.delegate.remove();
        }

        @Override
        public Runnable poll() {
            return (Runnable)this.delegate.poll();
        }

        @Override
        public Runnable element() {
            return (Runnable)this.delegate.element();
        }

        @Override
        public Iterator<Runnable> iterator() {
            return this.delegate.iterator();
        }

        @Override
        public Runnable peek() {
            return (Runnable)this.delegate.peek();
        }

        @Override
        public void put(Runnable e) throws InterruptedException {
            this.delegate.put(e);
        }

        @Override
        public Object[] toArray() {
            return this.delegate.toArray();
        }

        @Override
        public boolean offer(Runnable e, long timeout, TimeUnit unit) throws InterruptedException {
            return this.delegate.offer(e, timeout, unit);
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.delegate.toArray(a);
        }

        @Override
        public Runnable take() throws InterruptedException {
            return (Runnable)this.delegate.take();
        }

        @Override
        public Runnable poll(long timeout, TimeUnit unit) throws InterruptedException {
            return (Runnable)this.delegate.poll(timeout, unit);
        }

        @Override
        public int remainingCapacity() {
            return this.delegate.remainingCapacity();
        }

        @Override
        public boolean remove(Object o) {
            return this.delegate.remove(o);
        }

        @Override
        public boolean contains(Object o) {
            return this.delegate.contains(o);
        }

        @Override
        public int drainTo(Collection<? super Runnable> c) {
            return this.delegate.drainTo(c);
        }

        @Override
        public int drainTo(Collection<? super Runnable> c, int maxElements) {
            return this.delegate.drainTo(c, maxElements);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.delegate.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends Runnable> c) {
            return this.delegate.addAll(c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.delegate.removeAll(c);
        }

        @Override
        public boolean removeIf(Predicate<? super Runnable> filter) {
            return this.delegate.removeIf(filter);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.delegate.retainAll(c);
        }

        @Override
        public void clear() {
            this.delegate.clear();
        }

        @Override
        public boolean equals(Object o) {
            return this.delegate.equals(o);
        }

        @Override
        public int hashCode() {
            return this.delegate.hashCode();
        }

        @Override
        public Spliterator<Runnable> spliterator() {
            return this.delegate.spliterator();
        }

        @Override
        public Stream<Runnable> stream() {
            return this.delegate.stream();
        }

        @Override
        public Stream<Runnable> parallelStream() {
            return this.delegate.parallelStream();
        }

        public String toString() {
            return this.delegate.toString();
        }
    }

    private static class EnqueueUnlessShutdownRejectedExecutionHandlerWrapper
    implements RejectedExecutionHandler {
        private final RejectedExecutionHandler delegate;

        public EnqueueUnlessShutdownRejectedExecutionHandlerWrapper(RejectedExecutionHandler delegate) {
            this.delegate = delegate;
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            if (executor.isShutdown()) {
                this.delegate.rejectedExecution(r, executor);
                return;
            }
            try {
                executor.getQueue().put(r);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

