/*
 * Decompiled with CFR 0.152.
 */
package net.cnri.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class GrowBeforeQueueThreadPoolExecutor
extends ThreadPoolExecutor {
    public static final Runnable SENTINEL_NO_OP = new Runnable(){

        @Override
        public void run() {
        }
    };
    private final BlockingQueue<Runnable> workQueue;
    private final SentinelRejectingBlockingQueueWrapper queueWrapper;
    private volatile RejectedExecutionHandler handler;
    private final AtomicLong completedSentinelCount = new AtomicLong();
    private final AtomicLong completedTaskCount = new AtomicLong();

    public GrowBeforeQueueThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, new SentinelRejectingBlockingQueueWrapper(workQueue));
        this.queueWrapper = (SentinelRejectingBlockingQueueWrapper)super.getQueue();
        this.workQueue = workQueue;
        this.handler = super.getRejectedExecutionHandler();
        super.setRejectedExecutionHandler(new SentinelIgnoringRejectedExecutionHandlerWrapper(this.handler));
    }

    public GrowBeforeQueueThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, (BlockingQueue<Runnable>)new SentinelRejectingBlockingQueueWrapper(workQueue), threadFactory);
        this.queueWrapper = (SentinelRejectingBlockingQueueWrapper)super.getQueue();
        this.workQueue = workQueue;
        this.handler = super.getRejectedExecutionHandler();
        super.setRejectedExecutionHandler(new SentinelIgnoringRejectedExecutionHandlerWrapper(this.handler));
    }

    public GrowBeforeQueueThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, (BlockingQueue<Runnable>)new SentinelRejectingBlockingQueueWrapper(workQueue), new SentinelIgnoringRejectedExecutionHandlerWrapper(handler));
        this.queueWrapper = (SentinelRejectingBlockingQueueWrapper)super.getQueue();
        this.workQueue = workQueue;
        this.handler = handler;
    }

    public GrowBeforeQueueThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, new SentinelRejectingBlockingQueueWrapper(workQueue), threadFactory, new SentinelIgnoringRejectedExecutionHandlerWrapper(handler));
        this.queueWrapper = (SentinelRejectingBlockingQueueWrapper)super.getQueue();
        this.workQueue = workQueue;
        this.handler = handler;
    }

    @Override
    public void execute(Runnable command) {
        super.execute(command);
        if (!this.queueWrapper.enoughWaiters()) {
            super.execute(SENTINEL_NO_OP);
        }
    }

    @Override
    protected final void beforeExecute(Thread t, Runnable r) {
        if (r == SENTINEL_NO_OP) {
            return;
        }
        this.beforeExecuteIgnoreSentinel(t, r);
    }

    protected void beforeExecuteIgnoreSentinel(Thread t, Runnable r) {
    }

    @Override
    protected final void afterExecute(Runnable r, Throwable t) {
        if (r == SENTINEL_NO_OP) {
            this.completedSentinelCount.incrementAndGet();
        }
        this.afterExecuteIgnoreSentinel(r, t);
    }

    protected void afterExecuteIgnoreSentinel(Runnable r, Throwable t) {
    }

    @Override
    public long getTaskCount() {
        long sentinelCount = this.completedSentinelCount.get();
        return super.getTaskCount() - sentinelCount;
    }

    @Override
    public long getCompletedTaskCount() {
        long previousRes;
        long sentinelCount = this.completedSentinelCount.get();
        long superCompletedTaskCount = super.getCompletedTaskCount();
        long res = superCompletedTaskCount - sentinelCount;
        if (res < (previousRes = this.completedTaskCount.get())) {
            return previousRes;
        }
        this.completedTaskCount.compareAndSet(previousRes, res);
        return this.completedTaskCount.get();
    }

    @Override
    public BlockingQueue<Runnable> getQueue() {
        return this.workQueue;
    }

    @Override
    public RejectedExecutionHandler getRejectedExecutionHandler() {
        return this.handler;
    }

    @Override
    public void setRejectedExecutionHandler(RejectedExecutionHandler handler) {
        if (handler == null) {
            throw new NullPointerException();
        }
        this.handler = handler;
        super.setRejectedExecutionHandler(new SentinelIgnoringRejectedExecutionHandlerWrapper(handler));
    }

    private static class SentinelRejectingBlockingQueueWrapper
    implements BlockingQueue<Runnable> {
        private final BlockingQueue<Runnable> delegate;
        private final AtomicInteger waiters = new AtomicInteger();

        public SentinelRejectingBlockingQueueWrapper(BlockingQueue<Runnable> delegate) {
            this.delegate = delegate;
        }

        public boolean enoughWaiters() {
            int size = this.delegate.size();
            if (size == 0) {
                return true;
            }
            return this.waiters.get() >= size;
        }

        @Override
        public boolean offer(Runnable e) {
            if (e == SENTINEL_NO_OP) {
                return this.enoughWaiters();
            }
            return this.delegate.offer(e);
        }

        @Override
        public boolean add(Runnable e) {
            return this.delegate.add(e);
        }

        @Override
        public boolean addAll(Collection<? extends Runnable> c) {
            return this.delegate.addAll(c);
        }

        @Override
        public void clear() {
            this.delegate.clear();
        }

        @Override
        public boolean contains(Object o) {
            return this.delegate.contains(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.delegate.containsAll(c);
        }

        @Override
        public int drainTo(Collection<? super Runnable> c, int maxElements) {
            return this.delegate.drainTo(c, maxElements);
        }

        @Override
        public int drainTo(Collection<? super Runnable> c) {
            return this.delegate.drainTo(c);
        }

        @Override
        public Runnable element() {
            return (Runnable)this.delegate.element();
        }

        @Override
        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        @Override
        public Iterator<Runnable> iterator() {
            return this.delegate.iterator();
        }

        @Override
        public boolean offer(Runnable e, long timeout, TimeUnit unit) throws InterruptedException {
            return this.delegate.offer(e, timeout, unit);
        }

        @Override
        public Runnable peek() {
            return (Runnable)this.delegate.peek();
        }

        @Override
        public Runnable poll() {
            return (Runnable)this.delegate.poll();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Runnable poll(long timeout, TimeUnit unit) throws InterruptedException {
            try {
                this.waiters.incrementAndGet();
                Runnable runnable = this.delegate.poll(timeout, unit);
                return runnable;
            }
            finally {
                this.waiters.decrementAndGet();
            }
        }

        @Override
        public void put(Runnable e) throws InterruptedException {
            this.delegate.put(e);
        }

        @Override
        public int remainingCapacity() {
            return this.delegate.remainingCapacity();
        }

        @Override
        public Runnable remove() {
            return (Runnable)this.delegate.remove();
        }

        @Override
        public boolean remove(Object o) {
            return this.delegate.remove(o);
        }

        @Override
        public boolean removeAll(Collection<?> arg0) {
            return this.delegate.removeAll(arg0);
        }

        @Override
        public boolean retainAll(Collection<?> arg0) {
            return this.delegate.retainAll(arg0);
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public Runnable take() throws InterruptedException {
            try {
                this.waiters.incrementAndGet();
                Runnable runnable = this.delegate.take();
                return runnable;
            }
            finally {
                this.waiters.decrementAndGet();
            }
        }

        @Override
        public Object[] toArray() {
            return this.delegate.toArray();
        }

        @Override
        public <T> T[] toArray(T[] arg0) {
            return this.delegate.toArray(arg0);
        }
    }

    private static class SentinelIgnoringRejectedExecutionHandlerWrapper
    implements RejectedExecutionHandler {
        private final RejectedExecutionHandler delegate;

        public SentinelIgnoringRejectedExecutionHandlerWrapper(RejectedExecutionHandler delegate) {
            this.delegate = delegate;
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            if (r == SENTINEL_NO_OP) {
                return;
            }
            this.delegate.rejectedExecution(r, executor);
        }
    }
}

