/*
 * Decompiled with CFR 0.152.
 */
package net.handle.util;

import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509TrustManager;
import net.handle.hdllib.Util;

public class TrustManagerSpecificPublicKey
implements X509TrustManager {
    final byte[] pubKeyBytes;

    public TrustManagerSpecificPublicKey(byte[] pubKeyBytes) {
        this.pubKeyBytes = pubKeyBytes;
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return new X509Certificate[0];
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (chain == null || chain.length == 0) {
            throw new IllegalArgumentException("null or empty certificate chain");
        }
        this.authenticate(chain[0]);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (chain == null || chain.length == 0) {
            throw new IllegalArgumentException("null or empty certificate chain");
        }
        this.authenticate(chain[0]);
    }

    private void authenticate(X509Certificate cert) throws CertificateException {
        try {
            byte[] certPubKeyBytes = this.getPublicKeyBytesFromCertificate(cert);
            if (Util.equals(this.pubKeyBytes, certPubKeyBytes)) {
                return;
            }
        }
        catch (CertificateException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CertificateException("Exception validating X509 certificate", e);
        }
        throw new CertificateException("Unable to validate X509 certificate, public key does not match expected public key");
    }

    private byte[] getPublicKeyBytesFromCertificate(Certificate certificate) throws Exception {
        return Util.getBytesFromPublicKey(certificate.getPublicKey());
    }
}

