/*
 * Decompiled with CFR 0.152.
 */
package net.handle.server.txnlog;

import java.time.ZonedDateTime;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.handle.hdllib.TransactionQueueInterface;
import net.handle.hdllib.TransactionQueuesInterface;

public class TransactionQueuePruner {
    private final ScheduledExecutorService execServ;
    private final TransactionQueueInterface txnQueue;
    private final TransactionQueuesInterface otherTxnQueues;
    private final int daysToKeep;

    public TransactionQueuePruner(TransactionQueueInterface txnQueue, TransactionQueuesInterface otherTxnQueues, int daysToKeep) {
        this.daysToKeep = daysToKeep;
        this.txnQueue = txnQueue;
        this.otherTxnQueues = otherTxnQueues;
        this.execServ = Executors.newScheduledThreadPool(1);
        ((ScheduledThreadPoolExecutor)this.execServ).setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        ((ScheduledThreadPoolExecutor)this.execServ).setRemoveOnCancelPolicy(true);
    }

    public void start() throws Exception {
        if (this.daysToKeep <= 0) {
            return;
        }
        this.execServ.scheduleAtFixedRate(this::prune, 0L, 1L, TimeUnit.DAYS);
    }

    public void stop() {
        try {
            if (this.execServ != null) {
                this.execServ.shutdown();
                this.execServ.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
            }
        }
        catch (Exception e) {
            System.err.println("Error stopping transaction log pruner.");
            e.printStackTrace();
        }
    }

    public void runOnceNow() {
        this.prune();
    }

    private void prune() {
        try {
            long deleteUntilSeconds = ZonedDateTime.now().minusDays(this.daysToKeep).toInstant().toEpochMilli();
            if (this.txnQueue != null) {
                this.txnQueue.deleteUntilDate(deleteUntilSeconds);
            }
            if (this.otherTxnQueues != null) {
                for (String name : this.otherTxnQueues.listQueueNames()) {
                    this.otherTxnQueues.getQueue(name).deleteUntilDate(deleteUntilSeconds);
                }
            }
        }
        catch (Throwable e) {
            System.err.println("Exception pruning transaction queue: " + e);
            e.printStackTrace();
        }
    }
}

