/*
 * Decompiled with CFR 0.152.
 */
package net.handle.server.txnlog;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.cnri.util.StreamTable;
import net.cnri.util.StringUtils;
import net.handle.hdllib.TransactionQueueInterface;
import net.handle.hdllib.TransactionQueuesInterface;
import net.handle.server.txnlog.BdbjeTransactionQueue;

public class BdbjeTransactionQueues
implements TransactionQueuesInterface {
    private final Map<String, TransactionQueueInterface> queues = new HashMap<String, TransactionQueueInterface>();
    private final File queueDir;
    private File othersDir;
    private static final String OTHER_SERVERS_DIR = "others";
    private final TransactionQueueInterface thisServersTransactionQueue;
    private final StreamTable config;

    public BdbjeTransactionQueues(File queueDir, TransactionQueueInterface thisServersTransactionQueue, StreamTable config) {
        this.queueDir = queueDir;
        this.thisServersTransactionQueue = thisServersTransactionQueue;
        this.config = config;
        this.loadQueuesFromOthersDir();
    }

    private void loadQueuesFromOthersDir() {
        this.othersDir = new File(this.queueDir, OTHER_SERVERS_DIR);
        if (this.othersDir.exists()) {
            File[] othersDirList;
            for (File file : othersDirList = this.othersDir.listFiles()) {
                if (!file.isDirectory()) continue;
                try {
                    BdbjeTransactionQueue queue = new BdbjeTransactionQueue(file, this.config);
                    String name = StringUtils.decodeURL((String)file.getName());
                    this.queues.put(name, queue);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public synchronized TransactionQueueInterface createNewQueue(String name) throws Exception {
        if (this.queues.containsKey(name)) {
            throw new IllegalArgumentException("Cannot create a transaction queue for " + name + " as one already exists.");
        }
        String sourceDirName = StringUtils.encodeURLComponent((String)name);
        if (this.othersDir == null) {
            this.othersDir = new File(this.queueDir, OTHER_SERVERS_DIR);
            this.othersDir.mkdirs();
        }
        File sourceDir = new File(this.othersDir, sourceDirName);
        sourceDir.mkdirs();
        BdbjeTransactionQueue queue = new BdbjeTransactionQueue(sourceDir, this.config);
        this.queues.put(name, queue);
        return queue;
    }

    @Override
    public TransactionQueueInterface getThisServersTransactionQueue() {
        return this.thisServersTransactionQueue;
    }

    @Override
    public List<String> listQueueNames() {
        return new ArrayList<String>(this.queues.keySet());
    }

    @Override
    public TransactionQueueInterface getQueue(String name) {
        return this.queues.get(name);
    }

    @Override
    public synchronized TransactionQueueInterface getOrCreateTransactionQueue(String name) throws Exception {
        TransactionQueueInterface result = this.getQueue(name);
        if (result == null) {
            result = this.createNewQueue(name);
        }
        return result;
    }

    @Override
    public void shutdown() {
        for (TransactionQueueInterface txnQueue : this.queues.values()) {
            txnQueue.shutdown();
        }
    }
}

