/*
 * Decompiled with CFR 0.152.
 */
package net.handle.server.txnlog;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Durability;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;
import net.cnri.util.StreamTable;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.Transaction;
import net.handle.hdllib.TransactionScannerInterface;
import net.handle.server.bdbje.JeUpgradeTool;
import net.handle.server.txnlog.AbstractTransactionQueue;

public class BdbjeTransactionQueue
extends AbstractTransactionQueue {
    private static final String DB_DIR_NAME = "db";
    private final Environment dbEnvironment;
    private final Database txnLogDatabase;
    private volatile long lastTxnId = 0L;
    private volatile long firstDate = Long.MAX_VALUE;
    private boolean shutdown;
    private final boolean readonly;

    public BdbjeTransactionQueue(File queueDir, StreamTable config) throws Exception {
        File dbDir = new File(queueDir, DB_DIR_NAME);
        if (!dbDir.exists()) {
            dbDir.mkdirs();
        }
        this.readonly = config.getBoolean("read_only_txn_queue", false);
        EnvironmentConfig envConfig = new EnvironmentConfig();
        envConfig.setAllowCreate(true);
        envConfig.setSharedCache(true);
        envConfig.setTransactional(true);
        envConfig.setLockTimeout((long)config.getInt("bdbje_timeout", 0), TimeUnit.MICROSECONDS);
        envConfig.setDurability(config.getBoolean("bdbje_no_sync_on_write", false) ? Durability.COMMIT_WRITE_NO_SYNC : Durability.COMMIT_SYNC);
        envConfig.setReadOnly(this.readonly);
        envConfig.setConfigParam("je.freeDisk", "0");
        this.dbEnvironment = JeUpgradeTool.openEnvironment(dbDir, envConfig);
        DatabaseConfig dbConfig = new DatabaseConfig();
        dbConfig.setAllowCreate(true);
        dbConfig.setTransactional(true);
        dbConfig.setReadOnly(this.readonly);
        this.txnLogDatabase = this.dbEnvironment.openDatabase(null, "txnLogDatabase", dbConfig);
        this.lastTxnId = this.calculateLastTxnId();
        this.firstDate = this.calculateFirstDate();
    }

    @Override
    public long getLastTxnId() {
        return this.lastTxnId;
    }

    @Override
    public long getFirstDate() {
        return this.firstDate;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long calculateFirstDate() {
        try {
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry data = new DatabaseEntry();
            try (Cursor cursor = this.txnLogDatabase.openCursor(null, CursorConfig.READ_UNCOMMITTED);){
                OperationStatus status = cursor.getNext(key, data, LockMode.READ_UNCOMMITTED);
                if (status == OperationStatus.NOTFOUND) {
                    long l = Long.MAX_VALUE;
                    return l;
                }
                if (status != OperationStatus.SUCCESS) throw new RuntimeException("Error getting first date; status " + status);
                long l = Encoder.readLong(data.getData(), 9);
                return l;
            }
        }
        catch (DatabaseException e) {
            throw new RuntimeException("Error getting first date", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long calculateLastTxnId() {
        try {
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry data = new DatabaseEntry();
            try (Cursor cursor = this.txnLogDatabase.openCursor(null, CursorConfig.READ_UNCOMMITTED);){
                OperationStatus status = cursor.getPrev(key, data, LockMode.READ_UNCOMMITTED);
                if (status == OperationStatus.NOTFOUND) {
                    long l = 0L;
                    return l;
                }
                if (status != OperationStatus.SUCCESS) throw new RuntimeException("Error getting last transaction id; status " + status);
                long l = Encoder.readLong(key.getData(), 0);
                return l;
            }
        }
        catch (DatabaseException e) {
            throw new RuntimeException("Error getting last transaction id", e);
        }
    }

    @Override
    public void addTransaction(long txnId, byte[] handle, HandleValue[] values, byte action, long date) throws Exception {
        if (this.readonly) {
            throw new HandleException(18, "Transaction queue is read-only");
        }
        if (txnId <= 0L) {
            throw new HandleException(0, "An attempt was made to store a transaction with zero or negative txnId.");
        }
        this.lastTxnId = txnId;
        if (this.firstDate == Long.MAX_VALUE) {
            this.firstDate = date;
        }
        Transaction txn = new Transaction(txnId, handle, values, action, date);
        BytesMap bytesMap = new BytesMap(txn);
        this.txnLogDatabase.put(null, bytesMap.getKey(), bytesMap.getData());
        this.notifyQueueListeners(txn);
    }

    @Override
    public synchronized void shutdown() {
        if (this.shutdown) {
            return;
        }
        this.shutdownQueueListeners();
        try {
            this.shutdown = true;
            if (this.txnLogDatabase != null) {
                try {
                    this.txnLogDatabase.close();
                }
                catch (IllegalStateException e) {
                    Thread.sleep(1000L);
                    this.txnLogDatabase.close();
                }
            }
            if (this.dbEnvironment != null) {
                this.dbEnvironment.close();
            }
        }
        catch (Exception e) {
            System.err.println("Error closing environment");
            e.printStackTrace();
        }
    }

    @Override
    public void deleteUntilDate(long date) {
        long lastId = this.getLastIdBeforeDate(date);
        this.deleteUpToAndIncludingId(lastId);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long getLastIdBeforeDate(long date) {
        try (Cursor cursor = this.txnLogDatabase.openCursor(null, CursorConfig.READ_UNCOMMITTED);){
            if (date < 0L) {
                date = 0L;
            }
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry data = new DatabaseEntry();
            long lastId = -1L;
            long currId = -1L;
            while (cursor.getNext(key, data, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                if (this.shutdown) {
                    long l = -1L;
                    return l;
                }
                lastId = currId;
                Transaction txn = BdbjeTransactionQueue.readTxn(data.getData());
                if (txn.date >= date) {
                    long l = lastId;
                    return l;
                }
                currId = txn.txnId;
            }
            long l = lastId;
            return l;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void deleteUpToAndIncludingId(long lastId) {
        boolean done = false;
        while (!done) {
            com.sleepycat.je.Transaction dbTxn = this.txnLogDatabase.getEnvironment().beginTransaction(null, null);
            try (Cursor cursor = this.txnLogDatabase.openCursor(dbTxn, CursorConfig.READ_UNCOMMITTED);){
                int count;
                DatabaseEntry key = new DatabaseEntry();
                DatabaseEntry data = new DatabaseEntry();
                done = true;
                for (count = 0; count < 1000 && cursor.getNext(key, data, LockMode.DEFAULT) == OperationStatus.SUCCESS; ++count) {
                    done = false;
                    if (this.shutdown) {
                        done = true;
                        break;
                    }
                    Transaction txn = BdbjeTransactionQueue.readTxn(data.getData());
                    if (txn.txnId <= lastId) {
                        cursor.delete();
                        continue;
                    }
                    done = true;
                    break;
                }
                if (count == 0) {
                    done = true;
                }
                cursor.close();
            }
            catch (Exception e) {
                dbTxn.abort();
                dbTxn = null;
                throw new RuntimeException(e);
            }
            finally {
                if (dbTxn != null) {
                    dbTxn.commit();
                }
            }
            this.firstDate = this.calculateFirstDate();
        }
    }

    @Override
    public TransactionScannerInterface getScanner(long lastTxnId) throws Exception {
        return new QueueScanner(lastTxnId);
    }

    public static byte[] toByteArray(long data) {
        return new byte[]{(byte)(data >> 56 & 0xFFL), (byte)(data >> 48 & 0xFFL), (byte)(data >> 40 & 0xFFL), (byte)(data >> 32 & 0xFFL), (byte)(data >> 24 & 0xFFL), (byte)(data >> 16 & 0xFFL), (byte)(data >> 8 & 0xFFL), (byte)(data >> 0 & 0xFFL)};
    }

    public static long fromByteArray(byte[] bytes) {
        long result = 0L;
        for (byte b : bytes) {
            result = (result << 8) + (long)(b & 0xFF);
        }
        return result;
    }

    private static void encodeTransaction(Transaction txn, OutputStream out) throws IOException {
        byte[] buf = new byte[8];
        Encoder.writeLong(buf, 0, txn.txnId);
        out.write(buf);
        out.write(txn.action);
        Encoder.writeLong(buf, 0, txn.date);
        out.write(buf);
        Encoder.writeInt(buf, 0, txn.hashOnAll);
        out.write(buf, 0, 4);
        Encoder.writeInt(buf, 0, txn.hashOnNA);
        out.write(buf, 0, 4);
        Encoder.writeInt(buf, 0, txn.hashOnId);
        out.write(buf, 0, 4);
        Encoder.writeInt(buf, 0, txn.handle.length);
        out.write(buf, 0, 4);
        out.write(txn.handle);
    }

    static Transaction readTxn(byte[] buf) {
        Transaction txn = new Transaction();
        txn.txnId = Encoder.readLong(buf, 0);
        txn.action = buf[8];
        txn.date = Encoder.readLong(buf, 9);
        txn.hashOnAll = Encoder.readInt(buf, 17);
        txn.hashOnNA = Encoder.readInt(buf, 21);
        txn.hashOnId = Encoder.readInt(buf, 25);
        try {
            txn.handle = Encoder.readByteArray(buf, 29);
        }
        catch (HandleException e) {
            throw new RuntimeException(e);
        }
        return txn;
    }

    public static void main(String[] args) throws Exception {
        long lastTxnId = 0L;
        if (args.length == 0) {
            System.out.println("Queue dir missing from args.");
            return;
        }
        String dirName = args[0];
        File dir = new File(dirName);
        if (!dir.exists()) {
            System.out.println(dirName + " directory is missing.");
        }
        if (args.length > 1) {
            lastTxnId = Long.parseLong(args[1]);
        }
        StreamTable config = new StreamTable();
        config.put("read_only_txn_queue", true);
        config.put("bdbje_no_sync_on_write", false);
        BdbjeTransactionQueue queue = new BdbjeTransactionQueue(dir, config);
        QueueScanner scanner = (QueueScanner)queue.getScanner(lastTxnId);
        Transaction txn = null;
        while ((txn = scanner.nextTransaction()) != null) {
            System.out.println(txn.toString());
        }
        scanner.close();
    }

    private class QueueScanner
    implements TransactionScannerInterface {
        private Cursor cursor;
        private Transaction next = null;

        QueueScanner(long afterTxnId) throws Exception {
            if (afterTxnId < 0L) {
                afterTxnId = 0L;
            }
            DatabaseEntry key = new DatabaseEntry(BdbjeTransactionQueue.toByteArray(afterTxnId));
            DatabaseEntry data = new DatabaseEntry();
            this.cursor = BdbjeTransactionQueue.this.txnLogDatabase.openCursor(null, CursorConfig.READ_UNCOMMITTED);
            try {
                OperationStatus status = this.cursor.getSearchKeyRange(key, data, LockMode.READ_UNCOMMITTED);
                if (status != OperationStatus.SUCCESS) {
                    this.cursor.close();
                    this.cursor = null;
                } else {
                    long keyAsLong = BdbjeTransactionQueue.fromByteArray(key.getData());
                    if (keyAsLong > afterTxnId) {
                        this.next = BdbjeTransactionQueue.readTxn(data.getData());
                    }
                }
            }
            catch (Exception e) {
                this.close();
                throw e;
            }
        }

        @Override
        public Transaction nextTransaction() {
            if (this.next == null) {
                return this.getNextFromDB();
            }
            Transaction result = this.next;
            this.next = null;
            return result;
        }

        private Transaction getNextFromDB() {
            if (this.cursor == null) {
                return null;
            }
            if (BdbjeTransactionQueue.this.shutdown) {
                this.cursor.close();
                this.cursor = null;
                return null;
            }
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry data = new DatabaseEntry();
            try {
                boolean success;
                boolean bl = success = this.cursor.getNext(key, data, LockMode.READ_UNCOMMITTED) == OperationStatus.SUCCESS;
                if (success) {
                    Transaction result = BdbjeTransactionQueue.readTxn(data.getData());
                    return result;
                }
                this.cursor.close();
                this.cursor = null;
                return null;
            }
            catch (DatabaseException e) {
                throw new RuntimeException(e);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void close() {
            if (this.cursor == null) {
                return;
            }
            try {
                this.cursor.close();
                this.cursor = null;
            }
            catch (DatabaseException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class BytesMap {
        private final byte[] key;
        private final byte[] data;

        public BytesMap(Transaction txn) throws IOException {
            this.key = BdbjeTransactionQueue.toByteArray(txn.txnId);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            BdbjeTransactionQueue.encodeTransaction(txn, out);
            this.data = out.toByteArray();
        }

        public DatabaseEntry getKey() {
            return new DatabaseEntry(this.key);
        }

        public DatabaseEntry getData() {
            return new DatabaseEntry(this.data);
        }
    }
}

