/*
 * Decompiled with CFR 0.152.
 */
package net.handle.server.txnlog;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.handle.hdllib.Transaction;
import net.handle.hdllib.TransactionQueueInterface;
import net.handle.hdllib.TransactionQueueListener;

public abstract class AbstractTransactionQueue
implements TransactionQueueInterface {
    protected List<TransactionQueueListener> queueListeners = new CopyOnWriteArrayList<TransactionQueueListener>();

    @Override
    public void addTransaction(Transaction txn) throws Exception {
        this.addTransaction(txn.txnId, txn.handle, txn.values, txn.action, txn.date);
    }

    @Override
    public void addQueueListener(TransactionQueueListener l) {
        this.queueListeners.add(l);
    }

    @Override
    public void removeQueueListener(TransactionQueueListener l) {
        this.queueListeners.remove(l);
    }

    protected void notifyQueueListeners(Transaction txn) {
        for (TransactionQueueListener listener : this.queueListeners) {
            try {
                listener.transactionAdded(txn);
            }
            catch (Exception e) {
                System.err.println("error notifying queue listeners: " + e);
                e.printStackTrace(System.err);
            }
        }
    }

    protected void shutdownQueueListeners() {
        for (TransactionQueueListener listener : this.queueListeners) {
            try {
                listener.shutdown();
            }
            catch (Exception e) {
                System.err.println("error in queue listeners shutdown: " + e);
                e.printStackTrace(System.err);
            }
        }
    }
}

