/*
 * Decompiled with CFR 0.152.
 */
package net.handle.server.servletcontainer.servlets;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.AuthenticationInfo;
import net.handle.hdllib.Common;
import net.handle.hdllib.Util;
import net.handle.hdllib.ValueReference;
import net.handle.hdllib.VerifyAuthRequest;
import net.handle.server.servletcontainer.auth.StandardHandleAuthenticator;
import net.handle.server.servletcontainer.servlets.BaseHandleRequestProcessingServlet;
import org.apache.commons.codec.binary.Base64;

public class VerificationsServlet
extends BaseHandleRequestProcessingServlet {
    public VerificationsServlet() {
        this.allowString = "GET, HEAD, TRACE, OPTIONS";
    }

    @Override
    protected void doGet(HttpServletRequest servletReq, HttpServletResponse servletResp) throws ServletException, IOException {
        AbstractResponse resp;
        VerifyAuthRequest req;
        String handle = VerificationsServlet.getPath(servletReq);
        if (handle.isEmpty()) {
            req = null;
            resp = VerificationsServlet.errorResponseFromException(new Exception("Handle not specified in verification request"));
        } else {
            try {
                req = VerificationsServlet.getVerificationRequest(handle, servletReq);
                resp = this.processRequest(servletReq, req);
            }
            catch (Exception e) {
                req = null;
                resp = VerificationsServlet.errorResponseFromException(e);
            }
        }
        this.processResponse(servletReq, servletResp, req, resp);
    }

    private static VerifyAuthRequest getVerificationRequest(String handle, HttpServletRequest servletReq) throws Exception {
        byte[] sigBytes;
        ValueReference handleAndIndex = VerificationsServlet.getValueReferenceFromIndexColonHandle(handle);
        int[] indexes = VerificationsServlet.getIndexes(servletReq);
        if (indexes == null || indexes.length == 0) {
            if (handleAndIndex.index == -1) {
                throw new Exception("No index provided");
            }
        } else {
            if (indexes.length > 1 || handleAndIndex.index >= 0) {
                throw new Exception("Too many indexes specified in verification request");
            }
            handleAndIndex.index = indexes[0];
        }
        String nonce = servletReq.getParameter("nonce");
        String cnonce = servletReq.getParameter("cnonce");
        String alg = servletReq.getParameter("alg");
        String signature = servletReq.getParameter("signature");
        if (nonce == null || cnonce == null || alg == null || signature == null) {
            throw new Exception("Missing parameters in verification request");
        }
        byte[] nonceBytes = Base64.decodeBase64((String)nonce);
        byte[] cnonceBytes = Base64.decodeBase64((String)cnonce);
        byte[] decodedSignatureBytes = Base64.decodeBase64((String)signature);
        byte[] algBytes = Util.encodeString(alg);
        if (Util.equalsIgnoreCaseAndPunctuation(algBytes, Common.HASH_ALG_PBKDF2_HMAC_SHA1) || Util.equalsIgnoreCaseAndPunctuation(algBytes, Common.HASH_ALG_PBKDF2_HMAC_SHA1_ALTERNATE)) {
            String salt = servletReq.getParameter("salt");
            String iterationsString = servletReq.getParameter("iterations");
            String keyLengthString = servletReq.getParameter("length");
            if (salt != null && iterationsString != null && keyLengthString != null) {
                decodedSignatureBytes = Util.constructPbkdf2Encoding(Base64.decodeBase64((String)salt), Integer.parseInt(iterationsString), Integer.parseInt(keyLengthString), decodedSignatureBytes);
            }
        }
        if ((sigBytes = StandardHandleAuthenticator.constructSignedResponse("HS_SECKEY", alg, decodedSignatureBytes)) == null) {
            throw new Exception("Unknown algorithm");
        }
        AuthenticationInfo authInfo = VerificationsServlet.getAuthenticationInfo(servletReq);
        VerifyAuthRequest verifyAuthReq = new VerifyAuthRequest(handleAndIndex.handle, nonceBytes, cnonceBytes, StandardHandleAuthenticator.hashTypeForCnonce(cnonceBytes), sigBytes, handleAndIndex.index, authInfo);
        return verifyAuthReq;
    }

    private static boolean isDigits(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch >= '0' && ch <= '9') continue;
            return false;
        }
        return true;
    }

    private static ValueReference getValueReferenceFromIndexColonHandle(String indexColonHandle) {
        if (indexColonHandle == null) {
            return null;
        }
        int colon = indexColonHandle.indexOf(58);
        if (colon < 0) {
            return new ValueReference(Util.encodeString(indexColonHandle), -1);
        }
        String maybeIndex = indexColonHandle.substring(0, colon);
        if (VerificationsServlet.isDigits(maybeIndex)) {
            String handle = indexColonHandle.substring(colon + 1);
            return new ValueReference(Util.encodeString(handle), Integer.parseInt(maybeIndex));
        }
        return new ValueReference(Util.encodeString(indexColonHandle), -1);
    }
}

