/*
 * Decompiled with CFR 0.152.
 */
package net.handle.server.servletcontainer.servlets;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.cnri.util.FastDateFormat;
import net.handle.server.servletcontainer.servlets.BaseHandleRequestProcessingServlet;

public class UncaughtExceptionsFilter
implements Filter {
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
            this.doHttpFilter((HttpServletRequest)request, (HttpServletResponse)response, chain);
        } else {
            chain.doFilter(request, response);
        }
    }

    private void doHttpFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException {
        try {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        catch (Exception e) {
            String requestUri = request.getRequestURI();
            String queryString = request.getQueryString();
            if (queryString != null) {
                requestUri = requestUri + "?" + queryString;
            }
            System.err.println(FastDateFormat.getLocalFormat().formatNow() + " Unexpected error processing API request " + request.getMethod() + " " + requestUri);
            e.printStackTrace();
            JsonObject json = new JsonObject();
            json.addProperty("responseCode", (Number)2);
            json.addProperty("message", "Unexpected server error");
            BaseHandleRequestProcessingServlet.processResponse(request, response, 500, (JsonElement)json);
        }
    }

    public void destroy() {
    }
}

