/*
 * Decompiled with CFR 0.152.
 */
package net.handle.server.servletcontainer.servlets;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.cnri.util.StringUtils;
import net.handle.hdllib.GsonUtility;
import net.handle.server.servletcontainer.TlsRenegotiationRequestor;
import net.handle.server.servletcontainer.auth.AuthenticationInfoWithId;
import net.handle.server.servletcontainer.auth.AuthenticationResponse;
import net.handle.server.servletcontainer.auth.HandleAuthenticationStatus;
import net.handle.server.servletcontainer.auth.HandleAuthorizationHeader;
import net.handle.server.servletcontainer.auth.StandardHandleAuthenticator;
import net.handle.server.servletcontainer.servlets.BaseHandleRequestProcessingServlet;
import net.handle.server.servletcontainer.servlets.JsonParameterServletReq;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.jetty.server.SessionManager;

public class SessionsServlet
extends BaseHandleRequestProcessingServlet {
    private SessionManager sessionManager;

    public SessionsServlet() {
        this.allowString = "GET, HEAD, POST, PUT, DELETE, TRACE, OPTIONS";
    }

    @Override
    public void init() throws ServletException {
        super.init();
        this.sessionManager = (SessionManager)this.getServletContext().getAttribute(SessionManager.class.getName());
    }

    @Override
    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        HandleAuthorizationHeader handleAuthHeader;
        Object wrappedReq;
        String method = req.getMethod();
        if ("TRACE".equals(method)) {
            super.service(req, resp);
            return;
        }
        if (!req.isSecure() && !"OPTIONS".equals(method)) {
            resp.setStatus(403);
            return;
        }
        String path = SessionsServlet.getPath(req);
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (path.isEmpty()) {
            if (!"POST".equals(method)) {
                if (!"OPTIONS".equals(method)) {
                    resp.setStatus(405);
                }
                resp.setHeader("Allow", "POST, TRACE, OPTIONS");
                return;
            }
        } else {
            if ("OPTIONS".equals(method)) {
                resp.setHeader("Allow", "GET, HEAD, POST, PUT, DELETE, TRACE, OPTIONS");
                return;
            }
            if (!"this".equals(path)) {
                resp.setStatus(403);
                return;
            }
        }
        if ((wrappedReq = (HttpServletRequest)req.getAttribute(SessionsServlet.class.getName() + ".wrappedReq")) == null) {
            wrappedReq = req;
            if (BaseHandleRequestProcessingServlet.hasJsonEntity(req)) {
                try {
                    wrappedReq = new JsonParameterServletReq(req);
                }
                catch (JsonParseException e) {
                    resp.setStatus(400);
                    return;
                }
                catch (IOException e) {
                    resp.setStatus(500);
                    return;
                }
            }
        }
        if (this.isAsyncTlsRenegotiate(handleAuthHeader = HandleAuthorizationHeader.fromHeaderAndParameters(req.getHeader("Authorization"), wrappedReq), req, (HttpServletRequest)wrappedReq, resp)) {
            return;
        }
        req.setAttribute(HandleAuthorizationHeader.class.getName(), (Object)handleAuthHeader);
        if (!path.isEmpty() && "POST".equals(method)) {
            this.doPut(req, resp);
            return;
        }
        super.service(req, resp);
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        HandleAuthorizationHeader handleAuthHeader = (HandleAuthorizationHeader)req.getAttribute(HandleAuthorizationHeader.class.getName());
        HttpSession session = req.getSession(false);
        if (handleAuthHeader != null && handleAuthHeader.getSessionId() != null && session == null && this.sessionManager != null) {
            session = this.sessionManager.getHttpSession(handleAuthHeader.getSessionId());
        }
        if (session == null && handleAuthHeader != null && handleAuthHeader.requiresSession()) {
            resp.setStatus(403);
            return;
        }
        AuthenticationResponse authResp = this.getAuthenticationResponse(handleAuthHeader, req, session);
        if (authResp.isAuthenticating() && !authResp.isAuthenticated()) {
            resp.setStatus(401);
        } else {
            resp.setStatus(200);
        }
        resp.setContentType("application/json");
        resp.setCharacterEncoding("UTF-8");
        GsonUtility.getGson().toJson((JsonElement)this.getSessionRepresentation(authResp), (Appendable)resp.getWriter());
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        HandleAuthorizationHeader handleAuthHeader = (HandleAuthorizationHeader)req.getAttribute(HandleAuthorizationHeader.class.getName());
        if (handleAuthHeader != null && handleAuthHeader.getSessionId() != null) {
            resp.setStatus(400);
            return;
        }
        HttpSession session = req.getSession();
        AuthenticationResponse authResp = this.getAuthenticationResponse(handleAuthHeader, req, session);
        resp.setStatus(201);
        String newPath = req.getContextPath() + req.getServletPath();
        if (!newPath.endsWith("/")) {
            newPath = newPath + "/";
        }
        newPath = newPath + "this";
        resp.setHeader("Location", StringUtils.encodeURLPath((String)newPath));
        resp.setContentType("application/json");
        resp.setCharacterEncoding("UTF-8");
        GsonUtility.getGson().toJson((JsonElement)this.getSessionRepresentation(authResp), (Appendable)resp.getWriter());
    }

    private boolean isAsyncTlsRenegotiate(HandleAuthorizationHeader handleAuthHeader, HttpServletRequest req, HttpServletRequest wrappedReq, HttpServletResponse resp) throws IOException {
        if (handleAuthHeader == null) {
            return false;
        }
        if (!req.isSecure()) {
            return false;
        }
        Boolean wantClientAuth = handleAuthHeader.getClientCertAsBooleanObject();
        if (wantClientAuth == null && !handleAuthHeader.isRequestingForceRenegotiate()) {
            return false;
        }
        TlsRenegotiationRequestor tlsRenegotiationRequestor = (TlsRenegotiationRequestor)req.getAttribute(TlsRenegotiationRequestor.class.getName());
        boolean isWanting = tlsRenegotiationRequestor.isWantingTlsRenegotiation(wantClientAuth, handleAuthHeader.isRequestingForceRenegotiate());
        if (!isWanting) {
            return false;
        }
        if (wantClientAuth != null && !wantClientAuth.booleanValue() && tlsRenegotiationRequestor.isNeedClientAuth()) {
            resp.setStatus(403);
            return true;
        }
        req.setAttribute(SessionsServlet.class.getName() + ".wrappedReq", (Object)wrappedReq);
        tlsRenegotiationRequestor.requestTlsRenegotiation(null, wantClientAuth);
        return true;
    }

    @Override
    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        HandleAuthorizationHeader handleAuthHeader = (HandleAuthorizationHeader)req.getAttribute(HandleAuthorizationHeader.class.getName());
        HttpSession session = req.getSession(false);
        if (handleAuthHeader != null && handleAuthHeader.getSessionId() != null && session == null && this.sessionManager != null) {
            session = this.sessionManager.getHttpSession(handleAuthHeader.getSessionId());
        }
        if (session == null && handleAuthHeader != null && handleAuthHeader.requiresSession()) {
            resp.setStatus(403);
            return;
        }
        AuthenticationResponse authResp = this.getAuthenticationResponse(handleAuthHeader, req, session);
        if (authResp.isAuthenticating() && !authResp.isAuthenticated()) {
            resp.setStatus(401);
        } else {
            resp.setStatus(200);
        }
        resp.setContentType("application/json");
        resp.setCharacterEncoding("UTF-8");
        GsonUtility.getGson().toJson((JsonElement)this.getSessionRepresentation(authResp), (Appendable)resp.getWriter());
    }

    @Override
    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        HandleAuthorizationHeader handleAuthHeader = (HandleAuthorizationHeader)req.getAttribute(HandleAuthorizationHeader.class.getName());
        HttpSession session = req.getSession(false);
        if (handleAuthHeader != null && handleAuthHeader.getSessionId() != null && session == null && this.sessionManager != null) {
            session = this.sessionManager.getHttpSession(handleAuthHeader.getSessionId());
        }
        if (session == null) {
            resp.setStatus(403);
            return;
        }
        session.invalidate();
        resp.setStatus(204);
    }

    private AuthenticationResponse getAuthenticationResponse(HandleAuthorizationHeader handleAuthHeader, HttpServletRequest req, HttpSession session) {
        AuthenticationResponse authResp = new AuthenticationResponse();
        req.setAttribute(AuthenticationResponse.class.getName(), (Object)authResp);
        HandleAuthenticationStatus status = null;
        if (session != null) {
            status = HandleAuthenticationStatus.fromSession(session, true);
            authResp.setSessionId(status.getSessionId());
            authResp.setNonce(status.getNonce());
            AuthenticationInfoWithId authInfo = status.getAuthInfoWithId();
            if (authInfo != null) {
                authResp.setId(authInfo.getId());
                authResp.setAuthenticated(true);
            }
            status = HandleAuthenticationStatus.processServerSignature(status, this.handleServer, session, handleAuthHeader, authResp);
        }
        new StandardHandleAuthenticator(req, session, status, authResp).authenticate();
        return authResp;
    }

    private JsonObject getSessionRepresentation(AuthenticationResponse authResp) {
        byte[] serverSignature;
        byte[] nonce;
        JsonObject res = new JsonObject();
        String sessionId = authResp.getSessionId();
        if (sessionId != null) {
            res.addProperty("sessionId", sessionId);
        }
        if ((nonce = authResp.getNonce()) != null) {
            res.addProperty("nonce", Base64.encodeBase64String((byte[])nonce));
        }
        if ((serverSignature = authResp.getServerSignature()) != null) {
            res.addProperty("serverAlg", authResp.getServerAlg());
            res.addProperty("serverSignature", Base64.encodeBase64String((byte[])serverSignature));
        }
        if (authResp.isAuthenticated()) {
            res.addProperty("authenticated", Boolean.TRUE);
            res.addProperty("id", authResp.getId());
        }
        if (!authResp.getErrors().isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String error : authResp.getErrors()) {
                if (sb.length() > 0) {
                    sb.append("; ");
                }
                sb.append(error);
            }
            res.addProperty("error", sb.toString());
        }
        if (res.entrySet().isEmpty()) {
            res.addProperty("authenticated", Boolean.FALSE);
        }
        return res;
    }
}

