/*
 * Decompiled with CFR 0.152.
 */
package net.handle.server.servletcontainer.servlets;

import com.google.gson.JsonParseException;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.Common;
import net.handle.hdllib.GenericRequest;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.ListNAsRequest;
import net.handle.hdllib.ResponseMessageCallback;
import net.handle.hdllib.Util;
import net.handle.server.servletcontainer.servlets.BaseHandleRequestProcessingServlet;
import net.handle.server.servletcontainer.servlets.JsonParameterServletReq;
import net.handle.server.servletcontainer.servlets.ListCallback;
import net.handle.server.servletcontainer.support.LoggingResponseMessageCallbackWrapper;

public class PrefixesServlet
extends BaseHandleRequestProcessingServlet {
    public PrefixesServlet() {
        this.allowString = "GET, HEAD, POST, DELETE, TRACE, OPTIONS";
    }

    @Override
    protected void doGet(HttpServletRequest servletReq, HttpServletResponse servletResp) throws ServletException, IOException {
        String prefix = servletReq.getParameter("prefix");
        if (prefix == null) {
            prefix = PrefixesServlet.getPath(servletReq);
        }
        if (!prefix.isEmpty()) {
            servletResp.setStatus(405);
            servletResp.setHeader("Allow", "POST, DELETE, TRACE, OPTIONS");
            return;
        }
        this.listPrefixes(servletReq, servletResp);
    }

    @Override
    protected void doOptions(HttpServletRequest servletReq, HttpServletResponse servletResp) throws ServletException, IOException {
        String prefix = servletReq.getParameter("prefix");
        if (prefix == null) {
            prefix = PrefixesServlet.getPath(servletReq);
        }
        if (prefix.isEmpty()) {
            servletResp.setHeader("Allow", "GET, HEAD, POST, DELETE, TRACE, OPTIONS");
        } else {
            servletResp.setHeader("Allow", "POST, DELETE, TRACE, OPTIONS");
        }
    }

    @Override
    protected void doPost(HttpServletRequest servletReq, HttpServletResponse servletResp) throws ServletException, IOException {
        AbstractResponse resp;
        GenericRequest req;
        String prefix;
        if (PrefixesServlet.hasJsonEntity(servletReq)) {
            try {
                servletReq = new JsonParameterServletReq((HttpServletRequest)servletReq);
            }
            catch (JsonParseException e) {
                this.processResponse((HttpServletRequest)servletReq, servletResp, null, PrefixesServlet.errorResponseFromException((Exception)((Object)e)));
                return;
            }
        }
        if ((prefix = servletReq.getParameter("prefix")) == null) {
            prefix = PrefixesServlet.getPath(servletReq);
        }
        if (prefix.isEmpty()) {
            req = null;
            resp = PrefixesServlet.errorResponseFromException(new Exception("Prefix not specified in homing request"));
        } else {
            req = new GenericRequest(Util.encodeString(prefix), 300, PrefixesServlet.getAuthenticationInfo(servletReq));
            resp = this.processRequest((HttpServletRequest)servletReq, req);
        }
        this.processResponse((HttpServletRequest)servletReq, servletResp, req, resp);
    }

    @Override
    protected void doDelete(HttpServletRequest servletReq, HttpServletResponse servletResp) throws ServletException, IOException {
        AbstractResponse resp;
        GenericRequest req;
        String prefix;
        if (PrefixesServlet.hasJsonEntity(servletReq)) {
            try {
                servletReq = new JsonParameterServletReq((HttpServletRequest)servletReq);
            }
            catch (JsonParseException e) {
                this.processResponse((HttpServletRequest)servletReq, servletResp, null, PrefixesServlet.errorResponseFromException((Exception)((Object)e)));
                return;
            }
        }
        if ((prefix = servletReq.getParameter("prefix")) == null) {
            prefix = PrefixesServlet.getPath(servletReq);
        }
        if (prefix.isEmpty()) {
            req = null;
            resp = PrefixesServlet.errorResponseFromException(new Exception("Prefix not specified in unhoming request"));
        } else {
            req = new GenericRequest(Util.encodeString(prefix), 301, PrefixesServlet.getAuthenticationInfo(servletReq));
            resp = this.processRequest((HttpServletRequest)servletReq, req);
        }
        this.processResponse((HttpServletRequest)servletReq, servletResp, req, resp);
    }

    private void listPrefixes(HttpServletRequest servletReq, HttpServletResponse servletResp) throws IOException {
        try {
            ListNAsRequest listReq = new ListNAsRequest(Common.BLANK_HANDLE, PrefixesServlet.getAuthenticationInfo(servletReq));
            ListCallback listCallback = new ListCallback();
            listCallback.page = BaseHandleRequestProcessingServlet.getIntegerParameter(servletReq, "page", -1);
            listCallback.pageSize = BaseHandleRequestProcessingServlet.getIntegerParameter(servletReq, "pageSize", -1);
            listReq.certify = PrefixesServlet.getBooleanParameter(servletReq, "cert");
            ResponseMessageCallback callbackWrapper = listCallback;
            if (this.handleServer != null) {
                callbackWrapper = new LoggingResponseMessageCallbackWrapper(listCallback, this.handleServer, this.handleServer.logHttpAccesses(), listReq, PrefixesServlet.getRemoteInetAddress(servletReq), "HDLApi");
            }
            try {
                this.requestHandler.processRequest(listReq, PrefixesServlet.getRemoteInetAddress(servletReq), callbackWrapper);
            }
            catch (HandleException e) {
                listCallback.unexpectedResponse = HandleException.toErrorResponse(listReq, e);
            }
            if (listCallback.unexpectedResponse != null) {
                this.processResponse(servletReq, servletResp, listReq, listCallback.unexpectedResponse);
            } else {
                listCallback.processListHandlesResponse(servletReq, servletResp, listReq, listCallback.handles, listCallback.totalCount);
            }
        }
        catch (IllegalArgumentException e) {
            this.processResponse(servletReq, servletResp, null, PrefixesServlet.errorResponseFromException(e));
        }
    }
}

