/*
 * Decompiled with CFR 0.152.
 */
package net.handle.server.servletcontainer.servlets;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.handle.hdllib.AbstractRequest;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.GsonUtility;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.ListHandlesResponse;
import net.handle.hdllib.ListNAsResponse;
import net.handle.hdllib.ResponseMessageCallback;
import net.handle.hdllib.Util;
import net.handle.server.servletcontainer.servlets.BaseHandleRequestProcessingServlet;

class ListCallback
implements ResponseMessageCallback {
    int page;
    int pageSize;
    final List<String> handles = new ArrayList<String>();
    int totalCount;
    AbstractResponse unexpectedResponse;

    ListCallback() {
    }

    @Override
    public void handleResponse(AbstractResponse resp) throws HandleException {
        if (resp instanceof ListHandlesResponse) {
            this.handleListResponse(((ListHandlesResponse)resp).handles);
        } else if (resp instanceof ListNAsResponse) {
            this.handleListResponse(((ListNAsResponse)resp).handles);
        } else {
            this.unexpectedResponse = resp;
        }
    }

    private void handleListResponse(byte[][] responseHandles) {
        if (this.page >= 0 && this.pageSize >= 0 && (this.pageSize == 0 || this.totalCount >= (this.page + 1) * this.pageSize || this.totalCount + responseHandles.length <= this.page * this.pageSize)) {
            this.totalCount += responseHandles.length;
            return;
        }
        for (byte[] handle : responseHandles) {
            if (this.page >= 0 && this.pageSize >= 0 && (this.pageSize == 0 || this.totalCount >= (this.page + 1) * this.pageSize || this.totalCount + 1 <= this.page * this.pageSize)) {
                ++this.totalCount;
                continue;
            }
            String handleString = Util.decodeString(handle);
            this.handles.add(handleString);
            ++this.totalCount;
        }
    }

    void processListHandlesResponse(HttpServletRequest servletReq, HttpServletResponse servletResp, AbstractRequest listReq, List<String> handles, int totalCount) throws IOException {
        JsonObject json = new JsonObject();
        json.addProperty("responseCode", (Number)1);
        if (listReq.opCode == 105) {
            json.addProperty("prefix", Util.decodeString(listReq.handle));
        }
        json.addProperty("totalCount", String.valueOf(totalCount));
        if (this.page >= 0 && this.pageSize >= 0) {
            json.addProperty("page", (Number)this.page);
            json.addProperty("pageSize", (Number)this.pageSize);
        }
        String property = listReq.opCode == 302 ? "prefixes" : "handles";
        json.add(property, GsonUtility.getGson().toJsonTree(handles));
        BaseHandleRequestProcessingServlet.processResponse(servletReq, servletResp, 200, (JsonElement)json);
    }
}

