/*
 * Decompiled with CFR 0.152.
 */
package net.handle.server.servletcontainer;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Set;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLSession;
import net.handle.server.servletcontainer.TlsRenegotiationRequestor;
import org.eclipse.jetty.io.AsyncEndPoint;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.nio.AsyncConnection;
import org.eclipse.jetty.io.nio.ChannelEndPoint;
import org.eclipse.jetty.io.nio.SelectChannelEndPoint;
import org.eclipse.jetty.io.nio.SelectorManager;
import org.eclipse.jetty.io.nio.SslConnection;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.ssl.SslCertificates;
import org.eclipse.jetty.server.ssl.SslSelectChannelConnector;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class PortUnificationSelectChannelConnector
extends SslSelectChannelConnector {
    public PortUnificationSelectChannelConnector() {
    }

    public PortUnificationSelectChannelConnector(SslContextFactory sslContextFactory) {
        super(sslContextFactory);
    }

    protected SelectChannelEndPoint newEndPoint(SocketChannel channel, SelectorManager.SelectSet selectSet, SelectionKey key) throws IOException {
        return super.newEndPoint((SocketChannel)new ReadAheadSocketChannelWrapper(channel, 1), selectSet, key);
    }

    protected AsyncConnection newConnection(SocketChannel channel, AsyncEndPoint endPoint) {
        return new LazyConnection((ReadAheadSocketChannelWrapper)channel, endPoint);
    }

    public void customize(EndPoint endpoint, Request request) throws IOException {
        String scheme = request.getScheme();
        try {
            super.customize(endpoint, request);
            if (endpoint instanceof SslConnection.SslEndPoint) {
                SslConnection.SslEndPoint sslEndPoint = (SslConnection.SslEndPoint)endpoint;
                request.setAttribute(TlsRenegotiationRequestor.class.getName(), (Object)new TlsRenegotiationRequestor(sslEndPoint, request));
            }
        }
        catch (ClassCastException e) {
            request.setScheme(scheme);
        }
    }

    public boolean isConfidential(Request request) {
        if (request.getAttribute("javax.servlet.request.cipher_suite") != null) {
            return true;
        }
        return this.isForwarded() && request.getScheme().equalsIgnoreCase("https");
    }

    public boolean isIntegral(Request request) {
        return this.isConfidential(request);
    }

    static class ReadAheadSocketChannelWrapper
    extends SocketChannel {
        private final SocketChannel channel;
        private final ByteBuffer start;
        private byte[] bytes;
        private IOException pendingException;
        private int leftToRead;
        WeakReference<Request> request;

        public ReadAheadSocketChannelWrapper(SocketChannel channel, int readAheadLength) throws IOException {
            super(channel.provider());
            this.channel = channel;
            this.start = ByteBuffer.allocate(readAheadLength);
            this.leftToRead = readAheadLength;
            this.readAhead();
        }

        public synchronized void readAhead() throws IOException {
            if (this.leftToRead > 0) {
                int n = this.channel.read(this.start);
                this.leftToRead = n == -1 ? -1 : (this.leftToRead -= n);
                if (this.leftToRead <= 0) {
                    this.start.flip();
                    this.bytes = new byte[this.start.remaining()];
                    this.start.get(this.bytes);
                    this.start.rewind();
                }
            }
        }

        public byte[] getBytes() {
            if (this.pendingException == null) {
                try {
                    this.readAhead();
                }
                catch (IOException e) {
                    this.pendingException = e;
                }
            }
            return this.bytes;
        }

        public void throwPendingException() throws IOException {
            if (this.pendingException != null) {
                IOException e = this.pendingException;
                this.pendingException = null;
                throw e;
            }
        }

        private int readFromStart(ByteBuffer dst) {
            int sr = this.start.remaining();
            int dr = dst.remaining();
            if (dr == 0) {
                return 0;
            }
            int n = Math.min(dr, sr);
            dst.put(this.bytes, this.start.position(), n);
            this.start.position(this.start.position() + n);
            return n;
        }

        @Override
        public synchronized int read(ByteBuffer dst) throws IOException {
            int n;
            this.throwPendingException();
            this.readAhead();
            if (this.leftToRead > 0) {
                return 0;
            }
            int sr = this.start.remaining();
            if (sr > 0 && (n = this.readFromStart(dst)) < sr) {
                return n;
            }
            return sr + this.channel.read(dst);
        }

        @Override
        public synchronized long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
            int newOffset;
            this.throwPendingException();
            if (offset + length > dsts.length || length < 0 || offset < 0) {
                throw new IndexOutOfBoundsException();
            }
            this.readAhead();
            if (this.leftToRead > 0) {
                return 0L;
            }
            int sr = this.start.remaining();
            if (sr > 0) {
                int accum = 0;
                for (newOffset = offset; newOffset < offset + length && (accum += this.readFromStart(dsts[newOffset])) != sr; ++newOffset) {
                }
                if (accum < sr) {
                    return accum;
                }
            }
            return (long)sr + this.channel.read(dsts, newOffset, length - newOffset + offset);
        }

        public int hashCode() {
            return this.channel.hashCode();
        }

        public boolean equals(Object obj) {
            return this.channel.equals(obj);
        }

        public String toString() {
            return this.channel.toString();
        }

        @Override
        public Socket socket() {
            return this.channel.socket();
        }

        @Override
        public boolean isConnected() {
            return this.channel.isConnected();
        }

        @Override
        public boolean isConnectionPending() {
            return this.channel.isConnectionPending();
        }

        @Override
        public boolean connect(SocketAddress remote) throws IOException {
            return this.channel.connect(remote);
        }

        @Override
        public boolean finishConnect() throws IOException {
            return this.channel.finishConnect();
        }

        @Override
        public int write(ByteBuffer src) throws IOException {
            return this.channel.write(src);
        }

        @Override
        public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
            return this.channel.write(srcs, offset, length);
        }

        @Override
        protected void implCloseSelectableChannel() throws IOException {
            this.channel.close();
        }

        @Override
        protected void implConfigureBlocking(boolean block) throws IOException {
            this.channel.configureBlocking(block);
        }

        @Override
        public SocketAddress getLocalAddress() throws IOException {
            return this.channel.getLocalAddress();
        }

        @Override
        public <T> T getOption(SocketOption<T> name) throws IOException {
            return this.channel.getOption(name);
        }

        @Override
        public Set<SocketOption<?>> supportedOptions() {
            return this.channel.supportedOptions();
        }

        @Override
        public SocketChannel bind(SocketAddress local) throws IOException {
            return this.channel.bind(local);
        }

        @Override
        public SocketAddress getRemoteAddress() throws IOException {
            return this.channel.getRemoteAddress();
        }

        @Override
        public <T> SocketChannel setOption(SocketOption<T> name, T value) throws IOException {
            return this.channel.setOption((SocketOption)name, (Object)value);
        }

        @Override
        public SocketChannel shutdownInput() throws IOException {
            return this.channel.shutdownInput();
        }

        @Override
        public SocketChannel shutdownOutput() throws IOException {
            return this.channel.shutdownOutput();
        }
    }

    class LazyConnection
    implements AsyncConnection {
        private final ReadAheadSocketChannelWrapper channel;
        private final AsyncEndPoint endPoint;
        private final long timestamp;
        private AsyncConnection connection;
        private SslConnection.SslEndPoint sslEndPoint;
        private SSLEngine sslEngine;

        public LazyConnection(ReadAheadSocketChannelWrapper channel, AsyncEndPoint endPoint) {
            this.channel = channel;
            this.endPoint = endPoint;
            this.timestamp = System.currentTimeMillis();
            this.determineNewConnection(channel, endPoint, false);
        }

        public Connection handle() throws IOException {
            if (this.connection == null) {
                this.determineNewConnection(this.channel, this.endPoint, false);
                this.channel.throwPendingException();
            }
            if (this.connection != null) {
                Request request;
                boolean handshaking = this.sslEndPoint != null && this.sslEndPoint.isOpen() && this.sslEngine.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
                this.connection.handle();
                if (handshaking && this.sslEndPoint.isOpen() && this.sslEngine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING && (request = this.getRequestStoredInEndpointChannel()) != null) {
                    request.removeAttribute("javax.servlet.request.X509Certificate");
                    SslCertificates.customize((SSLSession)this.sslEngine.getSession(), (EndPoint)this.sslEndPoint, (Request)request);
                    this.channel.request = null;
                    request.getAsyncContext().dispatch();
                }
            }
            return this;
        }

        private Request getRequestStoredInEndpointChannel() {
            if (!(this.endPoint instanceof ChannelEndPoint)) {
                return null;
            }
            ByteChannel channel = ((ChannelEndPoint)this.endPoint).getChannel();
            if (!(channel instanceof ReadAheadSocketChannelWrapper)) {
                return null;
            }
            WeakReference<Request> requestRef = ((ReadAheadSocketChannelWrapper)channel).request;
            if (requestRef == null) {
                return null;
            }
            return (Request)requestRef.get();
        }

        public long getTimeStamp() {
            return this.timestamp;
        }

        public void onInputShutdown() throws IOException {
            this.determineNewConnection(this.channel, this.endPoint, true);
            this.connection.onInputShutdown();
        }

        public boolean isIdle() {
            this.determineNewConnection(this.channel, this.endPoint, false);
            if (this.connection != null) {
                return this.connection.isIdle();
            }
            return false;
        }

        public boolean isSuspended() {
            this.determineNewConnection(this.channel, this.endPoint, false);
            if (this.connection != null) {
                return this.connection.isSuspended();
            }
            return false;
        }

        public void onClose() {
            this.determineNewConnection(this.channel, this.endPoint, true);
            this.connection.onClose();
        }

        public void onIdleExpired(long l) {
            this.determineNewConnection(this.channel, this.endPoint, true);
            this.connection.onIdleExpired(l);
        }

        void determineNewConnection(ReadAheadSocketChannelWrapper channel, AsyncEndPoint endPoint, boolean force) {
            if (this.connection != null) {
                return;
            }
            byte[] bytes = channel.getBytes();
            if (!(bytes != null && bytes.length != 0 || force)) {
                return;
            }
            if (this.looksLikeSsl(bytes)) {
                this.connection = PortUnificationSelectChannelConnector.super.newConnection(channel, endPoint);
                this.sslEndPoint = (SslConnection.SslEndPoint)((SslConnection)this.connection).getSslEndPoint();
                this.sslEngine = this.sslEndPoint.getSslEngine();
            } else {
                this.connection = PortUnificationSelectChannelConnector.super.newPlainConnection(channel, endPoint);
            }
        }

        private boolean looksLikeSsl(byte[] bytes) {
            if (bytes == null || bytes.length == 0) {
                return false;
            }
            byte b = bytes[0];
            return b >= 127 || b < 32 && b != 10 && b != 13 && b != 9;
        }
    }
}

