/*
 * Decompiled with CFR 0.152.
 */
package net.handle.server.servletcontainer;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.cnri.util.StringUtils;
import net.handle.server.servletcontainer.servlets.BaseHandleRequestProcessingServlet;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.ErrorHandler;

public class HandleApiErrorHandler
extends ErrorHandler {
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String requestUri = StringUtils.decodeURLIgnorePlus((String)request.getRequestURI());
        if (requestUri.equals("/api") || requestUri.startsWith("/api/")) {
            int httpStatus;
            try {
                httpStatus = (Integer)request.getAttribute("javax.servlet.error.status_code");
            }
            catch (Exception e) {
                httpStatus = 500;
            }
            String message = (String)request.getAttribute("javax.servlet.error.message");
            if (message == null) {
                message = "Unexpected server error";
            }
            int handleStatus = this.handleStatusOfHttpStatus(httpStatus);
            JsonObject json = new JsonObject();
            json.addProperty("responseCode", (Number)handleStatus);
            json.addProperty("message", message);
            BaseHandleRequestProcessingServlet.processResponse(request, response, httpStatus, (JsonElement)json);
        } else {
            super.handle(target, baseRequest, request, response);
        }
    }

    private int handleStatusOfHttpStatus(int httpStatus) {
        switch (httpStatus) {
            case 400: {
                return 4;
            }
            case 401: {
                return 402;
            }
            case 403: {
                return 403;
            }
            case 404: {
                return 4;
            }
            case 409: {
                return 4;
            }
            case 410: {
                return 4;
            }
            case 500: {
                return 2;
            }
            case 503: {
                return 3;
            }
            case 505: {
                return 4;
            }
        }
        if (httpStatus >= 500) {
            return 2;
        }
        return 4;
    }
}

