/*
 * Decompiled with CFR 0.152.
 */
package net.handle.server.servletcontainer;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.net.InetAddress;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509KeyManager;
import net.handle.hdllib.HandleResolver;
import net.handle.hdllib.SSLEngineHelper;
import net.handle.server.servletcontainer.EmbeddedJettyConfig;
import net.handle.server.servletcontainer.PortUnificationSelectChannelConnector;
import net.handle.util.AutoSelfSignedKeyManager;
import net.handle.util.X509HSTrustManager;
import org.eclipse.jetty.annotations.AnnotationConfiguration;
import org.eclipse.jetty.annotations.AnnotationParser;
import org.eclipse.jetty.deploy.App;
import org.eclipse.jetty.deploy.AppProvider;
import org.eclipse.jetty.deploy.DeploymentManager;
import org.eclipse.jetty.deploy.providers.WebAppProvider;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.server.ssl.SslSelectChannelConnector;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.log.StdErrLog;
import org.eclipse.jetty.util.ssl.AliasedX509ExtendedKeyManager;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.xml.XmlConfiguration;

public class EmbeddedJetty {
    private Server httpServer;
    private ContextHandlerCollection contexts;
    private DeploymentManager priorityDeploymentManager;
    private DeploymentManager deploymentManager;
    private final EmbeddedJettyConfig config;
    private File baseDir = null;
    private File webAppsBaseStorageDir = null;
    private File webAppsTempDir = null;
    private File webAppsDir = null;
    private File webAppsPriorityDir = null;
    private File jettyConfigFile = null;
    private HandleResolver sharedResolver = null;
    private static SecureRandom srand = null;
    private static Object RANDOM_LOCK = new Object();
    public static final String[] HTTPS_KEY_STORE_FILE_NAMES = new String[]{"https.jks", "https.keystore", "https.key"};

    public EmbeddedJetty(EmbeddedJettyConfig config) {
        this.config = config;
        this.baseDir = config.getBaseDir();
        this.webAppsDir = config.getWebAppsPath() != null ? new File(config.getWebAppsPath()) : new File(this.baseDir, "webapps");
        this.webAppsPriorityDir = config.getWebAppsPriorityPath() != null ? new File(config.getWebAppsPriorityPath()) : new File(this.baseDir, "webapps-priority");
        this.webAppsTempDir = config.getWebAppsTempPath() != null ? new File(config.getWebAppsTempPath()) : new File(this.baseDir, "webapps-temp");
        this.webAppsBaseStorageDir = config.getWebAppsStoragePath() != null ? new File(config.getWebAppsStoragePath()) : new File(this.baseDir, "webapps-storage");
        this.jettyConfigFile = config.getJettyXmlPath() != null ? new File(config.getJettyXmlPath()) : new File(this.baseDir, "jetty.xml");
    }

    public void setUpHttpServer() throws Exception {
        this.turnOffJetty8AnnotationParserWarnings();
        if (this.config.isEnableDefaultHttpConfig()) {
            if (this.config.getConnectors().size() > 0) {
                this.httpServer = new Server();
                for (EmbeddedJettyConfig.ConnectorConfig connectorConfig : this.config.getConnectors()) {
                    this.addConnector(connectorConfig);
                }
                this.contexts = new OverridingContextHandlerCollection();
                this.priorityDeploymentManager = this.setUpDeploymentManager(this.webAppsPriorityDir);
                if (this.priorityDeploymentManager != null) {
                    this.httpServer.addBean((Object)this.priorityDeploymentManager, true);
                }
                this.deploymentManager = this.setUpDeploymentManager(this.webAppsDir);
                HashLoginService loginService = new HashLoginService("default");
                loginService.setConfig(new File(this.baseDir, "realm.properties").getAbsolutePath());
                this.httpServer.addBean((Object)loginService);
                for (Handler handler : this.config.getDefaultHandlers()) {
                    this.contexts.addHandler(handler);
                }
                this.httpServer.setHandler((Handler)this.contexts);
                this.httpServer.setGracefulShutdown(3000);
                this.httpServer.setStopAtShutdown(false);
            }
        } else {
            this.httpServer = new Server();
        }
        if (this.httpServer != null) {
            this.httpServer.setSendServerVersion(false);
            if (this.jettyConfigFile.exists()) {
                try (FileInputStream in = new FileInputStream(this.jettyConfigFile);){
                    new XmlConfiguration((InputStream)in).configure((Object)this.httpServer);
                }
            }
        }
    }

    private void turnOffJetty8AnnotationParserWarnings() {
        Logger logger = Log.getLogger(AnnotationParser.class);
        if (logger instanceof StdErrLog) {
            ((StdErrLog)logger).setLevel(4);
        }
    }

    public void startPriorityDeploymentManager() throws Exception {
        if (this.priorityDeploymentManager != null) {
            this.priorityDeploymentManager.start();
        }
    }

    public void startHttpServer() throws Exception {
        if (this.httpServer != null) {
            this.httpServer.start();
            if (this.deploymentManager != null) {
                this.httpServer.addBean((Object)this.deploymentManager, true);
            }
        }
    }

    public void join() throws InterruptedException {
        if (this.httpServer != null) {
            this.httpServer.join();
        }
    }

    public void stopHttpServer() {
        if (this.httpServer != null) {
            if (this.deploymentManager != null && this.priorityDeploymentManager != null) {
                this.deploymentManager.undeployAll();
            }
            try {
                this.httpServer.stop();
                this.httpServer.join();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.httpServer = null;
        }
    }

    public void addConnector(EmbeddedJettyConfig.ConnectorConfig connectorConfig) throws Exception {
        KeyManager[] keyManagers;
        if (connectorConfig.isHttpsUseSelfSignedCert() || connectorConfig.getHttpsKeyStoreFile() == null) {
            keyManagers = connectorConfig.getHttpsCertificateChain() != null ? new KeyManager[]{new AutoSelfSignedKeyManager(connectorConfig.getHttpsId(), connectorConfig.getHttpsCertificateChain(), connectorConfig.getHttpsPrivKey())} : (connectorConfig.getHttpsPubKey() != null && connectorConfig.getHttpsPrivKey() != null ? new KeyManager[]{new AutoSelfSignedKeyManager(connectorConfig.getHttpsId(), connectorConfig.getHttpsPubKey(), connectorConfig.getHttpsPrivKey())} : new KeyManager[]{new AutoSelfSignedKeyManager(connectorConfig.getHttpsId())});
        } else {
            String keystorePassStr = connectorConfig.getHttpsKeyStorePassword();
            char[] keystorePass = keystorePassStr == null ? null : keystorePassStr.toCharArray();
            String keyPassStr = connectorConfig.getHttpsKeyPassword();
            char[] keyPass = keyPassStr == null ? new char[]{} : keyPassStr.toCharArray();
            KeyStore httpsKeyStore = KeyStore.getInstance("JKS");
            File keystoreFile = this.getKeystoreFile(connectorConfig.getHttpsKeyStoreFile());
            try (FileInputStream in = new FileInputStream(keystoreFile);){
                httpsKeyStore.load(in, keystorePass);
            }
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(httpsKeyStore, keyPass);
            keyManagers = EmbeddedJetty.getKeyManagers(kmf, connectorConfig.getHttpsAlias());
        }
        SSLContext sslContext = null;
        sslContext = SSLContext.getInstance("TLS");
        HandleResolver resolver = this.config.getResolver();
        if (resolver == null && (resolver = this.sharedResolver) == null) {
            resolver = this.sharedResolver = new HandleResolver();
        }
        sslContext.init(keyManagers, new TrustManager[]{new X509HSTrustManager(resolver)}, EmbeddedJetty.getRandom());
        SslContextFactory sslContextFactory = new SslContextFactory();
        String clientAuth = connectorConfig.getHttpsClientAuth();
        sslContextFactory.setWantClientAuth(true);
        if ("need".equalsIgnoreCase(clientAuth) || "true".equalsIgnoreCase(clientAuth)) {
            sslContextFactory.setNeedClientAuth(true);
        } else if ("false".equalsIgnoreCase(clientAuth)) {
            sslContextFactory.setWantClientAuth(false);
        }
        sslContextFactory.setSslContext(sslContext);
        sslContextFactory.setIncludeCipherSuites(SSLEngineHelper.COMPATIBILITY_CIPHER_SUITES);
        sslContextFactory.addExcludeProtocols(new String[]{"SSLv3"});
        Object connector = connectorConfig.isHttps() ? new SslSelectChannelConnector(sslContextFactory) : (connectorConfig.isHttpOnly() ? new SelectChannelConnector() : new PortUnificationSelectChannelConnector(sslContextFactory));
        connector.setPort(connectorConfig.getPort());
        InetAddress httpsListenAddress = connectorConfig.getListenAddress();
        if (httpsListenAddress != null) {
            connector.setHost(httpsListenAddress.getHostAddress());
        }
        connector.setMaxIdleTime(30000);
        connector.setRequestHeaderSize(8192);
        if (connectorConfig.getRedirectPort() > 0) {
            connector.setConfidentialPort(connectorConfig.getRedirectPort());
            connector.setIntegralPort(connectorConfig.getRedirectPort());
        } else if (!connectorConfig.isHttps() && !connectorConfig.isHttpOnly()) {
            connector.setConfidentialPort(connectorConfig.getPort());
            connector.setIntegralPort(connectorConfig.getPort());
        }
        this.httpServer.addConnector((Connector)connector);
    }

    public void addWebApp(File war, String contextPath) throws Exception {
        WebAppContext handler = new WebAppContext(war.getAbsolutePath(), contextPath);
        this.setUpWebAppContext(handler);
        for (String attributeName : this.config.getContextAttributes().keySet()) {
            handler.setAttribute(attributeName, this.config.getContextAttributes().get(attributeName));
        }
        handler.setExtractWAR(true);
        String warDirName = contextPath.substring(1);
        handler.setTempDirectory(new File(new File(this.baseDir, "webapps-temp"), warDirName));
        ContextHandlerCollection handlers = (ContextHandlerCollection)this.httpServer.getHandler();
        handlers.addHandler((Handler)handler);
        handler.start();
    }

    private DeploymentManager setUpDeploymentManager(File webAppsDir) {
        if (!webAppsDir.exists() || webAppsDir.isDirectory()) {
            EmbeddedWebAppProvider webAppProvider = new EmbeddedWebAppProvider();
            webAppProvider.setMonitoredDirName(webAppsDir.getAbsolutePath());
            webAppProvider.setParentLoaderPriority(false);
            webAppProvider.setExtractWars(true);
            webAppProvider.setTempDir(this.webAppsTempDir);
            webAppProvider.setScanInterval(10);
            DeploymentManager result = new DeploymentManager();
            result.setContexts(this.contexts);
            for (String attributeName : this.config.getContextAttributes().keySet()) {
                result.setContextAttribute(attributeName, this.config.getContextAttributes().get(attributeName));
            }
            result.addAppProvider((AppProvider)webAppProvider);
            return result;
        }
        return null;
    }

    private static KeyManager[] getKeyManagers(KeyManagerFactory kmf, String alias) throws Exception {
        KeyManager[] res = kmf.getKeyManagers();
        if (alias == null || res == null) {
            return res;
        }
        for (int i = 0; i < res.length; ++i) {
            if (!(res[i] instanceof X509KeyManager)) continue;
            res[i] = new AliasedX509ExtendedKeyManager(alias, (X509KeyManager)res[i]);
        }
        return res;
    }

    private File getKeystoreFile(String filename) {
        if (filename != null) {
            File res = new File(filename);
            if (res.isAbsolute()) {
                return res;
            }
            return new File(this.baseDir, filename);
        }
        for (String name : HTTPS_KEY_STORE_FILE_NAMES) {
            File res = new File(this.baseDir, name);
            if (!res.exists()) continue;
            return res;
        }
        return null;
    }

    private void setUpWebAppContext(WebAppContext res) {
        res.setSystemClasses(EmbeddedJetty.removeFromArray(res.getSystemClasses(), "org.apache.commons.logging."));
        res.setServerClasses(EmbeddedJetty.prependToArray(res.getServerClasses(), "-org.eclipse.jetty.servlets."));
        for (String systemClass : this.config.getSystemClasses()) {
            res.addSystemClass(systemClass);
        }
        for (String serverClass : this.config.getServerClasses()) {
            res.addServerClass(serverClass);
        }
        res.setConfigurationClasses(EmbeddedJetty.addToArray(res.getConfigurationClasses(), AnnotationConfiguration.class.getName()));
        res.setInitParameter("org.eclipse.jetty.servlet.Default.dirAllowed", "false");
    }

    private static <T> T[] prependToArray(T[] array, T item) {
        ArrayList<T> list = new ArrayList<T>();
        list.add(item);
        list.addAll(Arrays.asList(array));
        return list.toArray((Object[])Array.newInstance(array.getClass().getComponentType(), array.length + 1));
    }

    private static <T> T[] addToArray(T[] array, T item) {
        ArrayList<Object> list = new ArrayList<Object>(Arrays.asList(array));
        list.add(item);
        return list.toArray((Object[])Array.newInstance(array.getClass().getComponentType(), array.length + 1));
    }

    private static <T> T[] removeFromArray(T[] array, T item) {
        ArrayList<Object> list = new ArrayList<Object>(Arrays.asList(array));
        int len = array.length;
        if (list.remove(item)) {
            --len;
        }
        return list.toArray((Object[])Array.newInstance(array.getClass().getComponentType(), len));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final SecureRandom getRandom() {
        if (srand != null) {
            return srand;
        }
        Object object = RANDOM_LOCK;
        synchronized (object) {
            if (srand != null) {
                return srand;
            }
            srand = new SecureRandom();
            srand.setSeed(srand.generateSeed(10));
        }
        return srand;
    }

    private static class OverridingContextHandlerCollection
    extends ContextHandlerCollection {
        private OverridingContextHandlerCollection() {
        }

        public void addHandler(Handler handler) {
            Handler[] handlers = this.getHandlers();
            if (handlers == null) {
                this.setHandlers(new Handler[]{handler});
            } else {
                Handler[] newHandlers = new Handler[handlers.length + 1];
                newHandlers[0] = handler;
                System.arraycopy(handlers, 0, newHandlers, 1, handlers.length);
                this.setHandlers(newHandlers);
            }
        }
    }

    private class EmbeddedWebAppProvider
    extends WebAppProvider {
        private EmbeddedWebAppProvider() {
        }

        public ContextHandler createContextHandler(App app) throws Exception {
            this.getTempDir().mkdirs();
            WebAppContext res = (WebAppContext)super.createContextHandler(app);
            File webAppStorageDir = this.getWebAppStorageDirForContextPath(res.getContextPath());
            res.setAttribute("net.handle.server.webapp_storage_directory", (Object)webAppStorageDir);
            EmbeddedJetty.this.setUpWebAppContext(res);
            return res;
        }

        private File getWebAppStorageDirForContextPath(String contextPath) {
            File result = null;
            String webAppName = null;
            webAppName = "/".equals(contextPath) ? "root" : (contextPath.startsWith("/") ? contextPath.substring(1) : contextPath);
            if (webAppName != null) {
                result = new File(EmbeddedJetty.this.webAppsBaseStorageDir, webAppName);
                result.mkdirs();
            }
            return result;
        }
    }
}

