/*
 * Decompiled with CFR 0.152.
 */
package net.handle.server.replication;

import java.util.List;
import net.handle.hdllib.Common;
import net.handle.hdllib.Transaction;
import net.handle.hdllib.Util;

public class ReplicationPrefixFilter {
    private final List<String> acceptPrefixes;

    public ReplicationPrefixFilter(List<String> acceptPrefixes) {
        for (int i = 0; i < acceptPrefixes.size(); ++i) {
            acceptPrefixes.set(i, Util.decodeString(Util.upperCase(Util.encodeString(acceptPrefixes.get(i)))));
        }
        this.acceptPrefixes = acceptPrefixes;
    }

    public boolean acceptHandle(byte[] handle) {
        String prefix = this.getHandlePrefix(handle);
        return this.acceptPrefixes.contains(prefix);
    }

    public boolean acceptNA(byte[] authHandle) {
        byte[] naBytes = Util.startsWith(authHandle, Common.NA_HANDLE_PREFIX) ? Util.getSuffixPart(authHandle) : authHandle;
        byte[] upperCaseNaBytes = Util.upperCase(naBytes);
        String naString = Util.decodeString(upperCaseNaBytes);
        return this.acceptPrefixes.contains(naString);
    }

    public boolean acceptTransaction(Transaction txn) {
        if (txn.action == 4 || txn.action == 5) {
            return this.acceptNA(txn.handle);
        }
        return this.acceptHandle(txn.handle);
    }

    private String getHandlePrefix(byte[] handle) {
        byte[] prefixBytes = Util.getPrefixPart(handle);
        byte[] upperCasePrefixBytes = Util.upperCase(prefixBytes);
        String prefixString = Util.decodeString(upperCasePrefixBytes);
        return prefixString;
    }
}

