/*
 * Decompiled with CFR 0.152.
 */
package net.handle.server.replication;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.SocketTimeoutException;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.spec.InvalidKeySpecException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import java.util.Vector;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.net.ssl.SSLHandshakeException;
import net.cnri.util.FastDateFormat;
import net.cnri.util.StreamTable;
import net.handle.hdllib.AbstractMessage;
import net.handle.hdllib.AbstractRequest;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.AuthenticationInfo;
import net.handle.hdllib.Common;
import net.handle.hdllib.DumpHandlesCallback;
import net.handle.hdllib.DumpHandlesRequest;
import net.handle.hdllib.DumpHandlesResponse;
import net.handle.hdllib.GenericRequest;
import net.handle.hdllib.GsonUtility;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleResolver;
import net.handle.hdllib.HandleStorage;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.PublicKeyAuthenticationInfo;
import net.handle.hdllib.ReplicationDaemonInterface;
import net.handle.hdllib.ReplicationStateInfo;
import net.handle.hdllib.RetrieveTxnRequest;
import net.handle.hdllib.RetrieveTxnResponse;
import net.handle.hdllib.SecretKeyAuthenticationInfo;
import net.handle.hdllib.ServerInfo;
import net.handle.hdllib.SiteInfo;
import net.handle.hdllib.Transaction;
import net.handle.hdllib.TransactionCallback;
import net.handle.hdllib.TransactionQueueInterface;
import net.handle.hdllib.TransactionQueueListener;
import net.handle.hdllib.TransactionQueuesInterface;
import net.handle.hdllib.TransactionValidator;
import net.handle.hdllib.Util;
import net.handle.hdllib.ValueReference;
import net.handle.server.HandleServer;
import net.handle.server.replication.FileBasedReplicationSourceSiteCollection;
import net.handle.server.replication.HandleBasedReplicationSourceSiteCollection;
import net.handle.server.replication.NotifierInterface;
import net.handle.server.replication.RedumpErrorMessage;
import net.handle.server.replication.ReplicationDb;
import net.handle.server.replication.ReplicationPrefixFilter;
import net.handle.server.replication.ReplicationSourceSiteCollection;
import net.handle.server.replication.ReplicationSourceSiteInfo;
import net.handle.server.replication.TransactionValidationErrorMessage;

public class ReplicationDaemon
extends Thread
implements ReplicationDaemonInterface {
    public static final String REPLICATION_INTERVAL = "replication_interval";
    public static final String REPLICATION_START_TIME = "replication_start_time";
    public static final String REPLICATION_AUTH = "replication_authentication";
    public static final String REPLICATION_SERVER_INFO_FILE = "txnsrcsv.bin";
    public static final String REPLICATION_SERVER_INFO_JSON_FILE = "txnsrcsv.json";
    public static final String REPLICATION_STATUS_FILE = "txnstat.dct";
    public static final String REPLICATION_PRIV_KEY_FILE = "replpriv.bin";
    public static final String REPLICATION_SECRET_KEY_FILE = "replsec.bin";
    public static final String REPLICATION_TIMEOUT = "replication_timeout";
    public static final String REPLICATION_SITES_HANDLE = "replication_sites_handle";
    public static final String REPLICATION_SITE_HANDLE_VALUE = "replication_site_handle_value";
    public static final String REPLICATION_PULL_OTHER_TRANSACTIONS = "replication_pull_other_transactions";
    public static final String REPLICATION_KEEP_OTHER_TRANSACTIONS = "replication_keep_other_transactions";
    public static final String REPLICATION_SOURCES = "sources";
    public static final String REPLICATION_ACCEPT_PREFIXES = "replication_accept_prefixes";
    public volatile boolean keepRunning = true;
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private int replicationTimeout = 300000;
    private File replicationStatusFile = null;
    private AuthenticationInfo replicationAuth;
    private ReplicationSourceSiteCollection replicationSourceSites;
    private ReplicationStateInfo replicationStateInfo;
    private long replicationInterval = 30000L;
    private Long replicationStartTime = null;
    private boolean initializedReplicationStatus = false;
    private final HandleServer server;
    private final boolean caseSensitive;
    private final SiteInfo thisSite;
    private final int thisServerNum;
    private boolean fileWriteNoSync = false;
    private final HandleResolver retrievalResolver = new HandleResolver();
    private NotifierInterface notifier;
    private TransactionValidator replicationValidator = null;
    private final ReplicationPrefixFilter replicationPrefixFilter;
    private boolean isPullEntireGroupTransactions = false;
    protected List<TransactionQueueListener> queueListeners = new CopyOnWriteArrayList<TransactionQueueListener>();
    long lastNoPrimarySitesLoggedTimestamp = 0L;
    private final File redumpNeededFile;
    private ReplicationDb replicationDb;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ReplicationDaemon(HandleServer server, StreamTable config, File configDir) throws HandleException, IOException, InvalidKeySpecException {
        String replicationStartTimeString;
        this.server = server;
        this.thisSite = server.getSiteInfo();
        this.thisServerNum = server.getServerNum();
        this.caseSensitive = config.getBoolean("case_sensitive");
        this.fileWriteNoSync = config.getBoolean("file_write_no_sync", false);
        this.redumpNeededFile = new File(configDir, "SERVER_NEEDS_REDUMP.txt");
        List<String> replicationAcceptPrefixes = this.getReplicationAcceptPrefixes(config);
        this.replicationPrefixFilter = replicationAcceptPrefixes != null ? new ReplicationPrefixFilter(replicationAcceptPrefixes) : null;
        this.replicationTimeout = config.containsKey(REPLICATION_TIMEOUT) ? Integer.parseInt(String.valueOf(config.get(REPLICATION_TIMEOUT))) : 300000;
        this.retrievalResolver.setTcpTimeout(this.replicationTimeout);
        this.retrievalResolver.traceMessages = server.getResolver().traceMessages;
        if (config.containsKey(REPLICATION_INTERVAL)) {
            String repIntStr = String.valueOf(config.get(REPLICATION_INTERVAL));
            try {
                this.replicationInterval = Long.parseLong(repIntStr);
            }
            catch (Exception e) {
                System.err.println("Error: invalid replication interval \"" + repIntStr + "\"; using default: " + this.replicationInterval + " milliseconds");
            }
        }
        if ((replicationStartTimeString = config.getStr(REPLICATION_START_TIME)) != null) {
            try {
                this.replicationStartTime = FastDateFormat.parse((String)replicationStartTimeString, (TimeZone)TimeZone.getDefault());
            }
            catch (ParseException e) {
                throw new HandleException(11, "Invalid replication_start_time: " + replicationStartTimeString, e);
            }
        }
        if (!config.containsKey(REPLICATION_AUTH)) {
            throw new HandleException(0, "Servers using replication need to specify replication authentication information");
        }
        String replAuthSpec = config.getStr(REPLICATION_AUTH, "");
        String[] replFields = replAuthSpec.split(":");
        if (replFields.length < 3) {
            throw new HandleException(0, "Invalid replication auth descriptor: " + replAuthSpec);
        }
        int replHdlIdx = Integer.parseInt(replFields[1]);
        if (replFields[0].equals("privatekey")) {
            byte[] privKeyBytes;
            block37: {
                byte[] passphrase = null;
                File privKeyFile = new File(configDir, REPLICATION_PRIV_KEY_FILE);
                privKeyBytes = new byte[(int)privKeyFile.length()];
                try (FileInputStream in = new FileInputStream(privKeyFile);){
                    int r = 0;
                    for (int n = 0; n < privKeyBytes.length && (r = in.read(privKeyBytes, n, privKeyBytes.length - n)) >= 0; n += r) {
                    }
                }
                try {
                    if (Util.requiresSecretKey(privKeyBytes)) {
                        passphrase = Util.getPassphrase("Enter the passphrase for this servers replication private key: ");
                    }
                    privKeyBytes = Util.decrypt(privKeyBytes, passphrase);
                    if (passphrase == null) break block37;
                }
                catch (Exception e) {
                    try {
                        throw new HandleException(0, "Error decrypting private key: " + e);
                    }
                    catch (Throwable throwable) {
                        if (passphrase != null) {
                            for (int i = 0; i < passphrase.length; ++i) {
                                passphrase[i] = 0;
                            }
                        }
                        throw throwable;
                    }
                }
                for (int i = 0; i < passphrase.length; ++i) {
                    passphrase[i] = 0;
                }
            }
            this.replicationAuth = new PublicKeyAuthenticationInfo(Util.encodeString(replFields[2]), replHdlIdx, Util.getPrivateKeyFromBytes(privKeyBytes, 0));
        } else {
            if (!replAuthSpec.startsWith("secretkey:")) {
                throw new HandleException(0, "Unknown authentication type: " + replFields[0]);
            }
            File secKeyFile = new File(configDir, REPLICATION_SECRET_KEY_FILE);
            byte[] secKeyBytes = new byte[(int)secKeyFile.length()];
            try (FileInputStream in = new FileInputStream(secKeyFile);){
                int r = 0;
                for (int n = 0; n < secKeyBytes.length && (r = in.read(secKeyBytes, n, secKeyBytes.length - n)) >= 0; n += r) {
                }
            }
            this.replicationAuth = new SecretKeyAuthenticationInfo(Util.encodeString(replFields[2]), replHdlIdx, secKeyBytes);
        }
        String replicationSitesHandle = config.getStr(REPLICATION_SITES_HANDLE, null);
        String replicationSiteHandleValue = config.getStr(REPLICATION_SITE_HANDLE_VALUE, null);
        this.isPullEntireGroupTransactions = config.getBoolean(REPLICATION_PULL_OTHER_TRANSACTIONS);
        if (replicationSitesHandle == null || "".equals(replicationSitesHandle)) {
            if (replicationSiteHandleValue == null || "".equals(replicationSiteHandleValue)) {
                File replicationsSourceSiteFile = new File(configDir, REPLICATION_SERVER_INFO_FILE);
                if (!replicationsSourceSiteFile.exists()) {
                    replicationsSourceSiteFile = new File(configDir, REPLICATION_SERVER_INFO_JSON_FILE);
                }
                if (!replicationsSourceSiteFile.exists()) {
                    throw new HandleException(11, "No replication site found (txnsrcsv.bin)");
                }
                this.replicationSourceSites = new FileBasedReplicationSourceSiteCollection(replicationsSourceSiteFile);
            } else {
                ValueReference valueReference = ValueReference.fromString(replicationSiteHandleValue);
                String replicationSiteHandle = valueReference.getHandleAsString();
                int replicationSiteIndex = valueReference.index;
                this.replicationSourceSites = new HandleBasedReplicationSourceSiteCollection(replicationSiteIndex, replicationSiteHandle, this.retrievalResolver, this.thisSite.servers[this.thisServerNum], this.server);
            }
        } else {
            this.replicationSourceSites = new HandleBasedReplicationSourceSiteCollection(replicationSitesHandle, this.retrievalResolver, this.thisSite.servers[this.thisServerNum], this.server);
        }
        if (this.isPullEntireGroupTransactions) {
            this.replicationSourceSites.refresh();
            if (this.replicationSourceSites.getReplicationSourceSites().size() == 0) {
                throw new HandleException(11, "replication_pull_other_transactions and no source sites found");
            }
            this.throwIfNotAllSitesHaveEqualOrGreaterVersion(2, 9, this.replicationSourceSites.getReplicationSourceSites());
        }
        this.replicationStatusFile = new File(configDir, REPLICATION_STATUS_FILE);
        if (this.thisSite.isPrimary || this.replicationSourceSites instanceof HandleBasedReplicationSourceSiteCollection || this.isPullEntireGroupTransactions) {
            this.replicationDb = new ReplicationDb(configDir, server, config);
        }
    }

    private void throwIfNotAllSitesHaveEqualOrGreaterVersion(int majorVersion, int minorVersion, List<ReplicationSourceSiteInfo> sourceSites) throws HandleException {
        for (ReplicationSourceSiteInfo sourceSite : sourceSites) {
            SiteInfo siteInfo = sourceSite.getSite();
            if (AbstractMessage.hasEqualOrGreaterVersion(siteInfo.majorProtocolVersion, siteInfo.minorProtocolVersion, majorVersion, minorVersion)) continue;
            throw new HandleException(11, "replication_pull_other_transactions on but protocol version on source site " + sourceSite.getName() + " too old");
        }
    }

    public void registerReplicationTransactionValidator(TransactionValidator replicationValidator) {
        this.replicationValidator = replicationValidator;
    }

    public ReplicationStateInfo getReplicationStateInfo() {
        return this.replicationStateInfo;
    }

    public void registerReplicationErrorNotifier(NotifierInterface notifier) {
        this.notifier = notifier;
    }

    private List<String> getReplicationAcceptPrefixes(StreamTable config) {
        Vector prefixesVector = (Vector)config.get(REPLICATION_ACCEPT_PREFIXES);
        if (prefixesVector == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < prefixesVector.size(); ++i) {
            String prefix = String.valueOf(prefixesVector.elementAt(i));
            result.add(prefix);
        }
        return result;
    }

    private void loadInitialReplicationStatus() {
        if (this.replicationStatusFile.exists()) {
            try {
                StreamTable replicationConfig = new StreamTable();
                replicationConfig.readFromFile(this.replicationStatusFile);
                this.replicationStateInfo = ReplicationStateInfo.fromStreamTable(replicationConfig, this.replicationSourceSites.getOwnName());
            }
            catch (Exception e) {
                this.server.logError(75, "Exception while reading replication status information: " + e);
                e.printStackTrace();
            }
        } else {
            this.replicationStateInfo = new ReplicationStateInfo();
            this.replicationStateInfo.setOwnName(this.replicationSourceSites.getOwnName());
        }
    }

    @Override
    public StreamTable replicationStatus() throws HandleException {
        if (this.replicationStateInfo == null) {
            return null;
        }
        return ReplicationStateInfo.toStreamTable(this.replicationStateInfo);
    }

    private void saveReplicationInfo() throws HandleException {
        try {
            StreamTable replicationConfig = this.replicationStatus();
            replicationConfig.writeToFile(this.replicationStatusFile, !this.fileWriteNoSync);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            if (e instanceof HandleException) {
                throw (HandleException)e;
            }
            throw new HandleException(1, "Error saving replication state: " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpHandles(boolean deleteAll, SiteInfo[] sites) throws HandleException, IOException {
        this.replicationSourceSites.refresh();
        ReplicationSourceSiteInfo dumpSite = sites == null ? this.getFastestSite() : this.getSiteFromHandle(sites);
        this.pauseReplication();
        try {
            this.dumpHandlesFromSite(dumpSite, deleteAll);
        }
        finally {
            this.unpauseReplication();
        }
    }

    private ReplicationSourceSiteInfo getSiteFromHandle(SiteInfo[] sites) throws HandleException {
        for (ReplicationSourceSiteInfo replicationSourceSite : this.replicationSourceSites.getReplicationSourceSites()) {
            if (replicationSourceSite.getSite() == null) continue;
            for (SiteInfo site : sites) {
                if (!replicationSourceSite.getSite().equals(site)) continue;
                return replicationSourceSite;
            }
        }
        throw new HandleException(1, "Unable to find matching site");
    }

    private ReplicationSourceSiteInfo getFastestSite() throws HandleException {
        ArrayList<SiteTiming> timings = new ArrayList<SiteTiming>();
        for (ReplicationSourceSiteInfo replicationSourceSite : this.replicationSourceSites.getReplicationSourceSites()) {
            if (replicationSourceSite.getSite() == null) continue;
            timings.add(new SiteTiming(replicationSourceSite).getTiming());
        }
        if (timings.size() <= 0) {
            throw new HandleException(2, "No primary servers found for handle dump");
        }
        Collections.sort(timings);
        System.err.println("Dump site timings:");
        for (SiteTiming timing : timings) {
            System.err.println("  " + timing);
        }
        ReplicationSourceSiteInfo dumpSite = ((SiteTiming)timings.get((int)0)).replicationSourceSite;
        return dumpSite;
    }

    @Override
    public void pauseReplication() {
        this.readWriteLock.readLock().lock();
    }

    @Override
    public void unpauseReplication() {
        this.readWriteLock.readLock().unlock();
    }

    static long getInitialDelay(long lastPullTimestamp, long now, long replicationInterval) {
        long timeSinceLastPull = now - lastPullTimestamp;
        long intialDelay = (replicationInterval - timeSinceLastPull % replicationInterval) % replicationInterval;
        return intialDelay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void run() {
        if (this.replicationStartTime != null) {
            long now = System.currentTimeMillis();
            long initialDelay = ReplicationDaemon.getInitialDelay(this.replicationStartTime, now, this.replicationInterval);
            try {
                Thread.sleep(initialDelay);
            }
            catch (InterruptedException e1) {
                Thread.currentThread().interrupt();
            }
        }
        while (this.keepRunning) {
            this.readWriteLock.writeLock().lock();
            try {
                ArrayList<SiteInfo> redumpSites = null;
                try {
                    this.replicationSourceSites.refresh();
                    if (!this.initializedReplicationStatus) {
                        this.loadInitialReplicationStatus();
                        this.initializedReplicationStatus = true;
                    }
                    int primarySites = 0;
                    for (ReplicationSourceSiteInfo replicationSourceSite : this.replicationSourceSites.getReplicationSourceSites()) {
                        SiteInfo site = replicationSourceSite.getSite();
                        if (site == null) continue;
                        ++primarySites;
                        TxnCallback callback = new TxnCallback(this.replicationStateInfo, replicationSourceSite.getName(), site);
                        for (int i = 0; i < site.servers.length; ++i) {
                            long startTime;
                            block30: {
                                RetrieveTxnRequest req;
                                if (site.hashOption == this.thisSite.hashOption && site.servers.length == this.thisSite.servers.length && this.thisServerNum != i) continue;
                                if (this.isPullEntireGroupTransactions) {
                                    req = new RetrieveTxnRequest(this.replicationStateInfo, this.thisSite.hashOption, this.thisSite.servers.length, this.thisServerNum, this.replicationAuth);
                                } else {
                                    long lastTxnId = this.replicationStateInfo.getLastTxnId(i + ":" + replicationSourceSite.getName());
                                    long lastTimestamp = this.replicationStateInfo.getLastTimestamp(i + ":" + replicationSourceSite.getName());
                                    req = new RetrieveTxnRequest(lastTxnId, lastTimestamp, this.thisSite.hashOption, this.thisSite.servers.length, this.thisServerNum, this.replicationAuth);
                                }
                                req.encrypt = false;
                                req.certify = true;
                                req.setSupportedProtocolVersion(site);
                                startTime = System.nanoTime();
                                try {
                                    AbstractResponse res = this.retrievalResolver.sendRequestToServer((AbstractRequest)req, site, site.servers[i]);
                                    if (res.responseCode == 1) {
                                        callback.setServerNum(i);
                                        PublicKey pubKey = site.servers[i].getPublicKey();
                                        int status = ((RetrieveTxnResponse)res).processStreamedPart(callback, pubKey);
                                        if (status == 1) {
                                            this.notifyAboutNeedToRedumpResponse(replicationSourceSite, i);
                                            this.logAboutNeedToRedumpResponse(replicationSourceSite, i);
                                            System.out.println("------------------------------------------------------------\nCRITICAL: REDUMP NEEDED response from site: " + site.servers[i] + "\n------------------------------------------------------------");
                                            System.err.println("------------------------------------------------------------\nCRITICAL: REDUMP NEEDED response from site: " + site.servers[i] + "\n------------------------------------------------------------");
                                            if (redumpSites == null) {
                                                redumpSites = new ArrayList<SiteInfo>();
                                            }
                                            redumpSites.add(site);
                                        } else if (status == 2) {
                                            this.saveReplicationInfo();
                                        } else {
                                            this.server.logError(75, "Unknown status code from server during replication: " + status);
                                        }
                                    } else {
                                        this.server.logError(50, "Unexpected response to replication request: " + res);
                                    }
                                }
                                catch (HandleException e) {
                                    if (e.getCause() instanceof SSLHandshakeException) {
                                        if (e.getCause().getCause() instanceof CertificateException) {
                                            this.server.logError(50, "Error doing replication at server: " + site.servers[i] + ": " + e);
                                            this.server.logError(50, "Note: if this problem persists, a Java upgrade may be needed");
                                            e.printStackTrace(System.err);
                                        } else {
                                            this.server.logError(50, "Error doing replication at server (if occasional handshake failure, safe to ignore): " + site.servers[i] + ": " + e.getCause());
                                        }
                                    }
                                    this.server.logError(50, "Error doing replication at server: " + site.servers[i] + ": " + e);
                                    if (e.getCode() == 7 || e.getCause() instanceof SocketTimeoutException || e.getCause() instanceof HandleException && ((HandleException)e.getCause()).getCode() == 7) break block30;
                                    e.printStackTrace(System.err);
                                }
                            }
                            long endTime = System.nanoTime();
                            long duration = endTime - startTime;
                            double durationInSeconds = (double)duration / 1.0E9;
                            if (durationInSeconds > 10.0) {
                                this.server.logError(25, "Replication sequence at took " + durationInSeconds + " seconds at: " + site.servers[i]);
                            }
                            this.updateRedumpIsNeededStatus(redumpSites);
                        }
                    }
                    if (primarySites == 0 && System.currentTimeMillis() > this.lastNoPrimarySitesLoggedTimestamp + 86400000L) {
                        this.lastNoPrimarySitesLoggedTimestamp = System.currentTimeMillis();
                        this.server.logError(75, "No primary sites found to replicate!");
                    }
                }
                catch (Throwable t) {
                    this.server.logError(75, "Error in replication daemon: " + t);
                    t.printStackTrace(System.err);
                }
            }
            finally {
                this.readWriteLock.writeLock().unlock();
            }
            try {
                Thread.sleep(this.replicationInterval);
            }
            catch (Throwable e) {
                this.server.logError(50, "Error sleeping in replication thread: " + e);
            }
        }
    }

    private void notifyAboutNeedToRedumpResponse(ReplicationSourceSiteInfo replicationSourceSite, int i) throws HandleException {
        if (this.notifier != null) {
            RedumpErrorMessage redumpNotification = new RedumpErrorMessage();
            redumpNotification.receivingSiteInfo = this.thisSite;
            redumpNotification.receivingServerNumber = this.thisServerNum;
            redumpNotification.sourceSiteInfo = replicationSourceSite.getSite();
            redumpNotification.sourceSiteName = replicationSourceSite.getName();
            redumpNotification.sourceServerNumber = i;
            redumpNotification.replicationStateInfo = this.replicationStateInfo;
            this.notifier.sendNotification(GsonUtility.getPrettyGson().toJson((Object)redumpNotification), "RedumpErrorMessage");
        }
    }

    private void logAboutNeedToRedumpResponse(ReplicationSourceSiteInfo replicationSourceSite, int i) {
        RedumpErrorMessage redumpNotification = new RedumpErrorMessage();
        redumpNotification.receivingSiteInfo = this.thisSite;
        redumpNotification.receivingServerNumber = this.thisServerNum;
        redumpNotification.sourceSiteInfo = replicationSourceSite.getSite();
        redumpNotification.sourceSiteName = replicationSourceSite.getName();
        redumpNotification.sourceServerNumber = i;
        redumpNotification.replicationStateInfo = this.replicationStateInfo;
        System.err.println("NEED_TO_REDUMP received from remote server:");
        System.err.println(GsonUtility.getPrettyGson().toJson((Object)redumpNotification));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRedumpIsNeededStatus(ArrayList<SiteInfo> redumpSites) {
        if (redumpSites == null || redumpSites.size() == 0) {
            if (this.redumpNeededFile.exists()) {
                this.redumpNeededFile.delete();
            }
        } else {
            PrintWriter out = null;
            try {
                out = new PrintWriter(this.redumpNeededFile);
                out.println("******************************************************************");
                out.println("*                 REPLICATION IS OUT OF SYNC                     *");
                out.println("******************************************************************");
                out.println("The following primary servers report that our replication with");
                out.println("them is out of date: ");
                for (SiteInfo site : redumpSites) {
                    out.println("Site: " + site);
                }
                out.println("******************************************************************");
                out.close();
            }
            catch (IOException e) {
                System.err.println("Error updating redump-needed file: " + this.redumpNeededFile.getPath());
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
    }

    public void shutdown() {
        this.keepRunning = false;
        try {
            if (this.replicationDb != null) {
                this.replicationDb.shutdown();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public long adjustAndSetLastCreateOrDeleteDate(byte[] handle, long date, int priority) throws HandleException {
        if (this.replicationDb != null) {
            return this.replicationDb.adjustAndSetLastDate(handle, date, priority, false);
        }
        return date;
    }

    public long adjustAndSetLastHomeOrUnhomeDate(byte[] handle, long date, int priority) throws HandleException {
        if (this.replicationDb != null) {
            return this.replicationDb.adjustAndSetLastDate(handle, date, priority, true);
        }
        return date;
    }

    @Override
    public Iterator<byte[]> handleIterator() throws HandleException {
        if (this.replicationDb != null) {
            return this.replicationDb.iterator(false);
        }
        return Collections.emptyList().iterator();
    }

    @Override
    public Iterator<byte[]> naIterator() throws HandleException {
        if (this.replicationDb != null) {
            return this.replicationDb.iterator(true);
        }
        return Collections.emptyList().iterator();
    }

    @Override
    public Iterator<byte[]> handleIteratorFrom(byte[] startingPoint, boolean inclusive) throws HandleException {
        if (this.replicationDb != null) {
            return this.replicationDb.iteratorFrom(false, startingPoint, inclusive);
        }
        return Collections.emptyList().iterator();
    }

    @Override
    public Iterator<byte[]> naIteratorFrom(byte[] startingPoint, boolean inclusive) throws HandleException {
        if (this.replicationDb != null) {
            return this.replicationDb.iteratorFrom(true, startingPoint, inclusive);
        }
        return Collections.emptyList().iterator();
    }

    public synchronized void dumpHandlesFromSite(ReplicationSourceSiteInfo ReplicationSourceSiteInfo2) throws HandleException {
        this.dumpHandlesFromSite(ReplicationSourceSiteInfo2, true);
    }

    public synchronized void dumpHandlesFromSite(ReplicationSourceSiteInfo replicationSourceSite, boolean deleteAll) throws HandleException {
        boolean success = false;
        if (replicationSourceSite == null || replicationSourceSite.getSite() == null) {
            throw new NullPointerException("attempt to dump handles using a null ReplicationSiteInfo");
        }
        SiteInfo site = replicationSourceSite.getSite();
        try {
            System.out.println("------------------------------\n---- REDUMPING HANDLES!!! ----\n------------------------------");
            System.err.println("------------------------------\n---- REDUMPING HANDLES!!! ----\n------------------------------");
            this.server.disable();
            this.replicationStateInfo = new ReplicationStateInfo();
            this.replicationStateInfo.setOwnName(this.replicationSourceSites.getOwnName());
            if (deleteAll) {
                this.server.getStorage().deleteAllRecords();
                if (this.replicationDb != null) {
                    this.replicationDb.deleteAll();
                }
            }
            DumpHandlesRequest req = new DumpHandlesRequest(this.thisSite.hashOption, this.thisSite.servers.length, this.thisServerNum, this.replicationAuth);
            req.setSupportedProtocolVersion(site);
            block4: for (int i = 0; i < site.servers.length; ++i) {
                ServerInfo replServer = site.servers[i];
                if (site.hashOption == this.thisSite.hashOption && site.servers.length == this.thisSite.servers.length && this.thisServerNum != i) continue;
                int resumeCount = 0;
                int resumeTimeoutMs = 5000;
                AbstractResponse response = null;
                DumpHandlesResponse previousResponse = null;
                int maxAttemptsWithoutProgress = 2;
                int resumeWithoutProgressCount = 0;
                while (resumeWithoutProgressCount <= maxAttemptsWithoutProgress) {
                    try {
                        if (resumeCount == 0 || previousResponse == null) {
                            response = this.retrievalResolver.sendRequestToServer((AbstractRequest)req, site, replServer);
                        } else {
                            DumpHandlesRequest resumeRequest = this.createResumeRequest(req, previousResponse);
                            System.err.println("Sending resume dump request");
                            response = this.retrievalResolver.sendRequestToServer((AbstractRequest)resumeRequest, site, replServer);
                        }
                        if (response.responseCode == 1) {
                            if (previousResponse != null && previousResponse.responseCode == 1) {
                                ((DumpHandlesResponse)response).setLastProcessedRecordType(previousResponse.getLastProcessedRecordType());
                                ((DumpHandlesResponse)response).setLastProcessedRecord(previousResponse.getLastProcessedRecord());
                            }
                        } else {
                            throw new HandleException(12, "Response code " + response.responseCode + ":  " + AbstractMessage.getResponseCodeMessage(response.responseCode));
                        }
                        ((DumpHandlesResponse)response).processStreamedPart(new DumpHdlCallback(this.replicationStateInfo, replicationSourceSite.getName(), i), site.servers[i].getPublicKey());
                        success = true;
                        continue block4;
                    }
                    catch (Exception dumpError) {
                        System.out.println("Error dumping server");
                        System.err.println("Error dumping server " + i + ": ");
                        dumpError.printStackTrace();
                        boolean makingProgress = this.isMakingProgress(previousResponse, response);
                        System.err.println("Making progress: " + makingProgress);
                        if (response != null && response.responseCode == 1) {
                            byte lastProcessedRecordType = ((DumpHandlesResponse)response).getLastProcessedRecordType();
                            if (lastProcessedRecordType == -1) {
                                success = true;
                                continue block4;
                            }
                            if (response.hasEqualOrGreaterVersion(2, 8)) {
                                System.out.println("trying again...");
                                System.err.println("trying again...");
                                previousResponse = (DumpHandlesResponse)response;
                            } else {
                                System.out.println("Dump handles response interrupted and server does not support resumption.");
                                System.out.println("Dump handles response interrupted and server does not support resumption.");
                            }
                        }
                        ++resumeCount;
                        resumeWithoutProgressCount = makingProgress ? 0 : ++resumeWithoutProgressCount;
                        Thread.sleep(resumeTimeoutMs);
                    }
                }
            }
            if (success) {
                this.saveReplicationInfo();
                this.server.enable();
                System.out.println("------------------------------------\n---------- REDUMP FINISHED ---------\n------------------------------------");
                System.err.println("------------------------------------\n---------- REDUMP FINISHED ---------\n------------------------------------");
            } else {
                System.out.println("------------------------------------\n---------- REDUMP FAILED -----------\n------------------------------------");
                System.err.println("------------------------------------\n---------- REDUMP FAILED -----------\n------------------------------------");
            }
        }
        catch (Throwable e) {
            this.server.logError(75, "Error attempting to reload all handles: " + e);
            e.printStackTrace();
        }
    }

    private boolean isMakingProgress(DumpHandlesResponse previousResponse, AbstractResponse currentResponse) {
        if (currentResponse == null || currentResponse.responseCode != 1) {
            return false;
        }
        byte currentProcessedRecordType = ((DumpHandlesResponse)currentResponse).getLastProcessedRecordType();
        byte[] currentProcessedRecord = ((DumpHandlesResponse)currentResponse).getLastProcessedRecord();
        System.err.println("Current record type: " + currentProcessedRecordType);
        System.err.println("Current record: " + Util.decodeString(currentProcessedRecord));
        if (previousResponse == null) {
            System.out.println("No previous response, this is the first attempt.");
            return currentResponse.responseCode == 1;
        }
        if (currentResponse.responseCode == 1) {
            byte previousProcessedRecordType = previousResponse.getLastProcessedRecordType();
            byte[] previousProcessedRecord = previousResponse.getLastProcessedRecord();
            System.err.println("Previous record type: " + previousProcessedRecordType);
            System.err.println("Previous record: " + Util.decodeString(previousProcessedRecord));
            if (currentProcessedRecordType == previousProcessedRecordType) {
                return !Arrays.equals(currentProcessedRecord, previousProcessedRecord);
            }
            return !ReplicationDaemon.isRecordTypeComesBeforeInDumpSequence(currentProcessedRecordType, previousProcessedRecordType);
        }
        return false;
    }

    static boolean isRecordTypeComesBeforeInDumpSequence(byte a, byte b) {
        if (a == b) {
            return false;
        }
        ArrayList<Byte> recordTypesInOrder = new ArrayList<Byte>();
        recordTypesInOrder.add((byte)0);
        recordTypesInOrder.add((byte)5);
        recordTypesInOrder.add((byte)3);
        recordTypesInOrder.add((byte)4);
        recordTypesInOrder.add((byte)1);
        recordTypesInOrder.add((byte)2);
        recordTypesInOrder.add((byte)-1);
        int indexOfA = recordTypesInOrder.indexOf(a);
        int indexOfB = recordTypesInOrder.indexOf(b);
        return indexOfA < indexOfB;
    }

    private DumpHandlesRequest createResumeRequest(DumpHandlesRequest originalRequest, DumpHandlesResponse previousResponse) {
        byte[] startingPoint = previousResponse.getLastProcessedRecord();
        int startingPointType = -2;
        byte lastProcessedRecordType = previousResponse.getLastProcessedRecordType();
        if (lastProcessedRecordType == 3) {
            startingPointType = 0;
        } else if (lastProcessedRecordType == 4) {
            startingPointType = 1;
        } else if (lastProcessedRecordType == 1) {
            startingPointType = 2;
        } else if (lastProcessedRecordType == 2) {
            startingPointType = 3;
        } else {
            if (lastProcessedRecordType == 0) {
                return originalRequest;
            }
            if (lastProcessedRecordType == 5) {
                return originalRequest;
            }
            return originalRequest;
        }
        DumpHandlesRequest resumeRequest = new DumpHandlesRequest(originalRequest.rcvrHashType, originalRequest.numServers, originalRequest.serverNum, originalRequest.authInfo, startingPoint, startingPointType);
        return resumeRequest;
    }

    private void runIfMoreRecent(RunnableThrowingHandleException runnable, byte[] handle, long date, int priority, boolean isNA) throws HandleException {
        if (this.replicationDb == null) {
            runnable.run();
        } else if (this.replicationDb.isMoreRecentThanLastDate(handle, date, priority, isNA)) {
            runnable.run();
            this.replicationDb.setLastDate(handle, date, priority, isNA);
        }
    }

    private static String getSiteNameFromQueueName(String name) {
        int colon = name.indexOf(58);
        return name.substring(colon + 1);
    }

    private static int getIndexFromQueueName(String name) {
        String siteName = ReplicationDaemon.getSiteNameFromQueueName(name);
        int colon = siteName.indexOf(58);
        if (colon < 0) {
            return 0;
        }
        return Integer.parseInt(siteName.substring(0, colon));
    }

    @Override
    public void addQueueListener(TransactionQueueListener l) {
        this.queueListeners.add(l);
    }

    @Override
    public void removeQueueListener(TransactionQueueListener l) {
        this.queueListeners.remove(l);
    }

    protected void notifyQueueListeners(Transaction txn) {
        for (TransactionQueueListener listener : this.queueListeners) {
            try {
                listener.transactionAdded(txn);
            }
            catch (Exception e) {
                System.err.println("error notifying queue listeners: " + e);
                e.printStackTrace(System.err);
            }
        }
    }

    protected void shutdownQueueListeners() {
        for (TransactionQueueListener listener : this.queueListeners) {
            try {
                listener.shutdown();
            }
            catch (Exception e) {
                System.err.println("error in queue listeners shutdown: " + e);
                e.printStackTrace(System.err);
            }
        }
    }

    class TxnCallback
    implements TransactionCallback {
        private int currentServerNum = -1;
        private final ReplicationStateInfo replicationStateInfo;
        private final String sourceSiteName;
        private final SiteInfo sourceSite;

        public TxnCallback(ReplicationStateInfo replicationStateInfo, String sourceSiteName, SiteInfo sourceSite) {
            this.replicationStateInfo = replicationStateInfo;
            this.sourceSiteName = sourceSiteName;
            this.sourceSite = sourceSite;
        }

        public void setServerNum(int newServerNum) {
            this.currentServerNum = newServerNum;
        }

        @Override
        public void processTransaction(Transaction txn) throws HandleException {
            this.processTransaction(this.currentServerNum + ":" + this.sourceSiteName, txn);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void processTransaction(String queueName, Transaction txn) throws HandleException {
            TransactionValidator.ValidationResult validationResult = null;
            if (ReplicationDaemon.this.replicationValidator != null) {
                validationResult = ReplicationDaemon.this.replicationValidator.validate(txn);
            }
            if (validationResult != null && !validationResult.isValid()) {
                String logMessage = "--Denied!";
                if (validationResult.getMessage() != null) {
                    logMessage = logMessage + " (" + validationResult.getMessage() + ")";
                }
                logMessage = logMessage + txn;
                if (validationResult.getReport() != null) {
                    logMessage = logMessage + "\n" + validationResult.getReport();
                }
                System.err.println(logMessage);
                if (ReplicationDaemon.this.notifier != null) {
                    try {
                        TransactionValidationErrorMessage notification = new TransactionValidationErrorMessage(txn.values, txn, ReplicationDaemon.this.server.getSiteInfo(), ReplicationDaemon.this.server.getServerNum(), this.sourceSite, this.currentServerNum, validationResult.getMessage(), validationResult.getReport());
                        String notificationJson = GsonUtility.getNewGsonBuilder().setPrettyPrinting().create().toJson((Object)notification);
                        ReplicationDaemon.this.notifier.sendNotification(notificationJson, "TransactionValidationErrorMessage");
                    }
                    catch (Exception e) {
                        ReplicationDaemon.this.server.logError(75, "Exception while attempting notification: " + e);
                        e.printStackTrace();
                    }
                }
            } else if (ReplicationDaemon.this.replicationPrefixFilter != null && !ReplicationDaemon.this.replicationPrefixFilter.acceptTransaction(txn)) {
                System.err.println("--Transaction skipped by filter: " + txn);
            } else {
                HandleStorage storage = ReplicationDaemon.this.server.getStorage();
                int priority = ReplicationDaemon.getIndexFromQueueName(queueName);
                System.err.println("--Processing " + txn);
                byte[] handle = ReplicationDaemon.this.caseSensitive ? txn.handle : Util.upperCase(txn.handle);
                Object object = ReplicationDaemon.this.server.getWriteLock(handle);
                synchronized (object) {
                    switch (txn.action) {
                        case 1: 
                        case 3: {
                            ReplicationDaemon.this.runIfMoreRecent(() -> storage.createOrUpdateRecord(handle, txn.values), handle, txn.date, priority, false);
                            break;
                        }
                        case 2: {
                            ReplicationDaemon.this.runIfMoreRecent(() -> {
                                if (!storage.deleteHandle(handle)) {
                                    ReplicationDaemon.this.server.logError(50, "Warning: got delete-handle transaction for non-existent handle: " + Util.decodeString(txn.handle));
                                }
                            }, handle, txn.date, priority, false);
                            break;
                        }
                        case 4: {
                            ReplicationDaemon.this.runIfMoreRecent(() -> {
                                storage.setHaveNA(handle, true);
                                ReplicationDaemon.this.server.adjustHomedPrefix(handle, true);
                            }, handle, txn.date, priority, true);
                            break;
                        }
                        case 5: {
                            ReplicationDaemon.this.runIfMoreRecent(() -> {
                                storage.setHaveNA(handle, false);
                                ReplicationDaemon.this.server.adjustHomedPrefix(handle, false);
                            }, handle, txn.date, priority, true);
                            break;
                        }
                        default: {
                            ReplicationDaemon.this.server.logError(75, "Encountered unknown transaction type (" + txn.action + ") during replication for handle: " + Util.decodeString(txn.handle));
                        }
                    }
                }
            }
            TransactionQueuesInterface otherTransactionQueues = ReplicationDaemon.this.server.getAllOtherTransactionQueues();
            if (otherTransactionQueues != null) {
                try {
                    TransactionQueueInterface otherTransactionQueue = otherTransactionQueues.getOrCreateTransactionQueue(queueName);
                    otherTransactionQueue.addTransaction(txn);
                }
                catch (Exception e) {
                    throw new HandleException(1, (Throwable)e);
                }
            }
            ReplicationDaemon.this.notifyQueueListeners(txn);
            this.replicationStateInfo.setLastTxnId(queueName, txn.txnId);
        }

        @Override
        public void setQueueLastTimestamp(String queueName, long sourceDate) {
            this.replicationStateInfo.setLastTimestamp(queueName, sourceDate);
        }

        @Override
        public void finishProcessing(long date) {
            this.setQueueLastTimestamp(this.currentServerNum + ":" + this.sourceSiteName, date);
            this.finishProcessing();
        }

        @Override
        public void finishProcessing() {
        }
    }

    static interface RunnableThrowingHandleException {
        public void run() throws HandleException;
    }

    class DumpHdlCallback
    implements DumpHandlesCallback {
        private final ReplicationStateInfo replicationStateInfo;
        private final String sourceSiteName;
        private int currentServerNum = -1;
        private boolean gotSourceSiteReplicationStatus;

        DumpHdlCallback(ReplicationStateInfo replicationStateInfo, String sourceSiteName, int serverNum) {
            this.replicationStateInfo = replicationStateInfo;
            this.sourceSiteName = sourceSiteName;
            this.currentServerNum = serverNum;
            System.err.println("Starting dump of source server #" + serverNum);
        }

        @Override
        public synchronized void addHandle(byte[] handle, HandleValue[] values) throws Exception {
            if (!ReplicationDaemon.this.caseSensitive) {
                handle = Util.upperCase(handle);
            }
            if (ReplicationDaemon.this.replicationPrefixFilter != null && !ReplicationDaemon.this.replicationPrefixFilter.acceptHandle(handle)) {
                System.err.println("--Handle skipped by prefix filter: " + Util.decodeString(handle));
                return;
            }
            System.err.println("---> " + Util.decodeString(handle));
            ReplicationDaemon.this.server.getStorage().createOrUpdateRecord(handle, values);
        }

        @Override
        public synchronized void addHomedPrefix(byte[] authHandle) throws Exception {
            if (ReplicationDaemon.this.replicationPrefixFilter != null && !ReplicationDaemon.this.replicationPrefixFilter.acceptNA(authHandle)) {
                System.err.println("--NA skipped by prefix filter: " + Util.decodeString(authHandle));
                return;
            }
            System.err.println("---NA> " + Util.decodeString(authHandle));
            ReplicationDaemon.this.server.getStorage().setHaveNA(authHandle, true);
        }

        @Override
        public synchronized void processThisServerReplicationInfo(long date, long txnId) {
            System.err.println("----received replication status: server=" + this.currentServerNum + " date=" + new Date(date) + "; last txnId: " + txnId);
            this.replicationStateInfo.setLastTxnId(this.currentServerNum + ":" + this.sourceSiteName, txnId);
            this.replicationStateInfo.setLastTimestamp(this.currentServerNum + ":" + this.sourceSiteName, date);
            this.gotSourceSiteReplicationStatus = true;
        }

        @Override
        public synchronized void processOtherSiteReplicationInfo(StreamTable otherReplicationConfig) throws HandleException {
            System.err.println("----getting replication info for other sites:");
            ReplicationStateInfo receivedReplicationStateInfo = ReplicationStateInfo.fromStreamTable(otherReplicationConfig, null);
            for (String name : receivedReplicationStateInfo.keySet()) {
                if (ReplicationStateInfo.isQueueNameInSiteNamed(name, this.sourceSiteName) && this.gotSourceSiteReplicationStatus || this.replicationStateInfo.isQueueNameInOwnSite(name)) continue;
                this.replicationStateInfo.setLastTxnId(name, receivedReplicationStateInfo.getLastTxnId(name));
                this.replicationStateInfo.setLastTimestamp(name, receivedReplicationStateInfo.getLastTimestamp(name));
            }
            ReplicationDaemon.this.saveReplicationInfo();
            System.err.println("------done.");
        }

        @Override
        public synchronized void setLastCreateOrDeleteDate(byte[] handle, long date, int priority) throws HandleException {
            System.err.println("---(date)> " + Util.decodeString(handle));
            if (ReplicationDaemon.this.replicationDb != null) {
                ReplicationDaemon.this.replicationDb.setLastDate(handle, date, priority, false);
            }
        }

        @Override
        public synchronized void setLastHomeOrUnhomeDate(byte[] handle, long date, int priority) throws HandleException {
            System.err.println("---NA(date)> " + Util.decodeString(handle));
            if (ReplicationDaemon.this.replicationDb != null) {
                ReplicationDaemon.this.replicationDb.setLastDate(handle, date, priority, true);
            }
        }
    }

    private class SiteTiming
    implements Comparable<SiteTiming> {
        ReplicationSourceSiteInfo replicationSourceSite;
        SiteInfo site;
        long responseTime = Integer.MAX_VALUE;

        SiteTiming(ReplicationSourceSiteInfo replicationSourceSite) {
            this.replicationSourceSite = replicationSourceSite;
            this.site = replicationSourceSite.getSite();
            this.responseTime = -1L;
            this.getTiming();
        }

        public String toString() {
            return "time=" + this.responseTime + " ms;  site=" + this.site;
        }

        public SiteTiming getTiming() {
            this.responseTime = Integer.MAX_VALUE;
            long startTime = System.currentTimeMillis();
            try {
                GenericRequest req = new GenericRequest(Common.BLANK_HANDLE, 2, null);
                AbstractResponse resp = ReplicationDaemon.this.retrievalResolver.sendRequestToSite(req, this.site);
                this.responseTime = resp.responseCode != 1 ? 0x7FFFFFFEL : System.currentTimeMillis() - startTime;
            }
            catch (Throwable t) {
                System.err.println("Error timing connection to site: " + this.site);
            }
            return this;
        }

        @Override
        public int compareTo(SiteTiming o) {
            return Long.compare(this.responseTime, o.responseTime);
        }
    }
}

