/*
 * Decompiled with CFR 0.152.
 */
package net.handle.server.replication;

import java.io.File;
import java.util.List;
import net.cnri.util.SimpleCommandLine;
import net.cnri.util.StreamTable;
import net.handle.hdllib.HandleRecord;
import net.handle.hdllib.HandleResolver;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.SiteInfo;
import net.handle.hdllib.Util;
import net.handle.hdllib.trust.ChainBuilder;
import net.handle.hdllib.trust.ChainVerifier;
import net.handle.hdllib.trust.HandleRecordTrustVerifier;
import net.handle.hdllib.trust.TrustException;
import net.handle.server.Main;

public class DumpHandles {
    private static void printUsage() {
        System.err.println("Usage: hdl-dumpfromprimary [-no-delete] [-service-handle <handle>] <server-directory>");
    }

    public static void main(String[] argv) throws Exception {
        Main main = null;
        SimpleCommandLine simpleCommandLine = new SimpleCommandLine(new String[]{"service-handle"});
        simpleCommandLine.parse(argv);
        boolean deleteAll = !simpleCommandLine.hasOption("no-delete");
        String serviceHandle = simpleCommandLine.getOptionArgument("service-handle");
        List operands = simpleCommandLine.getOperands();
        if (operands.size() != 1) {
            DumpHandles.printUsage();
            return;
        }
        String configDirStr = (String)operands.get(0);
        StreamTable configTable = new StreamTable();
        File serverDir = new File(configDirStr);
        if (!serverDir.exists() || !serverDir.isDirectory()) {
            System.err.println("Invalid configuration directory: " + configDirStr + ".");
            return;
        }
        try {
            configTable.readFromFile(new File(serverDir, "config.dct"));
        }
        catch (Exception e) {
            System.err.println("Error reading configuration: " + e);
            return;
        }
        try {
            main = new Main(serverDir, configTable);
            main.logError(25, "Handle.net Server Software version 9.2.0");
            SiteInfo[] sites = null;
            if (serviceHandle != null) {
                sites = DumpHandles.getServiceHandleSites(serviceHandle);
            }
            main.dumpFromPrimary(deleteAll, sites);
            main.shutdown();
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
            System.out.println("Error: " + e.getMessage());
            System.out.println("       (see the error log for details.)\n");
            System.out.println("Shutting down...");
            System.err.println("Shutting down...");
            if (main != null) {
                try {
                    main.shutdown();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            System.exit(0);
        }
    }

    private static SiteInfo[] getServiceHandleSites(String serviceHandle) throws Exception {
        HandleValue[] values;
        HandleRecord handleRecord;
        HandleResolver resolver = new HandleResolver();
        ChainBuilder builder = new ChainBuilder(resolver);
        ChainVerifier verifier = new ChainVerifier(resolver.getConfiguration().getRootKeys());
        HandleRecordTrustVerifier handleRecordTrustVerifier = new HandleRecordTrustVerifier(builder, verifier);
        if (!handleRecordTrustVerifier.validateHandleRecord(handleRecord = new HandleRecord(serviceHandle, values = resolver.resolveHandle(serviceHandle)))) {
            throw new TrustException("Unable to obtain and validate service handle record from resolver!");
        }
        System.out.println("Dumping from sites at " + serviceHandle);
        return Util.getSitesFromValues(values);
    }
}

