/*
 * Decompiled with CFR 0.152.
 */
package net.handle.server.dns;

import java.io.File;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Vector;
import net.cnri.util.StreamTable;
import net.handle.hdllib.AbstractRequest;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleResolver;
import net.handle.hdllib.ResponseMessageCallback;
import net.handle.server.AbstractServer;
import net.handle.server.Main;
import net.handle.server.NetworkInterface;
import net.handle.server.dns.DnsConfiguration;

public class DNSServer
extends Main {
    public DNSServer(StreamTable configTable) throws Exception {
        super(new File("."), configTable);
        this.configTable = configTable;
    }

    @Override
    public void dumpFromPrimary(boolean deleteAll) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void initialize() throws Exception {
        if (this.server != null) {
            throw new HandleException(15, "Server has already been initialized");
        }
        this.resolver = new HandleResolver();
        if (this.configTable.containsKey("tcp_timeout")) {
            int timeout = Integer.parseInt((String)this.configTable.get("tcp_timeout"));
            this.resolver.setTcpTimeout(timeout);
        }
        this.resolver.setCheckSignatures(true);
        this.resolver.traceMessages = this.configTable.getBoolean("trace_resolution") || this.configTable.getBoolean("trace_outgoing_messages");
        this.server = new Server((StreamTable)this.configTable.get("server_config"), this.resolver);
        this.dnsConfig = new DnsConfiguration(this.server, (StreamTable)this.configTable.get("dns_config"));
        this.interfaces = new Vector(2);
        this.interfaces.add(NetworkInterface.getInstance(this, "dns_udp", this.configTable));
        this.interfaces.add(NetworkInterface.getInstance(this, "dns_tcp", this.configTable));
    }

    @Override
    public void start() {
        for (NetworkInterface interfc : this.interfaces) {
            Thread t = new Thread(interfc);
            t.start();
        }
    }

    @Override
    public void shutdown() {
        for (NetworkInterface interfc : this.interfaces) {
            try {
                interfc.stopRunning();
            }
            catch (Throwable e) {
                this.logError(75, "unable to shut down interface " + interfc + "; reason: " + e);
            }
        }
        this.server.shutdown();
        if (this.logger != null) {
            try {
                this.logger.shutdown();
            }
            catch (Exception e) {
                System.err.println("Error shutting down logger: " + e);
            }
        }
        this.dnsConfig.getNameServer().shutdown();
    }

    public class Server
    extends AbstractServer {
        public Server(StreamTable configTable, HandleResolver resolver) {
            super(DNSServer.this, configTable, resolver);
        }

        @Override
        public void dumpHandles() throws HandleException, IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void processRequest(AbstractRequest req, ResponseMessageCallback callback) throws HandleException {
            this.resolver.processRequest(req, callback);
        }

        @Override
        public void shutdown() {
            super.shutdown();
        }

        @Override
        public PublicKey getPublicKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public PrivateKey getPrivateKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public X509Certificate getCertificate() {
            throw new UnsupportedOperationException();
        }

        @Override
        public X509Certificate[] getCertificateChain() {
            throw new UnsupportedOperationException();
        }

        @Override
        public PrivateKey getCertificatePrivateKey() {
            throw new UnsupportedOperationException();
        }
    }
}

