/*
 * Decompiled with CFR 0.152.
 */
package net.handle.server;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;
import oshi.hardware.GlobalMemory;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.software.os.NetworkParams;
import oshi.software.os.OSFileStore;
import oshi.software.os.OperatingSystem;

public class SystemInfoWrapper {
    private final HardwareAbstractionLayer hal;
    private final OperatingSystem os;

    public SystemInfoWrapper() {
        SystemInfo systemInfo = new SystemInfo();
        this.hal = systemInfo.getHardware();
        this.os = systemInfo.getOperatingSystem();
    }

    public String getFQDN() {
        NetworkParams net = this.os.getNetworkParams();
        String hostname = net.getHostName();
        String domain = net.getDomainName();
        return hostname + "." + domain;
    }

    public JsonArray getDiskInfo() {
        OSFileStore[] fsystems;
        JsonArray diskInfos = new JsonArray();
        for (OSFileStore system : fsystems = this.os.getFileSystem().getFileStores()) {
            JsonObject diskInfo = new JsonObject();
            String devName = system.getName();
            String dirName = system.getMount();
            String name = devName + ":" + dirName;
            long freeBytes = system.getUsableSpace();
            long totalBytes = system.getTotalSpace();
            long usedBytes = totalBytes - freeBytes;
            diskInfo.addProperty("name", name);
            diskInfo.addProperty("free", (Number)freeBytes);
            diskInfo.addProperty("used", (Number)usedBytes);
            diskInfos.add((JsonElement)diskInfo);
        }
        return diskInfos;
    }

    public JsonObject getMemInfo() {
        JsonObject memInfo = new JsonObject();
        GlobalMemory mem = this.hal.getMemory();
        long available = mem.getAvailable();
        long total = mem.getTotal();
        memInfo.addProperty("used", (Number)(total - available));
        memInfo.addProperty("free", (Number)available);
        return memInfo;
    }

    public JsonArray getLoadAverageInfo() {
        double[] laArray;
        JsonArray loadAverageInfo = new JsonArray();
        CentralProcessor processor = this.hal.getProcessor();
        for (double la : laArray = processor.getSystemLoadAverage(3)) {
            loadAverageInfo.add((Number)this.fixDoubleForJson(la));
        }
        return loadAverageInfo;
    }

    private double fixDoubleForJson(double d) {
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return -1.0;
        }
        return d;
    }
}

