/*
 * Decompiled with CFR 0.152.
 */
package net.handle.server;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.net.InetAddress;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import net.cnri.util.StreamTable;
import net.handle.hdllib.Util;

public class ServerLog
implements Runnable {
    public static final int ACCESS_LOG_BUFFER_SIZE = 100000;
    public static final int ERRLOG_LEVEL_EVERYTHING = 0;
    public static final int ERRLOG_LEVEL_INFO = 25;
    public static final int ERRLOG_LEVEL_NORMAL = 50;
    public static final int ERRLOG_LEVEL_REALBAD = 75;
    public static final int ERRLOG_LEVEL_FATAL = 100;
    private int errorLoggingLevel = 25;
    private static Map<String, Integer> calendarDays = new HashMap<String, Integer>();
    private File logDirectory = null;
    private Writer accessWriter = null;
    private Writer errorWriter = null;
    private PrintStream errorPrintStream = null;
    private boolean continuing = true;
    private boolean loggingAccesses = false;
    private boolean redirectStdErr = true;
    private final String ERROR_LOG_LOCK = "error_log_lock";
    private final String ACCESS_LOG_LOCK = "access_log_lock";
    private final Calendar accessCal = Calendar.getInstance();
    private Thread flusherThread = null;
    private Thread rotaterThread = null;

    public ServerLog(File logDir, StreamTable config) throws Exception {
        this.logDirectory = logDir;
        if (this.logDirectory != null) {
            this.loadConfig(config);
            this.logError(25, "Started new run.");
            this.flusherThread = new Thread(this);
            this.flusherThread.setDaemon(true);
            this.flusherThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getAccessLogDate() {
        StringBuffer sb = new StringBuffer(40);
        Calendar calendar = this.accessCal;
        synchronized (calendar) {
            this.accessCal.setTimeInMillis(System.currentTimeMillis());
            sb.append(this.accessCal.get(1));
            sb.append('-');
            int tmpInt = this.accessCal.get(2) + 1;
            if (tmpInt < 10) {
                sb.append('0');
            }
            sb.append(tmpInt);
            sb.append('-');
            tmpInt = this.accessCal.get(5);
            if (tmpInt < 10) {
                sb.append('0');
            }
            sb.append(tmpInt);
            sb.append(' ');
            tmpInt = this.accessCal.get(11);
            if (tmpInt < 10) {
                sb.append('0');
            }
            sb.append(tmpInt);
            sb.append(':');
            tmpInt = this.accessCal.get(12);
            if (tmpInt < 10) {
                sb.append('0');
            }
            sb.append(tmpInt);
            sb.append(':');
            tmpInt = this.accessCal.get(13);
            if (tmpInt < 10) {
                sb.append('0');
            }
            sb.append(tmpInt);
            sb.append('.');
            tmpInt = this.accessCal.get(14);
            if (tmpInt < 10) {
                sb.append('0').append('0');
            } else if (tmpInt < 100) {
                sb.append('0');
            }
            sb.append(tmpInt);
            tmpInt = (this.accessCal.get(15) + this.accessCal.get(16)) / 60000;
            if (tmpInt < 0) {
                sb.append('-');
                int tzHours = (tmpInt *= -1) / 60;
                tmpInt %= 60;
                if (tzHours < 10) {
                    sb.append('0');
                }
                sb.append(tzHours);
                if (tmpInt < 10) {
                    sb.append(tmpInt);
                }
                sb.append(tmpInt);
            } else if (tmpInt > 0) {
                sb.append('+');
                int tzHours = tmpInt / 60;
                tmpInt %= 60;
                if (tzHours < 10) {
                    sb.append('0');
                }
                sb.append(tzHours);
                if (tmpInt < 10) {
                    sb.append(tmpInt);
                }
                sb.append(tmpInt);
            } else {
                sb.append('Z');
            }
        }
        return sb.toString();
    }

    private void loadConfig(StreamTable config) throws Exception {
        Object obj = config.get("interfaces");
        if (obj instanceof Vector) {
            Vector frontEndLabels = (Vector)obj;
            for (Object labelObj : frontEndLabels) {
                if (!(labelObj instanceof String)) continue;
                StreamTable conf = (StreamTable)config.get((String)labelObj + "_config");
                this.loggingAccesses = conf.getBoolean("log_accesses");
                if (!this.loggingAccesses) continue;
                break;
            }
        }
        LogRotater logRotater = null;
        StreamTable conf = (StreamTable)config.get("log_save_config");
        if (conf == null) {
            conf = new StreamTable();
        }
        this.redirectStdErr = conf.getBoolean("log_redirect_stderr", this.redirectStdErr);
        String saveLogInterval = conf.getStr("log_save_interval", "Never");
        File serverDir = this.logDirectory;
        this.logDirectory = new File(conf.getStr("log_save_directory", "logs"));
        if (!this.logDirectory.isAbsolute()) {
            this.logDirectory = new File(serverDir, conf.getStr("log_save_directory", "logs"));
        }
        if (saveLogInterval.equalsIgnoreCase("Weekly")) {
            String saveLogWeekdayStr = conf.getStr("log_save_weekday", "");
            Integer saveLogWeekdayObj = calendarDays.get(saveLogWeekdayStr);
            int saveLogWeekday = saveLogWeekdayObj == null ? 1 : saveLogWeekdayObj;
            logRotater = new WeeklyRotater(saveLogWeekday);
        } else if (saveLogInterval.equalsIgnoreCase("Daily")) {
            logRotater = new DailyRotater();
        } else if (saveLogInterval.equalsIgnoreCase("Monthly")) {
            logRotater = new MonthlyRotater();
        } else if (saveLogInterval.equalsIgnoreCase("Never")) {
            logRotater = new DefaultRotater();
        } else {
            throw new Exception("Invalid log rotation interval: \"" + saveLogInterval + "\" for " + "log_save_interval" + " setting in config file");
        }
        if (this.logDirectory.exists()) {
            if (!this.logDirectory.isDirectory()) {
                throw new Exception("\"" + this.logDirectory.getAbsolutePath() + "\" is not a directory.");
            }
        } else {
            this.logDirectory.mkdirs();
        }
        logRotater.init();
        this.rotaterThread = new Thread(logRotater);
        this.rotaterThread.setPriority(1);
        this.rotaterThread.setDaemon(true);
        this.rotaterThread.start();
        while (!logRotater.initialized()) {
            try {
                Thread.sleep(500L);
            }
            catch (Throwable throwable) {}
        }
    }

    public void setErrorLogLevel(int newLogLevel) {
        this.errorLoggingLevel = newLogLevel;
    }

    private static String removeNewlines(String s) {
        return s.replace("\n", "\\n").replace("\r", "\\r");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void logAccess(String accessType, InetAddress clientAddr, int opCode, int rsCode, String logString, long time) {
        if (logString == null || this.accessWriter == null) return;
        String msg = (clientAddr == null ? "" : Util.rfcIpRepr(clientAddr)) + " " + accessType + " \"" + this.getAccessLogDate() + "\" " + opCode + " " + rsCode + " " + time + "ms " + ServerLog.removeNewlines(logString);
        String string = "access_log_lock";
        synchronized ("access_log_lock") {
            if (this.accessWriter == null) return;
            try {
                this.accessWriter.write(msg + "\n");
            }
            catch (Exception e) {
                System.err.println("Error writing to access log: (" + e + "): " + logString);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logError(int level, String logString) {
        if (level < this.errorLoggingLevel || logString == null) {
            return;
        }
        String msg = "\"" + this.getAccessLogDate() + "\" " + level + ' ' + logString;
        if (this.errorWriter != null) {
            String string = "error_log_lock";
            synchronized ("error_log_lock") {
                try {
                    this.errorWriter.write(msg + '\n');
                    this.errorWriter.flush();
                }
                catch (Throwable e) {
                    System.err.println("Error (" + e + ") writing \"" + logString + "\" to error log.");
                }
            }
        }
        System.err.println(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAccessLogFile(File newAccessLogFile) throws IOException {
        String string = "access_log_lock";
        synchronized ("access_log_lock") {
            if (this.accessWriter != null) {
                this.accessWriter.flush();
                this.accessWriter.close();
                this.accessWriter = null;
            }
            if (this.loggingAccesses) {
                this.accessWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(newAccessLogFile.getAbsolutePath(), true), "UTF-8"), 100000);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setErrorLogFile(File newErrorLogFile) throws IOException {
        String string = "error_log_lock";
        synchronized ("error_log_lock") {
            Writer oldWriter = null;
            PrintStream oldPrintStream = null;
            try {
                oldWriter = this.errorWriter;
                this.errorWriter = null;
                oldPrintStream = this.errorPrintStream;
                this.errorPrintStream = null;
                FileOutputStream errf = new FileOutputStream(newErrorLogFile.getAbsolutePath(), true);
                this.errorPrintStream = new PrintStream(errf);
                if (this.redirectStdErr) {
                    System.setErr(this.errorPrintStream);
                }
                this.errorWriter = new OutputStreamWriter((OutputStream)errf, "UTF-8");
            }
            finally {
                try {
                    if (oldPrintStream != null) {
                        oldPrintStream.flush();
                    }
                    if (oldWriter != null) {
                        oldWriter.close();
                    }
                    if (oldPrintStream != null) {
                        oldPrintStream.close();
                    }
                }
                catch (Throwable throwable) {}
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        while (this.continuing) {
            try {
                String string = "access_log_lock";
                // MONITORENTER : "access_log_lock"
                if (this.accessWriter != null) {
                    this.accessWriter.flush();
                }
                // MONITOREXIT : string
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                Thread.sleep(60000L);
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void shutdown() {
        this.continuing = false;
        if (this.flusherThread != null) {
            String string = "access_log_lock";
            // MONITORENTER : "access_log_lock"
            try {
                this.flusherThread.interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.rotaterThread.interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.accessWriter != null) {
            try {
                this.accessWriter.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.errorWriter == null) return;
        try {
            this.errorWriter.close();
            return;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        calendarDays.put("Sunday", 1);
        calendarDays.put("Monday", 2);
        calendarDays.put("Tuesday", 3);
        calendarDays.put("Wednesday", 4);
        calendarDays.put("Thursday", 5);
        calendarDays.put("Friday", 6);
        calendarDays.put("Saturday", 7);
    }

    class DefaultRotater
    extends LogRotater {
        protected Calendar cal;

        DefaultRotater() {
            this.cal = Calendar.getInstance();
        }

        @Override
        public long getNextRotationTime(long currentTime) {
            return Long.MAX_VALUE;
        }

        @Override
        public String getLogFileSuffix(long currentTime) {
            return "";
        }
    }

    class DailyRotater
    extends LogRotater {
        protected Calendar cal;

        DailyRotater() {
            this.cal = Calendar.getInstance();
        }

        @Override
        public long getNextRotationTime(long currentTime) {
            this.cal.setTime(new Date(currentTime));
            this.cal.add(5, 1);
            this.cal.set(11, 0);
            this.cal.set(12, 0);
            this.cal.set(13, 1);
            this.cal.set(14, 0);
            return this.cal.getTime().getTime();
        }

        @Override
        public String getLogFileSuffix(long currentTime) {
            this.cal.setTime(new Date(currentTime));
            this.cal.set(11, 0);
            this.cal.set(12, 0);
            this.cal.set(13, 1);
            return this.getSuffixForDate(this.cal);
        }
    }

    class MonthlyRotater
    extends LogRotater {
        protected Calendar cal;

        MonthlyRotater() {
            this.cal = Calendar.getInstance();
        }

        @Override
        public long getNextRotationTime(long currentTime) {
            this.cal.setTime(new Date(currentTime));
            int thisMonth = this.cal.get(2);
            while (this.cal.get(2) == thisMonth) {
                this.cal.add(5, 1);
            }
            this.cal.set(11, 0);
            this.cal.set(12, 0);
            this.cal.set(13, 1);
            this.cal.set(14, 0);
            return this.cal.getTime().getTime();
        }

        @Override
        public String getLogFileSuffix(long currentTime) {
            this.cal.setTime(new Date(currentTime));
            while (this.cal.get(5) != 1) {
                this.cal.add(5, -1);
            }
            this.cal.set(11, 0);
            this.cal.set(12, 0);
            this.cal.set(13, 1);
            return "-" + String.valueOf(this.cal.get(1) * 100 + (this.cal.get(2) + 1));
        }
    }

    class WeeklyRotater
    extends LogRotater {
        protected Calendar cal;
        private final int dayOfRotation;

        WeeklyRotater(int dayOfRotation) {
            this.cal = Calendar.getInstance();
            this.dayOfRotation = dayOfRotation;
        }

        @Override
        public long getNextRotationTime(long currentTime) {
            this.cal.setTime(new Date(currentTime));
            do {
                this.cal.add(5, 1);
            } while (this.cal.get(7) != this.dayOfRotation);
            this.cal.set(11, 0);
            this.cal.set(12, 0);
            this.cal.set(13, 1);
            this.cal.set(14, 0);
            return this.cal.getTime().getTime();
        }

        @Override
        public String getLogFileSuffix(long currentTime) {
            this.cal.setTime(new Date(currentTime));
            while (this.cal.get(7) != this.dayOfRotation) {
                this.cal.add(5, -1);
            }
            this.cal.set(11, 0);
            this.cal.set(12, 0);
            this.cal.set(13, 1);
            return this.getSuffixForDate(this.cal);
        }
    }

    private abstract class LogRotater
    implements Runnable {
        private volatile boolean isInitialized = false;

        private LogRotater() {
        }

        public void init() {
        }

        public abstract long getNextRotationTime(long var1);

        public abstract String getLogFileSuffix(long var1);

        public boolean initialized() {
            return this.isInitialized;
        }

        @Override
        public void run() {
            while (ServerLog.this.continuing) {
                long now = System.currentTimeMillis();
                if (this.isInitialized) {
                    ServerLog.this.logError(25, "Rotating log files");
                }
                try {
                    String logFileSuffix = this.getLogFileSuffix(now);
                    ServerLog.this.setAccessLogFile(new File(ServerLog.this.logDirectory, "access.log" + logFileSuffix));
                    ServerLog.this.setErrorLogFile(new File(ServerLog.this.logDirectory, "error.log" + logFileSuffix));
                }
                catch (Throwable t) {
                    System.err.println("Error setting log files: " + t);
                    t.printStackTrace(System.err);
                }
                this.isInitialized = true;
                long nextRotationTime = this.getNextRotationTime(now);
                while (ServerLog.this.continuing && nextRotationTime > System.currentTimeMillis()) {
                    try {
                        long waitTime = Math.max(1000L, nextRotationTime - System.currentTimeMillis());
                        Thread.sleep(waitTime);
                    }
                    catch (Throwable throwable) {}
                }
            }
        }

        protected String getSuffixForDate(Calendar cal) {
            return "-" + String.valueOf(cal.get(1) * 10000 + (cal.get(2) + 1) * 100 + cal.get(5));
        }
    }
}

