/*
 * Decompiled with CFR 0.152.
 */
package net.handle.server;

import java.io.File;
import java.util.Enumeration;
import net.cnri.util.StreamTable;
import net.handle.hdllib.Common;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleStorage;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.ScanCallback;
import net.handle.hdllib.Util;
import net.handle.jdb.DBHash;
import net.handle.server.DBTransactionLog;

public final class JDBHandleStorage
implements HandleStorage {
    private final File serverDir;
    private DBHash db;
    private DBHash naDB;
    private boolean logTxns = true;
    private DBTransactionLog txnLog;
    private final String WRITE_LOCK = "WRITE_LOCK";
    private final String READ_LOCK = "READ_LOCK";
    private boolean readOnly = false;
    private static final byte[] BLANK_BYTES = new byte[0];

    public JDBHandleStorage(File serverDir, boolean logTxns) throws Exception {
        this.serverDir = serverDir;
        this.logTxns = logTxns;
    }

    @Override
    public void init(StreamTable config) throws Exception {
        this.readOnly = config.getBoolean("read_only", false);
        this.db = new DBHash(new File(this.serverDir, "handles.jdb"), 5000, 1000, this.readOnly);
        this.naDB = new DBHash(new File(this.serverDir, "nas.jdb"), 1000, 500, this.readOnly);
        if (this.logTxns) {
            this.txnLog = new DBTransactionLog(new File(this.serverDir, "dbtxns.log"));
        }
    }

    @Override
    public final boolean haveNA(byte[] authHandle) throws HandleException {
        try {
            return this.naDB.getValue(Util.upperCase(authHandle)) != null;
        }
        catch (Exception e) {
            throw new HandleException(1, "Error accessing NA data");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setHaveNA(byte[] authHandle, boolean flag) throws HandleException {
        String string = "WRITE_LOCK";
        synchronized ("WRITE_LOCK") {
            if (this.readOnly) {
                throw new HandleException(18);
            }
            try {
                byte[] handle = Util.upperCase(authHandle);
                if (flag) {
                    if (this.logTxns) {
                        this.txnLog.log((byte)2, handle, BLANK_BYTES);
                    }
                    this.naDB.setValue(handle, BLANK_BYTES);
                } else {
                    if (this.logTxns) {
                        this.txnLog.log((byte)3, handle, BLANK_BYTES);
                    }
                    this.naDB.deleteValue(handle);
                }
            }
            catch (HandleException e1) {
                throw e1;
            }
            catch (Exception e) {
                throw new HandleException(1, "Error accessing NA data");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void createHandle(byte[] inHandle, HandleValue[] values) throws HandleException {
        String string = "WRITE_LOCK";
        synchronized ("WRITE_LOCK") {
            String string2 = "READ_LOCK";
            synchronized ("READ_LOCK") {
                if (this.readOnly) {
                    throw new HandleException(18);
                }
                byte[] handle = inHandle;
                byte[] existingValue = null;
                try {
                    existingValue = this.db.getValue(handle);
                }
                catch (Exception e) {
                    throw new HandleException(1, "Error checking for existing handle");
                }
                if (existingValue != null) {
                    throw new HandleException(5, "Handle already exists");
                }
                int totalSize = 4;
                for (int i = 0; i < values.length; ++i) {
                    totalSize += Encoder.calcStorageSize(values[i]) + 4;
                }
                byte[] data = new byte[totalSize];
                int offst = 0;
                offst += Encoder.writeInt(data, offst, values.length);
                for (int i = 0; i < values.length; ++i) {
                    int clumpLen = Encoder.encodeHandleValue(data, offst + 4, values[i]);
                    offst += Encoder.writeInt(data, offst, clumpLen);
                    offst += clumpLen;
                }
                try {
                    if (this.logTxns) {
                        this.txnLog.log((byte)0, handle, data);
                    }
                    this.db.setValue(handle, data);
                }
                catch (HandleException e1) {
                    throw e1;
                }
                catch (Exception e) {
                    throw new HandleException(1, "Error creating handle");
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean deleteHandle(byte[] inHandle) throws HandleException {
        String string = "WRITE_LOCK";
        synchronized ("WRITE_LOCK") {
            boolean deleted;
            if (this.readOnly) {
                throw new HandleException(18);
            }
            byte[] handle = inHandle;
            try {
                if (this.logTxns) {
                    this.txnLog.log((byte)1, handle, BLANK_BYTES);
                }
                deleted = this.db.deleteValue(handle);
            }
            catch (HandleException e1) {
                throw e1;
            }
            catch (Exception e) {
                throw new HandleException(1, "Error deleting handle");
            }
            return deleted;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final byte[][] getRawHandleValues(byte[] inHandle, int[] indexList, byte[][] typeList) throws HandleException {
        byte[] handle = inHandle;
        String string = "READ_LOCK";
        synchronized ("READ_LOCK") {
            int clumpIndex;
            byte[] clumpType;
            byte[] value;
            try {
                value = this.db.getValue(handle);
            }
            catch (Exception e) {
                throw new HandleException(1, "Error retrieving handle");
            }
            if (value == null) {
                return null;
            }
            int bufPos = 0;
            boolean allValues = !(indexList != null && indexList.length != 0 || typeList != null && typeList.length != 0);
            int numValues = Encoder.readInt(value, bufPos);
            int origBufPos = bufPos += 4;
            int matches = 0;
            if (allValues) {
                matches = numValues;
            } else {
                for (int i = 0; i < numValues; ++i) {
                    int clumpLen = Encoder.readInt(value, bufPos);
                    clumpType = Encoder.getHandleValueType(value, bufPos += 4);
                    clumpIndex = Encoder.getHandleValueIndex(value, bufPos);
                    if (Util.isParentTypeInArray(typeList, clumpType) || Util.isInArray(indexList, clumpIndex)) {
                        ++matches;
                    }
                    bufPos += clumpLen;
                }
            }
            byte[][] clumps = new byte[matches][];
            int clumpNum = 0;
            bufPos = origBufPos;
            for (int i = 0; i < numValues; ++i) {
                int clumpLen = Encoder.readInt(value, bufPos);
                clumpType = Encoder.getHandleValueType(value, bufPos += 4);
                clumpIndex = Encoder.getHandleValueIndex(value, bufPos);
                if (allValues || Util.isParentTypeInArray(typeList, clumpType) || Util.isInArray(indexList, clumpIndex)) {
                    clumps[clumpNum] = new byte[clumpLen];
                    System.arraycopy(value, bufPos, clumps[clumpNum], 0, clumpLen);
                    ++clumpNum;
                }
                bufPos += clumpLen;
            }
            return clumps;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void updateValue(byte[] inHandle, HandleValue[] values) throws HandleException {
        String string = "WRITE_LOCK";
        synchronized ("WRITE_LOCK") {
            if (this.readOnly) {
                throw new HandleException(18);
            }
            byte[] handle = inHandle;
            byte[] existingValue = null;
            try {
                existingValue = this.db.getValue(handle);
            }
            catch (Exception e) {
                throw new HandleException(1, "Error checking for existing handle");
            }
            if (existingValue == null) {
                throw new HandleException(9, "Cannot modify non-existent handle");
            }
            int totalSize = 4;
            for (int i = 0; i < values.length; ++i) {
                totalSize += Encoder.calcStorageSize(values[i]) + 4;
            }
            byte[] data = new byte[totalSize];
            int offst = 0;
            offst += Encoder.writeInt(data, offst, values.length);
            for (int i = 0; i < values.length; ++i) {
                int clumpLen = Encoder.encodeHandleValue(data, offst + 4, values[i]);
                offst += Encoder.writeInt(data, offst, clumpLen);
                offst += clumpLen;
            }
            try {
                if (this.logTxns) {
                    this.txnLog.log((byte)0, handle, data);
                }
                this.db.setValue(handle, data);
            }
            catch (HandleException e1) {
                throw e1;
            }
            catch (Exception e) {
                throw new HandleException(1, "Error updating handle");
            }
            return;
        }
    }

    @Override
    public final void scanHandles(ScanCallback callback) throws HandleException {
        Enumeration<byte[][]> recs = this.db.getEnumerator();
        while (recs.hasMoreElements()) {
            byte[][] record = recs.nextElement();
            callback.scanHandle(record[0]);
        }
    }

    @Override
    public void scanNAs(ScanCallback callback) throws HandleException {
        Enumeration<byte[][]> recs = this.naDB.getEnumerator();
        while (recs.hasMoreElements()) {
            byte[][] record = recs.nextElement();
            callback.scanHandle(record[0]);
        }
    }

    @Override
    public final Enumeration<byte[]> getHandlesForNA(byte[] naHdl) throws HandleException {
        if (!this.haveNA(naHdl)) {
            throw new HandleException(0, "The requested prefix doesn't live here");
        }
        boolean isZeroNA = Util.startsWithCI(naHdl, Common.NA_HANDLE_PREFIX);
        if (isZeroNA) {
            naHdl = Util.getSuffixPart(naHdl);
        }
        return new HdlsForNAEnum(this.db.getEnumerator(), naHdl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void deleteAllRecords() throws HandleException {
        String string = "WRITE_LOCK";
        synchronized ("WRITE_LOCK") {
            if (this.readOnly) {
                throw new HandleException(18);
            }
            try {
                if (this.logTxns) {
                    this.txnLog.log((byte)4, BLANK_BYTES, BLANK_BYTES);
                }
                this.db.deleteAllRecords();
                this.naDB.deleteAllRecords();
            }
            catch (HandleException e1) {
                throw e1;
            }
            catch (Exception e) {
                throw new HandleException(1, String.valueOf(e));
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void checkpointDatabase() throws HandleException {
        if (!this.logTxns) {
            throw new HandleException(0, "Transaction logging not enabled");
        }
        String string = "WRITE_LOCK";
        synchronized ("WRITE_LOCK") {
            if (this.readOnly) {
                throw new HandleException(18);
            }
            this.readOnly = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            Thread th = null;
            try {
                th = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            JDBHandleStorage.this.naDB.copyTo(new File(JDBHandleStorage.this.serverDir, "nas.bak"));
                            JDBHandleStorage.this.db.copyTo(new File(JDBHandleStorage.this.serverDir, "handles.bak"));
                            JDBHandleStorage.this.txnLog.reset();
                        }
                        catch (Exception e) {
                            System.err.println("ERROR: Unable to backup JDB database: " + e);
                            e.printStackTrace(System.err);
                        }
                        finally {
                            JDBHandleStorage.this.readOnly = false;
                        }
                    }
                });
            }
            catch (Throwable t) {
                this.readOnly = false;
                throw new HandleException(1, "Error creating backup thread: " + t);
            }
            try {
                th.start();
            }
            catch (Throwable t) {
                this.readOnly = false;
                System.err.println("Unable to start checkpoint process: " + t);
                t.printStackTrace(System.err);
                throw new HandleException(1, String.valueOf(t));
            }
            return;
        }
    }

    @Override
    public final void shutdown() {
        try {
            this.db.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.naDB.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (this.logTxns) {
                this.txnLog.shutdown();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private final class HdlsForNAEnum
    implements Enumeration<byte[]> {
        private final byte[] prefix;
        private byte[] nextHdl = null;
        private final Enumeration<byte[][]> dbEnum;
        private final boolean listingDerivedPrefixes;

        HdlsForNAEnum(Enumeration<byte[][]> dbEnum, byte[] na) {
            this.listingDerivedPrefixes = Util.startsWithCI(na, Common.NA_HANDLE_PREFIX);
            this.prefix = Util.encodeString(Util.decodeString(na));
            this.dbEnum = dbEnum;
            this.seekNextValue();
        }

        private final void seekNextValue() {
            this.nextHdl = null;
            while (this.dbEnum.hasMoreElements()) {
                byte[][] tmpRecord = this.dbEnum.nextElement();
                if (!Util.startsWithCI(tmpRecord[0], this.prefix) || tmpRecord[0].length <= this.prefix.length || !(this.listingDerivedPrefixes ? tmpRecord[0][this.prefix.length] == 46 : tmpRecord[0][this.prefix.length] == 47)) continue;
                this.nextHdl = tmpRecord[0];
                return;
            }
        }

        @Override
        public final boolean hasMoreElements() {
            return this.nextHdl != null;
        }

        @Override
        public final byte[] nextElement() {
            byte[] thisHdl = this.nextHdl;
            this.seekNextValue();
            return thisHdl;
        }
    }
}

