/*
 * Decompiled with CFR 0.152.
 */
package net.handle.server;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLHandshakeException;
import net.handle.hdllib.AbstractRequest;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.ErrorResponse;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.MessageEnvelope;
import net.handle.hdllib.ResponseMessageCallback;
import net.handle.hdllib.SignedOutputStream;
import net.handle.hdllib.Util;
import net.handle.server.AbstractServer;
import net.handle.server.HandleServer;
import net.handle.server.HdlTcpInterface;
import net.handle.server.Main;
import net.handle.server.ServerSideSessionInfo;

public class HdlTcpRequestHandler
implements Runnable,
ResponseMessageCallback {
    private static final int DEFAULT_MAX_MESSAGE_LENGTH = 1024;
    private Socket socket = null;
    private final AbstractServer server;
    private final Main main;
    private boolean logAccesses = false;
    private final MessageEnvelope envelope = new MessageEnvelope();
    private final byte[] envelopeBuf = new byte[20];
    private byte[] messageBuf = new byte[1024];
    public static final String ACCESS_TYPE = "TCP:HDL";
    public static final byte[] MSG_INVALID_MSG_SIZE = Util.encodeString("Invalid message length");
    public static final byte[] MSG_READ_TIMED_OUT = Util.encodeString("Read timed out");
    private long recvTime = 0L;
    private AbstractRequest currentRequest;
    private final HdlTcpInterface interfc;

    public HdlTcpRequestHandler(Main main, HdlTcpInterface ifc, boolean logAccesses, Socket socket, long recvTime) {
        this.main = main;
        this.interfc = ifc;
        this.server = main.getServer();
        this.logAccesses = logAccesses;
        this.recvTime = recvTime;
        this.socket = socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        InputStream in = null;
        try {
            int n;
            int r;
            in = this.socket.getInputStream();
            for (n = 0; n < 20 && (r = in.read(this.envelopeBuf, n, 20 - n)) > 0; n += r) {
            }
            Encoder.decodeEnvelope(this.envelopeBuf, this.envelope);
            if (this.envelope.messageLength > 262144 || this.envelope.messageLength < 0) {
                this.handleResponse(new ErrorResponse(0, 4, MSG_INVALID_MSG_SIZE));
                return;
            }
            if (this.messageBuf.length < this.envelope.messageLength) {
                this.messageBuf = new byte[this.envelope.messageLength];
            }
            r = 0;
            for (n = 0; n < this.envelope.messageLength && (r = in.read(this.messageBuf, n, this.envelope.messageLength - n)) > 0; n += r) {
            }
            if (n < this.envelope.messageLength) {
                String errMsg = "Expecting " + this.envelope.messageLength + " bytes, only received " + n;
                this.handleResponse(new ErrorResponse(0, 4, Util.encodeString(errMsg)));
                return;
            }
            if (this.envelope.encrypted) {
                if (this.envelope.sessionId > 0) {
                    ServerSideSessionInfo sssinfo = null;
                    if (this.server instanceof HandleServer) {
                        sssinfo = ((HandleServer)this.server).getSession(this.envelope.sessionId);
                        if (sssinfo != null) {
                            try {
                                this.messageBuf = sssinfo.decryptBuffer(this.messageBuf, 0, this.envelope.messageLength);
                                this.envelope.encrypted = false;
                                this.envelope.messageLength = this.messageBuf.length;
                            }
                            catch (Exception e) {
                                this.main.logError(75, "Exception decrypting request: " + e);
                                e.printStackTrace();
                                System.err.println("Exception decrypting request with session key: " + e.getMessage());
                                this.handleResponse(new ErrorResponse(0, 501, Util.encodeString("Exception decrypting request with session key " + e)));
                                if (in != null) {
                                    try {
                                        in.close();
                                    }
                                    catch (Throwable throwable) {
                                        // empty catch block
                                    }
                                }
                                if (this.socket != null) {
                                    try {
                                        this.socket.close();
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    this.socket = null;
                                }
                                return;
                            }
                        }
                        this.main.logError(75, "Session information not available or time out. Unable to decrypt request message");
                        System.err.println("Session information not available or time out. Unable to decrypt request message.");
                        this.handleResponse(new ErrorResponse(0, 500, Util.encodeString("Session information not available or time out. Unable to decrypt request message.")));
                        return;
                    }
                    this.main.logError(75, "Session manager not available. Unable to decrypt request message.");
                    System.err.println("Session manager not available. Request message not decrypted.");
                    this.handleResponse(new ErrorResponse(0, 501, Util.encodeString("Session manager not available. Unable to decrypt request message.")));
                    return;
                }
                this.main.logError(75, "Invalid session id. Request message not decrypted.");
                System.err.println("Invalid session id. Request message not decrypted.");
                this.handleResponse(new ErrorResponse(0, 501, Util.encodeString("Invalid session id. Unable to decrypt request message.")));
                return;
            }
            if (this.envelope.messageLength < 24) {
                this.handleResponse(new ErrorResponse(0, 4, MSG_INVALID_MSG_SIZE));
                return;
            }
            int opCode = Encoder.readOpCode(this.messageBuf, 0);
            if (opCode == 0) {
                this.handleResponse(new ErrorResponse(0, 4, Util.encodeString("Unknown opCode in message: " + opCode)));
                return;
            }
            this.currentRequest = (AbstractRequest)Encoder.decodeMessage(this.messageBuf, 0, this.envelope);
            String errMsg = this.interfc.canProcessMsg(this.currentRequest);
            if (errMsg != null) {
                this.main.logError(75, errMsg);
                this.handleResponse(new ErrorResponse(this.currentRequest.opCode, 4, Util.encodeString(errMsg)));
                return;
            }
            this.server.processRequest(this.currentRequest, this);
        }
        catch (SocketTimeoutException e) {
            this.handleResponse(new ErrorResponse(0, 4, MSG_READ_TIMED_OUT));
        }
        catch (Throwable e) {
            this.handleResponse(new ErrorResponse(0, 2, Util.encodeString("Server error processing request, see server logs")));
            this.main.logError(75, String.valueOf(this.getClass()) + ": Exception processing request: " + e);
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Throwable e) {}
            }
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (Exception e) {}
                this.socket = null;
            }
        }
    }

    public void handleResponseError(String error) {
        this.main.logError(50, String.valueOf(this.getClass()) + ": Server error: " + error);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleResponse(AbstractResponse response) {
        OutputStream out = null;
        boolean keepSocketOpen = response.continuous;
        boolean errorWriting = false;
        try {
            byte[] msg = response.getEncodedMessage();
            boolean encrypted = false;
            if (response.sessionId > 0 && (response.encrypt || response.shouldEncrypt())) {
                ServerSideSessionInfo sssinfo = null;
                if (this.server instanceof HandleServer) {
                    sssinfo = ((HandleServer)this.server).getSession(response.sessionId);
                    if (sssinfo != null) {
                        try {
                            msg = sssinfo.encryptBuffer(msg, 0, msg.length);
                            encrypted = true;
                        }
                        catch (Exception e) {
                            this.main.logError(50, "Exception encrypting response: " + e);
                            System.err.println("Exception encrypting message with session key: " + e.getMessage());
                            encrypted = false;
                        }
                    }
                } else {
                    this.main.logError(50, "Session manager not available. Message not encrypted.");
                    System.err.println("Session manager not available. Message not encrypted.");
                    encrypted = false;
                }
            }
            this.envelope.encrypted = encrypted;
            this.envelope.messageLength = msg.length;
            this.envelope.messageId = 0;
            this.envelope.requestId = response.requestId;
            this.envelope.sessionId = response.sessionId;
            this.envelope.protocolMajorVersion = response.majorProtocolVersion;
            this.envelope.protocolMinorVersion = response.minorProtocolVersion;
            this.envelope.suggestMajorProtocolVersion = response.suggestMajorProtocolVersion;
            this.envelope.suggestMinorProtocolVersion = response.suggestMinorProtocolVersion;
            Encoder.encodeEnvelope(this.envelope, this.envelopeBuf);
            try {
                out = this.socket.getOutputStream();
                out.write(Util.concat(this.envelopeBuf, msg));
                out.flush();
            }
            catch (Exception e) {
                errorWriting = true;
                throw e;
            }
            long respTime = System.currentTimeMillis() - this.recvTime;
            if (this.logAccesses && this.currentRequest != null) {
                this.main.logAccess("TCP:HDL(" + this.currentRequest.suggestMajorProtocolVersion + "." + this.currentRequest.suggestMinorProtocolVersion + ")", this.socket.getInetAddress(), this.currentRequest.opCode, response.responseCode, Util.getAccessLogString(this.currentRequest, response), respTime);
            }
            if (response.streaming) {
                this.streamResponse(response);
            }
        }
        catch (Exception e) {
            String clientString = "";
            try {
                clientString = " to " + Util.rfcIpRepr(this.socket.getInetAddress());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (errorWriting && keepSocketOpen) {
                keepSocketOpen = false;
                throw new RuntimeException(new HandleException(1, "Error writing continuous handle response" + clientString, e));
            }
            if (response.streaming && e instanceof SSLHandshakeException) {
                this.main.logError(50, String.valueOf(this.getClass()) + ": Exception sending response" + clientString + " (if occasional handshake failure, safe to ignore): " + e);
            } else if (response.streaming && e.getCause() instanceof SSLHandshakeException) {
                this.main.logError(50, String.valueOf(this.getClass()) + ": Exception sending response" + clientString + " (if occasional handshake failure, safe to ignore): " + e.getCause());
            } else {
                this.main.logError(50, String.valueOf(this.getClass()) + ": Exception sending response" + clientString + ": " + e);
                if (!(e instanceof SocketTimeoutException)) {
                    if (e.getCause() instanceof SocketTimeoutException) {
                    } else {
                        e.printStackTrace(System.err);
                    }
                }
            }
        }
        finally {
            if (out != null && !keepSocketOpen) {
                try {
                    out.close();
                }
                catch (Exception e) {
                    this.main.logError(50, String.valueOf(this.getClass()) + ": Exception sending response: " + e);
                    e.printStackTrace(System.err);
                }
            }
        }
    }

    private void streamResponse(AbstractResponse response) throws HandleException, IOException {
        SignedOutputStream sout;
        BufferedOutputStream out = new BufferedOutputStream(this.socket.getOutputStream());
        if (this.server instanceof HandleServer && response.hasEqualOrGreaterVersion(2, 8)) {
            X509Certificate certificate = ((HandleServer)this.server).getHdlTcpCertificate();
            sout = new SignedOutputStream(certificate, this.server.getPrivateKey(), out, this.socket);
        } else {
            sout = new SignedOutputStream(this.server.getPrivateKey(), out);
        }
        response.streamResponse(sout);
        sout.flush();
    }
}

