/*
 * Decompiled with CFR 0.152.
 */
package net.handle.server;

import java.io.File;
import java.lang.reflect.Method;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleStorage;
import net.handle.server.JDBHandleStorage;
import net.handle.server.SQLHandleStorage;
import net.handle.server.bdbje.BDBJEHandleStorage;
import net.handle.util.StreamTable;

public abstract class HandleStorageFactory {
    public static final String STORAGE_TYPE = "storage_type";
    public static final String STORAGE_CLASS = "storage_class";
    public static final String CUSTOM_STORAGE_CONFIG = "storage_config";
    public static final String SQL_CONFIG = "sql_settings";

    public static HandleStorage getStorage(File serverDir, net.cnri.util.StreamTable config, boolean isPrimary) throws Exception {
        return HandleStorageFactory.getStorage(serverDir, config, isPrimary, false);
    }

    public static HandleStorage getStorage(File serverDir, net.cnri.util.StreamTable config, boolean isPrimary, boolean isReadonly) throws Exception {
        HandleStorage storage = null;
        String storageType = config.getStr(STORAGE_TYPE, "").toUpperCase().trim();
        if (storageType.equals("")) {
            storageType = new File(serverDir, "handles.jdb").exists() ? "JDB" : "BDBJE";
        }
        if (storageType.equals("SQL")) {
            net.cnri.util.StreamTable sqlConfig = (net.cnri.util.StreamTable)config.get(SQL_CONFIG);
            if (sqlConfig == null) {
                throw new HandleException(0, "Missing sql_settings section in config file");
            }
            storage = new SQLHandleStorage();
            sqlConfig.put("sql_read_only", isReadonly);
            storage.init(sqlConfig);
            return storage;
        }
        if (storageType.equals("CUSTOM")) {
            Object obj;
            if (isReadonly) {
                throw new HandleException(15, "Unable to create read-only custom storage");
            }
            String storageClassName = String.valueOf(config.get(STORAGE_CLASS)).trim();
            Class<?> storageClass = Class.forName(storageClassName);
            net.cnri.util.StreamTable cfgTable = (net.cnri.util.StreamTable)config.get(CUSTOM_STORAGE_CONFIG);
            if (cfgTable == null) {
                cfgTable = new net.cnri.util.StreamTable();
            }
            if ((obj = storageClass.getConstructor(new Class[0]).newInstance(new Object[0])) instanceof HandleStorage) {
                storage = (HandleStorage)obj;
                cfgTable.put("serverDir", serverDir.getAbsolutePath());
                HandleStorageFactory.performCustomInit(storage, cfgTable);
                return storage;
            }
            throw new HandleException(0, "Custom storage class " + storageClassName + " does not implement the HandleStorage interface");
        }
        if (storageType.equals("JDB")) {
            storage = new JDBHandleStorage(serverDir, isPrimary);
            net.cnri.util.StreamTable configCopy = (net.cnri.util.StreamTable)config.deepClone();
            configCopy.put("serverDir", serverDir.getAbsolutePath());
            configCopy.put("read_only", isReadonly);
            storage.init(configCopy);
            return storage;
        }
        storage = new BDBJEHandleStorage();
        net.cnri.util.StreamTable configCopy = (net.cnri.util.StreamTable)config.deepClone();
        configCopy.put("serverDir", serverDir.getAbsolutePath());
        configCopy.put("read_only", isReadonly);
        storage.init(configCopy);
        return storage;
    }

    private static void performCustomInit(HandleStorage storage, net.cnri.util.StreamTable cfgTable) throws Exception {
        Class<?> storageClass = storage.getClass();
        try {
            storage.init(cfgTable);
            return;
        }
        catch (AbstractMethodError e) {
            Method method = storageClass.getMethod("init", StreamTable.class);
            StreamTable oldStreamTable = new StreamTable();
            oldStreamTable.readFrom(cfgTable.writeToString());
            method.invoke((Object)storage, oldStreamTable);
            return;
        }
    }
}

