/*
 * Decompiled with CFR 0.152.
 */
package net.handle.server;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.InetAddress;
import java.nio.file.Files;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import net.cnri.util.StreamObject;
import net.cnri.util.StreamObjectToJsonConverter;
import net.cnri.util.StreamTable;
import net.handle.apps.simple.SiteInfoConverter;
import net.handle.hdllib.AbstractMessage;
import net.handle.hdllib.AbstractRequest;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.AbstractResponseAndIndex;
import net.handle.hdllib.AddValueRequest;
import net.handle.hdllib.AdminRecord;
import net.handle.hdllib.ChallengeAnswerRequest;
import net.handle.hdllib.ChallengeResponse;
import net.handle.hdllib.Common;
import net.handle.hdllib.Configuration;
import net.handle.hdllib.CreateHandleRequest;
import net.handle.hdllib.CreateHandleResponse;
import net.handle.hdllib.DeleteHandleRequest;
import net.handle.hdllib.DumpHandlesRequest;
import net.handle.hdllib.DumpHandlesResponse;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.ErrorResponse;
import net.handle.hdllib.GenericRequest;
import net.handle.hdllib.GenericResponse;
import net.handle.hdllib.GetSiteInfoResponse;
import net.handle.hdllib.GsonUtility;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleResolver;
import net.handle.hdllib.HandleStorage;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.ListHandlesRequest;
import net.handle.hdllib.ListHandlesResponse;
import net.handle.hdllib.ListNAsRequest;
import net.handle.hdllib.ListNAsResponse;
import net.handle.hdllib.ModifyValueRequest;
import net.handle.hdllib.NamespaceInfo;
import net.handle.hdllib.RemoveValueRequest;
import net.handle.hdllib.ReplicationDaemonInterface;
import net.handle.hdllib.ReplicationStateInfo;
import net.handle.hdllib.RequestProcessor;
import net.handle.hdllib.ResolutionRequest;
import net.handle.hdllib.ResolutionResponse;
import net.handle.hdllib.ResponseMessageCallback;
import net.handle.hdllib.RetrieveTxnRequest;
import net.handle.hdllib.RetrieveTxnResponse;
import net.handle.hdllib.ServerInfo;
import net.handle.hdllib.ServiceReferralResponse;
import net.handle.hdllib.SessionExchangeKeyRequest;
import net.handle.hdllib.SessionInfo;
import net.handle.hdllib.SessionSetupRequest;
import net.handle.hdllib.SessionSetupResponse;
import net.handle.hdllib.SimpleResponseMessageCallback;
import net.handle.hdllib.SiteInfo;
import net.handle.hdllib.Transaction;
import net.handle.hdllib.TransactionQueueInterface;
import net.handle.hdllib.TransactionQueuesInterface;
import net.handle.hdllib.TransactionValidator;
import net.handle.hdllib.Util;
import net.handle.hdllib.ValueReference;
import net.handle.hdllib.VerifyAuthRequest;
import net.handle.hdllib.VerifyAuthResponse;
import net.handle.security.HdlSecurityProvider;
import net.handle.server.AbstractServer;
import net.handle.server.HandleStorageFactory;
import net.handle.server.HandleSuffixMinter;
import net.handle.server.HomedPrefixAccumulator;
import net.handle.server.Main;
import net.handle.server.MonitorDaemon;
import net.handle.server.ServerSideSessionInfo;
import net.handle.server.SessionManager;
import net.handle.server.TentativeServerSideAuthenticationInfo;
import net.handle.server.replication.NotifierInterface;
import net.handle.server.replication.ReplicationDaemon;
import net.handle.server.servletcontainer.HandleServerInterface;
import net.handle.server.servletcontainer.support.PreAuthenticatedChallengeAnswerRequest;
import net.handle.server.servletcontainer.support.PreAuthenticatedChallengeResponse;
import net.handle.server.txnlog.BdbjeTransactionQueue;
import net.handle.server.txnlog.BdbjeTransactionQueues;
import net.handle.server.txnlog.ConcatenatedTransactionQueue;
import net.handle.server.txnlog.FileBasedTransactionQueue;
import net.handle.server.txnlog.TransactionQueuePruner;
import net.handle.util.AutoSelfSignedKeyManager;
import net.handle.util.X509HSCertificateGenerator;

public class HandleServer
extends AbstractServer
implements HandleServerInterface,
RequestProcessor {
    private static final boolean DEBUG_AUTHENTICATION = false;
    private static final byte[] MSG_INTERNAL_ERROR = Util.encodeString("Internal Error");
    private static final byte[] MSG_NOT_A_PRIMARY = Util.encodeString("Not a primary server");
    private static final byte[] MSG_SERVER_TEMPORARILY_DISABLED = Util.encodeString("Server temporarily disabled");
    private static final byte[] MSG_WRONG_SERVER_HASH = Util.encodeString("Request was hashed incorrectly");
    private static final byte[] MSG_NA_NOT_HOMED_HERE = Util.encodeString("That prefix doesn't live here");
    private static final byte[] MSG_INDEXES_MUST_BE_POSITIVE = Util.encodeString("Value indexes must be positive");
    private static final byte[] MSG_EMPTY_VALUE_LIST = Util.encodeString("Value list was empty");
    private static final byte[] MSG_READ_ONLY_VALUE = Util.encodeString("Value is read-only");
    private static final byte[] MSG_NOT_A_NA_HANDLE = Util.encodeString("Handle is not a prefix handle");
    private static final byte[] MSG_INVALID_ENCODING = Util.encodeString("Invalid UTF8 encoding");
    private static final byte[] MSG_SERVER_BACKUP = Util.encodeString("Server can only resolve handles due to maintenance. Come back later");
    private static final byte[] MSG_INVALID_SESSION_OR_TIMEOUT = Util.encodeString("Invalid session id or session time out. Please try again.");
    private static final byte[] MSG_NEED_LIST_HDLS_PERM = Util.encodeString("This server does not support the list handles operation.");
    private static final byte[] MSG_NO_TXN_QUEUE = Util.encodeString("This server does not support replication.");
    private static final byte[] MSG_NO_NEXT_TXN_ID = Util.encodeString("Next txn id no longer supported; upgrade required");
    private static final byte[] SERVER_STATUS_HANDLE = Util.encodeString("0.SITE/status");
    private static final byte[] SERVER_STATUS_HDL_TYPE = Util.encodeString("CNRI.SERVER_STATUS");
    private static final byte[] REPLICATION_STATUS_HDL_TYPE = Util.encodeString("CNRI.REPLICATION_STATUS");
    private static final byte[] MSG_SESSION_REQUIRED = Util.encodeString("Sessions are required for administration on this server");
    public static final String CASE_SENSITIVE = "case_sensitive";
    public static final String ENABLE_STATUS_HDL = "enable_status_handle";
    public static final String STATUS_HDL_ADMINS = "status_handle_admins";
    public static final String ENABLE_MONITOR_DAEMON = "enable_monitor_daemon";
    public static final String ENABLE_HOMED_PREFIX_LOCAL_SITES = "enable_homed_prefix_na_lookup_optimization";
    public static final String SERVER_ADMIN_FULL_ACCESS = "server_admin_full_access";
    public static final String ANONYMOUS_FULL_ACCESS = "anonymous_admin_full_access";
    public static final String MAX_AUTH_TIME = "max_auth_time";
    public static final String THIS_SERVER_ID = "this_server_id";
    public static final String IS_PRIMARY = "is_primary";
    public static final String SERVER_ADMINS = "server_admins";
    public static final String HOME_ONLY_ADMINS = "home_only_admins";
    public static final String BACKUP_ADMINS = "backup_admins";
    public static final String REPLICATION_ADMINS = "replication_admins";
    public static final String DO_RECURSION = "allow_recursion";
    public static final String DO_RECURSION_FOR_LEGACY_PREFIX_REFERRAL = "perform_recursion_for_legacy_prefix_referral";
    public static final String ALLOW_NA_ADMINS = "allow_na_admins";
    public static final String READ_ONLY_TXN_QUEUE = "read_only_txn_queue";
    public static final String FILE_WRITE_NO_SYNC = "file_write_no_sync";
    public static final String ALLOW_LIST_HANDLES = "allow_list_hdls";
    public static final String PREFERRED_GLOBAL = "preferred_global";
    public static final String MAX_SESSION_TIME = "max_session_time";
    public static final String REQUIRE_SESSIONS = "require_sessions";
    public static final String ENCRYPTION_ALGORITHM = "encryption_alg";
    public static final String AUTO_HOMED_PREFIXES = "auto_homed_prefixes";
    public static final String ENABLE_TXN_QUEUE = "enable_txn_queue";
    public static final String TEMPLATE_DELIM_CONFIG_KEY = "template_delimiter";
    public static final String NAMESPACE_CONFIG_KEY = "namespace";
    public static final String NAMESPACE_OVERRIDE_CONFIG_KEY = "template_ns_override";
    public static final String DB_TXN_QUEUE_DIR = "dbtxns";
    public static final String TXN_QUEUE_DIR = "txns";
    public static final String TXN_ID_FILE = "txn_id";
    public static final String STORAGE_FILE = "handles.jdb";
    public static final String NA_STORAGE_FILE = "nas.jdb";
    public static final String CACHE_STORAGE_FILE = "cache.jdb";
    public static final String STORAGE_FILE_BACKUP = "handles.jdb.backup";
    public static final String NA_STORAGE_FILE_BACKUP = "nas.jdb.backup";
    public static final String SITE_INFO_FILE = "siteinfo.bin";
    public static final String SITE_INFO_JSON_FILE = "siteinfo.json";
    public static final String PRIVATE_KEY_FILE = "privkey.bin";
    public static final String PUBLIC_KEY_FILE = "pubkey.bin";
    public static final String DO_REPLICATION = "do_replication";
    public static final int RECURSION_LIMIT = 10;
    public static final int LIST_HANDLES_PER_MSG = 50;
    public static final String DEFAULT_ENC_ALG = "AES";
    private static final int NUM_SERVER_SIGNATURES = 50;
    private static final int[] DEL_HANDLE_PERM = new int[]{1};
    private static final int[] ADD_HANDLE_PERM = new int[]{0};
    private static final int[] READ_VAL_PERM = new int[]{10};
    private static final int[] ADD_ADM_PERM = new int[]{9};
    private static final int[] ADD_VAL_PERM = new int[]{6};
    private static final int[] REM_VAL_PERM = new int[]{5};
    private static final int[] REM_ADM_PERM = new int[]{8};
    private static final int[] REM_ADM_AND_VAL_PERM = new int[]{8, 5};
    private static final int[] MOD_ADM_PERM = new int[]{7};
    private static final int[] MOD_VAL_PERM = new int[]{4};
    private static final int[] ADM_TO_VAL_PERM = new int[]{8, 4};
    private static final int[] VAL_TO_ADM_PERM = new int[]{4, 9};
    private static final int[] ADD_SUB_NA_PERM = new int[]{2};
    private static final int[] LIST_HDLS_PERM = new int[]{11};
    private static final byte[] SIGN_TEST = Util.encodeString("Testing...1..2..3");
    private volatile boolean serverEnabled = true;
    private static int nextAuthId = 0;
    private long maxAuthTime;
    protected HandleStorage storage;
    private final ConcurrentMap<Integer, ChallengeResponseInfo> pendingAuthorizations = new ConcurrentHashMap<Integer, ChallengeResponseInfo>();
    private boolean caseSensitive = false;
    private boolean serverAdminFullAccess = false;
    private boolean wideOpenAccessAllowed = false;
    ValueReference[] serverAdmins = new ValueReference[0];
    ValueReference[] statusHandleAdmins = new ValueReference[0];
    ValueReference[] homeOnlyAdmins = new ValueReference[0];
    ValueReference[] backupAdmins = new ValueReference[0];
    ValueReference[] replicationAdmins = new ValueReference[0];
    private boolean requireSessions = false;
    private String configTemplateDelimiter = null;
    private NamespaceInfo configNamespaceInfo = null;
    private boolean configNamespaceOverride = false;
    TransactionQueuesInterface allOtherTransactionQueues = null;
    TransactionQueueInterface txnQueue;
    TransactionQueuePruner txnQueuePruner;
    boolean enableTxnQueue = true;
    private int currentSigIndex = 0;
    SiteInfo thisSite = null;
    private int thisServerNum = -1;
    private TransactionValidator replicationValidator;
    PublicKey publicKey = null;
    PrivateKey privateKey = null;
    X509Certificate hdlTcpCertificate = null;
    X509Certificate[] certificateChain = null;
    PrivateKey certificatePrivateKey = null;
    Signature[] serverSignaturesSha1 = null;
    Signature[] serverSignaturesSha256 = null;
    private boolean allowRecursiveQueries = false;
    private boolean performRecursionForOldClientsRequestingReferredPrefixes = true;
    private boolean allowNAAdmins = true;
    private boolean allowListHdls = true;
    private String preferredGlobal = null;
    boolean isPrimary = false;
    private boolean doReplication = false;
    private boolean keepOtherTransactions = false;
    private AtomicLong nextTxnId = new AtomicLong();
    private Map<Long, Long> transactionsInProgress = new ConcurrentHashMap<Long, Long>();
    private ReplicationDaemon replicationDaemon;
    private long startTime = 0L;
    private final AtomicLong numRequests = new AtomicLong();
    private final AtomicLong numResolutionRequests = new AtomicLong();
    private final AtomicLong numAdminRequests = new AtomicLong();
    private final AtomicLong numTxnRequests = new AtomicLong();
    private boolean enableStatusHandle = true;
    private boolean enableHomedPrefixNaLookupOptimization = true;
    private int encryptionAlgorithm = 3;
    private Object[] lockHash = new Object[]{new Object()};
    private final SessionManager sessions = new SessionManager();
    private MonitorDaemon monitorDaemon;
    private int replicationPriority;
    private String replicationSiteName;

    private PublicKey getPublicKeyFromFile() {
        File publicKeyFile = new File(this.getConfigDir(), PUBLIC_KEY_FILE);
        PublicKey result = null;
        try {
            result = Util.getPublicKeyFromFile(publicKeyFile.getAbsolutePath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private void buildCertificate(String id, PublicKey pubKey, PrivateKey privKey) {
        try {
            this.hdlTcpCertificate = X509HSCertificateGenerator.generate((String)null, pubKey, privKey);
            X509Certificate[] certChain = this.loadServerCertificateChainFromFile();
            boolean isDsaKey = "DSA".equals(pubKey.getAlgorithm());
            if (certChain != null && certChain.length > 0) {
                boolean isCertificateKeyIdenticalToServerKey;
                if (!isDsaKey && !(isCertificateKeyIdenticalToServerKey = Util.equals(Util.getBytesFromPublicKey(certChain[0].getPublicKey()), Util.getBytesFromPublicKey(pubKey)))) {
                    this.logError(25, "Warning: certificate key from serverCertificate.pem does not match server key");
                }
                this.certificateChain = certChain;
                this.getServerCertificatePrivateKey();
            } else {
                boolean newKey = false;
                if (isDsaKey) {
                    KeyPair keyPair = this.generateKeyPairForCertificate();
                    pubKey = keyPair.getPublic();
                    privKey = keyPair.getPrivate();
                    newKey = true;
                }
                X509Certificate cert = this.generateCertificateAndWriteToFile(id, pubKey, privKey, newKey);
                this.certificatePrivateKey = privKey;
                this.certificateChain = new X509Certificate[]{cert};
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.certificateChain = new X509Certificate[]{this.hdlTcpCertificate};
            this.certificatePrivateKey = this.privateKey;
        }
    }

    private X509Certificate generateCertificateAndWriteToFile(String id, PublicKey pubKey, PrivateKey privKey, boolean newKey) {
        File certFile = new File(this.getConfigDir(), "serverCertificate.pem");
        AutoSelfSignedKeyManager keyManager = new AutoSelfSignedKeyManager(id, pubKey, privKey);
        X509Certificate cert = keyManager.getCertificate();
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(certFile), "UTF-8");){
            X509HSCertificateGenerator.writeCertAsPem(writer, cert);
            if (newKey) {
                this.writeServerCertificatePrivateKeyFile(privKey);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return cert;
    }

    private X509Certificate[] loadServerCertificateChainFromFile() {
        File certFile = new File(this.getConfigDir(), "serverCertificate.pem");
        if (certFile.exists()) {
            X509Certificate[] x509CertificateArray;
            InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(certFile), "UTF-8");
            try {
                x509CertificateArray = X509HSCertificateGenerator.readCertChainAsPem(reader);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((Reader)reader).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ((Reader)reader).close();
            return x509CertificateArray;
        }
        return null;
    }

    private KeyPair generateKeyPairForCertificate() throws NoSuchAlgorithmException {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
        keyGen.initialize(2048);
        KeyPair keyPair = keyGen.generateKeyPair();
        return keyPair;
    }

    private void writeServerCertificatePrivateKeyFile(PrivateKey privKey) throws FileNotFoundException, IOException, Exception {
        FileOutputStream out = new FileOutputStream(new File(this.getConfigDir(), "serverCertificatePrivateKey.bin"));
        out.write(new byte[]{0, 0, 0, 1});
        out.write(Util.getBytesFromPrivateKey(privKey));
        out.close();
    }

    private void getServerCertificatePrivateKey() throws IOException, Exception, HandleException, InvalidKeySpecException {
        File privateKeyFile = new File(this.getConfigDir(), "serverCertificatePrivateKey.bin");
        if (privateKeyFile.exists()) {
            byte[] encKeyBytes = Files.readAllBytes(privateKeyFile.toPath());
            byte[] secKey = null;
            if (Util.requiresSecretKey(encKeyBytes)) {
                secKey = Util.getPassphrase("Enter the passphrase for this server's HTTPS certificate private key: ");
            }
            this.certificatePrivateKey = Util.getPrivateKeyFromBytes(Util.decrypt(encKeyBytes, secKey));
        } else {
            this.certificatePrivateKey = this.privateKey;
        }
    }

    public X509Certificate getHdlTcpCertificate() {
        return this.hdlTcpCertificate;
    }

    @Override
    public X509Certificate getCertificate() {
        if (this.certificateChain == null || this.certificateChain.length == 0) {
            return null;
        }
        return this.certificateChain[0];
    }

    @Override
    public X509Certificate[] getCertificateChain() {
        return this.certificateChain;
    }

    @Override
    public PrivateKey getCertificatePrivateKey() {
        return this.certificatePrivateKey;
    }

    @Override
    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    @Override
    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    @Override
    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    protected HandleServer() {
    }

    public HandleServer(Main main, StreamTable config, HandleResolver resolver) throws Exception {
        super(main, config, resolver);
        this.startTime = System.currentTimeMillis();
        this.enableStatusHandle = config.getBoolean(ENABLE_STATUS_HDL, true);
        this.enableHomedPrefixNaLookupOptimization = config.getBoolean(ENABLE_HOMED_PREFIX_LOCAL_SITES, true);
        if (config.containsKey(DO_RECURSION)) {
            this.allowRecursiveQueries = config.getBoolean(DO_RECURSION);
        }
        if (config.containsKey(DO_RECURSION_FOR_LEGACY_PREFIX_REFERRAL)) {
            this.performRecursionForOldClientsRequestingReferredPrefixes = config.getBoolean(DO_RECURSION_FOR_LEGACY_PREFIX_REFERRAL);
        }
        if (config.containsKey(PREFERRED_GLOBAL)) {
            this.preferredGlobal = config.getStr(PREFERRED_GLOBAL);
            Properties p = new Properties(System.getProperties());
            p.put("hdllib.preferredGlobal", this.preferredGlobal);
            System.setProperties(p);
        }
        this.initAdmins();
        this.initThisSiteAndServerNum();
        this.initKeysAndCertsAndSignatures();
        this.initSessionManager();
        this.doReplication = config.getBoolean(DO_REPLICATION, this.thisSite.multiPrimary || !this.isPrimary);
        if (this.doReplication) {
            this.replicationDaemon = new ReplicationDaemon(this, config, this.getConfigDir());
        }
        if (config.containsKey(ENABLE_TXN_QUEUE)) {
            this.enableTxnQueue = config.getBoolean(ENABLE_TXN_QUEUE);
        }
        if (this.enableTxnQueue) {
            int daysToKeep;
            File txnDir = new File(this.getConfigDir(), TXN_QUEUE_DIR);
            if (this.isPrimary) {
                this.initTxnQueue(txnDir);
            }
            this.keepOtherTransactions = config.getBoolean("replication_keep_other_transactions", true);
            if (this.isPrimary || this.keepOtherTransactions) {
                this.initOtherTxnQueues(txnDir);
            }
            if ((this.txnQueue != null || this.allOtherTransactionQueues != null) && (daysToKeep = config.getInt("txnlog_num_days_to_keep", 0)) > 0) {
                this.txnQueuePruner = new TransactionQueuePruner(this.txnQueue, this.allOtherTransactionQueues, daysToKeep);
                this.txnQueuePruner.start();
            }
        }
        this.caseSensitive = config.getBoolean(CASE_SENSITIVE);
        this.configNamespaceOverride = config.getBoolean(NAMESPACE_OVERRIDE_CONFIG_KEY);
        this.configTemplateDelimiter = config.getStr(TEMPLATE_DELIM_CONFIG_KEY, "").trim();
        String configNamespaceInfoStr = config.getStr(NAMESPACE_CONFIG_KEY, null);
        if (configNamespaceInfoStr != null) {
            this.configNamespaceInfo = new NamespaceInfo(configNamespaceInfoStr.getBytes("UTF-8"));
        }
        this.storage = HandleStorageFactory.getStorage(this.getConfigDir(), config, this.isPrimary);
        try {
            this.maxAuthTime = Long.parseLong(String.valueOf(config.get(MAX_AUTH_TIME)).trim());
        }
        catch (Exception e) {
            System.err.println("Invalid authentication time allowance.  Using default (20 seconds)");
            this.maxAuthTime = 20000L;
        }
        if (this.enableHomedPrefixNaLookupOptimization) {
            SiteInfo[] ss = new SiteInfo[]{this.thisSite};
            this.storage.scanNAs(handle -> resolver.getConfiguration().setLocalSites(Util.decodeString(handle), ss));
        }
        this.lockHash = new Object[256];
        for (int i = 0; i < this.lockHash.length; ++i) {
            this.lockHash[i] = new Object();
        }
        ChallengeResponse.initializeRandom();
    }

    private void initAdmins() throws Exception {
        if (this.config.containsKey(SERVER_ADMIN_FULL_ACCESS)) {
            this.serverAdminFullAccess = this.config.getBoolean(SERVER_ADMIN_FULL_ACCESS);
        }
        if (this.config.containsKey(ANONYMOUS_FULL_ACCESS)) {
            this.wideOpenAccessAllowed = this.config.getBoolean(ANONYMOUS_FULL_ACCESS);
        }
        if (this.config.containsKey(ALLOW_LIST_HANDLES)) {
            this.allowListHdls = this.config.getBoolean(ALLOW_LIST_HANDLES);
        }
        if (this.config.containsKey(ALLOW_NA_ADMINS)) {
            this.allowNAAdmins = this.config.getBoolean(ALLOW_NA_ADMINS);
        }
        this.serverAdmins = HandleServer.getAdminListFromConfig(this.config, SERVER_ADMINS);
        this.homeOnlyAdmins = HandleServer.getAdminListFromConfig(this.config, HOME_ONLY_ADMINS);
        this.statusHandleAdmins = HandleServer.getAdminListFromConfig(this.config, STATUS_HDL_ADMINS);
        this.backupAdmins = HandleServer.getAdminListFromConfig(this.config, BACKUP_ADMINS);
        this.replicationAdmins = HandleServer.getAdminListFromConfig(this.config, REPLICATION_ADMINS);
    }

    private void initSessionManager() {
        this.requireSessions = this.config.getBoolean(REQUIRE_SESSIONS, false);
        SessionManager.initializeSessionKeyRandom();
        this.sessions.checkTimeoutSession();
        int maxSessionTimeout = 86400;
        if (this.config.containsKey(MAX_SESSION_TIME)) {
            try {
                maxSessionTimeout = Integer.parseInt(String.valueOf(this.config.get(MAX_SESSION_TIME)).trim());
            }
            catch (Exception e) {
                this.logError(50, "Invalid session timeout allowance.  Using default (24 hours)");
            }
        }
        if (maxSessionTimeout < 60) {
            maxSessionTimeout = 60;
            this.logError(50, "Adjusted session timeout allowance. Using 1 minute.");
        }
        SessionInfo.setDefaultTimeout(maxSessionTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initKeysAndCertsAndSignatures() throws Exception {
        String encAlg = this.config.getStr(ENCRYPTION_ALGORITHM, DEFAULT_ENC_ALG).toLowerCase().trim();
        if (encAlg.equals("des")) {
            this.encryptionAlgorithm = 1;
        } else if (encAlg.equals("desede")) {
            this.encryptionAlgorithm = 2;
        } else if (encAlg.equals("aes")) {
            this.encryptionAlgorithm = 3;
        } else {
            throw new Exception("Invalid encryption algorithm: '" + encAlg + "'; Please use either des, desede, or aes");
        }
        byte[] secKey = null;
        try {
            int i;
            this.publicKey = this.getPublicKeyFromFile();
            File privateKeyFile = new File(this.getConfigDir(), PRIVATE_KEY_FILE);
            if (!privateKeyFile.exists() || !privateKeyFile.canRead()) {
                System.err.println("Missing or inaccessible private key file: " + privateKeyFile.getAbsolutePath());
                throw new Exception("Missing or inaccessible private key file: " + privateKeyFile.getAbsolutePath());
            }
            byte[] encKeyBytes = new byte[(int)privateKeyFile.length()];
            try (FileInputStream in = new FileInputStream(privateKeyFile);){
                int r;
                for (int n = 0; n < encKeyBytes.length && (r = in.read(encKeyBytes, n, encKeyBytes.length - n)) >= 0; n += r) {
                }
            }
            byte[] keyBytes = null;
            if (Util.requiresSecretKey(encKeyBytes)) {
                secKey = Util.getPassphrase("Enter the passphrase for this server's authentication private key: ");
            }
            keyBytes = Util.decrypt(encKeyBytes, secKey);
            try {
                this.privateKey = Util.getPrivateKeyFromBytes(keyBytes, 0);
            }
            catch (Exception e) {
                System.err.println("\n**************************************************************************\nError parsing private key, please make sure the passphrase is correct.\n**************************************************************************\n");
                throw e;
            }
            for (i = 0; i < keyBytes.length; ++i) {
                keyBytes[i] = 0;
            }
            this.buildCertificate(null, this.publicKey, this.privateKey);
            this.serverSignaturesSha1 = new Signature[50];
            for (i = 0; i < this.serverSignaturesSha1.length; ++i) {
                this.serverSignaturesSha1[i] = Signature.getInstance(Util.getSigIdFromHashAlgId(Common.HASH_ALG_SHA1, this.privateKey.getAlgorithm()));
                this.serverSignaturesSha1[i].initSign(this.privateKey);
            }
            this.serverSignaturesSha256 = new Signature[50];
            for (i = 0; i < this.serverSignaturesSha256.length; ++i) {
                this.serverSignaturesSha256[i] = Signature.getInstance(Util.getSigIdFromHashAlgId(Common.HASH_ALG_SHA256, this.privateKey.getAlgorithm()));
                this.serverSignaturesSha256[i].initSign(this.privateKey);
            }
            PublicKey pubKey = this.thisSite.servers[this.thisServerNum].getPublicKey();
            this.serverSignaturesSha1[0].update(SIGN_TEST);
            byte[] testSig = this.serverSignaturesSha1[0].sign();
            Signature verifier = Signature.getInstance(this.serverSignaturesSha1[0].getAlgorithm());
            verifier.initVerify(pubKey);
            verifier.update(SIGN_TEST);
            if (!verifier.verify(testSig)) {
                throw new Exception("Private key doesn't match public key from site info!");
            }
        }
        catch (Exception e) {
            System.err.println("Unable to initialize server signature object: " + e);
            e.printStackTrace(System.err);
            throw e;
        }
        for (int i = 0; secKey != null && i < secKey.length; ++i) {
            secKey[i] = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initThisSiteAndServerNum() throws Exception {
        try {
            SiteInfo site;
            int thisId = Integer.parseInt((String)this.config.get(THIS_SERVER_ID));
            File siteInfoFile = new File(this.getConfigDir(), SITE_INFO_FILE);
            if (!siteInfoFile.exists() || !siteInfoFile.canRead()) {
                File siteInfoJsonFile = new File(this.getConfigDir(), SITE_INFO_JSON_FILE);
                if (!siteInfoJsonFile.exists() || !siteInfoJsonFile.canRead()) {
                    System.err.println("Missing or inaccessible site info file: " + siteInfoFile.getAbsolutePath() + "/" + siteInfoJsonFile.getName());
                    throw new Exception("Missing or inaccessible site info file: " + siteInfoFile.getAbsolutePath() + "/" + siteInfoJsonFile.getName());
                }
                byte[] siteInfoBytes = Util.getBytesFromFile(siteInfoJsonFile);
                try {
                    site = SiteInfoConverter.convertToSiteInfo(new String(siteInfoBytes, "UTF-8"));
                }
                catch (Throwable t) {
                    System.err.println("Missing or inaccessible site info file: " + siteInfoFile.getAbsolutePath() + "/" + siteInfoJsonFile.getName());
                    throw new Exception("Missing or inaccessible site info file: " + siteInfoFile.getAbsolutePath() + "/" + siteInfoJsonFile.getName(), t);
                }
            }
            site = new SiteInfo();
            byte[] siteInfoBuf = new byte[(int)siteInfoFile.length()];
            try (FileInputStream in = new FileInputStream(siteInfoFile);){
                int r;
                int n = 0;
                while ((r = ((InputStream)in).read(siteInfoBuf, n, siteInfoBuf.length - n)) > 0) {
                    n += r;
                }
            }
            Encoder.decodeSiteInfoRecord(siteInfoBuf, 0, site);
            this.thisServerNum = -1;
            for (int i = 0; i < site.servers.length; ++i) {
                if (site.servers[i].serverId != thisId) continue;
                this.thisServerNum = i;
            }
            if (this.thisServerNum < 0) {
                throw new Exception("Server ID " + thisId + " does not exist in site!");
            }
            this.thisSite = site;
        }
        catch (Exception e) {
            System.err.println("Invalid site/server specification: " + e);
            throw e;
        }
        this.isPrimary = this.thisSite.isPrimary;
    }

    @Override
    public void start() {
        super.start();
        if (this.config.getBoolean(ENABLE_MONITOR_DAEMON, false)) {
            this.monitorDaemon = new MonitorDaemon(60, this.startTime, this.numRequests, this.numResolutionRequests, this.numAdminRequests, this.numTxnRequests, this.getConfigDir());
            this.monitorDaemon.start();
        }
        ChallengePurgeThread cpt = new ChallengePurgeThread();
        cpt.setDaemon(true);
        cpt.setPriority(1);
        cpt.start();
        if (this.isPrimary) {
            this.applyAutoHomedPrefixes();
        }
        if (this.doReplication) {
            System.err.println("starting replication thread");
            this.replicationDaemon.setDaemon(true);
            this.replicationDaemon.setPriority(1);
            this.replicationDaemon.start();
        }
    }

    @Override
    public void registerInternalTransactionValidator(TransactionValidator replicationValidator) {
        this.replicationValidator = replicationValidator;
    }

    @Override
    public void registerReplicationTransactionValidator(TransactionValidator replicationValidator) {
        if (this.replicationDaemon != null) {
            this.replicationDaemon.registerReplicationTransactionValidator(replicationValidator);
        }
    }

    @Override
    public void registerReplicationErrorNotifier(NotifierInterface notifier) {
        if (this.replicationDaemon != null) {
            this.replicationDaemon.registerReplicationErrorNotifier(notifier);
        }
    }

    public TransactionQueuesInterface getAllOtherTransactionQueues() {
        return this.allOtherTransactionQueues;
    }

    private static List<String> getAutoHomedPrefixListFromConfig(StreamTable config) {
        ArrayList<String> result = new ArrayList<String>();
        if (config.containsKey(AUTO_HOMED_PREFIXES)) {
            Vector autoHomedPrefixesVect = (Vector)config.get(AUTO_HOMED_PREFIXES);
            for (int i = 0; i < autoHomedPrefixesVect.size(); ++i) {
                String prefixStr = String.valueOf(autoHomedPrefixesVect.elementAt(i));
                result.add(prefixStr);
            }
        }
        return result;
    }

    private void applyAutoHomedPrefixes() {
        List<String> autoHomedPrefixes = HandleServer.getAutoHomedPrefixListFromConfig(this.config);
        for (String na : autoHomedPrefixes) {
            if ("0.NA/YOUR_PREFIX".equals(na)) continue;
            byte[] naBytes = Util.encodeString(na);
            if (!Util.hasSlash(naBytes)) {
                naBytes = Util.convertSlashlessHandleToZeroNaHandle(naBytes);
            }
            try {
                if (this.storageHaveNA(naBytes)) continue;
                this.doHomeNA(naBytes);
            }
            catch (HandleException e) {
                this.logError(100, "Unable to \"home\" prefix \"" + na + "\" after transaction was logged! - " + e);
                e.printStackTrace(System.err);
                return;
            }
        }
    }

    private static ValueReference[] getAdminListFromConfig(StreamTable config, String key) throws Exception {
        ValueReference[] valRefs = new ValueReference[]{};
        if (config.containsKey(key)) {
            try {
                Vector adminVect = (Vector)config.get(key);
                valRefs = new ValueReference[adminVect.size()];
                for (int i = 0; i < adminVect.size(); ++i) {
                    String adminStr = String.valueOf(adminVect.elementAt(i));
                    valRefs[i] = ValueReference.fromString(adminStr);
                    if (valRefs[i] != null) continue;
                    throw new Exception("Invalid administrator ID: \"" + adminStr + "\"");
                }
            }
            catch (Exception e) {
                throw new Exception("Error processing administrator list \"" + key + "\": " + e);
            }
        }
        return valRefs;
    }

    public void initTxnQueue(File txnDir) throws Exception {
        if (!txnDir.exists()) {
            txnDir.mkdirs();
        }
        if (HandleServer.isConcatenatedQueueNeeded(txnDir)) {
            boolean readOnly = this.config.getBoolean(READ_ONLY_TXN_QUEUE, false);
            FileBasedTransactionQueue oldQueue = new FileBasedTransactionQueue(txnDir, readOnly);
            BdbjeTransactionQueue currentQueue = new BdbjeTransactionQueue(txnDir, this.config);
            this.txnQueue = new ConcatenatedTransactionQueue(oldQueue, currentQueue);
        } else {
            this.txnQueue = new BdbjeTransactionQueue(txnDir, this.config);
        }
        this.nextTxnId.set(this.txnQueue.getLastTxnId());
    }

    private void initOtherTxnQueues(File txnDir) throws Exception {
        if (!txnDir.exists()) {
            txnDir.mkdirs();
        }
        this.allOtherTransactionQueues = new BdbjeTransactionQueues(txnDir, this.txnQueue, this.config);
    }

    public static boolean isConcatenatedQueueNeeded(File txnDir) {
        TxnQueueFilter filter = new TxnQueueFilter();
        File[] queueFiles = txnDir.listFiles(filter);
        return queueFiles.length != 0;
    }

    @Override
    public void dumpHandles() throws HandleException, IOException {
        this.replicationDaemon.dumpHandles(true, null);
    }

    @Override
    public SiteInfo getSiteInfo() {
        return this.thisSite;
    }

    @Override
    public int getServerNum() {
        return this.thisServerNum;
    }

    @Override
    public ServerInfo getServerInfo() {
        return this.thisSite.servers[this.thisServerNum];
    }

    @Override
    public HandleStorage getStorage() {
        return this.storage;
    }

    @Override
    public ReplicationDaemonInterface getReplicationDaemon() {
        return this.replicationDaemon;
    }

    @Override
    public final byte[][] getRawHandleValuesWithTemplate(byte[] inHandle, int[] indexList, byte[][] typeList, short recursionCount) throws HandleException {
        Object values = this.storageGetRawHandleValues(this.caseSensitive ? inHandle : Util.upperCase(inHandle), indexList, typeList);
        if (values != null) {
            return values;
        }
        String templateDelimiter = null;
        NamespaceInfo ns = null;
        if (!this.configNamespaceOverride) {
            ResolutionRequest resReq = new ResolutionRequest(inHandle, null, null, null);
            resReq.certify = true;
            resReq.recursionCount = recursionCount;
            try {
                ns = this.resolver.getNamespaceInfo(resReq);
            }
            catch (HandleException handleException) {
                // empty catch block
            }
        }
        if (ns == null) {
            ns = this.configNamespaceInfo;
        }
        if (ns != null) {
            templateDelimiter = ns.templateDelimiter();
        }
        if (templateDelimiter == null || templateDelimiter.length() == 0) {
            templateDelimiter = this.configTemplateDelimiter;
        }
        if (templateDelimiter == null || templateDelimiter.length() == 0) {
            return null;
        }
        byte[] naHandle = Util.getZeroNAHandle(inHandle);
        String naHandleStr = Util.startsWith(naHandle, Common.NA_HANDLE_PREFIX) ? Util.decodeString(naHandle, Common.NA_HANDLE_PREFIX.length, naHandle.length - Common.NA_HANDLE_PREFIX.length) : Util.decodeString(naHandle);
        String inHandleStr = Util.decodeString(inHandle);
        int startDelim = inHandleStr.indexOf(templateDelimiter, naHandleStr.length());
        if (startDelim < 0) {
            return null;
        }
        boolean allValues = !(indexList != null && indexList.length != 0 || typeList != null && typeList.length != 0);
        String baseHandleStr = inHandleStr.substring(0, startDelim);
        String afterDelimStr = inHandleStr.substring(startDelim + templateDelimiter.length());
        byte[] baseHandle = Util.encodeString(baseHandleStr);
        if (this.thisSite.servers.length > 1 && this.thisSite.determineServerNum(baseHandle) != this.thisServerNum) {
            ResolutionRequest req = new ResolutionRequest(baseHandle, null, null, null);
            req.setSupportedProtocolVersion(this.thisSite);
            AbstractResponse response = this.resolver.sendRequestToServer((AbstractRequest)req, this.thisSite, this.thisSite.determineServer(baseHandle));
            if (response.responseCode == 100) {
                return null;
            }
            if (response instanceof ErrorResponse) {
                String msg = Util.decodeString(((ErrorResponse)response).message);
                throw new HandleException(1, AbstractMessage.getResponseCodeMessage(response.responseCode) + ": " + msg);
            }
            values = ((ResolutionResponse)response).values;
        } else {
            values = this.storageGetRawHandleValues(this.caseSensitive ? baseHandle : Util.upperCase(baseHandle), null, null);
        }
        if (values == null) {
            if (ns == null) {
                return null;
            }
            values = new byte[0][];
        }
        HandleValue[] handleValues = new HandleValue[((byte[][])values).length];
        for (int i = 0; i < ((byte[][])values).length; ++i) {
            handleValues[i] = new HandleValue();
            Encoder.decodeHandleValue(values[i], 0, handleValues[i]);
        }
        NamespaceInfo thisNs = Util.getNamespaceFromValues(baseHandleStr, handleValues);
        if (thisNs != null) {
            thisNs.setParentNamespace(ns);
            ns = thisNs;
        }
        if (ns == null || ns.getInheritedTag("template") == null) {
            if (allValues) {
                return values;
            }
            ArrayList<byte[]> res = new ArrayList<byte[]>(((byte[][])values).length);
            for (byte[] value : values) {
                byte[] clumpType = Encoder.getHandleValueType(value, 0);
                int clumpIndex = Encoder.getHandleValueIndex(value, 0);
                if (!Util.isParentTypeInArray(typeList, clumpType) && !Util.isInArray(indexList, clumpIndex)) continue;
                res.add(value);
            }
            return (byte[][])res.toArray((T[])new byte[0][]);
        }
        HandleValue[] resVals = ns.templateConstruct(handleValues, inHandleStr, baseHandleStr, afterDelimStr, this.caseSensitive, this.resolver, recursionCount);
        if (resVals == null) {
            return null;
        }
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>(resVals.length);
        for (HandleValue resVal : resVals) {
            if (!allValues && !Util.isParentTypeInArray(typeList, resVal.getType()) && !Util.isInArray(indexList, resVal.getIndex())) continue;
            byte[] buf = new byte[Encoder.calcStorageSize(resVal)];
            Encoder.encodeHandleValue(buf, 0, resVal);
            arrayList.add(buf);
        }
        return (byte[][])arrayList.toArray((T[])new byte[0][]);
    }

    private boolean pendingChallenge(int sessionId) {
        if (sessionId < 0) {
            return false;
        }
        ChallengeResponseInfo crInfo = (ChallengeResponseInfo)this.pendingAuthorizations.get(sessionId);
        return crInfo != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendResponse(ResponseMessageCallback callback, AbstractResponse response) throws HandleException {
        if (callback instanceof FixRequestIdAndThen) {
            ((FixRequestIdAndThen)callback).fixRequestId(response);
        }
        if (this.thisSite.isPrimary) {
            response.authoritative = true;
        }
        response.siteInfoSerial = this.thisSite.serialNumber;
        if (response.certify && (response.cacheCertify || response.signature == null)) {
            ServerSideSessionInfo sssinfo;
            boolean signed = false;
            if (response.sessionId > 0 && (sssinfo = this.getSession(response.sessionId)) != null && response.opCode != 400 && response.opCode != 402) {
                try {
                    response.sessionCounter = sssinfo.getNextSessionCounter();
                    response.signMessage(sssinfo.getSessionKey());
                    signed = true;
                }
                catch (Exception e) {
                    this.logError(75, "Exception signing response: " + e);
                    signed = false;
                }
            }
            if (!signed) {
                Signature[] serverSignatures = this.supportsSha256Signature(response) ? this.serverSignaturesSha256 : this.serverSignaturesSha1;
                try {
                    Signature sig;
                    int sigIndex = this.currentSigIndex++;
                    if (sigIndex >= serverSignatures.length) {
                        this.currentSigIndex = 0;
                        sigIndex = 0;
                    }
                    Signature signature = sig = serverSignatures[sigIndex];
                    synchronized (signature) {
                        response.signMessage(sig);
                    }
                }
                catch (Exception e) {
                    this.logError(75, "Exception signing response: " + e);
                }
            }
        }
        callback.handleResponse(response);
    }

    private boolean supportsSha256Signature(AbstractResponse response) {
        if (response.hasEqualOrGreaterVersion(2, 11)) {
            return true;
        }
        if ("DSA".equals(this.privateKey.getAlgorithm())) {
            return false;
        }
        return response.hasEqualOrGreaterVersion(2, 7);
    }

    @Override
    public void disable() {
        this.serverEnabled = false;
    }

    @Override
    public void enable() {
        this.serverEnabled = true;
    }

    @Override
    public void processRequest(AbstractRequest req, ResponseMessageCallback callback) throws HandleException {
        if (!this.serverEnabled) {
            this.sendServerDisabledResponse(req, callback);
            return;
        }
        this.processRequest(req, null, null, callback);
    }

    @Override
    public void processRequest(AbstractRequest req, InetAddress caller, ResponseMessageCallback callback) throws HandleException {
        this.processRequest(req, callback);
    }

    @Override
    public AbstractResponse processRequest(AbstractRequest req, InetAddress caller) throws HandleException {
        SimpleResponseMessageCallback callback = new SimpleResponseMessageCallback();
        try {
            this.processRequest(req, caller, callback);
        }
        catch (HandleException e) {
            return HandleException.toErrorResponse(req, e);
        }
        return callback.getResponse();
    }

    @Override
    public void processPreAuthenticatedRequest(AbstractRequest req, ResponseMessageCallback callback) throws HandleException {
        if (!this.serverEnabled) {
            this.sendServerDisabledResponse(req, callback);
            return;
        }
        if (req.authInfo == null) {
            this.processRequest(req, null, null, callback);
        } else {
            this.processRequest(req, new PreAuthenticatedChallengeResponse(), new PreAuthenticatedChallengeAnswerRequest(req.authInfo), callback);
        }
    }

    private void sendServerDisabledResponse(AbstractRequest req, ResponseMessageCallback callback) throws HandleException {
        this.sendResponse(callback, new ErrorResponse(req, 7, MSG_SERVER_TEMPORARILY_DISABLED));
    }

    void processRequest(AbstractRequest req, ChallengeResponse cRes, ChallengeAnswerRequest crReq, ResponseMessageCallback callback) throws HandleException {
        this.numRequests.incrementAndGet();
        this.setTentativeServerSideAuthenticationInfo(req, cRes, crReq);
        if (req.sessionId > 0 && !this.pendingChallenge(req.sessionId) && !this.validSession(req)) {
            this.sendResponse(callback, new ErrorResponse(req, 500, MSG_INVALID_SESSION_OR_TIMEOUT));
            return;
        }
        this.validSession(req);
        if (req.isAdminRequest && !this.isPrimary && (!this.keepOtherTransactions || req.opCode != 1001 && req.opCode != 1002)) {
            this.sendResponse(callback, new ErrorResponse(req, 301, MSG_NOT_A_PRIMARY));
            return;
        }
        switch (req.opCode) {
            case 2: {
                this.sendResponse(callback, new GetSiteInfoResponse(req, this.thisSite));
                break;
            }
            case 1: {
                this.numResolutionRequests.incrementAndGet();
                this.sendResponse(callback, this.doResolution((ResolutionRequest)req, cRes, crReq, false));
                break;
            }
            case 105: {
                this.doListHandles(callback, (ListHandlesRequest)req, cRes, crReq);
                break;
            }
            case 302: {
                this.doListNAs(callback, (ListNAsRequest)req, cRes, crReq);
                break;
            }
            case 400: {
                this.sendResponse(callback, this.doSessionSetup((SessionSetupRequest)req, cRes, crReq));
                break;
            }
            case 402: {
                this.sendResponse(callback, this.doKeyExchange((SessionExchangeKeyRequest)req, cRes, crReq));
                break;
            }
            case 401: {
                this.sendResponse(callback, this.doSessionTerminate((GenericRequest)req, cRes, crReq));
                break;
            }
            case 200: {
                ChallengeResponseInfo crInfo = (ChallengeResponseInfo)this.pendingAuthorizations.get(req.sessionId);
                if (crInfo == null || crInfo.hasExpired()) {
                    this.sendResponse(callback, new ErrorResponse(req, 405, null));
                    break;
                }
                crInfo.challengeAccepted = true;
                this.processRequest(crInfo.originalRequest, crInfo.challenge, (ChallengeAnswerRequest)req, new FixRequestIdAndThen(req.requestId, callback));
                break;
            }
            case 201: {
                this.sendResponse(callback, this.verifyChallenge((VerifyAuthRequest)req, cRes, crReq));
                break;
            }
            case 1002: {
                this.sendResponse(callback, this.doDumpHandles((DumpHandlesRequest)req, cRes, crReq));
                break;
            }
            case 102: {
                this.numAdminRequests.incrementAndGet();
                this.sendResponse(callback, this.doAddValue((AddValueRequest)req, cRes, crReq));
                break;
            }
            case 103: {
                this.numAdminRequests.incrementAndGet();
                this.sendResponse(callback, this.doRemoveValue((RemoveValueRequest)req, cRes, crReq));
                break;
            }
            case 104: {
                this.numAdminRequests.incrementAndGet();
                this.sendResponse(callback, this.doModifyValue((ModifyValueRequest)req, cRes, crReq));
                break;
            }
            case 100: {
                this.numAdminRequests.incrementAndGet();
                this.sendResponse(callback, this.doCreateHandle((CreateHandleRequest)req, cRes, crReq));
                break;
            }
            case 101: {
                this.numAdminRequests.incrementAndGet();
                this.sendResponse(callback, this.doDeleteHandle((DeleteHandleRequest)req, cRes, crReq));
                break;
            }
            case 1000: {
                this.sendResponse(callback, this.getNextTxnId((GenericRequest)req, cRes, crReq));
                break;
            }
            case 1001: {
                this.sendResponse(callback, this.doRetrieveTxnLog((RetrieveTxnRequest)req, cRes, crReq));
                break;
            }
            case 300: {
                this.sendResponse(callback, this.doHomeNA(req, cRes, crReq));
                break;
            }
            case 301: {
                this.sendResponse(callback, this.doUnhomeNA(req, cRes, crReq));
                break;
            }
            case 1003: {
                this.sendResponse(callback, this.doBackup((GenericRequest)req, cRes, crReq));
                break;
            }
            default: {
                throw new HandleException(1, "Unknown operation: " + req.opCode);
            }
        }
    }

    private void setTentativeServerSideAuthenticationInfo(AbstractRequest req, ChallengeResponse cRes, ChallengeAnswerRequest crReq) {
        if (req.authInfo == null) {
            if (req instanceof ChallengeAnswerRequest) {
                ChallengeAnswerRequest car = (ChallengeAnswerRequest)req;
                req.authInfo = new TentativeServerSideAuthenticationInfo(car.userIdHandle, car.userIdIndex);
            } else if (cRes != null && crReq != null) {
                req.authInfo = new TentativeServerSideAuthenticationInfo(crReq.userIdHandle, crReq.userIdIndex);
            } else {
                ServerSideSessionInfo sessionInfo = this.getSession(req.sessionId);
                if (sessionInfo != null && !sessionInfo.isSessionAnonymous()) {
                    req.authInfo = new TentativeServerSideAuthenticationInfo(sessionInfo.identityKeyHandle, sessionInfo.identityKeyIndex);
                }
            }
        }
    }

    private final AbstractResponse getNextTxnId(GenericRequest req, ChallengeResponse cRes, ChallengeAnswerRequest crReq) throws HandleException {
        return new ErrorResponse(req, 5, MSG_NO_NEXT_TXN_ID);
    }

    private long getLatestTxnId() {
        if (this.txnQueue == null) {
            return -1L;
        }
        long latest = this.txnQueue.getLastTxnId();
        for (long txnInProgress : this.transactionsInProgress.values()) {
            if (txnInProgress - 1L >= latest) continue;
            latest = txnInProgress - 1L;
        }
        return latest;
    }

    private final long getNextTxnId() {
        return this.nextTxnId.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final AbstractResponse doHomeNA(AbstractRequest req, ChallengeResponse cRes, ChallengeAnswerRequest crReq) throws HandleException {
        byte[] handle = req.handle;
        if (!Util.hasSlash(handle)) {
            handle = Util.convertSlashlessHandleToZeroNaHandle(handle);
        }
        if (!Util.startsWithCI(handle, Common.NA_HANDLE_PREFIX)) {
            this.logError(50, "Was asked to home non-prefix handle: '" + Util.decodeString(handle) + "' ");
            return new ErrorResponse(req, 102, MSG_NOT_A_NA_HANDLE);
        }
        AbstractResponse authError = this.returnErrorOrChallengeIfRequestNotAuthorized(req, cRes, crReq, this.serverAdmins, this.homeOnlyAdmins);
        if (authError != null) {
            return authError;
        }
        Object object = this.getWriteLock(handle);
        synchronized (object) {
            try {
                ErrorResponse maybeError;
                if (this.thisSite.determineServerNum(handle) == this.thisServerNum && (maybeError = this.validateAndInsertTransactionReturnResponseIfError(req, handle, null, (byte)4)) != null) {
                    ErrorResponse errorResponse = maybeError;
                    return errorResponse;
                }
                this.storage.setHaveNA(handle, true);
            }
            catch (HandleException e) {
                this.logError(100, "Unable to \"home\" prefix \"" + Util.decodeString(handle) + "\" after transaction was logged! - " + e);
                e.printStackTrace(System.err);
                if (e.getCode() == 18) {
                    ErrorResponse errorResponse = new ErrorResponse(req, 7, MSG_SERVER_BACKUP);
                    return errorResponse;
                }
                ErrorResponse errorResponse = new ErrorResponse(req, 2, MSG_INTERNAL_ERROR);
                return errorResponse;
            }
            finally {
                this.transactionsInProgress.remove(Thread.currentThread().getId());
            }
            this.adjustHomedPrefix(handle, true);
            return new GenericResponse(req, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doHomeNA(byte[] na) throws HandleException {
        Object object = this.getWriteLock(na);
        synchronized (object) {
            try {
                if (this.thisSite.determineServerNum(na) == this.thisServerNum && !this.insertTransaction(na, null, (byte)4)) {
                    this.logError(75, "Unable to save HOME-NA transaction.");
                    return;
                }
                this.storage.setHaveNA(na, true);
            }
            finally {
                this.transactionsInProgress.remove(Thread.currentThread().getId());
            }
            this.adjustHomedPrefix(na, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final AbstractResponse doUnhomeNA(AbstractRequest req, ChallengeResponse cRes, ChallengeAnswerRequest crReq) throws HandleException {
        byte[] handle = req.handle;
        if (!Util.hasSlash(handle)) {
            handle = Util.convertSlashlessHandleToZeroNaHandle(handle);
        }
        if (!Util.startsWithCI(handle, Common.NA_HANDLE_PREFIX)) {
            this.logError(50, "Was asked to unhome non-prefix handle: '" + Util.decodeString(handle) + "' ");
            return new ErrorResponse(req, 102, MSG_NOT_A_NA_HANDLE);
        }
        AbstractResponse authError = this.returnErrorOrChallengeIfRequestNotAuthorized(req, cRes, crReq, this.serverAdmins, this.homeOnlyAdmins);
        if (authError != null) {
            return authError;
        }
        Object object = this.getWriteLock(handle);
        synchronized (object) {
            try {
                ErrorResponse maybeError;
                if (this.thisSite.determineServerNum(handle) == this.thisServerNum && (maybeError = this.validateAndInsertTransactionReturnResponseIfError(req, handle, null, (byte)5)) != null) {
                    ErrorResponse errorResponse = maybeError;
                    return errorResponse;
                }
                this.storage.setHaveNA(handle, false);
                if (!Util.hasSlash(req.handle) && this.storage.haveNA(req.handle)) {
                    this.storage.setHaveNA(req.handle, false);
                }
            }
            catch (HandleException e) {
                this.logError(100, "Unable to \"unhome\" prefix \"" + Util.decodeString(handle) + "\" after transaction was logged! - " + e);
                e.printStackTrace(System.err);
                if (e.getCode() == 18) {
                    ErrorResponse errorResponse = new ErrorResponse(req, 7, MSG_SERVER_BACKUP);
                    return errorResponse;
                }
                ErrorResponse errorResponse = new ErrorResponse(req, 2, MSG_INTERNAL_ERROR);
                return errorResponse;
            }
            finally {
                this.transactionsInProgress.remove(Thread.currentThread().getId());
            }
            this.adjustHomedPrefix(handle, false);
            return new GenericResponse(req, 1);
        }
    }

    public void adjustHomedPrefix(byte[] na, boolean home) {
        if (this.enableHomedPrefixNaLookupOptimization) {
            SiteInfo[] siteInfoArray;
            Configuration configuration = this.resolver.getConfiguration();
            String string = Util.decodeString(na);
            if (home) {
                SiteInfo[] siteInfoArray2 = new SiteInfo[1];
                siteInfoArray = siteInfoArray2;
                siteInfoArray2[0] = this.thisSite;
            } else {
                siteInfoArray = null;
            }
            configuration.setLocalSites(string, siteInfoArray);
        }
    }

    private final AbstractResponse doRetrieveTxnLog(RetrieveTxnRequest req, ChallengeResponse cRes, ChallengeAnswerRequest crReq) throws HandleException {
        if (!this.enableTxnQueue) {
            return new ErrorResponse(req, 5, MSG_NO_TXN_QUEUE);
        }
        if (req.replicationStateInfo == null && !this.isPrimary) {
            return new ErrorResponse(req, 5, MSG_NOT_A_PRIMARY);
        }
        AbstractResponse authError = this.returnErrorOrChallengeIfRequestNotAuthorized(req, cRes, crReq, this.replicationAdmins, this.serverAdmins);
        if (authError != null) {
            return authError;
        }
        long latestCommittedTxnId = this.getLatestTxnId();
        if (req.replicationStateInfo != null) {
            String ownReplicationServerName = this.thisServerNum + ":" + this.replicationSiteName;
            return new RetrieveTxnResponse(this.allOtherTransactionQueues, ownReplicationServerName, latestCommittedTxnId, this.replicationDaemon.getReplicationStateInfo(), req, this.storage, this.caseSensitive);
        }
        String start = new Date(req.lastQueryDate).toString();
        String end = new Date(System.currentTimeMillis()).toString();
        long count = latestCommittedTxnId - req.lastTxnId;
        if (count > 0L && latestCommittedTxnId > 0L) {
            String msg = "";
            msg = count == 1L ? "Replicating 1 transaction from [" + start + "] to [" + end + "]" : (count > 1L ? "Replicating " + count + " transactions from [" + start + "] to [" + end + "]" : "Replicating all transactions");
            this.logError(25, msg);
        }
        return new RetrieveTxnResponse(this.txnQueue, latestCommittedTxnId, req, this.storage, this.caseSensitive);
    }

    private final AbstractResponse doDumpHandles(DumpHandlesRequest req, ChallengeResponse cRes, ChallengeAnswerRequest crReq) throws HandleException {
        if (!this.enableTxnQueue) {
            return new ErrorResponse(req, 5, MSG_NO_TXN_QUEUE);
        }
        AbstractResponse authError = this.returnErrorOrChallengeIfRequestNotAuthorized(req, cRes, crReq, this.replicationAdmins, this.serverAdmins);
        if (authError != null) {
            return authError;
        }
        return new DumpHandlesResponse(req, this.storage, this.txnQueue, this.replicationDaemon);
    }

    private final AbstractResponse verifyChallenge(VerifyAuthRequest req, ChallengeResponse cRes, ChallengeAnswerRequest crReq) throws HandleException {
        byte[] authSignature;
        boolean oldFormat;
        int[] nArray;
        AbstractResponse res = this.errorIfNotHaveHandle(req);
        if (res != null) {
            if (this.allowRecursiveQueries && req.recursive || this.performRecursionForOldClientsRequestingReferredPrefixes && this.isOldClientRequestingReferredPrefix(req, res)) {
                AbstractRequest clonedReq = this.cloneRequestForRecursion(req);
                return this.processRecursiveRequestAndAdaptResponse(clonedReq, req);
            }
            return res;
        }
        int handleIndex = req.handleIndex;
        byte[] byArray = req.handle;
        if (handleIndex == 0) {
            nArray = null;
        } else {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = req.handleIndex;
        }
        byte[][] clumps = this.getRawHandleValuesWithTemplate(byArray, nArray, (byte[][])(handleIndex == 0 ? Common.SECRET_KEY_TYPES : null), req.recursionCount);
        if (clumps == null || clumps.length <= 0) {
            return new VerifyAuthResponse(req, false);
        }
        byte digestAlg = req.signedResponse[0];
        boolean bl = oldFormat = !req.hasEqualOrGreaterVersion(2, 1);
        if (oldFormat) {
            digestAlg = 1;
            authSignature = req.signedResponse;
        } else {
            authSignature = new byte[req.signedResponse.length - 1];
            System.arraycopy(req.signedResponse, 1, authSignature, 0, req.signedResponse.length - 1);
        }
        HandleValue secretKeyValue = new HandleValue();
        for (byte[] clump : clumps) {
            byte[] realSignature;
            Encoder.decodeHandleValue(clump, 0, secretKeyValue);
            if (handleIndex != 0 && handleIndex != secretKeyValue.getIndex() || !secretKeyValue.hasType(Common.STD_TYPE_HSSECKEY) || (realSignature = Util.doMac(digestAlg, Util.concat(req.nonce, req.origRequestDigest), secretKeyValue.getData(), authSignature)) == null || realSignature.length <= 0 || !Util.equals(realSignature, authSignature)) continue;
            return new VerifyAuthResponse(req, true);
        }
        return new VerifyAuthResponse(req, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final AbstractResponse doDeleteHandle(DeleteHandleRequest req, ChallengeResponse cRes, ChallengeAnswerRequest crReq) throws HandleException {
        if (this.thisSite.servers.length > 1 && this.thisSite.determineServerNum(req.handle) != this.thisServerNum) {
            return new ErrorResponse(req, 301, MSG_WRONG_SERVER_HASH);
        }
        AbstractResponse res = this.errorIfNotHaveHandle(req, req.handle);
        if (res != null && res.responseCode != 301) {
            return res;
        }
        if (!(cRes != null && crReq != null || this.authenticatedSession(req))) {
            return this.createChallenge(req);
        }
        Object object = this.getWriteLock(req.handle);
        synchronized (object) {
            ErrorResponse errorResponse;
            try {
                byte[][] clumps = this.storageGetRawHandleValues(this.caseSensitive ? req.handle : Util.upperCase(req.handle), null, Common.ADMIN_TYPES);
                if (clumps == null) {
                    return new ErrorResponse(req, 100, null);
                }
                AbstractResponse authResp = this.authenticateUser(req, cRes, crReq, DEL_HANDLE_PERM, clumps);
                if (authResp != null) {
                    return authResp;
                }
            }
            catch (Exception e) {
                this.logError(50, "Unable to authenticate delete handle request: " + e);
                return new ErrorResponse(req, 406, null);
            }
            try {
                ErrorResponse maybeError = this.validateAndInsertTransactionReturnResponseIfError(req, req.handle, null, (byte)2);
                if (maybeError != null) {
                    errorResponse = maybeError;
                    return errorResponse;
                }
                this.storage.deleteHandle(this.caseSensitive ? req.handle : Util.upperCase(req.handle));
            }
            catch (HandleException e) {
                this.logError(100, "Error committing transaction: " + e);
                switch (e.getCode()) {
                    case 9: {
                        errorResponse = new ErrorResponse(req, 100, null);
                        return errorResponse;
                    }
                    case 18: {
                        errorResponse = new ErrorResponse(req, 7, MSG_SERVER_BACKUP);
                        return errorResponse;
                    }
                }
                errorResponse = new ErrorResponse(req, 2, MSG_INTERNAL_ERROR);
                return errorResponse;
            }
            finally {
                this.transactionsInProgress.remove(Thread.currentThread().getId());
            }
            return new GenericResponse(req, 1);
        }
    }

    private static final int getHVByIndex(HandleValue[] values, int index) {
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null || values[i].getIndex() != index) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final AbstractResponse doRemoveValue(RemoveValueRequest req, ChallengeResponse cRes, ChallengeAnswerRequest crReq) throws HandleException {
        AbstractResponse res = this.errorIfNotHaveHandle(req);
        if (res != null) {
            return res;
        }
        if (!(cRes != null && crReq != null || this.authenticatedSession(req))) {
            return this.createChallenge(req);
        }
        byte[] handle = this.caseSensitive ? req.handle : Util.upperCase(req.handle);
        Object object = this.getWriteLock(req.handle);
        synchronized (object) {
            byte[][] rawValues = this.storageGetRawHandleValues(handle, null, null);
            if (rawValues == null) {
                return new ErrorResponse(req, 100, null);
            }
            HandleValue[] values = new HandleValue[rawValues.length];
            for (int i = 0; i < rawValues.length; ++i) {
                values[i] = new HandleValue();
                Encoder.decodeHandleValue(rawValues[i], 0, values[i]);
            }
            boolean needsRemAdminPerm = false;
            boolean needsRemValuePerm = false;
            int[] toBeRemovedIdxs = new int[req.indexes.length];
            for (int i = 0; i < toBeRemovedIdxs.length; ++i) {
                toBeRemovedIdxs[i] = HandleServer.getHVByIndex(values, req.indexes[i]);
                if (toBeRemovedIdxs[i] < 0) {
                    return new ErrorResponse(req, 200, null);
                }
                HandleValue val = values[toBeRemovedIdxs[i]];
                if (val.hasType(Common.ADMIN_TYPE)) {
                    needsRemAdminPerm = true;
                    continue;
                }
                needsRemValuePerm = true;
            }
            int[] neededPerms = needsRemValuePerm && needsRemAdminPerm ? REM_ADM_AND_VAL_PERM : (needsRemAdminPerm ? REM_ADM_PERM : REM_VAL_PERM);
            AbstractResponse authResp = this.authenticateUser(req, cRes, crReq, neededPerms, rawValues);
            if (authResp != null) {
                return authResp;
            }
            int removed = 0;
            for (int i = 0; i < toBeRemovedIdxs.length; ++i) {
                if (values[toBeRemovedIdxs[i]] != null) {
                    ++removed;
                }
                values[toBeRemovedIdxs[i]] = null;
            }
            HandleValue[] newValues = new HandleValue[values.length - removed];
            int j = 0;
            for (HandleValue value : values) {
                if (value == null) continue;
                newValues[j++] = value;
            }
            values = newValues;
            try {
                ErrorResponse maybeError = this.validateAndInsertTransactionReturnResponseIfError(req, handle, values, (byte)3);
                if (maybeError != null) {
                    ErrorResponse errorResponse = maybeError;
                    return errorResponse;
                }
                this.storage.updateValue(handle, values);
            }
            catch (HandleException e) {
                this.logError(100, "Error committing transaction: " + e);
                switch (e.getCode()) {
                    case 9: {
                        ErrorResponse errorResponse = new ErrorResponse(req, 100, null);
                        return errorResponse;
                    }
                    case 18: {
                        ErrorResponse errorResponse = new ErrorResponse(req, 7, MSG_SERVER_BACKUP);
                        return errorResponse;
                    }
                }
                ErrorResponse errorResponse = new ErrorResponse(req, 2, MSG_INTERNAL_ERROR);
                return errorResponse;
            }
            finally {
                this.transactionsInProgress.remove(Thread.currentThread().getId());
            }
            return new GenericResponse(req, 1);
        }
    }

    private static final int[] combinePerms(int[] current, int[] toAppend) {
        if (current == null) {
            return toAppend;
        }
        if (toAppend == null) {
            return current;
        }
        int[] newPerms = new int[current.length + toAppend.length];
        System.arraycopy(current, 0, newPerms, 0, current.length);
        System.arraycopy(toAppend, 0, newPerms, current.length, toAppend.length);
        return newPerms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final AbstractResponse doModifyValue(ModifyValueRequest req, ChallengeResponse cRes, ChallengeAnswerRequest crReq) throws HandleException {
        AbstractResponse res = this.errorIfNotHaveHandle(req);
        if (res != null) {
            return res;
        }
        boolean isAnonymous = (cRes == null || crReq == null) && !this.authenticatedSession(req);
        byte[] handle = this.caseSensitive ? req.handle : Util.upperCase(req.handle);
        Object object = this.getWriteLock(req.handle);
        synchronized (object) {
            int i;
            AbstractResponse authResp;
            byte[][] rawValues = this.storageGetRawHandleValues(handle, null, null);
            if (rawValues == null) {
                return new ErrorResponse(req, 100, null);
            }
            HandleValue[] values = new HandleValue[rawValues.length];
            for (int i2 = 0; i2 < rawValues.length; ++i2) {
                values[i2] = new HandleValue();
                Encoder.decodeHandleValue(rawValues[i2], 0, values[i2]);
            }
            boolean needsModAdminPerm = false;
            boolean needsModValuePerm = false;
            boolean needsAdmToValPerm = false;
            boolean needsValToAdmPerm = false;
            int[] toBeModifiedIdxs = new int[req.values.length];
            for (int i3 = 0; i3 < toBeModifiedIdxs.length; ++i3) {
                toBeModifiedIdxs[i3] = HandleServer.getHVByIndex(values, req.values[i3].getIndex());
                if (toBeModifiedIdxs[i3] < 0) {
                    return new ErrorResponse(req, 200, null);
                }
                HandleValue val = values[toBeModifiedIdxs[i3]];
                if (!val.getAdminCanWrite()) {
                    return new ErrorResponse(req, 401, MSG_READ_ONLY_VALUE);
                }
                boolean oldValIsAdmin = val.hasType(Common.ADMIN_TYPE);
                boolean newValIsAdmin = req.values[i3].hasType(Common.ADMIN_TYPE);
                if (isAnonymous) {
                    if (!val.getAnyoneCanWrite()) {
                        return this.createChallenge(req);
                    }
                    if (oldValIsAdmin || newValIsAdmin) {
                        return this.createChallenge(req);
                    }
                }
                if (oldValIsAdmin && newValIsAdmin) {
                    needsModAdminPerm = true;
                    continue;
                }
                if (oldValIsAdmin && !newValIsAdmin) {
                    needsAdmToValPerm = true;
                    continue;
                }
                if (!oldValIsAdmin && newValIsAdmin) {
                    needsValToAdmPerm = true;
                    continue;
                }
                if (oldValIsAdmin || newValIsAdmin || val.getAnyoneCanWrite()) continue;
                needsModValuePerm = true;
            }
            int[] perms = null;
            if (needsModAdminPerm) {
                perms = HandleServer.combinePerms(perms, MOD_ADM_PERM);
            }
            if (needsModValuePerm) {
                perms = HandleServer.combinePerms(perms, MOD_VAL_PERM);
            }
            if (needsAdmToValPerm) {
                perms = HandleServer.combinePerms(perms, ADM_TO_VAL_PERM);
            }
            if (needsValToAdmPerm) {
                perms = HandleServer.combinePerms(perms, VAL_TO_ADM_PERM);
            }
            if (perms != null && (authResp = this.authenticateUser(req, cRes, crReq, perms, rawValues)) != null) {
                return authResp;
            }
            int now = (int)(System.currentTimeMillis() / 1000L);
            for (i = 0; i < toBeModifiedIdxs.length; ++i) {
                values[toBeModifiedIdxs[i]] = req.values[i];
                values[toBeModifiedIdxs[i]].setTimestamp(now);
            }
            i = 0;
            while (true) {
                if (i < values.length) {
                } else {
                    try {
                        ErrorResponse maybeError = this.validateAndInsertTransactionReturnResponseIfError(req, handle, values, (byte)3);
                        if (maybeError != null) {
                            ErrorResponse errorResponse = maybeError;
                            return errorResponse;
                        }
                        this.storage.updateValue(handle, values);
                    }
                    catch (HandleException e) {
                        this.logError(100, "Error committing transaction: " + e);
                        switch (e.getCode()) {
                            case 9: {
                                ErrorResponse errorResponse = new ErrorResponse(req, 100, null);
                                return errorResponse;
                            }
                            case 18: {
                                ErrorResponse errorResponse = new ErrorResponse(req, 7, MSG_SERVER_BACKUP);
                                return errorResponse;
                            }
                        }
                        ErrorResponse errorResponse = new ErrorResponse(req, 2, MSG_INTERNAL_ERROR);
                        return errorResponse;
                    }
                    finally {
                        this.transactionsInProgress.remove(Thread.currentThread().getId());
                    }
                    return new GenericResponse(req, 1);
                }
                for (int j = i + 1; j < values.length; ++j) {
                    if (values[i].getIndex() != values[j].getIndex()) continue;
                    return new ErrorResponse(req, 202, Util.encodeString("Index conflict for " + values[j].getIndex()));
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final AbstractResponse doAddValue(AddValueRequest req, ChallengeResponse cRes, ChallengeAnswerRequest crReq) throws HandleException {
        boolean didOverwriteExisting;
        AbstractResponse res = this.errorIfNotHaveHandle(req);
        if (res != null) {
            return res;
        }
        if (req.values == null || req.values.length <= 0) {
            return new ErrorResponse(req, 202, MSG_EMPTY_VALUE_LIST);
        }
        Arrays.sort(req.values, HandleValue.INDEX_COMPARATOR);
        for (int i = 0; i < req.values.length; ++i) {
            if (req.values[i].getIndex() <= 0) {
                return new ErrorResponse(req, 202, MSG_INDEXES_MUST_BE_POSITIVE);
            }
            if (i <= 0 || req.values[i].getIndex() != req.values[i - 1].getIndex()) continue;
            return new ErrorResponse(req, 201, Util.encodeString("Index conflict for " + req.values[i].getIndex()));
        }
        if (!(cRes != null && crReq != null || this.authenticatedSession(req))) {
            return this.createChallenge(req);
        }
        byte[] handle = this.caseSensitive ? req.handle : Util.upperCase(req.handle);
        Object object = this.getWriteLock(req.handle);
        synchronized (object) {
            AbstractResponse authResp;
            ArrayList<HandleValue> result;
            HandleValue[] newValues;
            byte[][] rawValues = this.storageGetRawHandleValues(handle, null, null);
            if (rawValues == null) {
                return new ErrorResponse(req, 100, null);
            }
            HandleValue[] existingValues = Encoder.decodeHandleValues(rawValues);
            Arrays.sort(existingValues, HandleValue.INDEX_COMPARATOR);
            int sharedIndex = HandleServer.findSharedIndex(existingValues, req.values);
            boolean bl = didOverwriteExisting = sharedIndex > 0;
            if (didOverwriteExisting && !req.overwriteWhenExists) {
                return new ErrorResponse(req, 201, Util.encodeString("Index conflict for " + sharedIndex));
            }
            int now = (int)(System.currentTimeMillis() / 1000L);
            int[] neededPerms = this.getPermsAndSetTimestampsAndAccumulateResultValuesForAddValuesOperation(now, existingValues, newValues = req.values, result = new ArrayList<HandleValue>(req.values.length + existingValues.length));
            if (neededPerms != null && (authResp = this.authenticateUser(req, cRes, crReq, neededPerms, rawValues)) != null) {
                return authResp;
            }
            HandleValue[] values = result.toArray(new HandleValue[result.size()]);
            try {
                ErrorResponse maybeError = this.validateAndInsertTransactionReturnResponseIfError(req, handle, values, (byte)3);
                if (maybeError != null) {
                    ErrorResponse errorResponse = maybeError;
                    return errorResponse;
                }
                this.storage.updateValue(handle, values);
            }
            catch (HandleException e) {
                this.logError(100, "Error committing transaction: " + e);
                switch (e.getCode()) {
                    case 9: {
                        ErrorResponse errorResponse = new ErrorResponse(req, 100, null);
                        return errorResponse;
                    }
                    case 18: {
                        ErrorResponse errorResponse = new ErrorResponse(req, 7, MSG_SERVER_BACKUP);
                        return errorResponse;
                    }
                }
                ErrorResponse errorResponse = new ErrorResponse(req, 2, MSG_INTERNAL_ERROR);
                return errorResponse;
            }
            finally {
                this.transactionsInProgress.remove(Thread.currentThread().getId());
            }
        }
        GenericResponse resp = new GenericResponse(req, 1);
        resp.overwriteWhenExists = didOverwriteExisting;
        return resp;
    }

    private int[] getPermsAndSetTimestampsAndAccumulateResultValuesForAddValuesOperation(int now, HandleValue[] existingValues, HandleValue[] newValues, List<HandleValue> result) {
        HandleValue newValue;
        boolean needsAddAdminPerm = false;
        boolean needsAddValuePerm = false;
        boolean needsModAdminPerm = false;
        boolean needsModValuePerm = false;
        boolean needsAdmToValPerm = false;
        boolean needsValToAdmPerm = false;
        int i = 0;
        int j = 0;
        while (i < existingValues.length && j < newValues.length) {
            if (existingValues[i].getIndex() < newValues[j].getIndex()) {
                result.add(existingValues[i]);
                ++i;
                continue;
            }
            if (existingValues[i].getIndex() > newValues[j].getIndex()) {
                newValue = newValues[j];
                newValue.setTimestamp(now);
                result.add(newValue);
                if (newValue.hasType(Common.ADMIN_TYPE)) {
                    needsAddAdminPerm = true;
                } else {
                    needsAddValuePerm = true;
                }
                ++j;
                continue;
            }
            HandleValue existingValue = existingValues[i];
            HandleValue newValue2 = newValues[j];
            newValue2.setTimestamp(now);
            if (existingValue.equalsIgnoreTimestamp(newValue2)) {
                result.add(existingValue);
            } else {
                boolean oldValIsAdmin = existingValue.hasType(Common.ADMIN_TYPE);
                boolean newValIsAdmin = newValue2.hasType(Common.ADMIN_TYPE);
                if (oldValIsAdmin && newValIsAdmin) {
                    needsModAdminPerm = true;
                } else if (oldValIsAdmin && !newValIsAdmin) {
                    needsAdmToValPerm = true;
                } else if (!oldValIsAdmin && newValIsAdmin) {
                    needsValToAdmPerm = true;
                } else if (!(oldValIsAdmin || newValIsAdmin || existingValue.getAnyoneCanWrite())) {
                    needsModValuePerm = true;
                }
                result.add(newValue2);
            }
            ++i;
            ++j;
        }
        while (i < existingValues.length) {
            result.add(existingValues[i]);
            ++i;
        }
        while (j < newValues.length) {
            newValue = newValues[j];
            newValue.setTimestamp(now);
            result.add(newValue);
            if (newValue.hasType(Common.ADMIN_TYPE)) {
                needsAddAdminPerm = true;
            } else {
                needsAddValuePerm = true;
            }
            ++j;
        }
        int[] neededPerms = null;
        if (needsModAdminPerm) {
            neededPerms = HandleServer.combinePerms(neededPerms, MOD_ADM_PERM);
        }
        if (needsModValuePerm) {
            neededPerms = HandleServer.combinePerms(neededPerms, MOD_VAL_PERM);
        }
        if (needsAdmToValPerm) {
            neededPerms = HandleServer.combinePerms(neededPerms, ADM_TO_VAL_PERM);
        }
        if (needsValToAdmPerm) {
            neededPerms = HandleServer.combinePerms(neededPerms, VAL_TO_ADM_PERM);
        }
        if (needsAddAdminPerm) {
            neededPerms = HandleServer.combinePerms(neededPerms, ADD_ADM_PERM);
        }
        if (needsAddValuePerm) {
            neededPerms = HandleServer.combinePerms(neededPerms, ADD_VAL_PERM);
        }
        return neededPerms;
    }

    private static int findSharedIndex(HandleValue[] existingValues, HandleValue[] newValues) {
        int i = 0;
        int j = 0;
        while (i < existingValues.length && j < newValues.length) {
            if (existingValues[i].getIndex() < newValues[j].getIndex()) {
                ++i;
                continue;
            }
            if (existingValues[i].getIndex() > newValues[j].getIndex()) {
                ++j;
                continue;
            }
            return existingValues[i].getIndex();
        }
        return -1;
    }

    private final byte[][] getNAAdminValues(byte[] na) throws HandleException {
        if (!this.allowNAAdmins) {
            return new byte[0][];
        }
        ResolutionRequest authRequest = new ResolutionRequest(na, Common.ADMIN_TYPES, null, null);
        authRequest.certify = true;
        AbstractResponse response = this.resolver.processRequest(authRequest);
        if (response.responseCode == 100) {
            authRequest.authoritative = true;
            authRequest.clearBuffers();
            response = this.resolver.processRequest(authRequest);
        }
        if (response.getClass() != ResolutionResponse.class) {
            return null;
        }
        return ((ResolutionResponse)response).values;
    }

    private final AbstractResponse authenticateUser(AbstractRequest req, ChallengeResponse challenge, ChallengeAnswerRequest response, int[] operationIDs, byte[][] values) throws HandleException {
        if (this.wideOpenAccessAllowed) {
            return null;
        }
        byte[] identityHandle = null;
        int identityIndex = -1;
        ServerSideSessionInfo sessionInfo = this.getSession(req.sessionId);
        if (challenge != null && response != null) {
            identityHandle = response.userIdHandle;
            identityIndex = response.userIdIndex;
        } else {
            if (sessionInfo == null) {
                return new ErrorResponse(req, 500, MSG_INVALID_SESSION_OR_TIMEOUT);
            }
            identityHandle = sessionInfo.identityKeyHandle;
            identityIndex = sessionInfo.identityKeyIndex;
        }
        ValueReference thisAdmin = new ValueReference(identityHandle, identityIndex);
        if (this.requireSessions && sessionInfo == null && req.opCode != 400) {
            System.err.println("rejecting non-session request: " + req + "; session: " + this.getSession(req.sessionId));
            return new ErrorResponse(req, 404, MSG_SESSION_REQUIRED);
        }
        try {
            Vector<ValueReference> valuesTraversed = new Vector<ValueReference>();
            boolean hasAdminAccess = this.adminHasPermission(thisAdmin, operationIDs, values, valuesTraversed);
            if (!hasAdminAccess && HandleServer.mightGetNewIndexForAuthentication(response, sessionInfo)) {
                AbstractResponseAndIndex verifyResp = this.verifyIdentityAndGetIndex(challenge, response, req);
                if (verifyResp.getResponse() != null) {
                    return verifyResp.getResponse();
                }
                if (verifyResp.getIndex() != 0 && (hasAdminAccess = valuesTraversed.contains(thisAdmin = new ValueReference(thisAdmin.handle, verifyResp.getIndex())))) {
                    return null;
                }
            }
            if (hasAdminAccess) {
                return this.verifyIdentity(challenge, response, req);
            }
            return new ErrorResponse(req, 400, null);
        }
        catch (Exception e) {
            this.logError(50, "Error authenticating: " + e);
            return new ErrorResponse(req, 406, null);
        }
    }

    private boolean adminHasPermission(ValueReference thisAdmin, int[] operationIDs, byte[][] values, Vector<ValueReference> valuesTraversed) {
        boolean hasAdminAccess = false;
        Vector<ValueReference> valuesToTraverse = new Vector<ValueReference>();
        if (this.serverAdminFullAccess) {
            for (int i = 0; this.serverAdmins != null && i < this.serverAdmins.length; ++i) {
                try {
                    if (this.serverAdmins[i].isMatchedBy(thisAdmin)) {
                        hasAdminAccess = true;
                        break;
                    }
                    valuesToTraverse.addElement(this.serverAdmins[i]);
                    continue;
                }
                catch (Exception e) {
                    this.logError(50, "Error checking for server admin: " + e);
                }
            }
            if (!hasAdminAccess) {
                hasAdminAccess = this.isAdminInGroup(thisAdmin, valuesToTraverse, valuesTraversed);
            }
        }
        if (!hasAdminAccess) {
            block15: {
                try {
                    HandleValue tmpValue = new HandleValue();
                    AdminRecord admin = new AdminRecord();
                    if (values == null) break block15;
                    for (byte[] value : values) {
                        try {
                            Encoder.decodeHandleValue(value, 0, tmpValue);
                            if (!tmpValue.hasType(Common.ADMIN_TYPE)) continue;
                            Encoder.decodeAdminRecord(tmpValue.getData(), 0, admin);
                        }
                        catch (Exception e) {
                            this.logError(50, "Error decoding possible admin value: " + e);
                            continue;
                        }
                        boolean adminRecordIsRelevant = true;
                        for (int p = 0; p < operationIDs.length; ++p) {
                            if (admin.perms[operationIDs[p]]) continue;
                            adminRecordIsRelevant = false;
                            break;
                        }
                        if (!adminRecordIsRelevant) continue;
                        ValueReference adminValRef = new ValueReference(admin.adminId, admin.adminIdIndex);
                        if (adminValRef.isMatchedBy(thisAdmin)) {
                            hasAdminAccess = true;
                            break;
                        }
                        valuesToTraverse.addElement(adminValRef);
                    }
                }
                catch (Throwable e) {
                    this.logError(50, "Error authenticating: " + e);
                }
            }
            if (!hasAdminAccess) {
                hasAdminAccess = this.isAdminInGroup(thisAdmin, valuesToTraverse, valuesTraversed);
            }
        }
        return hasAdminAccess;
    }

    private static boolean permsContains(int[] perms, int perm) {
        if (perms == null) {
            return false;
        }
        for (int foundPerm : perms) {
            if (foundPerm != perm) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final AbstractResponse doCreateHandle(CreateHandleRequest req, ChallengeResponse cRes, ChallengeAnswerRequest crReq) throws HandleException {
        AbstractResponse res;
        byte[] handle = req.handle;
        if (req.mintNewSuffix) {
            HandleSuffixMinter minter = new HandleSuffixMinter(this.storage, this.caseSensitive);
            String handleInitialPortion = Util.decodeString(handle);
            String mintedHandle = minter.mintNextSuffix(handleInitialPortion);
            byte[] mintedHandleBytes = Util.encodeString(mintedHandle);
            handle = mintedHandleBytes;
        }
        if ((res = this.errorIfNotHaveHandle(req, handle)) != null) {
            return res;
        }
        if (!Util.isValidString(handle, 0, handle.length)) {
            return new ErrorResponse(req, 102, MSG_INVALID_ENCODING);
        }
        int i = 0;
        while (true) {
            if (i < req.values.length) {
                if (req.values[i].getIndex() <= 0) {
                    return new ErrorResponse(req, 202, MSG_INDEXES_MUST_BE_POSITIVE);
                }
            } else {
                byte[][] naVals;
                int now = (int)(System.currentTimeMillis() / 1000L);
                for (int i2 = 0; req.values != null && i2 < req.values.length; ++i2) {
                    req.values[i2].setTimestamp(now);
                }
                boolean isSubNAHandle = Util.isSubNAHandle(handle);
                Exception adminGroupException = null;
                try {
                    byte[] na = isSubNAHandle ? Util.getParentNAOfNAHandle(handle) : Util.getZeroNAHandle(handle);
                    naVals = this.getNAAdminValues(na);
                    if (naVals != null) {
                        // empty if block
                    }
                }
                catch (Exception e) {
                    adminGroupException = e;
                    naVals = null;
                }
                boolean didOverwriteExisting = false;
                Object object = this.getWriteLock(handle);
                synchronized (object) {
                    AbstractResponse authResp;
                    byte[][] rawValues = this.storageGetRawHandleValues(this.caseSensitive ? handle : Util.upperCase(handle), null, req.overwriteWhenExists ? null : Common.ADMIN_TYPES);
                    if (!req.overwriteWhenExists && rawValues != null) {
                        return new ErrorResponse(req, 101, null);
                    }
                    if (!(cRes != null && crReq != null || this.authenticatedSession(req))) {
                        return this.createChallenge(req);
                    }
                    int[] neededPerms = null;
                    if (rawValues != null) {
                        didOverwriteExisting = true;
                        HandleValue[] existingValues = Encoder.decodeHandleValues(rawValues);
                        HandleValue[] newValues = (HandleValue[])req.values.clone();
                        neededPerms = this.getPermsAndSetTimestampsForCreationWithOverwrite(existingValues, newValues);
                    }
                    boolean authorized = false;
                    if (rawValues != null) {
                        if (neededPerms == null) {
                            authorized = true;
                        } else if (!HandleServer.permsContains(neededPerms, 9)) {
                            authResp = this.authenticateUser(req, cRes, crReq, neededPerms, rawValues);
                            boolean bl = authorized = authResp == null;
                        }
                        if (!authorized) {
                            authResp = this.authenticateUser(req, cRes, crReq, ADD_ADM_PERM, rawValues);
                            boolean bl = authorized = authResp == null;
                        }
                        if (!authorized && (authResp = this.authenticateUser(req, cRes, crReq, DEL_HANDLE_PERM, rawValues)) != null) {
                            if (naVals == null) {
                                this.logError(50, "Unable to find admin group while creating handle");
                                if (adminGroupException != null) {
                                    adminGroupException.printStackTrace();
                                }
                            }
                            return authResp;
                        }
                    }
                    if (!authorized && (authResp = this.authenticateUser(req, cRes, crReq, isSubNAHandle ? ADD_SUB_NA_PERM : ADD_HANDLE_PERM, naVals)) != null) {
                        if (naVals == null) {
                            this.logError(50, "Unable to find admin group while creating handle");
                            if (adminGroupException != null) {
                                adminGroupException.printStackTrace();
                            }
                        }
                        return authResp;
                    }
                    try {
                        byte action = rawValues == null ? (byte)1 : 3;
                        ErrorResponse maybeError = this.validateAndInsertTransactionReturnResponseIfError(req, handle, req.values, action);
                        if (maybeError != null) {
                            ErrorResponse errorResponse = maybeError;
                            return errorResponse;
                        }
                        if (rawValues == null) {
                            this.storage.createHandle(this.caseSensitive ? handle : Util.upperCase(handle), req.values);
                        } else {
                            this.storage.updateValue(this.caseSensitive ? handle : Util.upperCase(handle), req.values);
                        }
                    }
                    catch (HandleException e) {
                        ErrorResponse errorResponse;
                        this.logError(100, "Error committing transaction: " + e);
                        switch (e.getCode()) {
                            case 5: {
                                errorResponse = new ErrorResponse(req, 101, null);
                                return errorResponse;
                            }
                            case 18: {
                                errorResponse = new ErrorResponse(req, 7, MSG_SERVER_BACKUP);
                                return errorResponse;
                            }
                        }
                        errorResponse = new ErrorResponse(req, 2, MSG_INTERNAL_ERROR);
                        return errorResponse;
                    }
                    finally {
                        this.transactionsInProgress.remove(Thread.currentThread().getId());
                    }
                }
                CreateHandleResponse resp = new CreateHandleResponse((AbstractRequest)req, handle);
                resp.overwriteWhenExists = didOverwriteExisting;
                resp.mintNewSuffix = req.mintNewSuffix;
                return resp;
            }
            for (int j = i + 1; j < req.values.length; ++j) {
                if (req.values[i].getIndex() != req.values[j].getIndex()) continue;
                return new ErrorResponse(req, 201, Util.encodeString("Index conflict for " + req.values[j].getIndex()));
            }
            ++i;
        }
    }

    private int[] getPermsAndSetTimestampsForCreationWithOverwrite(HandleValue[] existingValues, HandleValue[] newValues) {
        boolean newValIsAdmin;
        boolean oldValIsAdmin;
        boolean needsAddAdminPerm = false;
        boolean needsAddValuePerm = false;
        boolean needsRemAdminPerm = false;
        boolean needsRemValuePerm = false;
        boolean needsModAdminPerm = false;
        boolean needsModValuePerm = false;
        boolean needsAdmToValPerm = false;
        boolean needsValToAdmPerm = false;
        Arrays.sort(existingValues, HandleValue.INDEX_COMPARATOR);
        Arrays.sort(newValues, HandleValue.INDEX_COMPARATOR);
        int i = 0;
        int j = 0;
        while (i < existingValues.length && j < newValues.length) {
            if (existingValues[i].getIndex() < newValues[j].getIndex()) {
                oldValIsAdmin = existingValues[i].hasType(Common.ADMIN_TYPE);
                if (oldValIsAdmin) {
                    needsRemAdminPerm = true;
                } else {
                    needsRemValuePerm = true;
                }
                ++i;
                continue;
            }
            if (existingValues[i].getIndex() > newValues[j].getIndex()) {
                newValIsAdmin = newValues[j].hasType(Common.ADMIN_TYPE);
                if (newValIsAdmin) {
                    needsAddAdminPerm = true;
                } else {
                    needsAddValuePerm = true;
                }
                ++j;
                continue;
            }
            if (existingValues[i].equalsIgnoreTimestamp(newValues[j])) {
                newValues[j].setTimestamp(existingValues[i].getTimestamp());
            } else {
                oldValIsAdmin = existingValues[i].hasType(Common.ADMIN_TYPE);
                boolean newValIsAdmin2 = newValues[j].hasType(Common.ADMIN_TYPE);
                if (oldValIsAdmin && newValIsAdmin2) {
                    needsModAdminPerm = true;
                } else if (oldValIsAdmin && !newValIsAdmin2) {
                    needsAdmToValPerm = true;
                } else if (!oldValIsAdmin && newValIsAdmin2) {
                    needsValToAdmPerm = true;
                } else if (!(oldValIsAdmin || newValIsAdmin2 || existingValues[i].getAnyoneCanWrite())) {
                    needsModValuePerm = true;
                }
            }
            ++i;
            ++j;
        }
        while (i < existingValues.length) {
            oldValIsAdmin = existingValues[i].hasType(Common.ADMIN_TYPE);
            if (oldValIsAdmin) {
                needsRemAdminPerm = true;
            } else {
                needsRemValuePerm = true;
            }
            ++i;
        }
        while (j < newValues.length) {
            newValIsAdmin = newValues[j].hasType(Common.ADMIN_TYPE);
            if (newValIsAdmin) {
                needsAddAdminPerm = true;
            } else {
                needsAddValuePerm = true;
            }
            ++j;
        }
        int[] neededPerms = null;
        if (needsModAdminPerm) {
            neededPerms = HandleServer.combinePerms(neededPerms, MOD_ADM_PERM);
        }
        if (needsModValuePerm) {
            neededPerms = HandleServer.combinePerms(neededPerms, MOD_VAL_PERM);
        }
        if (needsAdmToValPerm) {
            neededPerms = HandleServer.combinePerms(neededPerms, ADM_TO_VAL_PERM);
        }
        if (needsValToAdmPerm) {
            neededPerms = HandleServer.combinePerms(neededPerms, VAL_TO_ADM_PERM);
        }
        if (needsAddAdminPerm) {
            neededPerms = HandleServer.combinePerms(neededPerms, ADD_ADM_PERM);
        }
        if (needsAddValuePerm) {
            neededPerms = HandleServer.combinePerms(neededPerms, ADD_VAL_PERM);
        }
        if (needsRemAdminPerm) {
            neededPerms = HandleServer.combinePerms(neededPerms, REM_ADM_PERM);
        }
        if (needsRemValuePerm) {
            neededPerms = HandleServer.combinePerms(neededPerms, REM_VAL_PERM);
        }
        return neededPerms;
    }

    @Override
    public AbstractResponse errorIfNotHaveHandle(AbstractRequest req) throws HandleException {
        return this.errorIfNotHaveHandle(req, req.handle);
    }

    public AbstractResponse errorIfNotHaveHandle(AbstractRequest req, byte[] handle) throws HandleException {
        if (this.thisSite != null && this.thisSite.servers.length > 1 && this.thisSite.determineServerNum(handle) != this.thisServerNum) {
            return new ErrorResponse(req, 301, MSG_WRONG_SERVER_HASH);
        }
        boolean haveHandle = false;
        try {
            haveHandle = this.storageHaveNA(Util.getZeroNAHandle(handle));
            if (!haveHandle && Util.isSubNAHandle(handle)) {
                haveHandle = this.storageHaveDerivedPrefixesOnly(handle);
            }
        }
        catch (HandleException e) {
            return new ErrorResponse(req, 2, MSG_INTERNAL_ERROR);
        }
        if (!haveHandle) {
            return new ErrorResponse(req, 301, MSG_NA_NOT_HOMED_HERE);
        }
        if (Util.isSubNAHandle(handle)) {
            boolean oldClient;
            AbstractResponse prefixReferralResponse = this.getPrefixReferralResponseIfAppropriate(req, handle);
            if (prefixReferralResponse == null) {
                return null;
            }
            if (req.opCode == 1 || req.opCode == 201) {
                return prefixReferralResponse;
            }
            boolean bl = oldClient = !AbstractMessage.hasEqualOrGreaterVersion(req.suggestMajorProtocolVersion, req.suggestMinorProtocolVersion, 2, 10);
            if (!oldClient) {
                return prefixReferralResponse;
            }
        }
        return null;
    }

    private final AbstractResponse getPrefixReferralResponseIfAppropriate(AbstractRequest req, byte[] handle) throws HandleException {
        if (req.doNotRefer) {
            return null;
        }
        byte[][] clumps = this.getRawHandleValuesWithTemplate(handle, null, null, req.recursionCount);
        if (clumps != null) {
            return null;
        }
        byte[] ancestorHandle = Util.getParentNAOfNAHandle(handle);
        while ((clumps = this.getRawHandleValuesWithTemplate(ancestorHandle, null, Common.DERIVED_PREFIX_SITE_AND_SERVICE_HANDLE_TYPES, req.recursionCount)) == null || clumps.length <= 0 || (clumps = HandleServer.publicValuesOnly(clumps)).length <= 0) {
            if (!Util.isSubNAHandle(ancestorHandle)) {
                return null;
            }
            ancestorHandle = Util.getParentNAOfNAHandle(ancestorHandle);
        }
        return new ServiceReferralResponse(req, 303, new byte[0], clumps);
    }

    private final AbstractResponse doResolution(ResolutionRequest req, ChallengeResponse cRes, ChallengeAnswerRequest crReq, boolean isInternal) throws HandleException {
        byte[] handle = req.handle;
        if (Util.equalsCI(handle, SERVER_STATUS_HANDLE)) {
            if (this.enableStatusHandle) {
                return this.doSiteStatusResolutionRequest(req, cRes, crReq);
            }
            return new ErrorResponse(req, 100, null);
        }
        if (!Util.hasSlash(handle)) {
            handle = Util.convertSlashlessHandleToZeroNaHandle(handle);
        }
        byte[][] clumps = null;
        AbstractResponse res = this.errorIfNotHaveHandle(req, handle);
        if (res == null) {
            try {
                clumps = this.getRawHandleValuesWithTemplate(handle, req.requestedIndexes, req.requestedTypes, req.recursionCount);
            }
            catch (Exception e) {
                this.logError(75, String.valueOf(this.getClass()) + ": error getting values: " + e);
                e.printStackTrace(System.err);
                return new ErrorResponse(req, 2, MSG_INTERNAL_ERROR);
            }
            if (clumps == null) {
                return new ErrorResponse(req, 100, null);
            }
            if (clumps.length == 0) {
                return new ErrorResponse(req, 200, null);
            }
            if (isInternal) {
                return new ResolutionResponse((AbstractRequest)req, req.handle, clumps);
            }
            return this.checkReadAccess(req, clumps, cRes, crReq);
        }
        if (this.allowRecursiveQueries && req.recursive || this.performRecursionForOldClientsRequestingReferredPrefixes && this.isOldClientRequestingReferredPrefix(req, res)) {
            AbstractRequest clonedReq = this.cloneRequestForRecursion(req);
            return this.processRecursiveRequestAndAdaptResponse(clonedReq, req);
        }
        return res;
    }

    private AbstractRequest cloneRequestForRecursion(AbstractRequest req) {
        AbstractRequest clonedReq = req.clone();
        clonedReq.recursionCount = (short)(clonedReq.recursionCount + 1);
        clonedReq.recursive = false;
        clonedReq.clearBuffers();
        clonedReq.suggestMajorProtocolVersion = (byte)2;
        clonedReq.suggestMinorProtocolVersion = (byte)11;
        return clonedReq;
    }

    private AbstractResponse processRecursiveRequestAndAdaptResponse(AbstractRequest clonedReq, AbstractRequest origReq) throws HandleException {
        if (clonedReq.recursionCount > 10) {
            return new ErrorResponse(origReq, 6, null);
        }
        try {
            AbstractResponse resp = this.resolver.processRequest(clonedReq);
            resp.setSupportedProtocolVersion(origReq);
            resp.suggestMajorProtocolVersion = (byte)2;
            resp.suggestMinorProtocolVersion = (byte)11;
            resp.clearBuffers();
            if (resp.returnRequestDigest) {
                resp.takeDigestOfRequest(origReq);
            }
            return resp;
        }
        catch (Exception e) {
            return HandleException.toErrorResponse(origReq, e);
        }
    }

    private boolean isOldClientRequestingReferredPrefix(AbstractRequest req, AbstractResponse maybePrefixReferralResponse) {
        if (maybePrefixReferralResponse.responseCode != 303) {
            return false;
        }
        boolean oldClient = !AbstractMessage.hasEqualOrGreaterVersion(req.suggestMajorProtocolVersion, req.suggestMinorProtocolVersion, 2, 10);
        return oldClient;
    }

    private static byte[][] publicValuesOnly(byte[][] clumps) throws HandleException {
        HandleValue[] values = Encoder.decodeHandleValues(clumps);
        int numSecret = 0;
        for (int i = 0; i < values.length; ++i) {
            if (values[i].getAnyoneCanRead()) continue;
            clumps[i] = null;
            ++numSecret;
        }
        if (numSecret == 0) {
            return clumps;
        }
        byte[][] res = new byte[clumps.length - numSecret][];
        int index = 0;
        for (byte[] clump : clumps) {
            if (clump == null) continue;
            res[index++] = clump;
        }
        return res;
    }

    private AbstractResponse doSiteStatusResolutionRequest(ResolutionRequest req, ChallengeResponse cRes, ChallengeAnswerRequest crReq) throws HandleException {
        StreamTable replicationStatus;
        String monitorDaemonStatus;
        if (req.ignoreRestrictedValues) {
            return new ErrorResponse(req, 200, null);
        }
        AbstractResponse authError = this.returnErrorOrChallengeIfRequestNotAuthorized(req, cRes, crReq, this.serverAdmins, this.statusHandleAdmins);
        if (authError != null) {
            return authError;
        }
        ArrayList<HandleValue> vals = new ArrayList<HandleValue>();
        StringBuffer status = new StringBuffer();
        Runtime jr = Runtime.getRuntime();
        status.append("freemem=").append(jr.freeMemory());
        status.append("; totalmem=").append(jr.totalMemory());
        status.append("; maxmem=").append(jr.maxMemory());
        status.append("; runtime=").append(System.currentTimeMillis() - this.startTime);
        status.append("; numreqs=").append(this.numRequests);
        vals.add(new HandleValue(1, SERVER_STATUS_HDL_TYPE, Util.encodeString(status.toString())));
        if (this.monitorDaemon != null && (monitorDaemonStatus = this.monitorDaemon.getStatusString()) != null) {
            vals.add(new HandleValue(2, SERVER_STATUS_HDL_TYPE, Util.encodeString(monitorDaemonStatus)));
        }
        JsonObject replicationInfo = new JsonObject();
        if (this.enableTxnQueue && this.isPrimary) {
            long latestTxnId = this.getLatestTxnId();
            replicationInfo.addProperty("latestTxnId", (Number)latestTxnId);
        }
        if (this.replicationDaemon != null && (replicationStatus = this.replicationDaemon.replicationStatus()) != null) {
            JsonElement replicationStatusAsJsonElement = StreamObjectToJsonConverter.toJson((StreamObject)replicationStatus);
            replicationInfo.add("replicationStatus", replicationStatusAsJsonElement);
        }
        Gson gson = GsonUtility.getGson();
        String replicationInfoAsJsonString = gson.toJson((JsonElement)replicationInfo);
        vals.add(new HandleValue(3, REPLICATION_STATUS_HDL_TYPE, Util.encodeString(replicationInfoAsJsonString)));
        byte[][] valBytes = new byte[vals.size()][];
        for (int i = 0; i < valBytes.length; ++i) {
            HandleValue val = (HandleValue)vals.get(i);
            val.setAnyoneCanRead(false);
            valBytes[i] = new byte[Encoder.calcStorageSize(val)];
            Encoder.encodeHandleValue(valBytes[i], 0, val);
        }
        return new ResolutionResponse((AbstractRequest)req, req.handle, valBytes);
    }

    private AbstractResponse returnErrorOrChallengeIfRequestNotAuthorized(AbstractRequest req, ChallengeResponse cRes, ChallengeAnswerRequest crReq, ValueReference[] ... adminLists) throws HandleException {
        try {
            Object verifyResp;
            if (this.wideOpenAccessAllowed) {
                return null;
            }
            if (!(cRes != null && crReq != null || this.authenticatedSession(req))) {
                return this.createChallenge(req);
            }
            ValueReference thisAdmin = null;
            ServerSideSessionInfo sessionInfo = this.getSession(req.sessionId);
            if (crReq != null) {
                thisAdmin = new ValueReference(crReq.userIdHandle, crReq.userIdIndex);
            } else if (sessionInfo != null) {
                thisAdmin = new ValueReference(sessionInfo.identityKeyHandle, sessionInfo.identityKeyIndex);
            } else {
                return new ErrorResponse(req, 500, MSG_INVALID_SESSION_OR_TIMEOUT);
            }
            if (this.requireSessions && sessionInfo == null && req.opCode != 400) {
                System.err.println("rejecting non-session request: " + req + "; session: " + this.getSession(req.sessionId));
                return new ErrorResponse(req, 404, MSG_SESSION_REQUIRED);
            }
            boolean verified = false;
            Vector<ValueReference> valuesTraversed = new Vector<ValueReference>();
            boolean hasPermission = this.isAdminInLists(thisAdmin, valuesTraversed, adminLists);
            if (!hasPermission && HandleServer.mightGetNewIndexForAuthentication(crReq, sessionInfo)) {
                verifyResp = this.verifyIdentityAndGetIndex(cRes, crReq, req);
                if (((AbstractResponseAndIndex)verifyResp).getResponse() != null) {
                    return ((AbstractResponseAndIndex)verifyResp).getResponse();
                }
                verified = true;
                if (((AbstractResponseAndIndex)verifyResp).getIndex() != 0) {
                    thisAdmin = new ValueReference(thisAdmin.handle, ((AbstractResponseAndIndex)verifyResp).getIndex());
                    hasPermission = valuesTraversed.contains(thisAdmin);
                }
            }
            if (!hasPermission) {
                return new ErrorResponse(req, 400, null);
            }
            if (verified) {
                return null;
            }
            verifyResp = this.verifyIdentity(cRes, crReq, req);
            return verifyResp;
        }
        catch (HandleException e) {
            this.logError(50, "Unable to authenticate request: " + e);
            return new ErrorResponse(req, 406, null);
        }
    }

    private static boolean mightGetNewIndexForAuthentication(ChallengeAnswerRequest crReq, ServerSideSessionInfo sessionInfo) {
        if (crReq != null && Common.PUBLIC_KEY_TYPE.equals(crReq.authType) && crReq.userIdIndex == 0) {
            return true;
        }
        return sessionInfo != null && sessionInfo.identityKeyIndex == 0;
    }

    private boolean isAdminInLists(ValueReference thisAdmin, Vector<ValueReference> valuesTraversed, ValueReference[] ... adminLists) {
        Vector<ValueReference> valuesToTraverse = new Vector<ValueReference>();
        boolean hasPermission = false;
        block0: for (ValueReference[] adminList : adminLists) {
            for (int i = 0; i < adminList.length; ++i) {
                ValueReference admin = adminList[i];
                if (admin.isMatchedBy(thisAdmin)) {
                    hasPermission = true;
                    break block0;
                }
                valuesToTraverse.addElement(admin);
            }
        }
        if (!hasPermission) {
            hasPermission = this.isAdminInGroup(thisAdmin, valuesToTraverse, valuesTraversed);
        }
        return hasPermission;
    }

    private final void doListHandles(ResponseMessageCallback callback, ListHandlesRequest req, ChallengeResponse cRes, ChallengeAnswerRequest crReq) throws HandleException {
        byte[] handle = req.handle;
        handle = !this.caseSensitive ? Util.upperCase(handle) : Util.upperCasePrefix(handle);
        if (!Util.hasSlash(handle)) {
            handle = Util.convertSlashlessHandleToZeroNaHandle(handle);
        }
        if (!this.allowListHdls) {
            this.sendResponse(callback, new ErrorResponse(req, 5, MSG_NEED_LIST_HDLS_PERM));
            return;
        }
        if (!this.storageHaveNA(handle)) {
            if (!this.isSpecialDerivedPrefixMarker(handle)) {
                this.sendResponse(callback, new ErrorResponse(req, 301, MSG_NA_NOT_HOMED_HERE));
                return;
            }
            if (!this.storage.haveNA(Common.ROOT_HANDLE)) {
                this.sendResponse(callback, new ErrorResponse(req, 301, MSG_NA_NOT_HOMED_HERE));
                return;
            }
        }
        if (!(cRes != null && crReq != null || this.authenticatedSession(req))) {
            this.sendResponse(callback, this.createChallenge(req));
            return;
        }
        try {
            byte[][] vals = null;
            Exception exception = null;
            try {
                vals = this.getNAAdminValues(handle);
            }
            catch (Exception e) {
                exception = e;
            }
            AbstractResponse authResp = this.authenticateUser(req, cRes, crReq, LIST_HDLS_PERM, vals);
            if (authResp != null) {
                if (exception != null) {
                    throw exception;
                }
                this.sendResponse(callback, authResp);
                return;
            }
        }
        catch (Exception e) {
            this.logError(50, "Auth error on list-handles request: " + e);
            this.sendResponse(callback, new ErrorResponse(req, 406, null));
            return;
        }
        ListHandlesResponse response = new ListHandlesResponse(req, null);
        byte[][] handles = new byte[50][];
        int numHandles = 0;
        boolean noHandles = true;
        Enumeration<byte[]> listEnum = this.storage.getHandlesForNA(handle);
        try {
            while (listEnum.hasMoreElements()) {
                noHandles = false;
                handles[numHandles++] = listEnum.nextElement();
                if (numHandles < 50) continue;
                response.handles = handles;
                response.clearBuffers();
                response.continuous = listEnum.hasMoreElements();
                numHandles = 0;
                this.sendResponse(callback, response);
            }
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof HandleException) {
                throw (HandleException)e.getCause();
            }
            throw e;
        }
        finally {
            if (listEnum instanceof Closeable) {
                try {
                    ((Closeable)((Object)listEnum)).close();
                }
                catch (Exception exception) {}
            }
        }
        if (noHandles || numHandles > 0) {
            byte[][] tmpHandles = new byte[numHandles][];
            System.arraycopy(handles, 0, tmpHandles, 0, numHandles);
            response.handles = tmpHandles;
            response.clearBuffers();
            response.continuous = false;
            numHandles = 0;
            this.sendResponse(callback, response);
        }
    }

    private boolean isSpecialDerivedPrefixMarker(byte[] handle) {
        return Util.startsWithCI(handle, Common.SPECIAL_DERIVED_MARKER);
    }

    private final void doListNAs(ResponseMessageCallback callback, ListNAsRequest req, ChallengeResponse cRes, ChallengeAnswerRequest crReq) throws HandleException {
        if (!(cRes != null && crReq != null || this.authenticatedSession(req))) {
            this.sendResponse(callback, this.createChallenge(req));
            return;
        }
        AbstractResponse authError = this.returnErrorOrChallengeIfRequestNotAuthorized(req, cRes, crReq, this.serverAdmins, this.homeOnlyAdmins);
        if (authError != null) {
            this.sendResponse(callback, authError);
            return;
        }
        ListNAsResponse response = new ListNAsResponse(req, null);
        HomedPrefixAccumulator homedPrefixAccumulator = new HomedPrefixAccumulator(this.storage);
        List<byte[]> homedPrefixes = homedPrefixAccumulator.getHomedPrefixes();
        Iterator<byte[]> listIter = homedPrefixes.iterator();
        byte[][] handles = new byte[50][];
        int numHandles = 0;
        boolean errorSendingResponse = false;
        boolean noHandles = true;
        while (!errorSendingResponse && listIter.hasNext()) {
            noHandles = false;
            handles[numHandles++] = listIter.next();
            if (numHandles < 50) continue;
            response.handles = handles;
            response.clearBuffers();
            response.continuous = listIter.hasNext();
            numHandles = 0;
            try {
                this.sendResponse(callback, response);
            }
            catch (Throwable t) {
                errorSendingResponse = true;
                System.err.println("Error sending response to list-NAs request: " + t);
            }
        }
        if ((noHandles || numHandles > 0) && !errorSendingResponse) {
            byte[][] tmpHandles = new byte[numHandles][];
            System.arraycopy(handles, 0, tmpHandles, 0, numHandles);
            response.handles = tmpHandles;
            response.clearBuffers();
            response.continuous = false;
            numHandles = 0;
            this.sendResponse(callback, response);
        }
    }

    private final AbstractResponse checkReadAccess(ResolutionRequest req, byte[][] clumps, ChallengeResponse cRes, ChallengeAnswerRequest crReq) throws HandleException {
        boolean needsauth;
        if (req.ignoreRestrictedValues) {
            int numUnrestricted = 0;
            for (byte[] clump : clumps) {
                if ((Encoder.getHandleValuePermissions(clump, 0) & 2) == 0) continue;
                ++numUnrestricted;
            }
            if (numUnrestricted == 0) {
                return new ErrorResponse(req, 200, null);
            }
            byte[][] unrestrictedVals = new byte[numUnrestricted][];
            --numUnrestricted;
            for (int i = clumps.length - 1; i >= 0; --i) {
                if ((Encoder.getHandleValuePermissions(clumps[i], 0) & 2) == 0) continue;
                unrestrictedVals[numUnrestricted--] = clumps[i];
            }
            return new ResolutionResponse((AbstractRequest)req, req.handle, unrestrictedVals);
        }
        boolean bl = needsauth = req.sessionId != 0;
        if (!needsauth) {
            for (byte[] clump : clumps) {
                byte perms = Encoder.getHandleValuePermissions(clump, 0);
                if ((perms & 2) != 0) continue;
                if ((perms & 8) == 0) {
                    return new ErrorResponse(req, 401, null);
                }
                needsauth = true;
                break;
            }
        }
        if (!needsauth) {
            return new ResolutionResponse((AbstractRequest)req, req.handle, clumps);
        }
        if (!(cRes != null && crReq != null || this.authenticatedSession(req))) {
            return this.createChallenge(req);
        }
        byte[][] adminClumps = this.getRawHandleValuesWithTemplate(req.handle, Common.ADMIN_INDEXES, Common.ADMIN_TYPES, req.recursionCount);
        AbstractResponse authResp = this.authenticateUser(req, cRes, crReq, READ_VAL_PERM, adminClumps);
        if (authResp != null) {
            return authResp;
        }
        return new ResolutionResponse((AbstractRequest)req, req.handle, clumps);
    }

    @Override
    public void setReplicationPriority(int i) {
        this.replicationPriority = i;
    }

    public void setReplicationSiteName(String name) {
        ReplicationStateInfo replicationStateInfo;
        this.replicationSiteName = name;
        if (this.replicationDaemon != null && (replicationStateInfo = this.replicationDaemon.getReplicationStateInfo()) != null) {
            replicationStateInfo.setOwnName(name);
        }
    }

    private ErrorResponse validateAndInsertTransactionReturnResponseIfError(AbstractRequest req, byte[] handle, HandleValue[] values, byte action) throws HandleException {
        if (this.replicationValidator != null) {
            Transaction txn = new Transaction(0L, handle, values, action, 0L);
            try {
                TransactionValidator.ValidationResult result = this.replicationValidator.validate(txn);
                if (!result.isValid()) {
                    String message = "Transaction is invalid according to policy";
                    if (result.getMessage() != null) {
                        message = message + ": " + result.getMessage();
                    }
                    return new ErrorResponse(req, 202, Util.encodeString(message));
                }
                if (result.getReport() != null) {
                    this.logError(25, GsonUtility.getPrettyGson().toJson((JsonElement)result.getReport()));
                }
            }
            catch (HandleException e) {
                this.logError(75, "Error validating transaction");
                e.printStackTrace();
                return new ErrorResponse(req, 2, MSG_INTERNAL_ERROR);
            }
        }
        if (!this.insertTransaction(handle, values, action)) {
            return new ErrorResponse(req, 2, MSG_INTERNAL_ERROR);
        }
        return null;
    }

    private final boolean insertTransaction(byte[] handle, HandleValue[] values, byte action) {
        if (!this.enableTxnQueue) {
            return true;
        }
        long date = System.currentTimeMillis();
        if (this.replicationDaemon != null) {
            try {
                switch (action) {
                    case 1: 
                    case 2: 
                    case 3: {
                        date = this.replicationDaemon.adjustAndSetLastCreateOrDeleteDate(handle, date, this.replicationPriority);
                        break;
                    }
                    case 4: 
                    case 5: {
                        date = this.replicationDaemon.adjustAndSetLastHomeOrUnhomeDate(handle, date, this.replicationPriority);
                        break;
                    }
                }
            }
            catch (Throwable e) {
                this.logError(75, "Unable to save transation in replication database");
                e.printStackTrace();
            }
        }
        try {
            long thisTxnId = this.getNextTxnId();
            this.transactionsInProgress.put(Thread.currentThread().getId(), thisTxnId);
            this.txnQueue.addTransaction(thisTxnId, handle, values, action, date);
        }
        catch (Throwable e) {
            this.logError(75, "Unable to insert transaction into queue");
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private final AbstractResponse createChallenge(AbstractRequest req) throws HandleException {
        ChallengeResponseInfo formerCri;
        boolean validSessionReq = this.validSession(req);
        if (validSessionReq && (formerCri = (ChallengeResponseInfo)this.pendingAuthorizations.get(req.sessionId)) != null && req.requestId == formerCri.originalRequest.requestId) {
            return formerCri.challenge;
        }
        ChallengeResponseInfo cri = new ChallengeResponseInfo();
        cri.timeStarted = System.currentTimeMillis();
        cri.challenge = new ChallengeResponse(req);
        cri.originalRequest = req;
        cri.sessionId = validSessionReq ? req.sessionId : HandleServer.getNextSessionId();
        cri.challenge.sessionId = cri.sessionId;
        ChallengeResponseInfo formerCri2 = this.pendingAuthorizations.put(cri.sessionId, cri);
        if (formerCri2 != null) {
            try {
                if (!formerCri2.challengeAccepted && !formerCri2.hasExpired()) {
                    this.logError(50, "Warning: clobbering pending authorization of " + formerCri2.originalRequest);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return cri.challenge;
    }

    private static synchronized int getNextSessionId() {
        return ++nextAuthId;
    }

    private final boolean isAdminInGroup(ValueReference admin, Vector<ValueReference> valuesToTraverse, Vector<ValueReference> valuesTraversed) {
        while (valuesToTraverse.size() > 0) {
            ValueReference val = valuesToTraverse.elementAt(0);
            valuesToTraverse.removeElementAt(0);
            if (valuesTraversed.contains(val)) continue;
            valuesTraversed.addElement(val);
            if (val.index == 0) continue;
            ResolutionRequest req = new ResolutionRequest(val.handle, null, new int[]{val.index}, null);
            HandleValue groupValue = null;
            try {
                AbstractResponse response;
                req.certify = true;
                if (this.errorIfNotHaveHandle(req) == null) {
                    req.ignoreRestrictedValues = false;
                    response = this.doResolution(req, null, null, true);
                } else {
                    response = this.resolver.processRequest(req);
                }
                if (response.responseCode != 1 || response.opCode != 1) continue;
                ResolutionResponse resResponse = (ResolutionResponse)response;
                groupValue = new HandleValue();
                for (byte[] value : resResponse.values) {
                    Encoder.decodeHandleValue(value, 0, groupValue);
                    if (!groupValue.hasType(Common.STD_TYPE_HSVALLIST)) continue;
                    ValueReference[] valuesInGroup = Encoder.decodeValueReferenceList(groupValue.getData(), 0);
                    for (int i = 0; i < valuesInGroup.length; ++i) {
                        if (valuesInGroup[i].isMatchedBy(admin)) {
                            return true;
                        }
                        if (valuesToTraverse.contains(valuesInGroup[i]) || valuesTraversed.contains(valuesInGroup[i])) continue;
                        valuesToTraverse.addElement(valuesInGroup[i]);
                    }
                }
            }
            catch (Throwable e) {
                System.err.println("Error trying to resolve possible group: " + e);
                e.printStackTrace(System.err);
            }
        }
        return false;
    }

    @Override
    public final AbstractResponse verifyIdentity(ChallengeResponse cRes, ChallengeAnswerRequest crReq, AbstractRequest origReq) throws HandleException {
        if (crReq instanceof PreAuthenticatedChallengeAnswerRequest) {
            return null;
        }
        return this.verifyIdentityAndGetIndex(cRes, crReq, origReq).getResponse();
    }

    @Override
    public final AbstractResponseAndIndex verifyIdentityAndGetIndex(ChallengeResponse cRes, ChallengeAnswerRequest crReq, AbstractRequest origReq) throws HandleException {
        if (crReq instanceof PreAuthenticatedChallengeAnswerRequest) {
            return new AbstractResponseAndIndex(0, null);
        }
        if (cRes == null && crReq == null && this.authenticatedSession(origReq)) {
            block45: {
                ServerSideSessionInfo sssinfo = this.getSession(origReq.sessionId);
                if (sssinfo == null) {
                    return new AbstractResponseAndIndex(0, new ErrorResponse(origReq, 500, MSG_INVALID_SESSION_OR_TIMEOUT));
                }
                if (origReq.signature == null || origReq.signature.length <= 0) {
                    return new AbstractResponseAndIndex(0, new ErrorResponse(origReq, 404, Util.encodeString("Session request missing MAC code.")));
                }
                byte[] sessionKey = sssinfo.getSessionKey();
                try {
                    if (sessionKey == null || !origReq.verifyMessage(sessionKey)) break block45;
                    try {
                        sssinfo.addSessionCounter(origReq.sessionCounter, true);
                    }
                    catch (HandleException e) {
                        if (e.getCode() == 28) {
                            return new AbstractResponseAndIndex(0, new ErrorResponse(origReq, 505, Util.encodeString(e.getMessage())));
                        }
                        throw e;
                    }
                    return new AbstractResponseAndIndex(sssinfo.getIndexOfAuthenticatedSession(), null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.logError(50, "Error verifying session key:" + e);
                }
            }
            return new AbstractResponseAndIndex(0, new ErrorResponse(origReq, 502, Util.encodeString("Session authentication failed.")));
        }
        if (cRes != null && crReq != null && Util.equals(crReq.authType, Common.SECRET_KEY_TYPE)) {
            VerifyAuthRequest vaReq = new VerifyAuthRequest(crReq.userIdHandle, cRes.nonce, cRes.requestDigest, cRes.rdHashType, crReq.signedResponse, crReq.userIdIndex, null);
            vaReq.certify = true;
            vaReq.setSupportedProtocolVersion(crReq);
            AbstractResponse response = this.errorIfNotHaveHandle(vaReq) == null ? this.verifyChallenge(vaReq, null, null) : this.resolver.processRequest(vaReq);
            if (response instanceof VerifyAuthResponse) {
                if (((VerifyAuthResponse)response).isValid) {
                    if (this.validSession(origReq)) {
                        this.setSessionAuthenticated(origReq, crReq, true);
                        boolean MACpass = true;
                        ServerSideSessionInfo ssinfo = this.getSession(origReq.sessionId);
                        if (ssinfo == null) {
                            return new AbstractResponseAndIndex(0, null);
                        }
                        if (ssinfo.getSessionKey() != null) {
                            try {
                                MACpass = origReq.verifyMessage(ssinfo.getSessionKey());
                            }
                            catch (Exception e) {
                                System.err.println("Error verifying the original request MAC code:" + e);
                                MACpass = false;
                            }
                        }
                        if (MACpass) {
                            try {
                                ssinfo.addSessionCounter(crReq.sessionCounter, true);
                                ssinfo.addSessionCounter(origReq.sessionCounter, false);
                            }
                            catch (HandleException e) {
                                if (e.getCode() == 28) {
                                    return new AbstractResponseAndIndex(0, new ErrorResponse(origReq, 505, Util.encodeString(e.getMessage())));
                                }
                                throw e;
                            }
                            return new AbstractResponseAndIndex(0, null);
                        }
                        return new AbstractResponseAndIndex(0, new ErrorResponse(origReq, 502, Util.encodeString("The session key authentication failed.")));
                    }
                    return new AbstractResponseAndIndex(0, null);
                }
                if (crReq.signedResponse[0] > 2 && !response.hasEqualOrGreaterVersion(cRes.majorProtocolVersion, cRes.minorProtocolVersion) && !response.hasEqualOrGreaterVersion(2, 7)) {
                    cRes.suggestMajorProtocolVersion = response.suggestMajorProtocolVersion;
                    cRes.suggestMinorProtocolVersion = response.suggestMinorProtocolVersion;
                    cRes.clearBuffers();
                    return new AbstractResponseAndIndex(0, cRes);
                }
            }
            return new AbstractResponseAndIndex(0, new ErrorResponse(origReq, 403, null));
        }
        if (cRes != null && crReq != null && Util.equals(crReq.authType, Common.PUBLIC_KEY_TYPE)) {
            int[] nArray;
            byte[] byArray = crReq.userIdHandle;
            byte[][] byArray2 = crReq.userIdIndex > 0 ? null : Common.PUBLIC_KEY_TYPES;
            if (crReq.userIdIndex > 0) {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = crReq.userIdIndex;
            } else {
                nArray = null;
            }
            ResolutionRequest req = new ResolutionRequest(byArray, byArray2, nArray, null);
            req.certify = true;
            AbstractResponse response = null;
            if (this.errorIfNotHaveHandle(req) == null) {
                req.ignoreRestrictedValues = false;
                response = this.doResolution(req, null, null, true);
            } else {
                response = this.resolver.processRequest(req);
            }
            if (response.getClass() == ResolutionResponse.class) {
                ResolutionResponse rresponse = (ResolutionResponse)response;
                HandleValue[] values = rresponse.getHandleValues();
                if (values == null || values.length < 1) {
                    return new AbstractResponseAndIndex(0, new ErrorResponse(origReq, 403, null));
                }
                try {
                    int offset = 0;
                    byte[] hashAlgId = Encoder.readByteArray(crReq.signedResponse, offset);
                    byte[] sigBytes = Encoder.readByteArray(crReq.signedResponse, offset += 4 + hashAlgId.length);
                    offset += 4 + sigBytes.length;
                    boolean verified = false;
                    int newIndex = 0;
                    Arrays.sort(values, HandleValue.INDEX_COMPARATOR);
                    for (HandleValue value : values) {
                        if (crReq.userIdIndex > 0 && crReq.userIdIndex != value.getIndex() || !Util.equals(Common.PUBLIC_KEY_TYPE, value.getType())) continue;
                        try {
                            PublicKey pubKey = Util.getPublicKeyFromBytes(value.getData(), 0);
                            Signature sig = Signature.getInstance(Util.getSigIdFromHashAlgId(hashAlgId, pubKey.getAlgorithm()));
                            sig.initVerify(pubKey);
                            sig.update(cRes.nonce);
                            sig.update(cRes.requestDigest);
                            if (!sig.verify(sigBytes)) continue;
                            verified = true;
                            newIndex = value.getIndex();
                            break;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (verified) {
                        if (newIndex == crReq.userIdIndex) {
                            newIndex = 0;
                        }
                        if (this.validSession(origReq)) {
                            this.setSessionAuthenticated(origReq, crReq, true);
                            boolean MACpass = true;
                            ServerSideSessionInfo ssinfo = this.getSession(origReq.sessionId);
                            if (ssinfo == null) {
                                return new AbstractResponseAndIndex(newIndex, null);
                            }
                            if (ssinfo.getSessionKey() != null) {
                                try {
                                    MACpass = origReq.verifyMessage(ssinfo.getSessionKey());
                                }
                                catch (Exception e) {
                                    System.err.println("Error verifying the original request MAC code:" + e);
                                    MACpass = false;
                                }
                            }
                            if (MACpass) {
                                try {
                                    ssinfo.addSessionCounter(crReq.sessionCounter, true);
                                    ssinfo.addSessionCounter(origReq.sessionCounter, false);
                                }
                                catch (HandleException e) {
                                    if (e.getCode() == 28) {
                                        return new AbstractResponseAndIndex(0, new ErrorResponse(origReq, 505, Util.encodeString(e.getMessage())));
                                    }
                                    throw e;
                                }
                                ssinfo.setIndexOfAuthenticatedSession(newIndex);
                                return new AbstractResponseAndIndex(newIndex, null);
                            }
                            return new AbstractResponseAndIndex(0, new ErrorResponse(origReq, 502, Util.encodeString("The session key authentication failed.")));
                        }
                        return new AbstractResponseAndIndex(newIndex, null);
                    }
                    return new AbstractResponseAndIndex(0, new ErrorResponse(origReq, 403, null));
                }
                catch (Exception e) {
                    return new AbstractResponseAndIndex(0, new ErrorResponse(origReq, 403, null));
                }
            }
            return new AbstractResponseAndIndex(0, new ErrorResponse(origReq, 403, null));
        }
        return new AbstractResponseAndIndex(0, new ErrorResponse(origReq, 404, null));
    }

    private final AbstractResponse doBackup(GenericRequest req, ChallengeResponse cRes, ChallengeAnswerRequest crReq) throws HandleException {
        AbstractResponse authError = this.returnErrorOrChallengeIfRequestNotAuthorized(req, cRes, crReq, this.backupAdmins, this.serverAdmins);
        if (authError != null) {
            return authError;
        }
        try {
            this.storage.checkpointDatabase();
        }
        catch (Exception e) {
            this.logError(100, "Error backup server: " + e);
            return new ErrorResponse(req, 2, MSG_INTERNAL_ERROR);
        }
        return new GenericResponse(req, 1);
    }

    private final AbstractResponse doSessionTerminate(GenericRequest req, ChallengeResponse cRes, ChallengeAnswerRequest crReq) throws HandleException {
        ServerSideSessionInfo ssinfo = this.getSession(req.sessionId);
        if (ssinfo != null) {
            boolean authenticated = false;
            try {
                authenticated = req.verifyMessage(ssinfo.getSessionKey());
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                authenticated = false;
            }
            if (!authenticated) {
                return new ErrorResponse(req, 502, Util.encodeString("Invalid session key."));
            }
            try {
                ssinfo.addSessionCounter(req.sessionCounter, false);
            }
            catch (HandleException e) {
                if (e.getCode() == 28) {
                    return new ErrorResponse(req, 505, Util.encodeString(e.getMessage()));
                }
                throw e;
            }
            this.sessions.removeSession(req.sessionId);
            return new GenericResponse(req, 1);
        }
        return new ErrorResponse(req, 500, Util.encodeString("Can not get session info."));
    }

    private final AbstractResponse doSessionSetup(SessionSetupRequest req, ChallengeResponse cRes, ChallengeAnswerRequest crReq) throws HandleException {
        int sessionId;
        int sessionKeyAlg;
        SessionSetupResponse rsp = new SessionSetupResponse(req, null);
        PublicKey pubKey = null;
        byte[] sessionKey = null;
        boolean oldClient = !AbstractMessage.hasEqualOrGreaterVersion(req.suggestMajorProtocolVersion, req.suggestMinorProtocolVersion, 2, 2);
        int n = sessionKeyAlg = oldClient ? 1 : this.encryptionAlgorithm;
        if (req.keyExchangeMode == 3) {
            try {
                HandleValue[] vals = this.resolver.resolveHandle(Util.decodeString(req.exchangeKeyHandle), null, new int[]{req.exchangeKeyIndex});
                HandleValue pubkeyval = null;
                for (int i = 0; vals != null && i < vals.length; ++i) {
                    if (!vals[i].hasType(Common.PUBLIC_KEY_TYPE)) continue;
                    pubkeyval = vals[i];
                    break;
                }
                if (pubkeyval == null) {
                    this.logError(50, "Error initializing session with hdl cipher: no key found.");
                    return new ErrorResponse(req, 501, Util.encodeString("No key found in key exchange handle."));
                }
                if (vals == null) {
                    throw new AssertionError();
                }
                pubKey = Util.getPublicKeyFromBytes(vals[0].getData(), 0);
                sessionKey = HdlSecurityProvider.getInstance().generateSecretKey(sessionKeyAlg);
                byte[] encryptKey = Util.substring(sessionKey, 4);
                rsp.data = Util.encrypt(pubKey, oldClient ? encryptKey : sessionKey, rsp.majorProtocolVersion, rsp.minorProtocolVersion);
                sessionKey = encryptKey;
            }
            catch (Exception e) {
                this.logError(50, "Error initializing session with hdl cipher: " + e);
                return new ErrorResponse(req, 501, Util.encodeString("Error performing hdl cipher key exchange."));
            }
        } else if (req.keyExchangeMode == 1) {
            try {
                pubKey = Util.getPublicKeyFromBytes(req.publicKey, 0);
                sessionKey = HdlSecurityProvider.getInstance().generateSecretKey(sessionKeyAlg);
                byte[] encryptKey = Util.substring(sessionKey, 4);
                rsp.data = Util.encrypt(pubKey, oldClient ? encryptKey : sessionKey, rsp.majorProtocolVersion, rsp.minorProtocolVersion);
                sessionKey = encryptKey;
            }
            catch (Exception e) {
                this.logError(50, "Error initializing client cipher session: " + e);
                return new ErrorResponse(req, 501, Util.encodeString("Error performing client cipher key exchange."));
            }
        } else if (req.keyExchangeMode == 2) {
            if (!(this.publicKey instanceof RSAPublicKey)) {
                return new ErrorResponse(req, 501, Util.encodeString("KEY_EXCHANGE_CIPHER_SERVER not supported"));
            }
            try {
                rsp.data = Util.getBytesFromPublicKey(this.publicKey);
            }
            catch (Exception e) {
                this.logError(50, "Error initializing server cipher session: " + e);
                return new ErrorResponse(req, 501, Util.encodeString("Error initializing server cipher session: " + e));
            }
        } else if (req.keyExchangeMode == 4) {
            try {
                pubKey = Util.getPublicKeyFromBytes(req.publicKey, 0);
                HdlSecurityProvider provider = HdlSecurityProvider.getInstance();
                DHPublicKey pub = (DHPublicKey)pubKey;
                DHParameterSpec dhSpec = pub.getParams();
                KeyPair kp = provider.generateDHKeyPair(dhSpec.getP(), dhSpec.getG());
                DHPrivateKey priv = (DHPrivateKey)kp.getPrivate();
                boolean bl = oldClient = !AbstractMessage.hasEqualOrGreaterVersion(req.suggestMajorProtocolVersion, req.suggestMinorProtocolVersion, 2, 4);
                if (!oldClient) {
                    byte[] pubKeyBytes = Util.getBytesFromPublicKey(kp.getPublic());
                    rsp.data = new byte[4 + pubKeyBytes.length];
                    Encoder.writeInt(rsp.data, 0, this.encryptionAlgorithm);
                    System.arraycopy(pubKeyBytes, 0, rsp.data, 4, pubKeyBytes.length);
                    sessionKey = provider.getKeyFromDH(pub, priv, this.encryptionAlgorithm);
                    sessionKey = Util.substring(sessionKey, 4);
                    sessionKeyAlg = this.encryptionAlgorithm;
                }
                rsp.data = Util.getBytesFromPublicKey(kp.getPublic());
                sessionKey = provider.getDESKeyFromDH(pub, priv);
                sessionKeyAlg = 1;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logError(50, "Error initializing DH session: " + e);
                return new ErrorResponse(req, 501, Util.encodeString("Error encoding public session key"));
            }
        } else {
            return new ErrorResponse(req, 501, Util.encodeString("Unrecognized key exchange mode"));
        }
        rsp.sessionId = sessionId = HandleServer.getNextSessionId();
        ServerSideSessionInfo sinfo = new ServerSideSessionInfo(sessionId, sessionKey, req.identityHandle, req.identityIndex, sessionKeyAlg, pubKey, req.keyExchangeMode, rsp.majorProtocolVersion, rsp.minorProtocolVersion);
        sinfo.setTimeOut(req.timeout);
        sinfo.setEncryptedMesssageFlag(req.encryptAllSessionMsg);
        sinfo.setAuthenticateMessageFlag(req.authAllSessionMsg);
        this.sessions.addSession(sinfo);
        return rsp;
    }

    private final AbstractResponse doKeyExchange(SessionExchangeKeyRequest req, ChallengeResponse cRes, ChallengeAnswerRequest crReq) throws HandleException {
        int sessionKeyAlg;
        if (!this.validSession(req)) {
            this.logError(50, "Bad server-cipher key exchange request");
            return new ErrorResponse(req, 500, MSG_INVALID_SESSION_OR_TIMEOUT);
        }
        ServerSideSessionInfo sinfo = this.sessions.getSession(req.sessionId);
        if (sinfo.keyExchangeMode != 2) {
            this.logError(50, "Bad server-cipher key exchange request");
            return new ErrorResponse(req, 501, Util.encodeString("Invalid session id. Session failed."));
        }
        boolean oldClient = !req.hasEqualOrGreaterVersion(2, 2);
        byte[] encSessionKey = req.getEncryptedSessionKey();
        byte[] sessionKey = null;
        GenericResponse successResponse = new GenericResponse(req, 1);
        try {
            sessionKey = Util.decrypt(this.privateKey, encSessionKey, successResponse.majorProtocolVersion, successResponse.minorProtocolVersion);
        }
        catch (Exception e) {
            return new ErrorResponse(req, 501, Util.encodeString("Can't decrypt client session key."));
        }
        if (!oldClient) {
            sessionKeyAlg = Encoder.readInt(sessionKey, 0);
            sessionKey = Util.substring(sessionKey, 4);
        } else {
            sessionKeyAlg = 1;
        }
        sinfo.setSessionKey(sessionKey);
        sinfo.setEncryptionAlgorithmCode(sessionKeyAlg);
        return successResponse;
    }

    private boolean validSession(AbstractRequest req) {
        if (req.sessionId == 0) {
            return false;
        }
        return this.getSession(req.sessionId) != null;
    }

    private boolean authenticatedSession(AbstractRequest req) {
        if (this.wideOpenAccessAllowed) {
            return true;
        }
        if (req.sessionId == 0) {
            return false;
        }
        ServerSideSessionInfo sssinfo = this.getSession(req.sessionId);
        return sssinfo != null && !sssinfo.isSessionAnonymous() && sssinfo.clientAuthenticated;
    }

    private void setSessionAuthenticated(AbstractRequest req, ChallengeAnswerRequest caReq, boolean authenticated) {
        ServerSideSessionInfo ssinfo = null;
        if (req != null && req.sessionId > 0) {
            ssinfo = this.getSession(req.sessionId);
        }
        if (ssinfo != null) {
            if (authenticated) {
                if (ssinfo.identityKeyHandle == null || ssinfo.identityKeyIndex < 0) {
                    return;
                }
                if (!Util.equals(ssinfo.identityKeyHandle, caReq.userIdHandle) || ssinfo.identityKeyIndex != caReq.userIdIndex) {
                    return;
                }
            }
            ssinfo.clientAuthenticated = authenticated;
        }
    }

    @Override
    public ServerSideSessionInfo getSession(int sessionId) {
        return this.sessions.getSession(sessionId);
    }

    public Object getWriteLock(byte[] hdl) {
        int result = 1;
        boolean inSuffix = false;
        for (byte element : hdl) {
            if (!inSuffix) {
                if (element != 47) continue;
                inSuffix = true;
                continue;
            }
            result = 31 * result + element;
            if (element < 97 || element > 122) continue;
            result -= 32;
        }
        result = Math.abs(result);
        return this.lockHash[result % this.lockHash.length];
    }

    @Override
    public final void shutdown() {
        this.keepRunning = false;
        if (this.monitorDaemon != null) {
            this.monitorDaemon.shutdown();
        }
        if (this.replicationDaemon != null) {
            this.replicationDaemon.shutdown();
        }
        if (this.sessions != null) {
            this.sessions.shutdown();
        }
        if (this.allOtherTransactionQueues != null) {
            this.allOtherTransactionQueues.shutdown();
        }
        if (this.txnQueue != null) {
            this.txnQueue.shutdown();
        }
        if (this.storage != null) {
            this.storage.shutdown();
        }
        if (this.txnQueuePruner != null) {
            this.txnQueuePruner.stop();
        }
    }

    private boolean storageHaveNA(byte[] authHandle) throws HandleException {
        if (this.storage.haveNA(authHandle)) {
            return true;
        }
        try {
            return this.storage.haveNA(Util.getSuffixPart(authHandle));
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean storageHaveDerivedPrefixesOnly(byte[] prefix) throws HandleException {
        prefix = Util.upperCase(prefix);
        int slash = Util.indexOf(prefix, (byte)47);
        for (int i = prefix.length - 1; i > slash; --i) {
            if (prefix[i] != 46 || !this.storage.haveNA(Util.concat(Common.NA_HANDLE_PREFIX, Util.substring(prefix, 0, i)))) continue;
            return true;
        }
        return false;
    }

    @Override
    public byte[][] storageGetRawHandleValues(byte[] handle, int[] indexList, byte[][] typeList) throws HandleException {
        try {
            return this.storage.getRawHandleValues(handle, indexList, typeList);
        }
        catch (HandleException e) {
            if (e.getCode() == 9) {
                return null;
            }
            throw e;
        }
    }

    class ChallengeResponseInfo {
        long timeStarted;
        int sessionId;
        ChallengeResponse challenge;
        AbstractRequest originalRequest;
        boolean challengeAccepted;

        ChallengeResponseInfo() {
        }

        final boolean hasExpired() {
            return this.timeStarted < System.currentTimeMillis() - HandleServer.this.maxAuthTime;
        }
    }

    private static class FixRequestIdAndThen
    implements ResponseMessageCallback {
        final int requestId;
        final ResponseMessageCallback callback;

        public FixRequestIdAndThen(int requestId, ResponseMessageCallback callback) {
            this.requestId = requestId;
            this.callback = callback;
        }

        public void fixRequestId(AbstractResponse message) {
            message.requestId = this.requestId;
        }

        @Override
        public void handleResponse(AbstractResponse message) throws HandleException {
            this.callback.handleResponse(message);
        }
    }

    private class ChallengePurgeThread
    extends Thread {
        private ChallengePurgeThread() {
        }

        @Override
        public void run() {
            while (HandleServer.this.keepRunning) {
                try {
                    Thread.sleep(30000L);
                    Iterator iter = HandleServer.this.pendingAuthorizations.values().iterator();
                    while (iter.hasNext()) {
                        ChallengeResponseInfo cri = (ChallengeResponseInfo)iter.next();
                        if (cri != null && !cri.hasExpired()) continue;
                        iter.remove();
                    }
                }
                catch (Throwable e) {
                    HandleServer.this.logError(75, "Error purging pending authentications: " + e);
                }
            }
        }
    }

    private static class TxnQueueFilter
    implements FilenameFilter {
        private TxnQueueFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".q");
        }
    }
}

