/*
 * Decompiled with CFR 0.152.
 */
package net.handle.server;

import java.io.IOException;
import java.io.InputStream;
import net.handle.hdllib.Encoder;

public final class DBTxn {
    private final byte action;
    private final byte[] key;
    private final byte[] val;
    private final long date;
    private static final byte NEWLINE = 110;
    private static final byte[] buf = new byte[8];

    public DBTxn(byte action, byte[] key, byte[] val, long date) {
        this.action = action;
        this.key = key;
        this.val = val;
        this.date = date;
    }

    public final long getDate() {
        return this.date;
    }

    public final byte getAction() {
        return this.action;
    }

    public final byte[] getKey() {
        return this.key;
    }

    public final byte[] getValue() {
        return this.val;
    }

    public final byte[] getLogBytes() {
        byte[] logBytes = new byte[6 + this.key.length + 4 + this.val.length + 8];
        int offset = 0;
        logBytes[offset++] = 110;
        logBytes[offset++] = this.action;
        offset += Encoder.writeLong(logBytes, offset, this.date);
        offset += Encoder.writeByteArray(logBytes, offset, this.key);
        offset += Encoder.writeByteArray(logBytes, offset, this.val);
        return logBytes;
    }

    public static synchronized DBTxn readTxn(InputStream in) throws IOException {
        int r;
        int ib;
        int n = 0;
        while ((ib = in.read()) == 110) {
        }
        if (ib < 0) {
            return null;
        }
        byte action = (byte)ib;
        while ((r = in.read(buf, n, 8 - n)) > 0 && n < 8) {
            n += r;
        }
        long date = Encoder.readLong(buf, 0);
        for (n = 0; (r = in.read(buf, n, 4 - n)) > 0 && n < 4; n += r) {
        }
        byte[] key = new byte[Encoder.readInt(buf, 0)];
        for (n = 0; (r = in.read(key, n, key.length - n)) > 0 && n < key.length; n += r) {
        }
        for (n = 0; (r = in.read(buf, n, 4 - n)) > 0 && n < 4; n += r) {
        }
        byte[] val = new byte[Encoder.readInt(buf, 0)];
        for (n = 0; (r = in.read(val, n, val.length - n)) > 0 && n < val.length; n += r) {
        }
        return new DBTxn(action, key, val, date);
    }
}

