/*
 * Decompiled with CFR 0.152.
 */
package net.handle.server;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import net.cnri.util.StreamTable;
import net.handle.hdllib.AbstractRequest;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleResolver;
import net.handle.hdllib.ResponseMessageCallback;
import net.handle.server.CacheServer;
import net.handle.server.HandleServer;
import net.handle.server.Main;

public abstract class AbstractServer {
    public static final String SERVER_TYPE = "server_type";
    public static final String HDLSVR_ID = "server";
    public static final String HDLSVR_CONFIG = "server_config";
    public static final String CACHESVR_ID = "cache";
    public static final String CACHESVR_CONFIG = "cache_config";
    public static final String PROXYSVR_ID = "proxy";
    public static final String PROXYSVR_CONFIG = "proxy_config";
    public static final String TRACE_MESSAGES = "trace_outgoing_messages";
    public static final String AUTO_UPDATE_ROOT_INFO = "auto_update_root_info";
    protected volatile boolean keepRunning = true;
    protected HandleResolver resolver;
    protected Main main;
    protected StreamTable config;

    protected AbstractServer() {
    }

    protected AbstractServer(Main main, StreamTable config, HandleResolver resolver) {
        this.config = config;
        this.main = main;
        this.resolver = resolver;
        if (config != null) {
            if (config.getBoolean(TRACE_MESSAGES, false) || config.getBoolean("trace_resolution", false)) {
                resolver.traceMessages = true;
            }
            if (!config.getBoolean(AUTO_UPDATE_ROOT_INFO, true)) {
                resolver.getConfiguration().setAutoUpdateRootInfo(false);
            }
        }
        resolver.getConfiguration().startAutoUpdate(resolver);
    }

    public void start() {
    }

    public StreamTable getConfig() {
        return this.main.getConfig();
    }

    public File getConfigDir() {
        return this.main.getConfigDir();
    }

    public HandleResolver getResolver() {
        return this.resolver;
    }

    public void logError(int level, String message) {
        this.main.logError(level, message);
    }

    public boolean logHttpAccesses() {
        return this.main.logHttpAccesses();
    }

    public void logAccess(String accesssType, InetAddress addr, int opCode, int rsCode, String message, long time) {
        this.main.logAccess(accesssType, addr, opCode, rsCode, message, time);
    }

    public abstract void processRequest(AbstractRequest var1, ResponseMessageCallback var2) throws HandleException;

    public void shutdown() {
        this.keepRunning = false;
    }

    public abstract X509Certificate getCertificate();

    public abstract X509Certificate[] getCertificateChain();

    public abstract PrivateKey getCertificatePrivateKey();

    public abstract PublicKey getPublicKey();

    public abstract PrivateKey getPrivateKey();

    public abstract void dumpHandles() throws HandleException, IOException;

    public static AbstractServer getInstance(Main main, StreamTable configTable, HandleResolver resolver) throws Exception {
        String serverType = String.valueOf(configTable.get(SERVER_TYPE, HDLSVR_ID));
        if (serverType.equals(HDLSVR_ID)) {
            StreamTable config = (StreamTable)configTable.get(HDLSVR_CONFIG);
            if (config == null) {
                throw new Exception("Configuration setting \"server_config\" is required.");
            }
            return new HandleServer(main, config, resolver);
        }
        if (serverType.equals(CACHESVR_ID)) {
            StreamTable config = (StreamTable)configTable.get(CACHESVR_CONFIG);
            if (config == null) {
                throw new Exception("Configuration setting \"cache_config\" is required.");
            }
            return new CacheServer(main, config, resolver);
        }
        throw new Exception("Configuration setting \"server_type\" must be \"server\", or \"cache\"");
    }
}

