/*
 * Decompiled with CFR 0.152.
 */
package net.handle.security;

import java.math.BigInteger;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import net.handle.security.provider.GenericProvider;

public abstract class HdlSecurityProvider {
    public static final int ENCRYPT_ALG_DES = 1;
    public static final int ENCRYPT_ALG_DESEDE = 2;
    public static final int ENCRYPT_ALG_AES = 3;
    private static HdlSecurityProvider instance = null;
    static final String DEFAULT_PROVIDER = "net.handle.security.provider.GenericProvider";

    public static final HdlSecurityProvider getInstance() {
        if (instance != null) {
            return instance;
        }
        String clssName = System.getProperty("handle.security.provider_class", null);
        if (clssName != null) {
            try {
                Class<?> klass = Class.forName(clssName);
                Object obj = klass.getConstructor(new Class[0]).newInstance(new Object[0]);
                if (obj instanceof HdlSecurityProvider) {
                    instance = (HdlSecurityProvider)obj;
                    return instance;
                }
                System.err.println("Security provider (" + clssName + ") not found");
            }
            catch (Exception e) {
                System.err.println("Security provider (" + clssName + ") not found; reason: " + e);
            }
            return null;
        }
        instance = new GenericProvider();
        return instance;
    }

    @Deprecated
    public Cipher getCipher(int algorithm, byte[] secretKey, int direction) throws Exception {
        return this.getCipher(algorithm, secretKey, direction, null, 2, 0);
    }

    public abstract Cipher getCipher(int var1, byte[] var2, int var3, byte[] var4, int var5, int var6) throws Exception;

    public abstract int getIvSize(int var1, int var2, int var3);

    public abstract byte[] generateSecretKey(int var1) throws Exception;

    public KeyPair generateDHKeyPair(int keySize) throws Exception {
        throw new NoSuchAlgorithmException("Diffie-Hellman key exchange not supported.");
    }

    public KeyPair generateDHKeyPair(BigInteger p, BigInteger g) throws Exception {
        throw new NoSuchAlgorithmException("Diffie-Hellman key exchange not supported.");
    }

    public byte[] getDESKeyFromDH(DHPublicKey pub, DHPrivateKey priv) throws Exception {
        throw new NoSuchAlgorithmException("Diffie-Hellman key exchange not supported");
    }

    public byte[] getKeyFromDH(DHPublicKey pub, DHPrivateKey priv, int algorithm) throws Exception {
        throw new NoSuchAlgorithmException("Diffie-Hellman key exchange not supported");
    }
}

