/*
 * Decompiled with CFR 0.152.
 */
package net.handle.jdb;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.security.MessageDigest;
import java.util.Date;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;
import net.handle.jdb.BlockCache;
import net.handle.jdb.HashBlock;

public class DBHash {
    public static final String V1_FILE_ID = "JDBHash v0.1";
    private static final int BLOCK_SIZE = 1024;
    private static final byte BC_REC_UNUSED = 0;
    private static final byte BC_REC_START = 1;
    private static final byte BC_REC_CONT = 2;
    private static final int START_HEADER_SIZE = 17;
    private static final int START_WCONT_HEADER_SIZE = 25;
    private static final int CONT_HEADER_SIZE = 5;
    private static final int CONT_WCONT_HEADER_SIZE = 13;
    private RandomAccessFile raFile;
    private final File hashFile;
    private int hashLength;
    private long tableStartIndex;
    private final boolean readOnly;
    private Vector freeBlocks;
    private final MessageDigest md5;
    private final byte[] blankBytes;
    private final byte[] buf = new byte[1024];
    public long stepCount = 0L;
    public long numQueries = 0L;
    private long[] hashIndex;
    private long dataSegmentStart;
    private final BlockCache cache;
    public boolean DEBUG = false;

    public DBHash(File hashFile, int hashLength, int cacheSize) throws Exception {
        this(hashFile, hashLength, cacheSize, false);
    }

    public DBHash(File hashFile, int hashLength, int cacheSize, boolean readOnly) throws Exception {
        if (hashLength < 0) {
            throw new IllegalArgumentException("The hash length (" + hashLength + ") must be >= 0");
        }
        this.readOnly = readOnly;
        this.hashFile = hashFile;
        this.hashLength = hashLength;
        this.freeBlocks = new Vector();
        this.blankBytes = new byte[1024];
        this.cache = new BlockCache(cacheSize);
        if (!hashFile.exists()) {
            if (readOnly) {
                throw new FileNotFoundException(hashFile.getAbsolutePath());
            }
            this.initNewFile();
        }
        this.raFile = new RandomAccessFile(hashFile, readOnly ? "r" : "rw");
        this.loadFromFile();
        this.md5 = MessageDigest.getInstance("MD5");
    }

    public synchronized void deleteAllRecords() throws Exception {
        if (this.readOnly) {
            throw new IOException("Attempted to modify read-only database");
        }
        System.err.println("Deleting records!!!");
        try {
            this.raFile.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.cache.clear();
        this.freeBlocks = new Vector();
        this.initNewFile();
        this.raFile = new RandomAccessFile(this.hashFile, "rw");
        this.loadFromFile();
    }

    public void close() throws Exception {
        this.sync();
        this.raFile.close();
    }

    private void sync() {
        try {
            this.raFile.getFD().sync();
        }
        catch (Exception e) {
            System.err.println("Exception syncing file: " + e);
        }
    }

    @Deprecated
    public void finalize() {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final synchronized byte[] getValue(byte[] key) throws Exception {
        byte[] digest = this.md5.digest(key);
        int digestLen = digest.length;
        int hash = 0xFF & digest[digestLen - 1] | (0xFF & digest[digestLen - 2]) << 8 | (0xFF & digest[digestLen - 3]) << 16 | (0xFF & digest[digestLen - 4]) << 24;
        int hashKey = (hash & Integer.MAX_VALUE) % this.hashLength;
        long recordLoc = this.hashIndex[hashKey];
        if (this.DEBUG) {
            System.err.println(" getvalue(" + new String(key) + ") startLoc: " + Long.toHexString(recordLoc));
        }
        if (recordLoc <= 0L) {
            return null;
        }
        HashBlock block = this.getValueAtBlock(recordLoc, key);
        if (block != null) {
            return block.data;
        }
        return null;
    }

    private final synchronized HashBlock readBlock(long blockNum) throws Exception {
        HashBlock block = (HashBlock)this.cache.getBlock(blockNum);
        if (this.DEBUG) {
            System.err.println("    reading block# " + Long.toHexString(blockNum));
        }
        if (block != null) {
            block.lastTouched = System.currentTimeMillis();
            if (this.DEBUG) {
                System.err.println("    block was cached");
            }
            return block;
        }
        block = new HashBlock();
        this.raFile.seek(blockNum);
        this.raFile.readFully(this.buf);
        int keyLen = (this.buf[1] & 0xFF) << 24 | (this.buf[2] & 0xFF) << 16 | (this.buf[3] & 0xFF) << 8 | this.buf[4] & 0xFF;
        int dataLen = (this.buf[5] & 0xFF) << 24 | (this.buf[6] & 0xFF) << 16 | (this.buf[7] & 0xFF) << 8 | this.buf[8] & 0xFF;
        block.thisRecord = blockNum;
        block.nextRecord = ((long)this.buf[9] & 0xFFL) << 56 | ((long)this.buf[10] & 0xFFL) << 48 | ((long)this.buf[11] & 0xFFL) << 40 | ((long)this.buf[12] & 0xFFL) << 32 | ((long)this.buf[13] & 0xFFL) << 24 | ((long)this.buf[14] & 0xFFL) << 16 | ((long)this.buf[15] & 0xFFL) << 8 | (long)this.buf[16] & 0xFFL;
        int bloc = 17;
        if (keyLen > 10000 || keyLen < 0 || dataLen > 1000000 || dataLen < 0) {
            System.err.println("invalid key/data length at block: " + Long.toHexString(blockNum) + '\n' + "  nextRecord=" + Long.toHexString(block.nextRecord) + '\n' + "  keyLen=" + keyLen + '\n' + "  dataLen=" + dataLen);
            throw new Exception("Data corruption exception.  Invalid key/data length");
        }
        block.key = new byte[keyLen];
        block.data = new byte[dataLen];
        int len = keyLen + dataLen;
        boolean willContinue = len + 17 > 1024;
        int numBlocks = 1;
        int remainingLength = willContinue ? len - 999 : len - 1007;
        if (remainingLength > 0) {
            ++numBlocks;
            remainingLength -= 1019;
        }
        while (remainingLength > 0) {
            ++numBlocks;
            remainingLength -= 1011;
        }
        long contBlock = 0L;
        int numRead = 0;
        for (int i = 0; i < numBlocks; ++i) {
            int thisHeaderSize;
            int numReadThisBlock = 0;
            if (i < numBlocks - 1) {
                contBlock = ((long)this.buf[bloc] & 0xFFL) << 56 | ((long)this.buf[bloc + 1] & 0xFFL) << 48 | ((long)this.buf[bloc + 2] & 0xFFL) << 40 | ((long)this.buf[bloc + 3] & 0xFFL) << 32 | ((long)this.buf[bloc + 4] & 0xFFL) << 24 | ((long)this.buf[bloc + 5] & 0xFFL) << 16 | ((long)this.buf[bloc + 6] & 0xFFL) << 8 | (long)this.buf[bloc + 7] & 0xFFL;
                bloc += 8;
            }
            if (i == 0) {
                thisHeaderSize = numBlocks > 1 ? 25 : 17;
            } else if (i < numBlocks - 1) {
                thisHeaderSize = 13;
            } else if (i == numBlocks - 1) {
                thisHeaderSize = 5;
            } else {
                throw new Exception("File corrupted!! This shouldn't happen!!!!");
            }
            while (numReadThisBlock < 1024 - thisHeaderSize) {
                int r;
                if (numRead + numReadThisBlock < keyLen) {
                    r = Math.min(keyLen - numRead, 1024 - thisHeaderSize);
                    System.arraycopy(this.buf, bloc, block.key, numRead, r);
                    bloc += r;
                    numReadThisBlock += r;
                }
                if (numRead + numReadThisBlock < len && numReadThisBlock < 1024 - thisHeaderSize) {
                    r = Math.min(len - numRead - numReadThisBlock, 1024 - thisHeaderSize - numReadThisBlock);
                    System.arraycopy(this.buf, bloc, block.data, numRead + numReadThisBlock - keyLen, r);
                    bloc += r;
                    numReadThisBlock += r;
                }
                if (numRead + numReadThisBlock < len) continue;
            }
            numRead += numReadThisBlock;
            if (i >= numBlocks - 1) continue;
            this.raFile.seek(contBlock);
            this.raFile.readFully(this.buf);
            bloc = 5;
        }
        this.cache.putBlock(block);
        return block;
    }

    private final HashBlock getValueAtBlock(long blockNum, byte[] key) throws Exception {
        HashBlock block;
        do {
            block = this.readBlock(blockNum);
            if (this.keyMatches(block.key, key)) {
                if (this.DEBUG) {
                    System.err.println("   found block: " + new String(block.key));
                }
                return block;
            }
            if (this.DEBUG) {
                System.err.println("   skipping block: " + new String(block.key) + "; len=" + key.length);
            }
            blockNum = block.nextRecord;
        } while (block.nextRecord > 0L);
        return null;
    }

    public final synchronized void setValue(byte[] key, byte[] data) throws Exception {
        if (this.readOnly) {
            throw new IOException("Attempted to modify read-only database");
        }
        byte[] digest = this.md5.digest(key);
        int digestLen = digest.length;
        int hash = 0xFF & digest[digestLen - 1] | (0xFF & digest[digestLen - 2]) << 8 | (0xFF & digest[digestLen - 3]) << 16 | (0xFF & digest[digestLen - 4]) << 24;
        int hashKey = (hash & Integer.MAX_VALUE) % this.hashLength;
        long recordLoc = this.hashIndex[hashKey];
        if (this.DEBUG) {
            System.err.println(" setvalue(" + new String(key) + ") startLoc: " + Long.toHexString(recordLoc));
        }
        if (recordLoc <= 0L) {
            long newRecordLoc;
            this.hashIndex[hashKey] = newRecordLoc = this.writeRecord(-1L, key, data, 0L);
            if (this.DEBUG) {
                System.err.println("  NEW ENTRY: " + new String(key));
            }
            this.writeHashIndex(hashKey, newRecordLoc);
        } else {
            HashBlock dupBlock = this.getValueAtBlock(recordLoc, key);
            if (dupBlock != null) {
                if (this.DEBUG) {
                    System.err.println("  EXISTING ENTRY: " + new String(key));
                }
                this.writeRecord(dupBlock.thisRecord, key, data, dupBlock.nextRecord);
            } else {
                long newRecordLoc;
                if (this.DEBUG) {
                    System.err.println("  NEW ENTRY (but existing hash): " + new String(key));
                }
                this.hashIndex[hashKey] = newRecordLoc = this.writeRecord(-1L, key, data, recordLoc);
                this.writeHashIndex(hashKey, newRecordLoc);
            }
        }
        this.sync();
    }

    public final synchronized boolean deleteValue(byte[] key) throws Exception {
        HashBlock block;
        int digestLen;
        if (this.DEBUG) {
            System.err.println("delete(" + new String(key) + ")");
        }
        if (this.readOnly) {
            throw new IOException("Attempted to modify read-only database");
        }
        byte[] digest = this.md5.digest(key);
        int hash = 0xFF & digest[(digestLen = digest.length) - 1] | (0xFF & digest[digestLen - 2]) << 8 | (0xFF & digest[digestLen - 3]) << 16 | (0xFF & digest[digestLen - 4]) << 24;
        int hashKey = (hash & Integer.MAX_VALUE) % this.hashLength;
        long recordLoc = this.hashIndex[hashKey];
        if (recordLoc <= 0L) {
            return false;
        }
        long parentBlock = 0L;
        while (recordLoc > 0L && (block = this.readBlock(recordLoc)) != null) {
            if (this.keyMatches(block.key, key)) {
                if (parentBlock > 0L) {
                    this.raFile.seek(parentBlock + 9L);
                    this.raFile.writeLong(block.nextRecord);
                    this.cache.removeBlock(parentBlock);
                } else {
                    this.hashIndex[hashKey] = block.nextRecord;
                    this.writeHashIndex(hashKey, block.nextRecord);
                }
                this.cache.removeBlock(block.thisRecord);
                this.deleteStartRecord(block.thisRecord);
                this.sync();
                return true;
            }
            parentBlock = recordLoc;
            recordLoc = block.nextRecord;
        }
        return false;
    }

    private final boolean keyMatches(byte[] key1, byte[] key2) {
        if (key1 == null || key2 == null || key1.length != key2.length) {
            return false;
        }
        for (int i = 0; i < key1.length; ++i) {
            if (key1[i] == key2[i]) continue;
            return false;
        }
        return true;
    }

    private final void writeHashIndex(int hashKey, long newRecordLoc) throws Exception {
        if (this.readOnly) {
            throw new IOException("Attempted to modify read-only database");
        }
        this.raFile.seek(this.tableStartIndex + (long)(hashKey * 8));
        this.raFile.writeLong(newRecordLoc);
    }

    private final synchronized long writeRecord(long startLoc, byte[] key, byte[] data, long nextRecordLoc) throws Exception {
        int dataLen;
        int keyLen;
        int len;
        if (this.readOnly) {
            throw new IOException("Attempted to modify read-only database");
        }
        long contLoc = 0L;
        if (startLoc > 0L) {
            this.cache.removeBlock(startLoc);
            this.raFile.seek(startLoc + 1L);
            int oldKeyLen = this.raFile.readInt();
            int oldDataLen = this.raFile.readInt();
            if (oldDataLen + oldKeyLen > 1007) {
                this.raFile.writeLong(0L);
                contLoc = this.raFile.readLong();
            }
        }
        boolean willContinue = (len = (keyLen = key.length) + (dataLen = data.length)) + 17 > 1024;
        this.buf[0] = 1;
        int kl = key.length;
        int dl = data.length;
        this.buf[1] = (byte)((kl & 0xFF000000) >> 24);
        this.buf[2] = (byte)((kl & 0xFF0000) >> 16);
        this.buf[3] = (byte)((kl & 0xFF00) >> 8);
        this.buf[4] = (byte)(kl & 0xFF);
        this.buf[5] = (byte)((dl & 0xFF000000) >> 24);
        this.buf[6] = (byte)((dl & 0xFF0000) >> 16);
        this.buf[7] = (byte)((dl & 0xFF00) >> 8);
        this.buf[8] = (byte)(dl & 0xFF);
        this.buf[9] = (byte)((nextRecordLoc & 0xFF00000000000000L) >> 56);
        this.buf[10] = (byte)((nextRecordLoc & 0xFF000000000000L) >> 48);
        this.buf[11] = (byte)((nextRecordLoc & 0xFF0000000000L) >> 40);
        this.buf[12] = (byte)((nextRecordLoc & 0xFF00000000L) >> 32);
        this.buf[13] = (byte)((nextRecordLoc & 0xFF000000L) >> 24);
        this.buf[14] = (byte)((nextRecordLoc & 0xFF0000L) >> 16);
        this.buf[15] = (byte)((nextRecordLoc & 0xFF00L) >> 8);
        this.buf[16] = (byte)(nextRecordLoc & 0xFFL);
        if (willContinue) {
            long nextContLoc = this.writeContRecord(contLoc, key, data, 999);
            this.buf[17] = (byte)((nextContLoc & 0xFF00000000000000L) >> 56);
            this.buf[18] = (byte)((nextContLoc & 0xFF000000000000L) >> 48);
            this.buf[19] = (byte)((nextContLoc & 0xFF0000000000L) >> 40);
            this.buf[20] = (byte)((nextContLoc & 0xFF00000000L) >> 32);
            this.buf[21] = (byte)((nextContLoc & 0xFF000000L) >> 24);
            this.buf[22] = (byte)((nextContLoc & 0xFF0000L) >> 16);
            this.buf[23] = (byte)((nextContLoc & 0xFF00L) >> 8);
            this.buf[24] = (byte)(nextContLoc & 0xFFL);
            int written = Math.min(keyLen, 999);
            System.arraycopy(key, 0, this.buf, 25, written);
            if (written < 999) {
                System.arraycopy(data, 0, this.buf, 25 + written, 999 - written);
            }
        } else {
            System.arraycopy(key, 0, this.buf, 17, key.length);
            System.arraycopy(data, 0, this.buf, 17 + key.length, data.length);
            if (contLoc > 0L) {
                this.deleteContRecord(contLoc);
            }
        }
        if (startLoc <= 0L) {
            startLoc = this.getFreeBlock();
        }
        this.raFile.seek(startLoc);
        if (this.DEBUG) {
            System.err.println("  writing record at: " + Long.toHexString(startLoc));
        }
        this.raFile.write(this.buf);
        HashBlock block = new HashBlock();
        block.key = key;
        block.data = data;
        block.thisRecord = startLoc;
        block.nextRecord = nextRecordLoc;
        this.cache.putBlock(block);
        return startLoc;
    }

    private final synchronized void deleteContRecord(long startLoc) throws Exception {
        if (this.DEBUG) {
            System.err.println("  deleting contblock: " + Long.toHexString(startLoc));
        }
        if (this.readOnly) {
            throw new IOException("Attempted to modify read-only database");
        }
        this.raFile.seek(startLoc);
        this.raFile.readByte();
        int remainderLen = this.raFile.readInt();
        if (remainderLen > 1019) {
            this.deleteContRecord(this.raFile.readLong());
        }
        this.raFile.seek(startLoc);
        if (this.DEBUG) {
            System.err.println("writing unused marker at: " + Long.toHexString(startLoc));
        }
        this.raFile.writeByte(0);
        this.freeBlocks.addElement(startLoc);
    }

    private final synchronized long deleteStartRecord(long startLoc) throws Exception {
        if (this.readOnly) {
            throw new IOException("Attempted to modify read-only database");
        }
        this.raFile.seek(startLoc);
        this.raFile.readByte();
        int keyLen = this.raFile.readInt();
        int dataLen = this.raFile.readInt();
        long nextRecord = this.raFile.readLong();
        if (keyLen + dataLen > 1007) {
            this.deleteContRecord(this.raFile.readLong());
        }
        this.raFile.seek(startLoc);
        if (this.DEBUG) {
            System.err.println("writing unused marker at: " + Long.toHexString(startLoc));
        }
        this.raFile.writeByte(0);
        this.freeBlocks.addElement(startLoc);
        return nextRecord;
    }

    private final long writeContRecord(long startLoc, byte[] key, byte[] data, int currLoc) throws Exception {
        boolean willContinue;
        if (this.readOnly) {
            throw new IOException("Attempted to modify read-only database");
        }
        long contLoc = 0L;
        if (startLoc <= 0L) {
            startLoc = this.getFreeBlock();
        } else {
            this.raFile.seek(startLoc + 1L);
            int remainder = this.raFile.readInt();
            if (remainder > 1019) {
                contLoc = this.raFile.readLong();
            }
        }
        int keyLen = key.length;
        int dataLen = data.length;
        int len = keyLen + dataLen;
        int remainderLen = len - currLoc;
        boolean bl = willContinue = remainderLen + 5 > 1024;
        if (this.DEBUG) {
            System.err.println("  writing contblock at: " + Long.toHexString(startLoc));
        }
        this.raFile.seek(startLoc);
        this.raFile.writeByte(2);
        this.raFile.writeInt(remainderLen);
        if (willContinue) {
            long contPlaceHolder = this.raFile.getFilePointer();
            this.raFile.writeLong(0L);
            int written = 0;
            if (currLoc < keyLen) {
                written = Math.min(keyLen - currLoc, 1011);
                this.raFile.write(key, currLoc, written);
                currLoc += written;
            }
            if (written < 1011) {
                int bytesToWrite = 1011 - written;
                this.raFile.write(data, currLoc - keyLen, bytesToWrite);
                currLoc += bytesToWrite;
            }
            long nextContLoc = this.writeContRecord(contLoc, key, data, currLoc);
            this.raFile.seek(contPlaceHolder);
            this.raFile.writeLong(nextContLoc);
            this.raFile.seek(contPlaceHolder);
        } else {
            if (currLoc < keyLen) {
                this.raFile.write(key, currLoc, keyLen - currLoc);
                currLoc = keyLen;
            }
            this.raFile.write(data, currLoc - keyLen, dataLen - (currLoc - keyLen));
            currLoc += dataLen - (currLoc - keyLen);
            this.raFile.write(this.blankBytes, 0, 1019 - remainderLen);
            if (contLoc > 0L) {
                this.deleteContRecord(contLoc);
            }
        }
        return startLoc;
    }

    private final synchronized long getFreeBlock() throws Exception {
        int fbSize = this.freeBlocks.size();
        if (fbSize > 0) {
            long startLoc = (Long)this.freeBlocks.elementAt(fbSize - 1);
            this.freeBlocks.removeElementAt(fbSize - 1);
            return startLoc;
        }
        return this.raFile.length();
    }

    private final synchronized void loadFromFile() throws Exception {
        String fileID = this.raFile.readUTF();
        if (fileID == null || !fileID.equals(V1_FILE_ID)) {
            throw new Exception("Invalid file ID");
        }
        this.hashLength = this.raFile.readInt();
        if (this.hashLength < 0) {
            throw new IllegalArgumentException("The hash length (" + this.hashLength + ") must be >= 0");
        }
        this.tableStartIndex = this.raFile.getFilePointer();
        this.hashIndex = new long[this.hashLength];
        for (int i = 0; i < this.hashLength; ++i) {
            this.hashIndex[i] = this.raFile.readLong();
        }
        long filelen = this.raFile.length();
        for (long recLoc = this.dataSegmentStart = this.raFile.getFilePointer(); recLoc < filelen; recLoc += 1024L) {
            this.raFile.seek(recLoc);
            byte blockCode = this.raFile.readByte();
            if (blockCode != 0) continue;
            this.freeBlocks.addElement(recLoc);
        }
    }

    private final void initNewFile() throws Exception {
        if (this.readOnly) {
            throw new IOException("Attempted to modify read-only database");
        }
        DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.hashFile), 10000));
        out.writeUTF(V1_FILE_ID);
        out.writeInt(this.hashLength);
        for (int i = 0; i < this.hashLength; ++i) {
            out.writeLong(0L);
        }
        out.flush();
        out.close();
    }

    public synchronized void dumpDepthGraph() throws Exception {
        System.err.println("Dumping graph: ");
        for (int h = 0; h < this.hashIndex.length; ++h) {
            long index = this.hashIndex[h];
            if (index <= 0L) continue;
            do {
                HashBlock block = this.readBlock(index);
                index = block.nextRecord;
                System.err.print('X');
            } while (index > 0L);
            System.err.println("");
        }
    }

    public synchronized void dumpRecords(PrintStream out) {
        Enumeration<byte[][]> recs = this.getEnumerator();
        while (recs.hasMoreElements()) {
            byte[][] keydata = recs.nextElement();
            out.print(new String(keydata[0]));
            out.println("");
        }
    }

    public Enumeration<byte[][]> getEnumerator() {
        return new TableIterator();
    }

    public void dumpDataStructure(PrintStream out) {
        out.println("Dumping data structure: ");
        HashBlock block = null;
        long blockNum = 0L;
        for (int hash = 0; hash < this.hashIndex.length; ++hash) {
            while (hash < this.hashIndex.length && this.hashIndex[hash] == 0L) {
                ++hash;
            }
            if (hash >= this.hashIndex.length) break;
            blockNum = this.hashIndex[hash];
            out.println("Hash Index=" + hash + " location(h)=" + Long.toHexString(blockNum));
            do {
                try {
                    block = this.readBlock(blockNum);
                    blockNum = block.nextRecord;
                    out.println("   Read block# " + Long.toHexString(block.thisRecord) + '\n' + "         next# " + Long.toHexString(block.nextRecord) + '\n' + "       touched " + new Date(block.lastTouched) + '\n' + "           key " + new String(block.key) + '\n');
                }
                catch (Exception e) {
                    out.println("   Got exception reading block hash# " + hash + '\n' + "       block#" + Long.toHexString(blockNum) + '\n' + "       e: " + e);
                    blockNum = 0L;
                }
            } while (blockNum > 0L);
        }
    }

    private synchronized int hashOfKey(byte[] key) {
        byte[] digest = this.md5.digest(key);
        int digestLen = digest.length;
        int hash = 0xFF & digest[digestLen - 1] | (0xFF & digest[digestLen - 2]) << 8 | (0xFF & digest[digestLen - 3]) << 16 | (0xFF & digest[digestLen - 4]) << 24;
        int hashKey = (hash & Integer.MAX_VALUE) % this.hashLength;
        return hashKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyTo(File newJDBFile) throws Exception {
        if (this.DEBUG) {
            System.err.println("Backup JDB to:" + newJDBFile.getAbsolutePath());
        }
        if (newJDBFile == null) {
            throw new IOException("Invalid new JDB file, file can not be null");
        }
        FileInputStream in = null;
        OutputStream out = null;
        try {
            if (this.DEBUG) {
                System.err.println("Beginning copy of JDB file...");
            }
            in = new FileInputStream(this.hashFile);
            out = new FileOutputStream(newJDBFile);
            byte[] buf = new byte[100000];
            long fileLength = this.hashFile.length();
            int n = 0;
            int r = 0;
            while ((long)n < fileLength && (r = ((InputStream)in).read(buf)) > 0) {
                out.write(buf, 0, r);
            }
            if (this.DEBUG) {
                System.err.println("End copy ... ");
            }
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void main(String[] argv) throws Exception {
        if (argv.length != 1) {
            System.err.println("usage: java net.handle.jdb.DBHash <dbfile>");
        }
        String dbfile = argv[0];
        System.err.println("loading " + dbfile);
        DBHash db = new DBHash(new File(dbfile), 5000, 1000);
        System.err.println("dumping database...");
        db.dumpRecords(System.err);
    }

    class TableIterator
    implements Enumeration<byte[][]> {
        private int currentHash = -1;
        private HashBlock currentBlock = null;

        TableIterator() {
        }

        @Override
        public final boolean hasMoreElements() {
            if (this.currentBlock != null && this.currentBlock.nextRecord > 0L) {
                return true;
            }
            for (int h = this.currentHash + 1; h < DBHash.this.hashIndex.length; ++h) {
                if (DBHash.this.hashIndex[h] <= 0L) continue;
                return true;
            }
            return false;
        }

        @Override
        public final byte[][] nextElement() throws NoSuchElementException {
            try {
                while (this.currentBlock != null && this.currentBlock.nextRecord > 0L) {
                    this.currentBlock = DBHash.this.readBlock(this.currentBlock.nextRecord);
                    if (this.currentBlock == null || DBHash.this.hashOfKey(this.currentBlock.key) != this.currentHash) continue;
                    return new byte[][]{this.currentBlock.key, this.currentBlock.data};
                }
                while (this.currentHash < DBHash.this.hashIndex.length - 1) {
                    ++this.currentHash;
                    long block = DBHash.this.hashIndex[this.currentHash];
                    if (block <= 0L) continue;
                    this.currentBlock = DBHash.this.readBlock(block);
                    return new byte[][]{this.currentBlock.key, this.currentBlock.data};
                }
            }
            catch (Exception e) {
                System.err.println("Exception enumerating blocks: " + e);
                System.err.println("currentBlock=\"" + (this.currentBlock != null ? new String(this.currentBlock.key) + "\" at " + Long.toHexString(this.currentBlock.thisRecord) : "null"));
            }
            throw new NoSuchElementException();
        }
    }
}

