/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib;

import java.util.Arrays;
import net.handle.hdllib.AbstractMessage;
import net.handle.hdllib.AbstractRequest;
import net.handle.hdllib.AuthenticationInfo;
import net.handle.hdllib.ChallengeResponse;
import net.handle.hdllib.Common;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.Util;

public class SecretKeyAuthenticationInfo
extends AuthenticationInfo {
    private final byte[] secretKey;
    private final byte[] userIdHandle;
    private final int userIdIndex;

    public SecretKeyAuthenticationInfo(byte[] userIDHandle, int userIDIndex, byte[] secretKey) {
        this.secretKey = secretKey;
        this.userIdHandle = userIDHandle;
        this.userIdIndex = userIDIndex;
    }

    public SecretKeyAuthenticationInfo(byte[] userIDHandle, int userIDIndex, byte[] secretKey, boolean hash) throws Exception {
        this.secretKey = Encoder.encodeSecretKey(secretKey, hash);
        this.userIdHandle = userIDHandle;
        this.userIdIndex = userIDIndex;
    }

    @Override
    public byte[] getAuthType() {
        return Common.SECRET_KEY_TYPE;
    }

    @Override
    public byte[] authenticate(ChallengeResponse challenge, AbstractRequest request) throws HandleException {
        boolean oldFormat;
        byte lowerMinorProtocolVersion;
        byte lowerMajorProtocolVersion;
        byte[] origMessage = request.getEncodedMessageBody();
        byte[] origDigest = Util.doDigest(challenge.rdHashType, (byte[][])new byte[][]{origMessage});
        if (!Util.equals(origDigest, challenge.requestDigest)) {
            throw new HandleException(10, "Asked to sign unidentified request!");
        }
        byte digestAlg = 2;
        if (challenge.hasEqualOrGreaterVersion(challenge.suggestMajorProtocolVersion, challenge.suggestMinorProtocolVersion)) {
            lowerMajorProtocolVersion = challenge.suggestMajorProtocolVersion;
            lowerMinorProtocolVersion = challenge.suggestMinorProtocolVersion;
        } else {
            lowerMajorProtocolVersion = challenge.majorProtocolVersion;
            lowerMinorProtocolVersion = challenge.minorProtocolVersion;
        }
        boolean bl = oldFormat = !AbstractMessage.hasEqualOrGreaterVersion(lowerMajorProtocolVersion, lowerMinorProtocolVersion, 2, 1);
        if (oldFormat) {
            digestAlg = 0;
        } else if (AbstractMessage.hasEqualOrGreaterVersion(lowerMajorProtocolVersion, lowerMinorProtocolVersion, 2, 7)) {
            digestAlg = 34;
        }
        byte[] digest = Util.doMac(digestAlg, Util.concat(challenge.nonce, challenge.requestDigest), this.secretKey);
        if (oldFormat) {
            return digest;
        }
        byte[] authResponse = new byte[digest.length + 1];
        authResponse[0] = digestAlg;
        System.arraycopy(digest, 0, authResponse, 1, digest.length);
        return authResponse;
    }

    @Override
    public byte[] getUserIdHandle() {
        return this.userIdHandle;
    }

    @Override
    public int getUserIdIndex() {
        return this.userIdIndex;
    }

    public byte[] getSecretKey() {
        return this.secretKey;
    }

    public String toString() {
        return "secret_key:" + String.valueOf(this.userIdIndex) + ':' + (this.userIdHandle == null ? "null" : Util.decodeString(this.userIdHandle));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.secretKey);
        result = 31 * result + Arrays.hashCode(this.userIdHandle);
        result = 31 * result + this.userIdIndex;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SecretKeyAuthenticationInfo other = (SecretKeyAuthenticationInfo)obj;
        if (!Arrays.equals(this.secretKey, other.secretKey)) {
            return false;
        }
        if (!Arrays.equals(this.userIdHandle, other.userIdHandle)) {
            return false;
        }
        return this.userIdIndex == other.userIdIndex;
    }
}

