/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.security.PublicKey;
import java.util.HashSet;
import java.util.TimeZone;
import net.cnri.util.FastDateFormat;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleStorage;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.ReplicationStateInfo;
import net.handle.hdllib.RetrieveTxnRequest;
import net.handle.hdllib.SignedInputStream;
import net.handle.hdllib.SignedOutputStream;
import net.handle.hdllib.Transaction;
import net.handle.hdllib.TransactionCallback;
import net.handle.hdllib.TransactionQueueInterface;
import net.handle.hdllib.TransactionQueuesInterface;
import net.handle.hdllib.TransactionScannerInterface;
import net.handle.hdllib.Util;

public class RetrieveTxnResponse
extends AbstractResponse {
    private static FastDateFormat dateFormat = new FastDateFormat(new FastDateFormat.FormatSpec("-", " ", ":", "", ".", true, true), TimeZone.getDefault());
    public static final int NEED_TO_REDUMP = 1;
    public static final int SENDING_TRANSACTIONS = 2;
    private static final byte END_TRANSMISSION_RECORD = 0;
    private static final byte HANDLE_RECORD = 1;
    private static final byte NAME_OF_QUEUE_RECORD = 2;
    private static final byte END_OF_QUEUE_LAST_TIMESTAMP_RECORD = 3;
    public RetrieveTxnRequest req = null;
    public TransactionQueueInterface txnQueue = null;
    private HandleStorage storage = null;
    private boolean caseSensitive;
    private long lastTxnId = 0L;
    private long latestCommittedTxnId;
    private TransactionQueuesInterface txnQueues;
    private String ownReplicationServerName;
    private ReplicationStateInfo serversReplicationSourceSites;

    public RetrieveTxnResponse() {
        super(1001, 1);
        this.streaming = true;
    }

    public RetrieveTxnResponse(TransactionQueueInterface txnQueue, long latestCommittedTxnId, RetrieveTxnRequest req, HandleStorage storage, boolean caseSensitive) throws HandleException {
        super(req, 1);
        this.req = req;
        this.txnQueue = txnQueue;
        this.latestCommittedTxnId = latestCommittedTxnId;
        this.storage = storage;
        this.caseSensitive = caseSensitive;
        this.streaming = true;
        this.lastTxnId = req.lastTxnId;
    }

    public RetrieveTxnResponse(TransactionQueuesInterface allOtherTransactionQueues, String ownReplicationServerName, long latestCommittedTxnId, ReplicationStateInfo serversReplicationSourceSites, RetrieveTxnRequest req, HandleStorage storage, boolean caseSensitive) throws HandleException {
        super(req, 1);
        this.req = req;
        this.txnQueues = allOtherTransactionQueues;
        this.serversReplicationSourceSites = serversReplicationSourceSites;
        this.storage = storage;
        this.caseSensitive = caseSensitive;
        this.streaming = true;
        this.ownReplicationServerName = ownReplicationServerName;
        this.latestCommittedTxnId = latestCommittedTxnId;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int processStreamedPart(TransactionCallback callback, PublicKey sourceKey) throws HandleException {
        if (this.stream == null) {
            throw new HandleException(1, "Response stream not found");
        }
        int threadPriority = Thread.currentThread().getPriority();
        FilterInputStream in = null;
        SignedInputStream sin = null;
        long start = System.currentTimeMillis();
        int recordCount = 0;
        try {
            sin = new SignedInputStream(sourceKey, this.stream, this.socket);
            if (!this.secureStream && !sin.isSecure()) {
                throw new HandleException(10, "Insecure stream");
            }
            in = new DataInputStream(sin);
            int dataFormatVersion = ((DataInputStream)in).readInt();
            int status = ((DataInputStream)in).readInt();
            if (!sin.verifyBlock()) {
                throw new HandleException(10, "Invalid signature on replication stream");
            }
            String currentQueueName = null;
            while (true) {
                byte recordType;
                block47: {
                    block49: {
                        block48: {
                            if ((recordType = ((DataInputStream)in).readByte()) != 0) break block47;
                            if (dataFormatVersion > 1) break block48;
                            long sourceDate = ((DataInputStream)in).readLong();
                            if (!sin.verifyBlock()) {
                                throw new HandleException(10, "Invalid signature on replication stream");
                            }
                            if (status == 2) {
                                callback.finishProcessing(sourceDate);
                                break block49;
                            } else if (status == 1) {
                                callback.finishProcessing();
                            }
                            break block49;
                        }
                        if (!sin.verifyBlock()) {
                            throw new HandleException(10, "Invalid signature on replication stream");
                        }
                        callback.finishProcessing();
                    }
                    int sourceDate = status;
                    return sourceDate;
                }
                if (recordType == 1) {
                    ++recordCount;
                    Transaction txn = new Transaction();
                    txn.txnId = ((DataInputStream)in).readLong();
                    txn.handle = new byte[((DataInputStream)in).readInt()];
                    ((DataInputStream)in).readFully(txn.handle);
                    txn.action = ((DataInputStream)in).readByte();
                    txn.date = ((DataInputStream)in).readLong();
                    switch (txn.action) {
                        case 1: 
                        case 3: {
                            int numValues = ((DataInputStream)in).readInt();
                            txn.values = new HandleValue[numValues];
                            for (int i = 0; i < numValues; ++i) {
                                int r;
                                int valueSize = ((DataInputStream)in).readInt();
                                byte[] buf = new byte[valueSize];
                                for (int n = 0; n < valueSize && (r = ((DataInputStream)in).read(buf, n, valueSize - n)) >= 0; n += r) {
                                }
                                txn.values[i] = new HandleValue();
                                Encoder.decodeHandleValue(buf, 0, txn.values[i]);
                            }
                            break;
                        }
                    }
                    if (!sin.verifyBlock()) {
                        throw new HandleException(10, "Invalid signature on replication stream");
                    }
                    if (dataFormatVersion <= 1) {
                        callback.processTransaction(txn);
                    } else {
                        callback.processTransaction(currentQueueName, txn);
                    }
                    Thread.yield();
                    continue;
                }
                if (recordType == 2) {
                    int length = ((DataInputStream)in).readInt();
                    byte[] bytes = new byte[length];
                    ((DataInputStream)in).readFully(bytes);
                    if (!sin.verifyBlock()) {
                        throw new HandleException(10, "Invalid signature on replication stream");
                    }
                    currentQueueName = Util.decodeString(bytes);
                    continue;
                }
                if (recordType != 3) throw new HandleException(0, "Unknown transmission record type: " + recordType);
                long sourceDate = ((DataInputStream)in).readLong();
                if (!sin.verifyBlock()) {
                    throw new HandleException(10, "Invalid signature on replication stream");
                }
                callback.setQueueLastTimestamp(currentQueueName, sourceDate);
                continue;
                break;
            }
        }
        catch (Exception e) {
            if (!(e instanceof HandleException)) throw new HandleException(1, "Exception receiving transactions", e);
            throw (HandleException)e;
        }
        finally {
            if (recordCount > 20) {
                long end = System.currentTimeMillis();
                long durationInSeconds = (end - start) / 1000L;
                long millis = (end - start) % 1000L;
                System.err.println("\"" + dateFormat.formatNow() + "\" Processed " + recordCount + " records in " + durationInSeconds + "." + RetrieveTxnResponse.pad3(millis) + " seconds");
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception end) {}
            }
            if (sin != null) {
                try {
                    sin.close();
                }
                catch (Exception end) {}
            }
            if (this.stream != null) {
                try {
                    this.stream.close();
                }
                catch (Exception end) {}
            }
            try {
                Thread.currentThread().setPriority(threadPriority);
            }
            catch (Exception e) {
                System.err.println("Unable to upgrade thread priority: " + e);
            }
        }
    }

    private static String pad3(long millis) {
        if (millis < 10L) {
            return "00" + millis;
        }
        if (millis < 100L) {
            return "0" + millis;
        }
        return "" + millis;
    }

    @Override
    public void streamResponse(SignedOutputStream sout) throws HandleException {
        try {
            if (this.req.replicationStateInfo != null) {
                this.streamResponseForAllTransactions(sout);
            } else {
                this.streamResponseForThisServersTransactions(sout);
            }
        }
        catch (Exception e) {
            throw new HandleException(1, "Exception sending transactions: ", e);
        }
    }

    private boolean needsRedump(TransactionQueueInterface queue, long lastSafeTxnIdInQueue, long lastTxnId, long lastTimestamp) {
        if (lastSafeTxnIdInQueue <= 0L) {
            return false;
        }
        if (queue == null) {
            return lastSafeTxnIdInQueue > lastTxnId;
        }
        if (queue.getFirstDate() <= lastTimestamp) {
            return false;
        }
        if (lastTxnId <= 0L && queue.getFirstDate() + 864000000L > System.currentTimeMillis() && RetrieveTxnResponse.queueHasTransactionNumberOne(queue)) {
            return false;
        }
        if (lastTxnId <= 0L && queue.getFirstDate() <= lastTimestamp + 86400000L && RetrieveTxnResponse.queueHasTransactionNumberOne(queue)) {
            return false;
        }
        return lastTxnId <= 0L || queue.getFirstDate() > lastTimestamp + 86400000L || !RetrieveTxnResponse.queueStartsWithTransaction(queue, lastTxnId + 1L);
    }

    private static void logAboutNeedToRedumpResponse(String queueName, TransactionQueueInterface queue, long serversLastTxnId, long lastTxnId, long lastTimestamp) {
        System.err.println("NEED_TO_REDUMP sent about " + queueName + ": queue.lastTxnId=" + (queue == null ? "null" : Long.valueOf(queue.getLastTxnId())) + " serversLastTxnId=" + serversLastTxnId + " clientsLastTxnId=" + lastTxnId + " queue.firstDate=" + (queue == null ? "null" : Long.valueOf(queue.getFirstDate())) + " clientsLastTimestamp=" + lastTimestamp);
    }

    private void streamResponseForAllTransactions(SignedOutputStream sout) throws Exception {
        TransactionQueueInterface queue;
        long serversLastTxnId;
        DataOutputStream out = new DataOutputStream(sout);
        out.writeInt(2);
        ReplicationStateInfo sourceReplicationStateInfo = this.req.replicationStateInfo;
        long clientsLastTxnIdForThisServer = sourceReplicationStateInfo.getLastTxnId(this.ownReplicationServerName);
        long clientsLastTimestampForThisServer = sourceReplicationStateInfo.getLastTimestamp(this.ownReplicationServerName);
        TransactionQueueInterface thisServersTransactionQueue = this.txnQueues.getThisServersTransactionQueue();
        boolean needToRedump = false;
        if (thisServersTransactionQueue != null && (needToRedump = this.needsRedump(thisServersTransactionQueue, serversLastTxnId = this.latestCommittedTxnId, clientsLastTxnIdForThisServer, clientsLastTimestampForThisServer))) {
            RetrieveTxnResponse.logAboutNeedToRedumpResponse("this server", thisServersTransactionQueue, serversLastTxnId, clientsLastTxnIdForThisServer, clientsLastTimestampForThisServer);
        }
        HashSet<String> queueNames = new HashSet<String>(this.serversReplicationSourceSites.keySet());
        queueNames.addAll(this.txnQueues.listQueueNames());
        for (String queueName : queueNames) {
            long serversLastTxnId2;
            if (sourceReplicationStateInfo.isQueueNameInOwnSite(queueName)) continue;
            long clientsLastTxnId = sourceReplicationStateInfo.getLastTxnId(queueName);
            long clientsLastTimestamp = sourceReplicationStateInfo.getLastTimestamp(queueName);
            queue = this.txnQueues.getQueue(queueName);
            boolean thisQueueNeedsRedump = this.needsRedump(queue, serversLastTxnId2 = this.serversReplicationSourceSites.getLastTxnId(queueName), clientsLastTxnId, clientsLastTimestamp);
            if (thisQueueNeedsRedump) {
                RetrieveTxnResponse.logAboutNeedToRedumpResponse(queueName, queue, serversLastTxnId2, clientsLastTxnId, clientsLastTimestamp);
            }
            needToRedump = needToRedump || thisQueueNeedsRedump;
        }
        if (needToRedump) {
            out.writeInt(1);
            sout.signBlock();
        } else {
            out.writeInt(2);
            sout.signBlock();
            if (thisServersTransactionQueue != null) {
                out.writeByte(2);
                out.writeInt(Util.encodeString(this.ownReplicationServerName).length);
                out.write(Util.encodeString(this.ownReplicationServerName));
                sout.signBlock();
                this.forwardTransactions(this.txnQueues.getThisServersTransactionQueue(), this.latestCommittedTxnId, clientsLastTxnIdForThisServer, out, sout);
                out.writeByte(3);
                out.writeLong(System.currentTimeMillis());
                sout.signBlock();
            }
            for (String queueName : queueNames) {
                long serversLastTimestamp;
                if (sourceReplicationStateInfo.isQueueNameInOwnSite(queueName) || (serversLastTimestamp = this.getProxiedLastTimestampForQueueName(queueName)) <= 0L) continue;
                long clientsLastTxnId = sourceReplicationStateInfo.getLastTxnId(queueName);
                out.writeByte(2);
                out.writeInt(Util.encodeString(queueName).length);
                out.write(Util.encodeString(queueName));
                sout.signBlock();
                queue = this.txnQueues.getQueue(queueName);
                if (queue != null) {
                    this.forwardTransactions(queue, this.serversReplicationSourceSites.getLastTxnId(queueName), clientsLastTxnId, out, sout);
                }
                out.writeByte(3);
                out.writeLong(serversLastTimestamp);
                sout.signBlock();
            }
        }
        out.writeByte(0);
        sout.signBlock();
    }

    private long getProxiedLastTimestampForQueueName(String queueName) {
        return this.serversReplicationSourceSites.getLastTimestamp(queueName);
    }

    private void streamResponseForThisServersTransactions(SignedOutputStream sout) throws Exception {
        DataOutputStream out = new DataOutputStream(sout);
        out.writeInt(1);
        long serversLastTxnId = this.latestCommittedTxnId;
        boolean needToRedump = this.needsRedump(this.txnQueue, serversLastTxnId, this.lastTxnId, this.req.lastQueryDate);
        if (needToRedump) {
            RetrieveTxnResponse.logAboutNeedToRedumpResponse("this server", this.txnQueue, serversLastTxnId, this.lastTxnId, this.req.lastQueryDate);
            out.writeInt(1);
            sout.signBlock();
        } else {
            out.writeInt(2);
            sout.signBlock();
            this.forwardTransactions(this.txnQueue, this.latestCommittedTxnId, this.req.lastTxnId, out, sout);
        }
        out.writeByte(0);
        if (needToRedump) {
            out.writeLong(this.req.lastQueryDate);
        } else {
            out.writeLong(System.currentTimeMillis());
        }
        sout.signBlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean queueHasTransactionNumberOne(TransactionQueueInterface queue) {
        try (TransactionScannerInterface scanner = queue.getScanner(0L);){
            Transaction txn;
            while ((txn = scanner.nextTransaction()) != null) {
                if (txn.txnId == 1L) {
                    boolean bl = true;
                    return bl;
                }
                if (txn.txnId <= 1L) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            System.err.println("Exception checking first transaction");
            e.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean queueStartsWithTransaction(TransactionQueueInterface queue, long n) {
        try (TransactionScannerInterface scanner = queue.getScanner(0L);){
            Transaction txn = scanner.nextTransaction();
            if (txn != null) {
                if (txn.txnId == n) {
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            System.err.println("Exception checking first transaction");
            e.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forwardTransactions(TransactionQueueInterface queue, long latestSafeTxnIdInQueue, long lastTxnId, DataOutputStream out, SignedOutputStream sout) throws Exception {
        try (TransactionScannerInterface scanner = queue.getScanner(lastTxnId);){
            Transaction txn = null;
            while ((txn = scanner.nextTransaction()) != null) {
                if (txn.txnId <= lastTxnId) continue;
                if (txn.txnId > latestSafeTxnIdInQueue) {
                    break;
                }
                if (txn.action != 5 && txn.action != 4) {
                    boolean hashes;
                    switch (this.req.rcvrHashType) {
                        case 0: {
                            hashes = Math.abs(txn.hashOnNA % this.req.numServers) == this.req.serverNum;
                            break;
                        }
                        case 1: {
                            hashes = Math.abs(txn.hashOnId % this.req.numServers) == this.req.serverNum;
                            break;
                        }
                        case 2: {
                            hashes = Math.abs(txn.hashOnAll % this.req.numServers) == this.req.serverNum;
                            break;
                        }
                        default: {
                            System.err.println("Warning: unknown hash type (" + this.req.rcvrHashType + ") in RetrieveTxnRequest");
                            hashes = true;
                        }
                    }
                    if (!hashes) continue;
                }
                byte[][] hdlValue = null;
                if (txn.handle != null) {
                    hdlValue = this.storageGetRawHandleValues(txn.handle, null, null);
                }
                if (txn.action == 1 || txn.action == 3 ? hdlValue == null : txn.action == 2 && hdlValue != null) continue;
                out.writeByte(1);
                out.writeLong(txn.txnId);
                out.writeInt(txn.handle == null ? 0 : txn.handle.length);
                if (txn.handle != null) {
                    out.write(txn.handle, 0, txn.handle.length);
                }
                out.writeByte(txn.action);
                out.writeLong(txn.date);
                switch (txn.action) {
                    case 1: 
                    case 3: {
                        if (hdlValue == null) {
                            out.writeInt(0);
                            break;
                        }
                        out.writeInt(hdlValue.length);
                        for (byte[] element : hdlValue) {
                            if (element == null) {
                                out.writeInt(0);
                                continue;
                            }
                            out.writeInt(element.length);
                            out.write(element);
                        }
                        break;
                    }
                }
                sout.signBlock();
            }
        }
    }

    private byte[][] storageGetRawHandleValues(byte[] handle, int[] indexList, byte[][] typeList) throws HandleException {
        try {
            return this.storage.getRawHandleValues(this.caseSensitive ? handle : Util.upperCase(handle), indexList, typeList);
        }
        catch (HandleException e) {
            if (e.getCode() == 9) {
                return null;
            }
            throw e;
        }
    }
}

