/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib;

import net.handle.hdllib.AbstractRequest;

public class Interface {
    public static final byte ST_OUT_OF_SERVICE = 0;
    public static final byte ST_ADMIN = 1;
    public static final byte ST_QUERY = 2;
    public static final byte ST_ADMIN_AND_QUERY = 3;
    public static final byte SP_HDL_UDP = 0;
    public static final byte SP_HDL_TCP = 1;
    public static final byte SP_HDL_HTTP = 2;
    public static final byte SP_HDL_HTTPS = 3;
    public byte type;
    public int port;
    public byte protocol;

    public Interface(byte type, byte protocol, int port) {
        this.type = type;
        this.port = port;
        this.protocol = protocol;
    }

    public Interface cloneInterface() {
        Interface i2 = new Interface();
        i2.type = this.type;
        i2.port = this.port;
        i2.protocol = this.protocol;
        return i2;
    }

    public Interface() {
    }

    public boolean canHandleRequest(AbstractRequest req) {
        if ((req.streaming || req.requiresConnection) && this.protocol != 1 && this.protocol != 2 && this.protocol != 3) {
            return false;
        }
        if (req.isAdminRequest) {
            return this.type == 1 || this.type == 3;
        }
        return this.type == 2 || this.type == 3;
    }

    public String toString() {
        return Interface.typeName(this.type) + '/' + Interface.protocolName(this.protocol) + '/' + this.port;
    }

    public static final String typeName(byte type) {
        switch (type) {
            case 0: {
                return "out-of-service";
            }
            case 3: {
                return "adm+qry";
            }
            case 2: {
                return "qry";
            }
            case 1: {
                return "adm";
            }
        }
        return "UNKNOWN";
    }

    public static final String protocolName(byte protocol) {
        switch (protocol) {
            case 3: {
                return "HTTPS";
            }
            case 2: {
                return "HTTP";
            }
            case 1: {
                return "TCP";
            }
            case 0: {
                return "UDP";
            }
        }
        return "UNKNOWN";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.port;
        result = 31 * result + this.protocol;
        result = 31 * result + this.type;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Interface other = (Interface)obj;
        if (this.port != other.port) {
            return false;
        }
        if (this.protocol != other.protocol) {
            return false;
        }
        return this.type == other.type;
    }

    public static String canProcessMsg(AbstractRequest req, boolean processQueries, boolean processAdminRequests) {
        switch (req.opCode) {
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 300: 
            case 301: 
            case 302: 
            case 1000: 
            case 1001: 
            case 1002: 
            case 1003: {
                return processAdminRequests ? null : "Received admin request on non-admin interface";
            }
            case 1: {
                return processQueries ? null : "Received query request on non-query interface";
            }
            case 2: 
            case 200: 
            case 201: 
            case 400: 
            case 401: 
            case 402: {
                return null;
            }
        }
        System.err.println("Warning: cannot tell whether msg " + req + " is admin or not: unrecognized opcode!");
        return null;
    }
}

