/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib;

import java.util.Enumeration;
import net.cnri.util.StreamTable;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.ScanCallback;

public interface HandleStorage {
    public void init(StreamTable var1) throws Exception;

    public boolean haveNA(byte[] var1) throws HandleException;

    public void setHaveNA(byte[] var1, boolean var2) throws HandleException;

    public void createHandle(byte[] var1, HandleValue[] var2) throws HandleException;

    public boolean deleteHandle(byte[] var1) throws HandleException;

    public byte[][] getRawHandleValues(byte[] var1, int[] var2, byte[][] var3) throws HandleException;

    public void updateValue(byte[] var1, HandleValue[] var2) throws HandleException;

    public void scanHandles(ScanCallback var1) throws HandleException;

    public void scanNAs(ScanCallback var1) throws HandleException;

    public Enumeration<byte[]> getHandlesForNA(byte[] var1) throws HandleException;

    public void deleteAllRecords() throws HandleException;

    public void checkpointDatabase() throws HandleException;

    public void shutdown();

    default public boolean supportsDumpResumption() {
        return false;
    }

    default public void scanHandlesFrom(byte[] startingPoint, boolean inclusive, ScanCallback callback) throws HandleException {
        throw new UnsupportedOperationException();
    }

    default public void scanNAsFrom(byte[] startingPoint, boolean inclusive, ScanCallback callback) throws HandleException {
        throw new UnsupportedOperationException();
    }

    default public boolean exists(byte[] handle) throws HandleException {
        return this.getRawHandleValues(handle, null, null) != null;
    }

    default public void createOrUpdateRecord(byte[] handle, HandleValue[] values) throws HandleException {
        if (this.exists(handle)) {
            this.updateValue(handle, values);
        } else {
            this.createHandle(handle, values);
        }
    }
}

