/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import net.cnri.util.StringUtils;
import net.handle.hdllib.AbstractMessage;
import net.handle.hdllib.AbstractRequest;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.AuthenticationInfo;
import net.handle.hdllib.Cache;
import net.handle.hdllib.ChallengeAnswerRequest;
import net.handle.hdllib.ChallengeResponse;
import net.handle.hdllib.ClientSessionTracker;
import net.handle.hdllib.ClientSideSessionInfo;
import net.handle.hdllib.Common;
import net.handle.hdllib.Configuration;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.ErrorResponse;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.HappyEyeballsResolver;
import net.handle.hdllib.Interface;
import net.handle.hdllib.ListHandlesRequest;
import net.handle.hdllib.ListHandlesResponse;
import net.handle.hdllib.MemCache;
import net.handle.hdllib.MessageEnvelope;
import net.handle.hdllib.NamespaceInfo;
import net.handle.hdllib.RequestProcessor;
import net.handle.hdllib.ResolutionRequest;
import net.handle.hdllib.ResolutionResponse;
import net.handle.hdllib.ResponseMessageCallback;
import net.handle.hdllib.SSLEngineHelper;
import net.handle.hdllib.ScanCallback;
import net.handle.hdllib.ServerInfo;
import net.handle.hdllib.ServiceReferralResponse;
import net.handle.hdllib.SessionExchangeKeyRequest;
import net.handle.hdllib.SessionSetupInfo;
import net.handle.hdllib.SessionSetupRequest;
import net.handle.hdllib.SessionSetupResponse;
import net.handle.hdllib.SiteFilter;
import net.handle.hdllib.SiteInfo;
import net.handle.hdllib.Util;
import net.handle.hdllib.ValueReference;
import net.handle.security.HdlSecurityProvider;
import net.handle.util.LRUCacheTable;

public class HandleResolver
implements RequestProcessor {
    public boolean traceMessages = false;
    private static final byte[] HTTP_ACCEPT_HEADER = Util.encodeString("Accept: application/x-hdl-message\r\n");
    private static final byte[] HTTP_AGENT_HEADER = Util.encodeString("User-Agent: CNRI-HCL 2.0\r\n");
    private static final byte[] HTTP_CONTENT_TYPE_HEADER = Util.encodeString("Content-Type: application/x-hdl-message\r\n");
    private static final byte[] HTTP_NEWLINE = Util.encodeString("\r\n");
    private Random messageIDRandom;
    private Configuration config;
    boolean useIPv6FastFallback = true;
    int[] preferredProtocols = new int[]{0, 1, 2, 3};
    private final int recursionCountLimit = 40;
    private ClientSessionTracker resolverSessions = null;
    private int maxUDPDataSize = 492;
    private Cache secureCache = null;
    private Cache cache = null;
    private int[] udpRetryScheme = new int[]{500, 1000, 1500};
    private static final int CACHED_NOT_FOUND_TTL = 0;
    private int tcpTimeout = 60000;
    private boolean checkSignatures = true;
    private SiteFilter siteFilter;
    private int notFoundCacheTTL = 0;
    LRUCacheTable<String, Long> responseTimeTbl = new LRUCacheTable(1024);
    LRUCacheTable<String, Long> preferredPrimaryTbl = new LRUCacheTable(1024);
    private static final long USE_SAME_PRIMARY_MILLIS = 3600000L;
    private static final short IP_VERSION_6 = 6;
    private static final short IP_VERSION_4 = 4;
    private final int preferredEncryptionAlgorithm = 3;
    private static boolean hasIPv4Interface = true;
    private static boolean hasIPv6Interface = true;
    private volatile ExecutorService execServ;

    public HandleResolver() {
        this.setCache(new MemCache());
        this.setCertifiedCache(new MemCache());
        this.setSessionTracker(new ClientSessionTracker(new SessionSetupInfo()));
        try {
            this.messageIDRandom = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException nse) {
            this.messageIDRandom = new SecureRandom();
        }
        this.messageIDRandom.setSeed(System.nanoTime());
        this.setConfiguration(Configuration.defaultConfiguration());
    }

    private static void checkInterfaces(Enumeration<NetworkInterface> intfs) throws SocketException {
        while (intfs.hasMoreElements()) {
            NetworkInterface intf = intfs.nextElement();
            if (intf.isLoopback()) continue;
            Enumeration<InetAddress> addresses = intf.getInetAddresses();
            while (addresses.hasMoreElements()) {
                InetAddress address = addresses.nextElement();
                if (address instanceof Inet6Address) {
                    hasIPv6Interface = true;
                }
                if (address instanceof Inet4Address) {
                    hasIPv4Interface = true;
                }
                if (!hasIPv6Interface || !hasIPv4Interface) continue;
                return;
            }
            HandleResolver.checkInterfaces(intf.getSubInterfaces());
        }
    }

    public ExecutorService getExecutorService() {
        if (this.execServ != null) {
            return this.execServ;
        }
        return CachedThreadPoolHolder.execServ;
    }

    public void setExecutorService(ExecutorService execServ) {
        this.execServ = execServ;
    }

    public int[] protocolsByPreference() {
        int[] protocolList = new int[this.preferredProtocols.length];
        for (int i = 0; i < this.preferredProtocols.length; ++i) {
            protocolList[i] = this.preferredProtocols[i];
        }
        return protocolList;
    }

    public byte[] retrieveHandleIndexData(byte[] handle, int index) throws Exception {
        ResolutionRequest req = new ResolutionRequest(handle, null, new int[]{index}, null);
        req.certify = true;
        AbstractResponse response = this.processRequest(req);
        if (!(response instanceof ResolutionResponse)) {
            throw new Exception("Unable to verify resolve the handle/index \n" + response);
        }
        HandleValue[] values = ((ResolutionResponse)response).getHandleValues();
        if (values == null || values.length < 1) {
            throw new Exception("The index specified does not exist\n");
        }
        return values[0].getData();
    }

    SessionSetupRequest createSessionSetupRequest(AuthenticationInfo authInfo, SessionSetupInfo options, int majorProtocolVersion, int minorProtocolVersion) throws HandleException {
        if (options == null) {
            throw new HandleException(0, "Cannot create session setup request with null SessionSetupInfo");
        }
        SessionSetupRequest ssreq = new SessionSetupRequest();
        ssreq.keyExchangeMode = options.keyExchangeMode;
        if (authInfo != null) {
            ssreq.identityHandle = authInfo.getUserIdHandle();
            ssreq.identityIndex = authInfo.getUserIdIndex();
        }
        if (options.keyExchangeMode == 3) {
            ssreq.exchangeKeyHandle = options.exchangeKeyHandle;
            ssreq.exchangeKeyIndex = options.exchangeKeyIndex;
        } else if (options.keyExchangeMode == 1 || options.keyExchangeMode == 4) {
            options.initDHKeys();
            ssreq.publicKey = options.publicExchangeKey;
        }
        ssreq.certify = true;
        ssreq.encrypt = false;
        ssreq.returnRequestDigest = true;
        ssreq.majorProtocolVersion = (byte)majorProtocolVersion;
        ssreq.minorProtocolVersion = (byte)minorProtocolVersion;
        ssreq.setSupportedProtocolVersion();
        ssreq.encryptAllSessionMsg = options.encrypted;
        ssreq.authAllSessionMsg = options.authenticated;
        if (options.timeout > 0) {
            ssreq.timeout = options.timeout;
        }
        return ssreq;
    }

    public void setCache(Cache cache) {
        if (this.secureCache != null && this.secureCache == cache) {
            throw new RuntimeException("Error:  attempt to set the certified and regular cache to the same value");
        }
        this.cache = cache;
    }

    public void setCertifiedCache(Cache cache) {
        if (this.cache != null && this.cache == cache) {
            throw new RuntimeException("Error:  attempt to set the certified and regular cache to the same value");
        }
        this.secureCache = cache;
    }

    public void clearCaches() throws Exception {
        Cache c = this.secureCache;
        if (c != null) {
            c.clear();
        }
        if ((c = this.cache) != null) {
            c.clear();
        }
    }

    public void setSessionTracker(ClientSessionTracker sessionTracker) {
        this.resolverSessions = sessionTracker;
    }

    public ClientSessionTracker getSessionTracker() {
        return this.resolverSessions;
    }

    public void setConfiguration(Configuration config) {
        this.config = config;
        config.configureResolver(this);
    }

    public void setPreferredProtocols(int[] prefProtocols) {
        this.preferredProtocols = new int[prefProtocols.length];
        System.arraycopy(prefProtocols, 0, this.preferredProtocols, 0, this.preferredProtocols.length);
    }

    public void setMaxUDPDataSize(int newMaxUDPDataSize) {
        this.maxUDPDataSize = newMaxUDPDataSize;
    }

    public int getMaxUDPDataSize() {
        return this.maxUDPDataSize;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public void setTcpTimeout(int newTcpTimeout) {
        this.tcpTimeout = newTcpTimeout;
    }

    public int getTcpTimeout() {
        return this.tcpTimeout;
    }

    public boolean isUseIPv6FastFallback() {
        return this.useIPv6FastFallback;
    }

    public void setUseIPv6FastFallback(boolean useIPv6FastFallback) {
        this.useIPv6FastFallback = useIPv6FastFallback;
    }

    public SiteFilter getSiteFilter() {
        return this.siteFilter;
    }

    public void setSiteFilter(SiteFilter siteFilter) {
        this.siteFilter = siteFilter;
    }

    public int[] getUdpRetryScheme() {
        int[] urs = new int[this.udpRetryScheme.length];
        System.arraycopy(this.udpRetryScheme, 0, urs, 0, urs.length);
        return urs;
    }

    public void setUdpRetryScheme(int[] newudpRetryScheme) {
        this.udpRetryScheme = null;
        this.udpRetryScheme = new int[newudpRetryScheme.length];
        System.arraycopy(newudpRetryScheme, 0, this.udpRetryScheme, 0, this.udpRetryScheme.length);
    }

    public void setCheckSignatures(boolean checkSigs) {
        this.checkSignatures = checkSigs;
    }

    public HandleValue[] resolveHandle(String sHandle, String[] sTypes, int[] indexes) throws HandleException {
        if (sTypes == null) {
            sTypes = new String[]{};
        }
        if (indexes == null) {
            indexes = new int[]{};
        }
        byte[][] types = new byte[sTypes.length][];
        byte[] handle = Util.encodeString(sHandle);
        for (int i = 0; i < sTypes.length; ++i) {
            types[i] = Util.encodeString(sTypes[i]);
        }
        return this.resolveHandle(handle, types, indexes);
    }

    public HandleValue[] resolveHandle(byte[] handle, byte[][] types, int[] indexes) throws HandleException {
        if (types == null) {
            types = new byte[0][];
        }
        if (indexes == null) {
            indexes = new int[]{};
        }
        AbstractResponse response = this.processRequest(new ResolutionRequest(handle, (byte[][])types, indexes, null));
        if (response.responseCode == 100) {
            throw new HandleException(9);
        }
        if (response.responseCode == 200) {
            return new HandleValue[0];
        }
        if (response instanceof ErrorResponse) {
            String msg = Util.decodeString(((ErrorResponse)response).message);
            throw new HandleException(1, AbstractMessage.getResponseCodeMessage(response.responseCode) + ": " + msg);
        }
        HandleValue[] values = ((ResolutionResponse)response).getHandleValues();
        if (values == null) {
            return null;
        }
        if (((byte[][])types).length <= 0 && indexes.length <= 0) {
            return values;
        }
        int numValues = values.length;
        for (int i = 0; i < values.length; ++i) {
            if (((byte[][])types).length > 0 && Util.isParentTypeInArray(types, values[i].type) || indexes.length > 0 && Util.isInArray(indexes, values[i].index)) continue;
            values[i] = null;
            --numValues;
        }
        if (numValues == values.length) {
            return values;
        }
        HandleValue[] filteredVals = new HandleValue[numValues];
        int j = 0;
        for (HandleValue value : values) {
            if (value == null) continue;
            filteredVals[j++] = value;
        }
        return filteredVals;
    }

    public HandleValue[] resolveHandle(String sHandle) throws HandleException {
        return this.resolveHandle(sHandle, null, null);
    }

    public HandleValue[] resolveHandle(byte[] handle) throws HandleException {
        return this.resolveHandle(handle, null, null);
    }

    public HandleValue resolveValueReference(ValueReference valueReference) throws HandleException {
        HandleValue[] values = this.resolveHandle(valueReference.handle, null, new int[]{valueReference.index});
        if (values == null || values.length == 0) {
            return null;
        }
        return values[0];
    }

    public void listHandlesUnderPrefix(String prefixHandle, AuthenticationInfo authInfo, ScanCallback callback) throws HandleException {
        byte[] prefixHandleBytes = Util.encodeString(prefixHandle);
        SiteInfo[] sites = this.findLocalSitesForNA(prefixHandleBytes);
        SiteInfo primarySite = Util.getPrimarySite(sites);
        this.listHandlesUnderPrefixAtSite(prefixHandle, primarySite, authInfo, callback);
    }

    public void listHandlesUnderPrefixAtSite(String prefixHandle, SiteInfo site, AuthenticationInfo authInfo, ScanCallback callback) throws HandleException {
        byte[] prefixHandleBytes = Util.encodeString(prefixHandle);
        for (ServerInfo server : site.servers) {
            ListHandlesRequest listReq = new ListHandlesRequest(prefixHandleBytes, authInfo);
            this.sendRequestToServer((AbstractRequest)listReq, site, server, (AbstractResponse message) -> {
                if (message instanceof ListHandlesResponse) {
                    for (byte[] handle : ((ListHandlesResponse)message).handles) {
                        callback.scanHandle(handle);
                    }
                } else {
                    throw HandleException.ofResponse(message);
                }
            });
        }
    }

    public AbstractResponse processRequest(AbstractRequest req, ResponseMessageCallback callback) throws HandleException {
        switch (this.config.getResolutionMethod()) {
            case 1: {
                SiteInfo[] cacheSites;
                if (!req.isAdminRequest && !req.requiresConnection && req.ignoreRestrictedValues && (cacheSites = this.config.getCacheSites()) != null && cacheSites.length > 0) {
                    return this.sendRequestToService(req, this.config.getCacheSites(), true, callback);
                }
                return this.processRequestGlobally(req, callback);
            }
        }
        return this.processRequestGlobally(req, callback);
    }

    public AbstractResponse processRequest(AbstractRequest req) throws HandleException {
        return this.processRequest(req, (ResponseMessageCallback)null);
    }

    @Override
    public AbstractResponse processRequest(AbstractRequest req, InetAddress caller) throws HandleException {
        return this.processRequest(req);
    }

    @Override
    public void processRequest(AbstractRequest req, InetAddress caller, ResponseMessageCallback callback) throws HandleException {
        this.processRequest(req, callback);
    }

    private AbstractResponse processRequestGlobally(AbstractRequest req, ResponseMessageCallback callback) throws HandleException {
        return this.sendRequestToService(req, this.findLocalSites(req), true, callback);
    }

    public AbstractResponse processRequestGlobally(AbstractRequest req) throws HandleException {
        return this.processRequestGlobally(req, null);
    }

    private ServiceInfo globalServiceInfo(byte[] handle) {
        ServiceInfo res = new ServiceInfo();
        res.response = null;
        res.sites = this.config.getLocalSites(handle);
        if (res.sites == null) {
            res.sites = this.getGlobalSites();
        }
        res.ns = this.config.getGlobalNamespace();
        res.values = this.config.getGlobalValues();
        return res;
    }

    private SiteInfo[] getGlobalSites() {
        SiteInfo[] res = this.config.getLocalSites(Common.ROOT_HANDLE);
        if (res != null) {
            return res;
        }
        return this.config.getGlobalSites();
    }

    private void getServiceInfoForNA(ResolutionRequest resReq, SiteInfo[] sites, ServiceInfo service, boolean forceResolution, boolean findPrefixReferralSites) throws HandleException {
        resReq.clearBuffers();
        service.response = null;
        service.sites = null;
        service.ns = null;
        service.values = null;
        SiteInfo[] localSites = this.config.getLocalSites(resReq.handle);
        if (localSites != null) {
            service.sites = localSites;
            if (!forceResolution) {
                return;
            }
        }
        if (resReq.recursionCount >= 40) {
            throw new HandleException(2, "Encountered recursion limit looking for service for handle " + Util.decodeString(resReq.handle));
        }
        if (sites == null) {
            sites = this.getGlobalSites();
        }
        service.response = this.sendRequestToService(resReq, sites, true, null);
        if (service.response.responseCode == 1) {
            HandleValue[] values = ((ResolutionResponse)service.response).getHandleValues();
            service.values = values;
            service.ns = Util.getNamespaceFromValues(Util.decodeString(resReq.handle), values);
            if (service.sites == null) {
                this.populateServiceInfoSites(resReq, service, values, findPrefixReferralSites);
            }
        }
    }

    private SiteInfo[] getSitesFromReferralValues(HandleValue[] values, boolean findPrefixReferralSites, AbstractRequest origRequest) throws HandleException {
        if (values == null || values.length == 0) {
            return null;
        }
        ResolutionRequest resReq = new ResolutionRequest(Common.BLANK_HANDLE, findPrefixReferralSites ? Common.SITE_INFO_AND_SERVICE_HANDLE_INCL_PREFIX_TYPES : Common.SITE_INFO_AND_SERVICE_HANDLE_TYPES, null, null);
        resReq.authoritative = false;
        resReq.sessionInfo = null;
        resReq.sessionTracker = null;
        resReq.encrypt = false;
        resReq.requestedTypes = findPrefixReferralSites ? Common.SITE_INFO_AND_SERVICE_HANDLE_INCL_PREFIX_TYPES : Common.SITE_INFO_AND_SERVICE_HANDLE_TYPES;
        resReq.recursionCount = origRequest.recursionCount;
        ServiceInfo service = new ServiceInfo();
        this.populateServiceInfoSites(resReq, service, values, findPrefixReferralSites);
        origRequest.recursionCount = resReq.recursionCount;
        if (findPrefixReferralSites && service.prefixSites != null && service.prefixSites.length >= 0) {
            return service.prefixSites;
        }
        return service.sites;
    }

    private void populateServiceInfoSites(ResolutionRequest resReq, ServiceInfo service, HandleValue[] values, boolean findPrefixReferralSites) throws HandleException {
        LinkedHashSet<SiteInfo> sites = new LinkedHashSet<SiteInfo>();
        LinkedHashSet<SiteInfo> prefixSites = findPrefixReferralSites ? new LinkedHashSet<SiteInfo>() : null;
        HashSet<String> visitedHandles = new HashSet<String>();
        visitedHandles.add(Util.decodeString(resReq.handle));
        HandleException exception = this.populateServiceInfoSitesHelper(resReq, values, visitedHandles, sites, prefixSites, findPrefixReferralSites, false, 0);
        SiteInfo[] siteArray = sites.isEmpty() ? null : sites.toArray(new SiteInfo[sites.size()]);
        SiteInfo[] prefixSiteArray = prefixSites == null || prefixSites.isEmpty() ? null : prefixSites.toArray(new SiteInfo[prefixSites.size()]);
        service.prefixSites = prefixSiteArray;
        service.sites = siteArray;
        if (!(service.sites != null || findPrefixReferralSites && service.prefixSites != null || exception == null)) {
            throw exception;
        }
    }

    private HandleException populateServiceInfoSitesHelper(ResolutionRequest resReq, HandleValue[] values, Set<String> visitedHandles, Set<SiteInfo> sites, Set<SiteInfo> prefixSites, boolean findPrefixReferralSites, boolean prefixOnly, int depth) {
        List<byte[]> serviceHandles;
        SiteInfo[] prefixSiteArray;
        SiteInfo[] siteArray;
        if (!prefixOnly && (siteArray = Util.getSitesAndAltSitesFromValues(values, Common.SITE_INFO_TYPES)) != null) {
            for (SiteInfo site : siteArray) {
                sites.add(site);
            }
        }
        if (findPrefixReferralSites && (prefixSiteArray = Util.getSitesAndAltSitesFromValues(values, Common.DERIVED_PREFIX_SITE_INFO_TYPES)) != null) {
            for (SiteInfo site : prefixSiteArray) {
                prefixSites.add(site);
            }
        }
        if (depth >= 20) {
            return null;
        }
        HandleException exception = null;
        if (!prefixOnly) {
            serviceHandles = HandleResolver.getServiceHandlesFromValues(values, false);
            exception = this.processServiceHandles(resReq, visitedHandles, sites, prefixSites, false, depth, serviceHandles);
        }
        if (findPrefixReferralSites) {
            serviceHandles = HandleResolver.getServiceHandlesFromValues(values, true);
            HandleException otherEx = this.processServiceHandles(resReq, visitedHandles, sites, prefixSites, true, depth, serviceHandles);
            if (exception == null) {
                exception = otherEx;
            }
        }
        return exception;
    }

    private HandleException processServiceHandles(ResolutionRequest resReq, Set<String> visitedHandles, Set<SiteInfo> sites, Set<SiteInfo> prefixSites, boolean isPrefixServiceHandle, int depth, List<byte[]> serviceHandles) {
        HandleException exception = null;
        if (serviceHandles != null) {
            for (byte[] serviceHandle : serviceHandles) {
                String serviceHandleString = Util.decodeString(serviceHandle);
                if (!visitedHandles.add(serviceHandleString)) continue;
                if (Util.equalsCI(Common.ROOT_HANDLE, serviceHandle)) {
                    for (SiteInfo site : this.getGlobalSites()) {
                        if (isPrefixServiceHandle) {
                            prefixSites.add(site);
                            continue;
                        }
                        sites.add(site);
                    }
                    continue;
                }
                try {
                    resReq.recursionCount = (short)(resReq.recursionCount + 1);
                    if (resReq.recursionCount >= 40) {
                        throw new HandleException(29, "Recursion limit exceeded on service lookup of " + Util.decodeString(serviceHandle));
                    }
                    ResolutionRequest svcReq = new ResolutionRequest(serviceHandle, isPrefixServiceHandle ? Common.DERIVED_PREFIX_SITE_AND_SERVICE_HANDLE_TYPES : Common.SITE_INFO_AND_SERVICE_HANDLE_TYPES, null, null);
                    svcReq.takeValuesFrom(resReq);
                    svcReq.authoritative = false;
                    AbstractResponse svcRes = this.processRequest(svcReq);
                    if (svcRes.responseCode != 1) continue;
                    HandleValue[] serviceHandleValues = ((ResolutionResponse)svcRes).getHandleValues();
                    HandleException subEx = this.populateServiceInfoSitesHelper(resReq, serviceHandleValues, visitedHandles, sites, prefixSites, isPrefixServiceHandle, isPrefixServiceHandle, depth + 1);
                    if (exception != null) continue;
                    exception = subEx;
                }
                catch (HandleException e) {
                    if (exception != null) continue;
                    exception = e;
                }
            }
        }
        return exception;
    }

    private static List<byte[]> getServiceHandlesFromValues(HandleValue[] values, boolean findPrefixReferralSites) {
        ArrayList<byte[]> result = null;
        for (int i = 0; values != null && i < values.length; ++i) {
            if (!findPrefixReferralSites && Util.equals(values[i].type, Common.SERVICE_HANDLE_TYPE)) {
                if (result == null) {
                    result = new ArrayList<byte[]>();
                }
                result.add(values[i].data);
                continue;
            }
            if (!findPrefixReferralSites || !Util.equals(values[i].type, Common.DERIVED_PREFIX_SERVICE_HANDLE_TYPE)) continue;
            if (result == null) {
                result = new ArrayList();
            }
            result.add(values[i].data);
        }
        return result;
    }

    public SiteInfo[] findLocalSitesForNA(byte[] naHandle) throws HandleException {
        return this.findLocalSitesForNA(naHandle, null);
    }

    private SiteInfo[] findLocalSitesForNA(byte[] naHandle, AbstractRequest origRequest) throws HandleException {
        ResolutionRequest resReq = new ResolutionRequest(naHandle, Common.SITE_INFO_AND_SERVICE_HANDLE_TYPES, null, null);
        resReq.authoritative = false;
        resReq.sessionInfo = null;
        resReq.sessionTracker = null;
        resReq.encrypt = false;
        resReq.requestedTypes = Common.SITE_INFO_AND_SERVICE_HANDLE_TYPES;
        resReq.recursionCount = origRequest == null ? (short)0 : origRequest.recursionCount;
        ServiceInfo service = new ServiceInfo();
        this.getServiceInfoForNA(resReq, this.findLocalSites(resReq), service, false, false);
        if (origRequest != null) {
            origRequest.recursionCount = resReq.recursionCount;
        }
        return service.sites;
    }

    private SiteInfo[] findPrefixReferralSitesForNA(byte[] naHandle, AbstractRequest origRequest) throws HandleException {
        ResolutionRequest resReq = new ResolutionRequest(naHandle, Common.SITE_INFO_AND_SERVICE_HANDLE_INCL_PREFIX_TYPES, null, null);
        resReq.authoritative = false;
        resReq.sessionInfo = null;
        resReq.sessionTracker = null;
        resReq.encrypt = false;
        resReq.requestedTypes = Common.SITE_INFO_AND_SERVICE_HANDLE_INCL_PREFIX_TYPES;
        resReq.recursionCount = origRequest == null ? (short)0 : origRequest.recursionCount;
        ServiceInfo service = new ServiceInfo();
        this.getServiceInfoForNA(resReq, this.findLocalSites(resReq), service, false, true);
        if (origRequest != null) {
            origRequest.recursionCount = resReq.recursionCount;
        }
        return service.prefixSites;
    }

    private ServiceInfo getServiceInfo(AbstractRequest req, boolean forceResolution) throws HandleException {
        if (Util.startsWithCI(req.handle, Common.GLOBAL_NA_PREFIX) || Util.startsWithCI(req.handle, Common.GLOBAL_NA) || !Util.hasSlash(req.handle)) {
            req.setNamespace(this.config.getGlobalNamespace());
            return this.globalServiceInfo(Util.getZeroNAHandle(req.handle));
        }
        req.setNamespace(this.config.getGlobalNamespace());
        ServiceInfo service = new ServiceInfo();
        ResolutionRequest resReq = this.buildPrefixResolutionRequest(req);
        this.getServiceInfoForNA(resReq, null, service, forceResolution, false);
        if (service.sites != null) {
            if (service.ns != null) {
                req.setNamespace(service.ns);
            }
        } else {
            this.tryAuthGlobalServiceLookupAndThrowExceptionOnFailure(req, resReq, service);
        }
        return service;
    }

    private ResolutionRequest buildPrefixResolutionRequest(AbstractRequest req) {
        ResolutionRequest resReq = new ResolutionRequest(Util.getZeroNAHandle(req.handle), Common.SITE_INFO_AND_SERVICE_HANDLE_AND_NAMESPACE_TYPES, null, null);
        resReq.takeValuesFrom(req);
        resReq.ignoreRestrictedValues = true;
        resReq.authoritative = false;
        resReq.sessionInfo = null;
        resReq.sessionTracker = null;
        resReq.encrypt = false;
        resReq.recursionCount = (short)(req.recursionCount + 1);
        resReq.requestedTypes = Common.SITE_INFO_AND_SERVICE_HANDLE_AND_NAMESPACE_TYPES;
        return resReq;
    }

    private void tryAuthGlobalServiceLookupAndThrowExceptionOnFailure(AbstractRequest req, ResolutionRequest resReq, ServiceInfo service) throws HandleException {
        resReq.authoritative = true;
        resReq.handle = Util.getZeroNAHandle(req.handle);
        this.getServiceInfoForNA(resReq, null, service, false, false);
        if (service.ns != null) {
            req.setNamespace(service.ns);
        }
        if (service.sites == null) {
            throw new HandleException(2, "Unable to find service for prefix " + Util.decodeString(resReq.handle) + "; prefix resolution response: " + service.response);
        }
    }

    public SiteInfo[] findLocalSites(AbstractRequest req) throws HandleException {
        return this.getServiceInfo((AbstractRequest)req, (boolean)false).sites;
    }

    @Deprecated
    public byte[] getNAHandle(byte[] handle) {
        return Util.getZeroNAHandle(handle);
    }

    @Deprecated
    public byte[] getNAHandle(ResolutionRequest resReq) {
        return Util.getZeroNAHandle(resReq.handle);
    }

    public NamespaceInfo getNamespaceInfo(ResolutionRequest resReq) throws HandleException {
        return this.getServiceInfo((AbstractRequest)resReq, (boolean)true).ns;
    }

    public final AbstractResponse sendRequestToService(AbstractRequest req, SiteInfo[] sites, ResponseMessageCallback callback) throws HandleException {
        return this.sendRequestToService(req, sites, false, callback);
    }

    public AbstractResponse sendRequestToService(AbstractRequest req, SiteInfo[] sites) throws HandleException {
        return this.sendRequestToService(req, sites, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractResponse sendRequestToService(AbstractRequest req, SiteInfo[] sites, boolean cacheResult, ResponseMessageCallback callback) throws HandleException {
        ServiceReferralResponse srresp;
        Cache cache;
        if (sites == null) {
            throw new HandleException(2, "No sites found");
        }
        boolean isCacheable = cacheResult && req.opCode == 1;
        SiteInfo[] ipv6Sites = null;
        SiteInfo[] ipv4Sites = null;
        Cache cache2 = cache = req.certify ? this.secureCache : this.cache;
        if (cache != null && req.opCode == 1) {
            AbstractResponse resp = this.resolveFromCache(req, cache);
            if (resp != null) {
                if (callback != null) {
                    callback.handleResponse(resp);
                }
                return resp;
            }
        } else if (req.opCode == 102 || req.opCode == 100 || req.opCode == 101 || req.opCode == 104 || req.opCode == 103) {
            try {
                if (this.cache != null) {
                    this.cache.removeHandle(Util.upperCasePrefix(req.handle));
                }
                if (this.secureCache != null && this.secureCache != this.cache) {
                    this.secureCache.removeHandle(Util.upperCasePrefix(req.handle));
                }
            }
            catch (Throwable e) {
                System.err.println("Cache remove error: " + e);
                e.printStackTrace(System.err);
            }
        }
        sites = this.filterSitesForRequest(sites, req);
        sites = this.adjustSitesForDomains(sites);
        ipv6Sites = HandleResolver.getIpSites(sites, (short)6);
        ipv4Sites = HandleResolver.getIpSites(sites, (short)4);
        SiteInfo preferredPrimary = null;
        int primaries = 0;
        if (req.isAdminRequest || req.authoritative) {
            primaries = HandleResolver.getNumPrimaries(sites);
            preferredPrimary = this.getPreferredPrimary(sites);
        }
        this.setResponseTimesOfSites(sites);
        ipv6Sites = Util.orderSitesByPreference(ipv6Sites);
        ipv4Sites = Util.orderSitesByPreference(ipv4Sites);
        HappyEyeballsResolver resolver6 = null;
        HappyEyeballsResolver resolver4 = null;
        Future<?> alternateThreadFuture = null;
        boolean preferIPv4Stack = Boolean.parseBoolean(System.getProperty("java.net.preferIPv4Stack"));
        AbstractResponse resp = null;
        try {
            req.multithread = false;
            req.completed.set(false);
            req.socketRef.set(null);
            if (preferIPv4Stack || !hasIPv6Interface || ipv6Sites.length == 0) {
                resolver4 = new HappyEyeballsResolver(this, ipv4Sites, req, callback, primaries, preferredPrimary, 0, false);
                resolver6 = new HappyEyeballsResolver();
                resolver4.run();
            } else if (!hasIPv4Interface || ipv4Sites.length == 0) {
                resolver6 = new HappyEyeballsResolver(this, ipv6Sites, req, callback, primaries, preferredPrimary, 0, false);
                resolver4 = new HappyEyeballsResolver();
                resolver6.run();
            } else if (this.useIPv6FastFallback) {
                req.multithread = true;
                resolver6 = new HappyEyeballsResolver(this, ipv6Sites, req.clone(), callback, primaries, preferredPrimary, 0, false);
                resolver6.siblingResolver = resolver4 = new HappyEyeballsResolver(this, ipv4Sites, req.clone(), callback, primaries, preferredPrimary, 300, preferredPrimary != null);
                resolver4.siblingResolver = resolver6;
                alternateThreadFuture = this.getExecutorService().submit(resolver4);
                resolver6.run();
            } else {
                SiteInfo[] allSites6First = new SiteInfo[ipv6Sites.length + ipv4Sites.length];
                System.arraycopy(ipv6Sites, 0, allSites6First, 0, ipv6Sites.length);
                System.arraycopy(ipv4Sites, 0, allSites6First, ipv6Sites.length, ipv4Sites.length);
                resolver6 = new HappyEyeballsResolver(this, allSites6First, req, callback, primaries, preferredPrimary, 0, false);
                resolver4 = new HappyEyeballsResolver();
                resolver6.run();
            }
            if (alternateThreadFuture != null) {
                try {
                    if (!alternateThreadFuture.isDone()) {
                        if (resolver6.resp != null) {
                            alternateThreadFuture.cancel(true);
                        } else {
                            alternateThreadFuture.get();
                        }
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof RuntimeException) {
                        throw (RuntimeException)cause;
                    }
                    if (cause instanceof Error) {
                        throw (Error)cause;
                    }
                    throw new AssertionError((Object)cause);
                }
                catch (CancellationException e) {
                    // empty catch block
                }
            }
            if (resolver4.resp != null) {
                resp = resolver4.resp;
                if (req.multithread) {
                    req.takeValuesFromRequestActuallyUsed(resolver4.req);
                }
            } else if (resolver6.resp != null) {
                resp = resolver6.resp;
                if (req.multithread) {
                    req.takeValuesFromRequestActuallyUsed(resolver6.req);
                }
            }
            if (resp == null) {
                if (resolver4.publicException != null) {
                    if (req.multithread) {
                        req.takeValuesFromRequestActuallyUsed(resolver4.req);
                        throw new HandleException(resolver4.publicException.getCode(), resolver4.publicException.getMessage(), resolver4.publicException);
                    }
                    throw resolver4.publicException;
                }
                if (resolver6.publicException != null) {
                    if (req.multithread) {
                        req.takeValuesFromRequestActuallyUsed(resolver6.req);
                    }
                    throw resolver6.publicException;
                }
                throw new HandleException(3, "Cannot contact an acceptable interface");
            }
        }
        finally {
            req.multithread = false;
            req.completed.set(false);
            req.socketRef.set(null);
        }
        if (cacheResult && resp.responseCode == 302) {
            req = this.newRequestForReferral(req);
            req.recursionCount = (short)(req.recursionCount + 1);
            if (req.recursionCount >= 40) {
                throw new HandleException(29, "Recursion limit exceeded on service referral for " + Util.decodeString(req.handle));
            }
            srresp = (ServiceReferralResponse)resp;
            SiteInfo[] referralSites = this.getSitesFromReferralValues(srresp.getHandleValues(), false, req);
            if (referralSites == null && srresp.handle.length > 0) {
                referralSites = this.findLocalSitesForNA(srresp.handle, req);
            }
            if (referralSites == null) {
                throw new HandleException(29, "Unable to find sites for service referral");
            }
            return this.sendRequestToService(req, referralSites, cacheResult, callback);
        }
        if (cacheResult && (Util.startsWithCI(req.handle, Common.NA_HANDLE_PREFIX) || !Util.hasSlash(req.handle)) && resp.responseCode == 303) {
            req = this.newRequestForReferral(req);
            req.recursionCount = (short)(req.recursionCount + 1);
            if (req.recursionCount >= 40) {
                throw new HandleException(29, "Recursion limit exceeded on prefix referral for " + Util.decodeString(req.handle));
            }
            srresp = (ServiceReferralResponse)resp;
            HandleValue[] values = srresp.getHandleValues();
            SiteInfo[] prefixSites = this.getSitesFromReferralValues(values, true, req);
            if (prefixSites == null && srresp.handle.length > 0) {
                prefixSites = this.findPrefixReferralSitesForNA(srresp.handle, req);
            }
            if (prefixSites == null) {
                throw new HandleException(29, "Unable to find sites for prefix referral");
            }
            return this.sendRequestToService(req, prefixSites, cacheResult, callback);
        }
        this.cacheResponse(resp, req, isCacheable, cache);
        if (resp.responseCode == 300) {
            this.config.notifyRootInfoOutdated(this);
        }
        return resp;
    }

    private AbstractRequest newRequestForReferral(AbstractRequest req) {
        AbstractRequest result = req.clone();
        req.clearBuffers();
        result.sessionInfo = null;
        return result;
    }

    private SiteInfo[] filterSitesForRequest(SiteInfo[] sites, AbstractRequest req) {
        if (sites == null) {
            return null;
        }
        if (this.siteFilter == null) {
            return sites;
        }
        ArrayList<SiteInfo> filteredSites = new ArrayList<SiteInfo>(sites.length);
        for (SiteInfo site : sites) {
            if (!this.siteFilter.apply(site)) continue;
            filteredSites.add(site);
        }
        if (filteredSites.size() == sites.length || filteredSites.isEmpty()) {
            return sites;
        }
        SiteInfo[] res = filteredSites.toArray(new SiteInfo[filteredSites.size()]);
        if ((req.isAdminRequest || req.authoritative) && HandleResolver.getNumPrimaries(res) == 0) {
            for (SiteInfo site : sites) {
                if (!site.isPrimary) continue;
                filteredSites.add(site);
            }
            res = filteredSites.toArray(new SiteInfo[filteredSites.size()]);
        }
        return res;
    }

    private static SiteInfo[] getIpSites(SiteInfo[] sites, short protocol) {
        boolean ipv6Site;
        int arraySize = 0;
        int sitesFound = 0;
        SiteInfo[] matchingSites = null;
        if (sites == null) {
            return null;
        }
        for (SiteInfo site : sites) {
            ipv6Site = false;
            for (ServerInfo server : site.servers) {
                if (server.isIPv4()) continue;
                ipv6Site = true;
                break;
            }
            if ((!ipv6Site || protocol != 6) && (ipv6Site || protocol != 4)) continue;
            ++arraySize;
        }
        if (arraySize == 0) {
            return null;
        }
        matchingSites = new SiteInfo[arraySize];
        for (SiteInfo site : sites) {
            ipv6Site = false;
            for (ServerInfo server : site.servers) {
                if (server.isIPv4()) continue;
                ipv6Site = true;
                break;
            }
            if ((!ipv6Site || protocol != 6) && (ipv6Site || protocol != 4)) continue;
            matchingSites[sitesFound] = site;
            if (++sitesFound == arraySize) break;
        }
        return matchingSites;
    }

    private AbstractResponse resolveFromCache(AbstractRequest req, Cache cache) {
        byte[] handle = null;
        byte[][] types = null;
        int[] indexes = null;
        ResolutionRequest rreq = (ResolutionRequest)req;
        handle = new byte[rreq.handle.length];
        System.arraycopy(rreq.handle, 0, handle, 0, rreq.handle.length);
        Util.upperCasePrefixInPlace(handle);
        types = rreq.requestedTypes;
        indexes = rreq.requestedIndexes;
        if (!req.authoritative && req.ignoreRestrictedValues) {
            try {
                AbstractResponse resp = null;
                byte[][] cachedVals = cache.getCachedValues(handle, types, indexes);
                if (cachedVals != null) {
                    resp = cache.isCachedNotFound(cachedVals) ? new ErrorResponse(req, 100, null) : (cachedVals.length == 0 ? new ErrorResponse(req, 200, null) : new ResolutionResponse(req, req.handle, cachedVals));
                }
                if (resp == null && this.secureCache != null && this.secureCache != cache && (cachedVals = this.secureCache.getCachedValues(handle, types, indexes)) != null) {
                    resp = this.secureCache.isCachedNotFound(cachedVals) ? new ErrorResponse(req, 100, null) : (cachedVals.length == 0 ? new ErrorResponse(req, 200, null) : new ResolutionResponse(req, req.handle, cachedVals));
                }
                return resp;
            }
            catch (Throwable e) {
                System.err.println("Cache get error: " + e);
                e.printStackTrace(System.err);
                return null;
            }
        }
        return null;
    }

    private static int getNumPrimaries(SiteInfo[] sites) {
        int primaries = 0;
        for (int i = 0; sites != null && i < sites.length; ++i) {
            if (!sites[i].isPrimary) continue;
            ++primaries;
        }
        return primaries;
    }

    private void setResponseTimesOfSites(SiteInfo[] sites) {
        for (int i = 0; sites != null && i < sites.length; ++i) {
            if (sites[i].servers == null || sites[i].servers.length == 0) continue;
            String ip = sites[i].servers[0].getAddressString();
            Long cachedResponseTime = this.responseTimeTbl.get(ip);
            sites[i].responseTime = cachedResponseTime == null ? 0L : cachedResponseTime;
        }
    }

    private SiteInfo getPreferredPrimary(SiteInfo[] sites) {
        SiteInfo preferredPrimary = null;
        for (int i = 0; sites != null && i < sites.length; ++i) {
            String ipPort;
            Long timeOfLastRequest;
            if (!sites[i].isPrimary || sites[i].servers == null || sites[i].servers.length == 0) continue;
            String ip = sites[i].servers[0].getAddressString();
            if (sites[i].servers[0].interfaces == null || sites[i].servers[0].interfaces.length <= 0 || (timeOfLastRequest = this.preferredPrimaryTbl.get(ipPort = ip + ":" + sites[i].servers[0].interfaces[0].port)) == null) continue;
            long now = System.currentTimeMillis();
            if (now - timeOfLastRequest > 3600000L) {
                this.preferredPrimaryTbl.remove(ipPort);
                continue;
            }
            if (preferredPrimary != null) continue;
            preferredPrimary = sites[i];
        }
        return preferredPrimary;
    }

    private void cacheResponse(AbstractResponse resp, AbstractRequest req, boolean isCacheable, Cache cache) {
        byte[] handle = null;
        byte[][] types = null;
        int[] indexes = null;
        if (req instanceof ResolutionRequest) {
            ResolutionRequest rreq = (ResolutionRequest)req;
            handle = new byte[rreq.handle.length];
            System.arraycopy(rreq.handle, 0, handle, 0, rreq.handle.length);
            Util.upperCasePrefixInPlace(handle);
            types = rreq.requestedTypes;
            indexes = rreq.requestedIndexes;
        }
        if (isCacheable && cache == null) {
            if (cache != this.cache) {
                cache = this.cache;
            } else {
                isCacheable = false;
            }
        }
        if (isCacheable) {
            if (resp.responseCode == 1 && resp instanceof ResolutionResponse) {
                this.cacheSuccessfulResolutionResponse(resp, req, handle, types, indexes);
            }
            if (resp.responseCode == 200) {
                this.cacheValueNotFound(req, handle, types, indexes);
            }
            if (resp.responseCode == 100 && this.notFoundCacheTTL > 0) {
                this.cacheHandleNotFound(req, handle);
            }
        }
    }

    private void cacheSuccessfulResolutionResponse(AbstractResponse resp, AbstractRequest req, byte[] handle, byte[][] types, int[] indexes) {
        try {
            HandleValue[] origVals = ((ResolutionResponse)resp).getHandleValues();
            HandleValue[] vals = null;
            if (req.ignoreRestrictedValues) {
                vals = origVals;
            } else if (origVals != null) {
                int numPub = 0;
                for (HandleValue origVal : origVals) {
                    if (!origVal.getAnyoneCanRead()) continue;
                    ++numPub;
                }
                vals = new HandleValue[numPub];
                int j = 0;
                for (HandleValue origVal : origVals) {
                    if (j >= numPub) break;
                    if (!origVal.getAnyoneCanRead()) continue;
                    vals[j++] = origVal;
                }
            }
            this.cache.setCachedValues(handle, vals, types, indexes);
            if (req.certify && (Util.equalsCI(handle, Common.ROOT_HANDLE) || Util.equalsCI(handle, Common.TRUST_ROOT_HANDLE)) && types == null && indexes == null) {
                this.config.checkRootInfoUpToDate(this, Util.decodeString(handle), vals);
            }
            if (req.certify && this.secureCache != null && this.secureCache != this.cache) {
                this.secureCache.setCachedValues(handle, vals, types, indexes);
            }
        }
        catch (Throwable e) {
            System.err.println("Cache set error: " + e);
            e.printStackTrace(System.err);
        }
    }

    private void cacheValueNotFound(AbstractRequest req, byte[] handle, byte[][] types, int[] indexes) {
        try {
            this.cache.setCachedValues(handle, new HandleValue[0], types, indexes);
            if (req.certify && this.secureCache != null && this.secureCache != this.cache) {
                this.secureCache.setCachedValues(handle, new HandleValue[0], types, indexes);
            }
        }
        catch (Throwable e) {
            System.err.println("Cache set error: " + e);
            e.printStackTrace(System.err);
        }
    }

    private void cacheHandleNotFound(AbstractRequest req, byte[] handle) {
        try {
            if (this.cache != null) {
                this.cache.setCachedNotFound(handle, this.notFoundCacheTTL);
            }
            if (req.certify && this.secureCache != null && this.secureCache != this.cache) {
                this.secureCache.setCachedNotFound(handle, this.notFoundCacheTTL);
            }
        }
        catch (Throwable e) {
            System.err.println("Cache set error: " + e);
            e.printStackTrace(System.err);
        }
    }

    public AbstractResponse sendRequestToSite(AbstractRequest req, SiteInfo site, int protocol) throws HandleException {
        return this.sendRequestToSite(req, site, protocol, null);
    }

    public AbstractResponse sendRequestToSite(AbstractRequest req, SiteInfo site, int protocol, ResponseMessageCallback callback) throws HandleException {
        return this.sendRequestToServerInSiteByProtocol(req, site, null, protocol, callback);
    }

    public AbstractResponse sendRequestToServerInSiteByProtocol(AbstractRequest req, SiteInfo site, ServerInfo server, int protocol, ResponseMessageCallback callback) throws HandleException {
        AbstractResponse response;
        req.siteInfoSerial = site.serialNumber;
        req.setSupportedProtocolVersion(site);
        long time1 = System.currentTimeMillis();
        try {
            int which = site.determineServerNum(req.handle);
            if (server == null) {
                server = site.determineServer(req.handle);
            }
            String domain = site.getAttributeForServer("domain", which);
            String path = site.getAttributeForServer("path", which);
            server = this.adjustServerIpAddressForDomain(server, domain);
            response = this.sendRequestToServerByProtocol(req, domain, path, server, protocol, callback);
            if (site.isRoot && response != null && response.siteInfoSerial > req.siteInfoSerial) {
                this.config.notifyRootInfoOutdated(this);
            }
            long time2 = System.currentTimeMillis();
            site.responseTime = time2 - time1;
            this.responseTimeTbl.put(site.servers[0].getAddressString(), time2 - time1);
        }
        catch (HandleException e) {
            if (e.getCode() == 7) {
                this.responseTimeTbl.put(site.servers[0].getAddressString(), Long.valueOf(this.tcpTimeout));
            } else if (e.getCode() != 27) {
                long time2 = System.currentTimeMillis();
                site.responseTime = time2 - time1;
                this.responseTimeTbl.put(site.servers[0].getAddressString(), time2 - time1);
            }
            throw e;
        }
        return response;
    }

    private SiteInfo[] adjustSitesForDomains(SiteInfo[] sites) {
        if (!this.someSiteHasZeroAddressAndDomain(sites)) {
            return sites;
        }
        ArrayList<SiteInfo> result = new ArrayList<SiteInfo>();
        for (SiteInfo site : sites) {
            if (!site.hasZeroAddressServersAndDomain()) {
                result.add(site);
                continue;
            }
            if (site.servers.length > 1) {
                this.addV4AndV6DomainSites(result, site);
                continue;
            }
            this.addAllDomainSitesForSingleServerSite(result, site);
        }
        return result.toArray(new SiteInfo[result.size()]);
    }

    private boolean someSiteHasZeroAddressAndDomain(SiteInfo[] sites) {
        for (SiteInfo site : sites) {
            if (!site.hasZeroAddressServersAndDomain()) continue;
            return true;
        }
        return false;
    }

    private void addAllDomainSitesForSingleServerSite(List<SiteInfo> result, SiteInfo site) {
        String domain = site.getDomainForServer(0);
        if (domain == null) {
            result.add(site);
            return;
        }
        try {
            InetAddress[] addresses;
            for (InetAddress address : addresses = InetAddress.getAllByName(domain)) {
                SiteInfo newSite = new SiteInfo(site);
                newSite.servers[0].ipAddress = Util.fill16(address.getAddress());
                result.add(newSite);
            }
        }
        catch (UnknownHostException e) {
            result.add(site);
            return;
        }
    }

    private void addV4AndV6DomainSites(List<SiteInfo> result, SiteInfo site) {
        byte[][] v4Addresses = new byte[site.servers.length][];
        byte[][] v6Addresses = new byte[site.servers.length][];
        boolean foundIpv4 = false;
        boolean foundIpv6 = false;
        boolean foundBoth = false;
        for (int i = 0; i < site.servers.length; ++i) {
            byte[][] twoAddresses = this.getV4AndV6DomainAddressesForServer(site, i);
            byte[] v4Address = twoAddresses[0];
            byte[] v6Address = twoAddresses[1];
            if (v4Address == null && v6Address == null) {
                result.add(site);
                return;
            }
            if (v6Address == null) {
                v6Addresses[i] = v4Address;
                v4Addresses[i] = v4Address;
                foundIpv4 = true;
                continue;
            }
            if (v4Address == null) {
                v6Addresses[i] = v6Address;
                v4Addresses[i] = v6Address;
                foundIpv6 = true;
                continue;
            }
            v4Addresses[i] = v4Address;
            v6Addresses[i] = v6Address;
            foundBoth = true;
        }
        if (foundBoth || foundIpv6) {
            SiteInfo v6Site = new SiteInfo(site);
            for (int i = 0; i < site.servers.length; ++i) {
                v6Site.servers[i].ipAddress = v6Addresses[i];
            }
            result.add(v6Site);
        }
        if (foundBoth || foundIpv4 && !foundIpv6) {
            SiteInfo v4Site = new SiteInfo(site);
            for (int i = 0; i < site.servers.length; ++i) {
                v4Site.servers[i].ipAddress = v4Addresses[i];
            }
            result.add(v4Site);
        }
    }

    private byte[][] getV4AndV6DomainAddressesForServer(SiteInfo site, int which) {
        ServerInfo server = site.servers[which];
        byte[][] res = new byte[2][];
        if (!server.hasAllZerosAddress()) {
            if (server.isIPv4()) {
                res[0] = server.ipAddress;
            } else {
                res[1] = server.ipAddress;
            }
            return res;
        }
        String domain = site.getDomainForServer(which);
        if (domain == null) {
            return res;
        }
        try {
            InetAddress[] addresses;
            for (InetAddress address : addresses = InetAddress.getAllByName(domain)) {
                if (res[0] == null && address instanceof Inet4Address) {
                    res[0] = Util.fill16(address.getAddress());
                }
                if (res[1] != null || !(address instanceof Inet6Address)) continue;
                res[1] = Util.fill16(address.getAddress());
            }
            return res;
        }
        catch (UnknownHostException e) {
            return res;
        }
    }

    private ServerInfo adjustServerIpAddressForDomain(ServerInfo server, String domain) {
        if (!server.hasAllZerosAddress() || domain == null) {
            return server;
        }
        try {
            byte[] addressBytes = InetAddress.getByName(domain).getAddress();
            ServerInfo newServer = server.cloneServerInfo();
            newServer.ipAddress = Util.fill16(addressBytes);
            return newServer;
        }
        catch (UnknownHostException e) {
            return server;
        }
    }

    public AbstractResponse sendRequestToServer(AbstractRequest req, ServerInfo server) throws HandleException {
        return this.sendRequestToServer(req, server, null);
    }

    private AbstractResponse sendRequestToServer(AbstractRequest req, String domain, String path, ServerInfo server) throws HandleException {
        return this.sendRequestToServer(req, domain, path, server, null);
    }

    public AbstractResponse sendRequestToServer(AbstractRequest req, SiteInfo site, ServerInfo server) throws HandleException {
        return this.sendRequestToServer(req, site, server, null);
    }

    public AbstractResponse sendRequestToServer(AbstractRequest req, ServerInfo server, ResponseMessageCallback callback) throws HandleException {
        return this.sendRequestToServer(req, null, null, server, callback);
    }

    private AbstractResponse sendRequestToServer(AbstractRequest req, String domain, String path, ServerInfo server, ResponseMessageCallback callback) throws HandleException {
        AbstractResponse response = null;
        Exception exception = null;
        for (int preferredProtocol : this.preferredProtocols) {
            try {
                response = this.sendRequestToServerByProtocol(req, domain, path, server, preferredProtocol, callback);
                if (response == null) continue;
                return response;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        if (exception == null) {
            throw new HandleException(3, "There were no acceptable interfaces to server: " + server);
        }
        if (exception instanceof HandleException) {
            throw (HandleException)exception;
        }
        throw new HandleException(7, "Unable to contact site on any interfaces", exception);
    }

    public AbstractResponse sendRequestToServer(AbstractRequest req, SiteInfo site, ServerInfo server, ResponseMessageCallback callback) throws HandleException {
        AbstractResponse response = null;
        Exception exception = null;
        for (int preferredProtocol : this.preferredProtocols) {
            try {
                response = this.sendRequestToServerInSiteByProtocol(req, site, server, preferredProtocol, callback);
                if (response == null) continue;
                return response;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        if (exception == null) {
            throw new HandleException(3, "There were no acceptable interfaces to server: " + server);
        }
        if (exception instanceof HandleException) {
            throw (HandleException)exception;
        }
        throw new HandleException(7, "Unable to contact site on any interfaces", exception);
    }

    public AbstractResponse sendRequestToSite(AbstractRequest req, SiteInfo site) throws HandleException {
        return this.sendRequestToSite(req, site, null);
    }

    public AbstractResponse sendRequestToSite(AbstractRequest req, SiteInfo site, ResponseMessageCallback callback) throws HandleException {
        AbstractResponse resp = null;
        Exception lastException = null;
        for (int preferredProtocol : this.preferredProtocols) {
            try {
                resp = this.sendRequestToSite(req, site, preferredProtocol, callback);
                if (resp == null) continue;
                break;
            }
            catch (Exception e) {
                lastException = e;
            }
        }
        if (resp == null) {
            if (lastException instanceof HandleException) {
                throw (HandleException)lastException;
            }
            if (lastException != null) {
                throw new HandleException(7, "Unable to contact site on any interface", lastException);
            }
            throw new HandleException(3, "Cannot contact an acceptable interface", lastException);
        }
        return resp;
    }

    private AbstractResponse sendRequestToServerByProtocol(AbstractRequest req, String domain, String path, ServerInfo server, int protocolToUse, ResponseMessageCallback callback) throws HandleException {
        return this.sendRequestToServerByProtocol(req, domain, path, server, protocolToUse, callback, false);
    }

    private AbstractResponse sendRequestToServerByProtocol(AbstractRequest req, String domain, String path, ServerInfo server, int protocolToUse, ResponseMessageCallback callback, boolean forceSessionForNonAdminRequest) throws HandleException {
        if (req.majorProtocolVersion <= 0) {
            req.majorProtocolVersion = (byte)2;
            req.minorProtocolVersion = (byte)3;
        }
        AbstractResponse response = null;
        Exception exception = null;
        Interface interfce = null;
        ClientSideSessionInfo sessionInfo = req.sessionInfo;
        ClientSessionTracker sessionTracker = null;
        interfce = server.interfaceWithProtocol(protocolToUse, req);
        if (interfce == null) {
            return null;
        }
        sessionTracker = req.sessionTracker;
        if (sessionTracker == null && (req.isAdminRequest || !req.ignoreRestrictedValues)) {
            sessionTracker = this.resolverSessions;
        }
        if (sessionInfo != null && sessionInfo.hasExpired()) {
            if (sessionTracker != null) {
                sessionTracker.removeSession(sessionInfo);
            }
            sessionInfo = null;
        }
        boolean sessionToBeInitializedButNotAdminRequest = sessionTracker != null && req.sessionInfo == null && req.sessionTracker == null && !req.isAdminRequest && !forceSessionForNonAdminRequest;
        boolean sessionIsNew = false;
        boolean oldUnauthenticatedSession = false;
        if (sessionInfo == null && sessionTracker != null && req.hasEqualOrGreaterVersion(2, 1) && req.opCode != 400) {
            SessionSetupInfo setupInfo = sessionTracker.getSessionSetupInfo();
            sessionInfo = sessionTracker.getSession(server, req.authInfo);
            if (sessionInfo == null && (sessionInfo = sessionTracker.getAndRemoveSession(server, null)) != null) {
                oldUnauthenticatedSession = true;
            }
            if (sessionInfo == null && !sessionToBeInitializedButNotAdminRequest) {
                if (setupInfo != null) {
                    try {
                        sessionInfo = this.setupSessionWithServer(req, setupInfo, domain, path, server);
                        sessionIsNew = true;
                    }
                    catch (Exception e) {
                        String msg = "Error setting up session";
                        throw new HandleException(1, msg, e);
                    }
                }
            } else if (sessionInfo != null && setupInfo != null && ClientSessionTracker.sessionOptionChanged(sessionInfo, setupInfo)) {
                if (sessionToBeInitializedButNotAdminRequest) {
                    sessionInfo = null;
                } else {
                    try {
                        ClientSideSessionInfo newSessionInfo = this.setupSessionWithServer(req, setupInfo, domain, path, server, sessionInfo);
                        sessionTracker.removeSession(sessionInfo);
                        sessionInfo = newSessionInfo;
                        sessionIsNew = true;
                    }
                    catch (Exception e) {
                        String msg = "Error modifying session";
                        throw new HandleException(1, msg, e);
                    }
                }
            }
        }
        req.sessionInfo = sessionInfo;
        if (sessionInfo != null) {
            do {
                req.requestId = Math.abs(this.messageIDRandom.nextInt());
            } while (req.requestId <= 0);
            req.sessionId = sessionInfo.sessionId;
            req.certify = req.certify || sessionInfo.getAuthenticateMessageFlag();
            req.encrypt = req.encrypt || sessionInfo.getEncryptedMesssageFlag();
            req.majorProtocolVersion = sessionInfo.getMajorProtocolVersion();
            req.minorProtocolVersion = sessionInfo.getMinorProtocolVersion();
            req.setSupportedProtocolVersion();
            req.signMessageForSession();
        } else {
            req.sessionId = 0;
        }
        boolean sessionProblems = false;
        boolean sessionTimeout = false;
        ResponseMessageCallback wrappedCallback = callback == null || callback instanceof AvoidTransientErrorResponseMessageCallbackWrapper ? callback : new AvoidTransientErrorResponseMessageCallbackWrapper(callback);
        try {
            response = this.sendRequestToInterface(req, domain, path, server, interfce, wrappedCallback);
            sessionProblems = response != null && response.responseCode >= 500;
            sessionTimeout = response != null && response.responseCode == 500;
        }
        catch (HandleException e) {
            if (sessionInfo != null && e.getCode() == 13) {
                exception = e;
                sessionProblems = true;
            } else {
                exception = e;
            }
        }
        catch (Exception e) {
            exception = e;
        }
        if (sessionTracker != null && (sessionIsNew || oldUnauthenticatedSession) && response != null && response.getClass() != ChallengeResponse.class) {
            sessionTracker.putSession(sessionInfo, server, null);
        }
        for (int numChallenges = 0; numChallenges < 2 && response != null && response.getClass() == ChallengeResponse.class; ++numChallenges) {
            if (req.authInfo == null) {
                if (callback != null) {
                    callback.handleResponse(response);
                }
                throw new HandleException(8, "No authentication info provided");
            }
            if (sessionToBeInitializedButNotAdminRequest && sessionInfo == null) {
                return this.sendRequestToServerByProtocol(req, domain, path, server, protocolToUse, callback, true);
            }
            ChallengeResponse challResponse = (ChallengeResponse)response;
            byte[] sig = req.authInfo.authenticate(challResponse, req);
            int challengeSessionID = response.sessionId;
            response = null;
            try {
                ChallengeAnswerRequest answer = new ChallengeAnswerRequest(req.authInfo.getAuthType(), req.authInfo.getUserIdHandle(), req.authInfo.getUserIdIndex(), sig, req.authInfo);
                answer.takeValuesFrom(req);
                answer.originalRequest = req;
                answer.majorProtocolVersion = challResponse.majorProtocolVersion;
                answer.minorProtocolVersion = challResponse.minorProtocolVersion;
                answer.setSupportedProtocolVersion();
                answer.sessionId = challengeSessionID;
                answer.sessionInfo = req.sessionInfo;
                try {
                    response = this.sendRequestToInterface(answer, domain, path, server, interfce, wrappedCallback);
                    sessionProblems = response != null && response.responseCode >= 500;
                    sessionTimeout = response != null && response.responseCode == 500;
                }
                catch (HandleException e) {
                    if (sessionInfo != null && e.getCode() == 13) {
                        exception = e;
                        sessionProblems = true;
                    }
                    exception = e;
                }
                if (sessionTracker == null || response == null || sessionInfo == null || !sessionIsNew && !oldUnauthenticatedSession || HandleResolver.isAuthenticationOrSessionErrorResponse(response)) continue;
                sessionTracker.putSession(sessionInfo, server, req.authInfo);
                continue;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        if (sessionProblems) {
            if (sessionInfo != null) {
                if (sessionTracker != null) {
                    sessionTracker.removeSession(sessionInfo);
                }
                sessionInfo = null;
                req.sessionInfo = null;
                if (!sessionIsNew) {
                    return this.sendRequestToServerByProtocol(req, domain, path, server, protocolToUse, callback, forceSessionForNonAdminRequest);
                }
                if (sessionTimeout) {
                    if (response != null && callback != null && HandleResolver.isPotentiallyTransientErrorResponse(response)) {
                        callback.handleResponse(response);
                    }
                    throw new HandleException(15, "Unexpected session timeout response on new session");
                }
            } else if (sessionTimeout) {
                if (response != null && callback != null && HandleResolver.isPotentiallyTransientErrorResponse(response)) {
                    callback.handleResponse(response);
                }
                throw new HandleException(15, "Unexpected session timeout response when not using a session");
            }
        }
        if (response != null && callback != null && HandleResolver.isPotentiallyTransientErrorResponse(response)) {
            callback.handleResponse(response);
        }
        if (response != null) {
            return response;
        }
        if (exception != null) {
            if (exception instanceof HandleException) {
                throw (HandleException)exception;
            }
            exception.printStackTrace();
            throw new HandleException(7, "Got Exception: " + exception);
        }
        return null;
    }

    private static boolean isAuthenticationOrSessionErrorResponse(AbstractResponse response) {
        return response.responseCode >= 400;
    }

    private static boolean isPotentiallyTransientErrorResponse(AbstractResponse response) {
        return response.responseCode == 402 || response.responseCode >= 500;
    }

    public ClientSideSessionInfo setupSessionWithServer(AbstractRequest req, SessionSetupInfo sessionOptions, ServerInfo server) throws Exception {
        return this.setupSessionWithServer(req.authInfo, req, sessionOptions, null, null, server, null, req.majorProtocolVersion, req.minorProtocolVersion);
    }

    private ClientSideSessionInfo setupSessionWithServer(AbstractRequest req, SessionSetupInfo sessionOptions, String domain, String path, ServerInfo server) throws Exception {
        return this.setupSessionWithServer(req.authInfo, req, sessionOptions, domain, path, server, null, req.majorProtocolVersion, req.minorProtocolVersion);
    }

    private ClientSideSessionInfo setupSessionWithServer(AbstractRequest req, SessionSetupInfo sessionOptions, String domain, String path, ServerInfo server, ClientSideSessionInfo currSession) throws Exception {
        return this.setupSessionWithServer(req.authInfo, req, sessionOptions, domain, path, server, currSession, req.majorProtocolVersion, req.minorProtocolVersion);
    }

    private ClientSideSessionInfo setupSessionWithServer(AuthenticationInfo authInfo, AbstractRequest origReq, SessionSetupInfo sessionOptions, String domain, String path, ServerInfo server, ClientSideSessionInfo currSession, int majorProtocolVersion, int minorProtocolVersion) throws Exception {
        int sessionKeyAlg;
        AbstractResponse response = null;
        byte[] sessionKey = null;
        byte[] identityHandle = null;
        int identityIndex = -1;
        if (authInfo != null) {
            identityHandle = authInfo.getUserIdHandle();
            identityIndex = authInfo.getUserIdIndex();
        }
        SessionSetupRequest sessionsetupReq = this.createSessionSetupRequest(authInfo, sessionOptions, majorProtocolVersion, minorProtocolVersion);
        if (currSession != null) {
            sessionsetupReq.sessionId = currSession.sessionId;
            sessionsetupReq.sessionInfo = currSession;
        }
        if (origReq != null && origReq.multithread) {
            sessionsetupReq.multithread = true;
            sessionsetupReq.connectionLock = origReq.connectionLock;
            sessionsetupReq.completed = origReq.completed;
            sessionsetupReq.socketRef = origReq.socketRef;
        }
        sessionsetupReq.certify = true;
        HdlSecurityProvider provider = HdlSecurityProvider.getInstance();
        response = this.sendRequestToServer((AbstractRequest)sessionsetupReq, domain, path, server);
        if (response == null || !(response instanceof SessionSetupResponse) || response.responseCode != 1) {
            throw new HandleException(25, String.valueOf(response));
        }
        SessionSetupResponse ssresp = (SessionSetupResponse)response;
        if (ssresp.keyExchangeMode == 1 || ssresp.keyExchangeMode == 3) {
            sessionKey = Util.decrypt(sessionOptions.privateExchangeKey, ssresp.data, ssresp.majorProtocolVersion, ssresp.minorProtocolVersion);
            if (ssresp.hasEqualOrGreaterVersion(2, 2)) {
                sessionKeyAlg = Encoder.readInt(sessionKey, 0);
                byte[] tmp = new byte[sessionKey.length - 4];
                System.arraycopy(sessionKey, 4, tmp, 0, tmp.length);
                sessionKey = tmp;
            } else {
                sessionKeyAlg = 1;
            }
        } else if (ssresp.keyExchangeMode == 2) {
            byte[] pubExchangeKey = ssresp.data;
            boolean oldServer = !ssresp.hasEqualOrGreaterVersion(2, 2);
            sessionKeyAlg = oldServer ? 1 : 3;
            sessionKey = HdlSecurityProvider.getInstance().generateSecretKey(sessionKeyAlg);
            byte[] encryptKey = Util.substring(sessionKey, 4);
            if (oldServer) {
                sessionKey = encryptKey;
            }
            PublicKey serverRSAPubKey = Util.getPublicKeyFromBytes(pubExchangeKey, 0);
            byte[] key = Util.encrypt(serverRSAPubKey, encryptKey, ssresp.majorProtocolVersion, ssresp.minorProtocolVersion);
            SessionExchangeKeyRequest sekr = new SessionExchangeKeyRequest(key);
            sekr.takeValuesFrom(sessionsetupReq);
            sekr.majorProtocolVersion = ssresp.majorProtocolVersion;
            sekr.minorProtocolVersion = ssresp.minorProtocolVersion;
            sekr.setSupportedProtocolVersion();
            sekr.encrypt = false;
            sekr.sessionId = ssresp.sessionId;
            AbstractResponse rsp = this.sendRequestToServer((AbstractRequest)sekr, domain, path, server);
            if (rsp == null || rsp.responseCode != 1) {
                throw new HandleException(25, "Server cipher key exchange failed.");
            }
            if (ssresp.hasEqualOrGreaterVersion(2, 2)) {
                sessionKey = Util.substring(sessionKey, 4);
            }
        } else if (ssresp.keyExchangeMode == 4) {
            boolean legacy;
            boolean bl = legacy = !ssresp.hasEqualOrGreaterVersion(2, 4);
            if (legacy) {
                sessionKeyAlg = 1;
                DHPublicKey pub = (DHPublicKey)Util.getPublicKeyFromBytes(ssresp.data, 0);
                sessionKey = provider.getDESKeyFromDH(pub, (DHPrivateKey)sessionOptions.privateExchangeKey);
            } else {
                sessionKeyAlg = Encoder.readInt(ssresp.data, 0);
                DHPublicKey pub = (DHPublicKey)Util.getPublicKeyFromBytes(ssresp.data, 4);
                sessionKey = provider.getKeyFromDH(pub, (DHPrivateKey)sessionOptions.privateExchangeKey, sessionKeyAlg);
                sessionKey = Util.substring(sessionKey, 4);
            }
        } else {
            throw new HandleException(25, "Unknown key exchange mode");
        }
        ClientSideSessionInfo csinfo = new ClientSideSessionInfo(response.sessionId, sessionKey, identityHandle, identityIndex, sessionKeyAlg, server, response.majorProtocolVersion, response.minorProtocolVersion);
        csinfo.takeValuesFromOption(sessionOptions);
        return csinfo;
    }

    public AbstractResponse sendRequestToInterface(AbstractRequest req, ServerInfo server, Interface interfce) throws HandleException {
        return this.sendRequestToInterface(req, server, interfce, null);
    }

    public AbstractResponse sendRequestToInterface(AbstractRequest req, ServerInfo server, Interface interfce, ResponseMessageCallback callback) throws HandleException {
        return this.sendRequestToInterface(req, null, null, server, interfce, callback);
    }

    private AbstractResponse sendRequestToInterface(AbstractRequest req, String domain, String path, ServerInfo server, Interface interfce, ResponseMessageCallback callback) throws HandleException {
        req.serverPubKeyBytes = server.publicKey;
        InetAddress addr = server.getInetAddress();
        int port = interfce.port;
        AbstractResponse response = null;
        switch (interfce.protocol) {
            case 0: {
                response = this.sendHdlUdpRequest(req, addr, port, callback);
                break;
            }
            case 1: {
                response = this.sendHdlTcpRequest(req, addr, port, callback);
                break;
            }
            case 2: {
                if (req.hasEqualOrGreaterVersion(2, 8) && this.expectStreamingResponse(req) && !HandleResolver.isDsaPublicKey(req.serverPubKeyBytes)) {
                    response = this.sendHttpsRequest(req, domain, path, addr, port, callback);
                    break;
                }
                response = this.sendHttpRequest(req, domain, path, addr, port, callback);
                break;
            }
            case 3: {
                response = this.sendHttpsRequest(req, domain, path, addr, port, callback);
                break;
            }
            default: {
                throw new HandleException(4, "unknown protocol: " + interfce.protocol);
            }
        }
        if (response != null) {
            if (response.responseCode == 2) {
                throw new HandleException(15, Util.decodeString(((ErrorResponse)response).message));
            }
            if ((long)response.expiration < System.currentTimeMillis() / 1000L) {
                throw new HandleException(17);
            }
        }
        return response;
    }

    private boolean expectStreamingResponse(AbstractRequest req) {
        return req.opCode == 1001 || req.opCode == 1002 || req instanceof ChallengeAnswerRequest && this.expectStreamingResponse(((ChallengeAnswerRequest)req).originalRequest);
    }

    private final boolean verifyResponseWithSessionKey(AbstractRequest req, AbstractResponse response) throws HandleException {
        boolean veriPass = false;
        if (req == null || response == null) {
            return false;
        }
        try {
            veriPass = response.verifyMessage(req.sessionInfo.getSessionKey());
        }
        catch (HandleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HandleException(13, "Error verifying MAC code", e);
        }
        if (veriPass) {
            req.sessionInfo.addSessionCounter(response.sessionCounter, true);
        }
        return veriPass;
    }

    private static final void verifyResponseWithServerPublicKey(AbstractRequest req, AbstractResponse response) throws HandleException {
        PublicKey pubKey;
        if (req.serverPubKeyBytes == null) {
            throw new HandleException(10, "Unable to verify certified message: no pubkey associated with request");
        }
        try {
            pubKey = Util.getPublicKeyFromBytes(req.serverPubKeyBytes, 0);
        }
        catch (Exception e) {
            throw new HandleException(0, "Unable to extract public key", e);
        }
        try {
            if (response.signature == null || response.signature.length <= 0) {
                throw new HandleException(13, "Verification failed, missing signature.");
            }
            if (!response.verifyMessage(pubKey)) {
                throw new HandleException(13, "Verification failed.");
            }
        }
        catch (Exception e) {
            throw new HandleException(13, "Unable to verify signature for message: " + response, e);
        }
        if (req.sessionInfo != null) {
            req.sessionInfo.addSessionCounter(response.sessionCounter, true);
        }
    }

    private static void verifyRequestDigestIfNeeded(AbstractRequest req, AbstractResponse response) throws HandleException {
        byte[] requestDigest;
        if (req.returnRequestDigest && !Util.equals(requestDigest = Util.doDigest(response.rdHashType, (byte[][])new byte[][]{req.getEncodedMessageBody()}), response.requestDigest)) {
            throw new HandleException(10, "Message came back with invalid request digest.");
        }
    }

    public AbstractResponse sendHdlUdpRequest(AbstractRequest req, InetAddress addr, int port) throws HandleException {
        return this.sendHdlUdpRequest(req, addr, port, null);
    }

    private static void waitIfSiblingConnectedAndThrowHandleExceptionIfFinished(AbstractRequest req) throws HandleException {
        if (req.multithread) {
            try {
                HandleResolver.waitIfSiblingConnectedAndThrowInterruptedExceptionIfFinished(req);
            }
            catch (InterruptedException e) {
                throw new HandleException(27, "This request has been fully processed by another thread.");
            }
        }
    }

    private static void waitIfSiblingConnectedAndThrowInterruptedExceptionIfFinished(AbstractRequest req) throws InterruptedException {
        if (req.multithread) {
            if (req.completed.get()) {
                throw new InterruptedException();
            }
            if (!req.connectionLock.tryLock()) {
                req.connectionLock.lockInterruptibly();
            }
            req.connectionLock.unlock();
            if (req.completed.get()) {
                throw new InterruptedException();
            }
        }
    }

    private static void lockConnectionAndThrowHandleExceptionIfFinished(AbstractRequest req) throws HandleException {
        if (req.multithread) {
            if (req.completed.get()) {
                throw new HandleException(27, "This request has been fully processed by another thread.");
            }
            try {
                req.connectionLock.lockInterruptibly();
            }
            catch (InterruptedException e) {
                throw new HandleException(27, "This request has been fully processed by another thread.");
            }
            if (req.completed.get()) {
                req.connectionLock.unlock();
                throw new HandleException(27, "This request has been fully processed by another thread.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractResponse sendHdlUdpRequest(AbstractRequest req, InetAddress addr, int port, ResponseMessageCallback callback) throws HandleException {
        this.config.startAutoUpdate(this);
        addr = this.config.mapLocalAddress(addr);
        DatagramSocket socket = null;
        DatagramPacket[] packets = null;
        Throwable lastException = null;
        try {
            try {
                socket = new DatagramSocket();
            }
            catch (Exception e) {
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                throw new HandleException(1, (Throwable)e);
            }
            MessageEnvelope rcvEnvelope = new MessageEnvelope();
            for (int element : this.udpRetryScheme) {
                long whenToTimeout;
                if (packets == null) {
                    packets = this.getUdpPacketsForRequest(req, addr, port);
                } else if (req.sessionInfo != null && req.authInfo != null && req.hasEqualOrGreaterVersion(2, 5)) {
                    req.signMessageForSession();
                    packets = this.getUdpPacketsForRequest(req, addr, port);
                }
                HandleResolver.waitIfSiblingConnectedAndThrowHandleExceptionIfFinished(req);
                if (this.traceMessages) {
                    System.err.println("  sending HDL-UDP request (" + req + ") to " + Util.rfcIpPortRepr(addr, port));
                }
                try {
                    socket.setSoTimeout(element);
                    for (DatagramPacket datagramPacket : packets) {
                        socket.send(datagramPacket);
                    }
                    whenToTimeout = System.currentTimeMillis() + (long)element;
                }
                catch (Exception e) {
                    throw new HandleException(1, String.valueOf(e) + " sending UDP request to " + Util.rfcIpRepr(addr));
                }
                byte[] returnMessage = null;
                boolean[] packetsReceived = null;
                boolean haveAllPackets = false;
                while (!haveAllPackets && System.currentTimeMillis() <= whenToTimeout) {
                    DatagramPacket rspnsPkt = new DatagramPacket(new byte[this.maxUDPDataSize + 20], this.maxUDPDataSize + 20);
                    HandleResolver.waitIfSiblingConnectedAndThrowHandleExceptionIfFinished(req);
                    try {
                        socket.receive(rspnsPkt);
                        if (rspnsPkt.getLength() <= 0) continue;
                        byte[] rspnsPktData = rspnsPkt.getData();
                        int rspnsPktDataLen = rspnsPkt.getLength();
                        Encoder.decodeEnvelope(rspnsPktData, rcvEnvelope);
                        if (rcvEnvelope.requestId != req.requestId) continue;
                        if (packetsReceived == null) {
                            int numPkts = rcvEnvelope.messageLength / this.maxUDPDataSize;
                            if (rcvEnvelope.messageLength % this.maxUDPDataSize != 0) {
                                ++numPkts;
                            }
                            packetsReceived = new boolean[numPkts];
                            for (int pr = 0; pr < packetsReceived.length; ++pr) {
                                packetsReceived[pr] = false;
                            }
                            returnMessage = new byte[rcvEnvelope.messageLength];
                        }
                        packetsReceived[rcvEnvelope.messageId] = true;
                        System.arraycopy(rspnsPktData, 20, returnMessage, rcvEnvelope.messageId * this.maxUDPDataSize, rspnsPktDataLen - 20);
                        haveAllPackets = true;
                        for (int pr = 0; pr < packetsReceived.length; ++pr) {
                            if (packetsReceived[pr]) continue;
                            haveAllPackets = false;
                            pr = packetsReceived.length;
                        }
                        if (!haveAllPackets) continue;
                        if (req.multithread) {
                            req.connectionLock.lockInterruptibly();
                        }
                        if (rcvEnvelope.encrypted) {
                            ClientSideSessionInfo sessionInfo = req.sessionInfo;
                            if (sessionInfo == null) {
                                throw new HandleException(24, "Cannot decrypt message without a session");
                            }
                            if (this.traceMessages) {
                                System.err.println("Decrypting UDP message: " + rcvEnvelope);
                            }
                            if (returnMessage == null) {
                                throw new AssertionError();
                            }
                            returnMessage = sessionInfo.decryptBuffer(returnMessage, 0, returnMessage.length);
                            rcvEnvelope.encrypted = false;
                            rcvEnvelope.messageLength = returnMessage.length;
                        }
                        AbstractResponse response = (AbstractResponse)Encoder.decodeMessage(returnMessage, 0, rcvEnvelope);
                        if (this.traceMessages) {
                            System.err.println("    received HDL-UDP response: " + response);
                        }
                        this.checkSignatureIfNeeded(req, response);
                        if (callback != null) {
                            callback.handleResponse(response);
                        }
                        AbstractResponse abstractResponse = response;
                        return abstractResponse;
                    }
                    catch (InterruptedException e) {
                        throw new HandleException(27, "This request has been fully processed by another thread.");
                    }
                    catch (Exception e) {
                        lastException = e;
                    }
                }
            }
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (Exception exception) {}
            }
        }
        if (lastException != null) {
            if (lastException instanceof HandleException) {
                throw (HandleException)lastException;
            }
            throw new HandleException(7, addr + ": " + lastException.toString());
        }
        throw new HandleException(7, "Unable to connect to server: " + addr);
    }

    private void checkSignatureIfNeeded(AbstractRequest req, AbstractResponse response) throws HandleException {
        HandleResolver.verifyRequestDigestIfNeeded(req, response);
        if (req.certify && this.checkSignatures) {
            if (response.signatureIsMac()) {
                if (response.sessionId <= 0) {
                    throw new HandleException(13, "Message signed with MAC but no session id given");
                }
                if (req.sessionInfo == null) {
                    throw new HandleException(13, "Message signed with MAC but no client-side session information");
                }
                if (!this.verifyResponseWithSessionKey(req, response)) {
                    throw new HandleException(13, "Verification of session MAC failed");
                }
            } else {
                HandleResolver.verifyResponseWithServerPublicKey(req, response);
            }
        }
    }

    private DatagramPacket[] getUdpPacketsForRequest(AbstractRequest req, InetAddress addr, int port) throws HandleException {
        MessageEnvelope sndEnvelope = new MessageEnvelope();
        if (req.majorProtocolVersion > 0 && req.minorProtocolVersion >= 0) {
            sndEnvelope.protocolMajorVersion = req.majorProtocolVersion;
            sndEnvelope.protocolMinorVersion = req.minorProtocolVersion;
            sndEnvelope.suggestMajorProtocolVersion = req.suggestMajorProtocolVersion;
            sndEnvelope.suggestMinorProtocolVersion = req.suggestMinorProtocolVersion;
        }
        sndEnvelope.sessionId = req.sessionId;
        if (req.requestId <= 0) {
            req.requestId = sndEnvelope.requestId = Math.abs(this.messageIDRandom.nextInt());
        } else {
            sndEnvelope.requestId = req.requestId;
        }
        byte[] requestBuf = req.getEncodedMessage();
        if (req.encrypt || req.sessionInfo != null && req.shouldEncrypt()) {
            if (req.sessionInfo == null) {
                throw new HandleException(24, "Cannot encrypt messages without a session");
            }
            requestBuf = req.sessionInfo.encryptBuffer(requestBuf, 0, requestBuf.length);
            sndEnvelope.encrypted = true;
        }
        sndEnvelope.messageLength = requestBuf.length;
        int numPackets = sndEnvelope.messageLength / this.maxUDPDataSize;
        if (sndEnvelope.messageLength % this.maxUDPDataSize != 0) {
            ++numPackets;
        }
        if (numPackets == 0) {
            throw new HandleException(1, "Cannot send empty request");
        }
        DatagramPacket[] packets = new DatagramPacket[numPackets];
        int bytesRemaining = sndEnvelope.messageLength;
        sndEnvelope.truncated = numPackets > 1;
        for (int packetNum = 0; packetNum < numPackets; ++packetNum) {
            int thisPacketSize = Math.min(this.maxUDPDataSize, bytesRemaining);
            byte[] buf = new byte[thisPacketSize + 20];
            sndEnvelope.messageId = packetNum;
            Encoder.encodeEnvelope(sndEnvelope, buf);
            System.arraycopy(requestBuf, requestBuf.length - bytesRemaining, buf, 20, buf.length - 20);
            packets[packetNum] = new DatagramPacket(buf, buf.length, addr, port);
            bytesRemaining -= thisPacketSize;
        }
        return packets;
    }

    public AbstractResponse sendHdlTcpRequest(AbstractRequest req, InetAddress addr, int port) throws HandleException {
        return this.sendHdlTcpRequest(req, addr, port, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AbstractResponse sendHdlTcpRequest(AbstractRequest req, InetAddress addr, int port, ResponseMessageCallback callback) throws HandleException {
        this.config.startAutoUpdate(this);
        addr = this.config.mapLocalAddress(addr);
        MessageEnvelope sndEnvelope = new MessageEnvelope();
        if (req.majorProtocolVersion > 0 && req.minorProtocolVersion >= 0) {
            sndEnvelope.protocolMajorVersion = req.majorProtocolVersion;
            sndEnvelope.protocolMinorVersion = req.minorProtocolVersion;
            sndEnvelope.suggestMajorProtocolVersion = req.suggestMajorProtocolVersion;
            sndEnvelope.suggestMinorProtocolVersion = req.suggestMinorProtocolVersion;
        }
        sndEnvelope.sessionId = req.sessionId;
        if (req.requestId <= 0) {
            req.requestId = sndEnvelope.requestId = Math.abs(this.messageIDRandom.nextInt());
        } else {
            sndEnvelope.requestId = req.requestId;
        }
        byte[] requestBuf = req.getEncodedMessage();
        if (req.encrypt || req.sessionInfo != null && req.shouldEncrypt()) {
            if (req.sessionInfo == null) {
                throw new HandleException(24, "Cannot encrypt messages without a session");
            }
            requestBuf = req.sessionInfo.encryptBuffer(requestBuf, 0, requestBuf.length);
            sndEnvelope.encrypted = true;
        }
        sndEnvelope.messageLength = requestBuf.length;
        HandleResolver.waitIfSiblingConnectedAndThrowHandleExceptionIfFinished(req);
        if (this.traceMessages) {
            System.err.println("  sending HDL-TCP request (" + req + ") to " + Util.rfcIpPortRepr(addr, port));
        }
        AbstractResponse response = null;
        Socket socket = null;
        OutputStream out = null;
        InputStream in = null;
        try {
            try {
                socket = SocketChannel.open().socket();
                socket.setSoTimeout(this.tcpTimeout);
                socket.setSoLinger(false, 0);
                if (req.multithread) {
                    req.socketRef.set(socket);
                }
                socket.connect(new InetSocketAddress(addr, port), this.tcpTimeout);
            }
            catch (Exception e) {
                req.socketRef.set(null);
                if (socket == null) throw new HandleException(7, "" + addr, e);
                try {
                    socket.close();
                    throw new HandleException(7, "" + addr, e);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new HandleException(7, "" + addr, e);
            }
            HandleResolver.lockConnectionAndThrowHandleExceptionIfFinished(req);
            MessageEnvelope rcvEnvelope = new MessageEnvelope();
            byte[] envBuf = new byte[20];
            try {
                out = socket.getOutputStream();
                Encoder.encodeEnvelope(sndEnvelope, envBuf);
                out.write(Util.concat(envBuf, requestBuf));
                out.flush();
                in = new BufferedInputStream(socket.getInputStream());
            }
            catch (Exception e) {
                throw new HandleException(7, String.valueOf(e) + " sending TCP request to " + Util.rfcIpRepr(addr), e);
            }
            while (true) {
                AbstractResponse abstractResponse;
                int n;
                int r;
                for (n = 0; n < 20 && (r = in.read(envBuf, n, 20 - n)) > 0; n += r) {
                }
                if (n == 0) {
                    throw new HandleException(15, "Connection closed without response");
                }
                if (n < 20) {
                    throw new HandleException(6, "Connection closed partway through message envelope");
                }
                Encoder.decodeEnvelope(envBuf, rcvEnvelope);
                if (rcvEnvelope.requestId != req.requestId) {
                    throw new HandleException(10, "Message came back with different ID: " + req.requestId + "!=" + rcvEnvelope.requestId);
                }
                byte[] messageBuf = new byte[rcvEnvelope.messageLength];
                for (n = 0; n < rcvEnvelope.messageLength && (r = in.read(messageBuf, n, rcvEnvelope.messageLength - n)) > 0; n += r) {
                }
                if (n < rcvEnvelope.messageLength) {
                    throw new HandleException(6, "Connection closed partway through message");
                }
                if (rcvEnvelope.encrypted) {
                    ClientSideSessionInfo csinfo = req.sessionInfo;
                    if (csinfo == null) {
                        throw new HandleException(24, "Cannot decrypt messages without a session");
                    }
                    if (this.traceMessages) {
                        System.err.println("Decrypting TCP message: " + rcvEnvelope);
                    }
                    messageBuf = csinfo.decryptBuffer(messageBuf, 0, messageBuf.length);
                    rcvEnvelope.encrypted = false;
                    rcvEnvelope.messageLength = messageBuf.length;
                }
                response = (AbstractResponse)Encoder.decodeMessage(messageBuf, 0, rcvEnvelope);
                if (response.streaming) {
                    response.stream = in;
                    response.socket = socket;
                }
                this.checkSignatureIfNeeded(req, response);
                if (this.traceMessages) {
                    System.err.println("    received HDL-TCP response: " + response);
                }
                if (callback == null) {
                    abstractResponse = response;
                    return abstractResponse;
                }
                callback.handleResponse(response);
                if (!response.continuous) {
                    abstractResponse = response;
                    return abstractResponse;
                }
                continue;
                break;
            }
        }
        catch (IOException e) {
            if (!this.traceMessages) throw new HandleException(7, "Error talking to " + Util.rfcIpRepr(addr), e);
            e.printStackTrace(System.err);
            throw new HandleException(7, "Error talking to " + Util.rfcIpRepr(addr), e);
        }
        finally {
            req.socketRef.set(null);
            if (!(socket == null || response != null && response.streaming)) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception exception) {}
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (Exception exception) {}
                }
                try {
                    socket.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static final String encodeHandleAsUri(byte[] handle) {
        return "/" + StringUtils.encodeURLComponent((String)Util.decodeString(handle));
    }

    public AbstractResponse sendHttpRequest(AbstractRequest req, InetAddress addr, int port) throws HandleException {
        return this.sendHttpRequest(req, addr, port, null);
    }

    public AbstractResponse sendHttpRequest(AbstractRequest req, InetAddress addr, int port, ResponseMessageCallback callback) throws HandleException {
        return this.sendHttpRequest(req, null, null, addr, port, callback);
    }

    private AbstractResponse sendHttpRequest(AbstractRequest req, String domain, String path, InetAddress addr, int port, ResponseMessageCallback callback) throws HandleException {
        return this.sendHttpOrHttpsRequest(req, domain, path, addr, port, callback, false);
    }

    public AbstractResponse sendHttpsRequest(AbstractRequest req, InetAddress addr, int port, ResponseMessageCallback callback) throws HandleException {
        return this.sendHttpsRequest(req, null, null, addr, port, callback);
    }

    private AbstractResponse sendHttpsRequest(AbstractRequest req, String domain, String path, InetAddress addr, int port, ResponseMessageCallback callback) throws HandleException {
        return this.sendHttpOrHttpsRequest(req, domain, path, addr, port, callback, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AbstractResponse sendHttpOrHttpsRequest(AbstractRequest req, String domain, String path, InetAddress addr, int port, ResponseMessageCallback callback, boolean isHttps) throws HandleException {
        this.config.startAutoUpdate(this);
        String protocol = isHttps ? "HTTPS" : "HTTP";
        addr = this.config.mapLocalAddress(addr);
        MessageEnvelope sndEnvelope = new MessageEnvelope();
        if (req.majorProtocolVersion > 0 && req.minorProtocolVersion >= 0) {
            sndEnvelope.protocolMajorVersion = req.majorProtocolVersion;
            sndEnvelope.protocolMinorVersion = req.minorProtocolVersion;
            sndEnvelope.suggestMajorProtocolVersion = req.suggestMajorProtocolVersion;
            sndEnvelope.suggestMinorProtocolVersion = req.suggestMinorProtocolVersion;
        }
        sndEnvelope.sessionId = req.sessionId;
        if (req.requestId <= 0) {
            req.requestId = sndEnvelope.requestId = Math.abs(this.messageIDRandom.nextInt());
        } else {
            sndEnvelope.requestId = req.requestId;
        }
        byte[] requestBuf = req.getEncodedMessage();
        if (req.encrypt || req.sessionInfo != null && req.shouldEncrypt()) {
            if (req.sessionInfo == null) {
                throw new HandleException(24, "Cannot encrypt messages without a session");
            }
            requestBuf = req.sessionInfo.encryptBuffer(requestBuf, 0, requestBuf.length);
            sndEnvelope.encrypted = true;
        }
        sndEnvelope.messageLength = requestBuf.length;
        HandleResolver.waitIfSiblingConnectedAndThrowHandleExceptionIfFinished(req);
        if (this.traceMessages) {
            System.err.println("  sending HDL-" + protocol + " request (" + req + ") to " + Util.rfcIpPortRepr(addr, port));
        }
        AbstractResponse response = null;
        Socket socket = null;
        OutputStream out = null;
        InputStream in = null;
        FilterInputStream din = null;
        try {
            try {
                socket = isHttps ? this.getHttpsSocket(req) : SocketChannel.open().socket();
                socket.setSoTimeout(this.tcpTimeout);
                socket.setSoLinger(false, 0);
                if (req.multithread) {
                    req.socketRef.set(socket);
                }
                socket.connect(new InetSocketAddress(addr, port), this.tcpTimeout);
            }
            catch (Exception e) {
                req.socketRef.set(null);
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (!(e instanceof HandleException)) throw new HandleException(7, Util.rfcIpRepr(addr) + ": " + e.toString(), e);
                throw (HandleException)e;
            }
            HandleResolver.lockConnectionAndThrowHandleExceptionIfFinished(req);
            MessageEnvelope rcvEnvelope = new MessageEnvelope();
            byte[] envBuf = new byte[20];
            try {
                out = new BufferedOutputStream(socket.getOutputStream());
                Encoder.encodeEnvelope(sndEnvelope, envBuf);
                String uri = HandleResolver.encodeHandleAsUri(req.handle);
                if (path != null) {
                    if (!path.startsWith("/")) {
                        path = "/" + path;
                    }
                    if (path.endsWith("/")) {
                        path = path.substring(0, path.length() - 1);
                    }
                    uri = path + uri;
                }
                out.write(Util.encodeString("POST " + uri + " HTTP/1.1\r\n"));
                String hostHeader = this.getHostHeader(domain, addr, port, isHttps);
                out.write(Util.encodeString(hostHeader + "\r\n"));
                out.write(HTTP_ACCEPT_HEADER);
                out.write(HTTP_AGENT_HEADER);
                out.write(HTTP_CONTENT_TYPE_HEADER);
                out.write(Util.encodeString("Content-Length: " + (envBuf.length + requestBuf.length) + "\r\n"));
                out.write(HTTP_NEWLINE);
                out.write(envBuf, 0, 20);
                out.write(requestBuf, 0, requestBuf.length);
                out.flush();
                in = new BufferedInputStream(socket.getInputStream());
            }
            catch (Exception e) {
                throw new HandleException(7, String.valueOf(e) + " sending " + protocol + " request to " + Util.rfcIpRepr(addr), e);
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            din = new DataInputStream(in);
            while (true) {
                String line;
                if ((line = din.readLine()) == null) {
                    if (!headers.isEmpty()) throw new HandleException(6, Util.rfcIpRepr(addr) + ": Unexpected end of HTTP message during headers");
                    throw new HandleException(15, "Connection closed without response");
                }
                if ((line = line.trim()).length() <= 0) break;
                int colIdx = line.indexOf(59);
                if (colIdx < 0) {
                    headers.put(line.toUpperCase(), "");
                    continue;
                }
                headers.put(line.substring(0, colIdx), line.substring(colIdx + 1));
            }
            int n = 0;
            while (true) {
                AbstractResponse abstractResponse;
                int r;
                int r2;
                for (n = 0; n < 20 && (r2 = in.read(envBuf, n, 20 - n)) > 0; n += r2) {
                }
                if (n == 0) {
                    throw new HandleException(6, "Connection closed after HTTP headers but with no body");
                }
                if (n < 20) {
                    throw new HandleException(6, "Connection closed partway through message envelope");
                }
                Encoder.decodeEnvelope(envBuf, rcvEnvelope);
                if (rcvEnvelope.requestId != req.requestId) {
                    throw new HandleException(10, "Message came back with different ID: " + req.requestId + "!=" + rcvEnvelope.requestId);
                }
                byte[] messageBuf = new byte[rcvEnvelope.messageLength];
                for (n = 0; n < rcvEnvelope.messageLength && (r = in.read(messageBuf, n, rcvEnvelope.messageLength - n)) > 0; n += r) {
                }
                if (n < rcvEnvelope.messageLength) {
                    throw new HandleException(6, "Connection closed partway through message");
                }
                if (rcvEnvelope.encrypted) {
                    if (rcvEnvelope.sessionId <= 0) throw new HandleException(10, "Invalid response session id.  Cannot decrypt response.");
                    ClientSideSessionInfo csinfo = req.sessionInfo;
                    if (csinfo == null) {
                        throw new HandleException(24, "Cannot encrypt messages without a session");
                    }
                    messageBuf = csinfo.decryptBuffer(messageBuf, 0, messageBuf.length);
                    rcvEnvelope.encrypted = false;
                    rcvEnvelope.messageLength = messageBuf.length;
                }
                response = (AbstractResponse)Encoder.decodeMessage(messageBuf, 0, rcvEnvelope);
                if (response.streaming) {
                    response.stream = in;
                    response.socket = socket;
                    response.secureStream = isHttps && !HandleResolver.isDsaPublicKey(req.serverPubKeyBytes);
                }
                this.checkSignatureIfNeeded(req, response);
                if (this.traceMessages) {
                    System.err.println("    received HDL-" + protocol + " response: " + response);
                }
                if (callback == null) {
                    abstractResponse = response;
                    return abstractResponse;
                }
                callback.handleResponse(response);
                if (!response.continuous) {
                    abstractResponse = response;
                    return abstractResponse;
                }
                continue;
                break;
            }
        }
        catch (IOException e) {
            if (!this.traceMessages) throw new HandleException(7, "Error talking to " + Util.rfcIpRepr(addr), e);
            e.printStackTrace(System.err);
            throw new HandleException(7, "Error talking to " + Util.rfcIpRepr(addr), e);
        }
        finally {
            req.socketRef.set(null);
            if (!(socket == null || response != null && response.streaming)) {
                if (din != null) {
                    try {
                        din.close();
                    }
                    catch (Exception exception) {}
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception exception) {}
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (Exception exception) {}
                }
                try {
                    socket.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private String getHostHeader(String domain, InetAddress addr, int port, boolean isHttps) {
        String hostHeader = "Host: ";
        hostHeader = domain != null ? hostHeader + domain : (addr instanceof Inet6Address ? hostHeader + "[" + Util.rfcIpRepr(addr) + "]" : hostHeader + addr.getHostAddress());
        if (isHttps && port != 443 || !isHttps && port != 80) {
            hostHeader = hostHeader + ":" + port;
        }
        return hostHeader;
    }

    private Socket getHttpsSocket(AbstractRequest req) throws Exception {
        if (req.serverPubKeyBytes == null) {
            throw new HandleException(10, "Server key not known when getting HTTPS socket");
        }
        SSLContext sslContext = HandleResolver.isDsaPublicKey(req.serverPubKeyBytes) ? SSLEngineHelper.getAllTrustingClientSSLContext() : SSLEngineHelper.getClientSSLContext(req.serverPubKeyBytes);
        SSLSocket res = (SSLSocket)sslContext.getSocketFactory().createSocket();
        try {
            res.setEnabledCipherSuites(SSLEngineHelper.ENABLED_CIPHER_SUITES);
            res.setEnabledProtocols(SSLEngineHelper.ENABLED_CLIENT_PROTOCOLS);
            return res;
        }
        catch (Exception e) {
            try {
                res.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    private static boolean isDsaPublicKey(byte[] pubKeyBytes) throws HandleException {
        byte[] keyType = Encoder.readByteArray(pubKeyBytes, 0);
        return Util.equals(keyType, Common.KEY_ENCODING_DSA_PUBLIC);
    }

    static {
        try {
            HandleResolver.checkInterfaces(NetworkInterface.getNetworkInterfaces());
            if (!hasIPv4Interface && !hasIPv6Interface) {
                hasIPv4Interface = true;
                hasIPv6Interface = true;
            }
        }
        catch (Exception e) {
            hasIPv4Interface = true;
            hasIPv6Interface = true;
        }
    }

    private static class AvoidTransientErrorResponseMessageCallbackWrapper
    implements ResponseMessageCallback {
        private final ResponseMessageCallback delegate;

        public AvoidTransientErrorResponseMessageCallbackWrapper(ResponseMessageCallback delegate) {
            this.delegate = delegate;
        }

        @Override
        public void handleResponse(AbstractResponse message) throws HandleException {
            if (!HandleResolver.isPotentiallyTransientErrorResponse(message)) {
                this.delegate.handleResponse(message);
            }
        }
    }

    private class ServiceInfo {
        SiteInfo[] prefixSites;
        SiteInfo[] sites;
        NamespaceInfo ns;
        AbstractResponse response;
        HandleValue[] values;

        private ServiceInfo() {
        }
    }

    private static class CachedThreadPoolHolder {
        private static final AtomicInteger poolNumber = new AtomicInteger(1);
        static final ExecutorService execServ = Executors.newCachedThreadPool(new ThreadFactory(){
            private final String namePrefix = "resolver-" + CachedThreadPoolHolder.access$000().getAndIncrement() + "-ipv4-thread-";
            private final AtomicInteger threadNumber = new AtomicInteger(1);

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, this.namePrefix + this.threadNumber.getAndIncrement());
                t.setDaemon(true);
                return t;
            }
        });

        private CachedThreadPoolHolder() {
        }

        static /* synthetic */ AtomicInteger access$000() {
            return poolNumber;
        }
    }
}

