/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib;

import net.handle.hdllib.AbstractRequest;
import net.handle.hdllib.AuthenticationInfo;
import net.handle.hdllib.ChallengeResponse;
import net.handle.hdllib.Common;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.Util;

public class ChallengeAnswerRequest
extends AbstractRequest {
    public byte[] authType;
    public byte[] userIdHandle;
    public int userIdIndex;
    public byte[] signedResponse;
    public AbstractRequest originalRequest;

    public ChallengeAnswerRequest(byte[] authType, byte[] userIdHandle, int userIdIndex, byte[] signedResponse, AuthenticationInfo authInfo) {
        super(Common.BLANK_HANDLE, 200, authInfo);
        this.authType = authType;
        this.userIdHandle = userIdHandle;
        this.userIdIndex = userIdIndex;
        this.signedResponse = signedResponse;
    }

    public ChallengeAnswerRequest(AbstractRequest req, ChallengeResponse challenge, AuthenticationInfo authInfo) throws HandleException {
        this(authInfo.getAuthType(), authInfo.getUserIdHandle(), authInfo.getUserIdIndex(), authInfo.authenticate(challenge, req), authInfo);
        this.takeValuesFrom(req);
        this.sessionId = challenge.sessionId;
        this.sessionInfo = req.sessionInfo;
    }

    @Override
    public String toString() {
        return super.toString() + ' ' + Util.decodeString(this.authType) + ' ' + this.userIdIndex + ':' + Util.decodeString(this.userIdHandle);
    }
}

