/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib;

import java.io.InputStream;
import java.net.Socket;
import net.handle.hdllib.AbstractMessage;
import net.handle.hdllib.AbstractRequest;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.SignedOutputStream;
import net.handle.hdllib.Util;

public abstract class AbstractResponse
extends AbstractMessage {
    public InputStream stream = null;
    public Socket socket = null;
    public boolean secureStream = false;
    public boolean streaming = false;

    public AbstractResponse() {
    }

    public AbstractResponse(int opCode, int responseCode) {
        super(opCode);
        this.responseCode = responseCode;
    }

    public AbstractResponse(AbstractRequest req, int responseCode) throws HandleException {
        super(req.opCode);
        this.requestId = req.requestId;
        this.responseCode = responseCode;
        this.sessionId = req.sessionId;
        this.takeValuesFrom(req);
        this.majorProtocolVersion = req.suggestMajorProtocolVersion;
        this.minorProtocolVersion = req.suggestMinorProtocolVersion;
        this.suggestMajorProtocolVersion = (byte)2;
        this.suggestMinorProtocolVersion = (byte)11;
        this.setSupportedProtocolVersion();
        if (this.returnRequestDigest) {
            this.takeDigestOfRequest(req);
        }
    }

    public AbstractResponse getContinuedResponse() {
        return null;
    }

    public final void takeDigestOfRequest(AbstractMessage req) throws HandleException {
        if (!this.hasEqualOrGreaterVersion(2, 1)) {
            this.requestDigest = Util.doMD5Digest(new byte[][]{req.getEncodedMessageBody()});
            this.rdHashType = 0;
        } else if (this.hasEqualOrGreaterVersion(2, 7)) {
            this.requestDigest = Util.doSHA256Digest(new byte[][]{req.getEncodedMessageBody()});
            this.rdHashType = (byte)3;
        } else {
            this.requestDigest = Util.doSHA1Digest(new byte[][]{req.getEncodedMessageBody()});
            this.rdHashType = (byte)2;
        }
    }

    public void streamResponse(SignedOutputStream out) throws HandleException {
    }
}

