/*
 * Decompiled with CFR 0.152.
 */
package net.handle.dnslib;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.handle.dnslib.DomainName;
import net.handle.dnslib.ParseException;
import net.handle.dnslib.ResourceRecord;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.ResolutionRequest;
import net.handle.hdllib.ResolutionResponse;
import net.handle.hdllib.ResponseMessageCallback;
import net.handle.hdllib.Util;
import net.handle.server.AbstractServer;
import net.handle.server.dns.DnsConfiguration;

public class Storage {
    private final DomainName zone;
    private final String handlePrefix;
    private final AbstractServer server;
    private final DnsConfiguration dnsConfig;
    private static Map<Integer, byte[]> dnsTypeToHandleTypeMap;
    private static Map<String, Integer> handleTypeToDNSTypeMap;
    private static final byte[] SYMBOLIC_CNAME;
    private static final byte[] NUMERIC_CNAME;
    private static final byte[][] HDL_DNS_TYPES_ANY;
    private static final byte[][] HDL_DNS_TYPES_CNAME;

    public Storage(DomainName zone, String handlePrefix, AbstractServer server, DnsConfiguration dnsConfig) {
        this.zone = zone;
        this.handlePrefix = handlePrefix;
        this.server = server;
        this.dnsConfig = dnsConfig;
    }

    private static byte[] handleTypeSymbolic(int type) {
        return dnsTypeToHandleTypeMap.get(type);
    }

    private static byte[] handleTypeNumeric(int type) {
        return Util.encodeString("DNS.TYPE" + type);
    }

    public static byte[][] dnsTypeToHandleTypes(int type, boolean includeCNAME) {
        if (type == 255) {
            return HDL_DNS_TYPES_ANY;
        }
        if (type == 5) {
            return HDL_DNS_TYPES_CNAME;
        }
        if (type == 254) {
            if (includeCNAME) {
                return new byte[][]{Storage.handleTypeSymbolic(3), Storage.handleTypeNumeric(3), Storage.handleTypeSymbolic(4), Storage.handleTypeNumeric(4), SYMBOLIC_CNAME, NUMERIC_CNAME};
            }
            return new byte[][]{Storage.handleTypeSymbolic(3), Storage.handleTypeNumeric(3), Storage.handleTypeSymbolic(4), Storage.handleTypeNumeric(4)};
        }
        if (type == 253) {
            if (includeCNAME) {
                return new byte[][]{Storage.handleTypeSymbolic(7), Storage.handleTypeNumeric(7), Storage.handleTypeSymbolic(8), Storage.handleTypeNumeric(8), Storage.handleTypeSymbolic(9), Storage.handleTypeNumeric(9), SYMBOLIC_CNAME, NUMERIC_CNAME};
            }
            return new byte[][]{Storage.handleTypeSymbolic(7), Storage.handleTypeNumeric(7), Storage.handleTypeSymbolic(8), Storage.handleTypeNumeric(8), Storage.handleTypeSymbolic(9), Storage.handleTypeNumeric(9)};
        }
        byte[] symbolic = Storage.handleTypeSymbolic(type);
        if (symbolic == null) {
            if (includeCNAME) {
                return new byte[][]{Storage.handleTypeNumeric(type), SYMBOLIC_CNAME, NUMERIC_CNAME};
            }
            return new byte[][]{Storage.handleTypeNumeric(type)};
        }
        if (includeCNAME) {
            return new byte[][]{symbolic, Storage.handleTypeNumeric(type), SYMBOLIC_CNAME, NUMERIC_CNAME};
        }
        return new byte[][]{symbolic, Storage.handleTypeNumeric(type)};
    }

    public static ResourceRecord handleValueToResourceRecord(DomainName name, HandleValue value) {
        String typeString = value.getTypeAsString();
        Integer type = handleTypeToDNSTypeMap.get(typeString);
        if (type == null) {
            try {
                if (!typeString.startsWith("DNS.TYPE")) {
                    return null;
                }
                type = Integer.parseInt(typeString.substring(8));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        int ttl = value.getTTL();
        if (value.getTTLType() == 1) {
            ttl -= (int)(System.currentTimeMillis() / 1000L);
        }
        if (ttl < 0) {
            ttl = 0;
        }
        try {
            return new ResourceRecord(name, type, 1, ttl, value.getDataAsString());
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public DomainName getZone() {
        return this.zone;
    }

    List<ResourceRecord> getRecords(DomainName name, int type, boolean includeCNAME) throws HandleException {
        byte[] handle;
        try {
            handle = name.toHandle(this.handlePrefix, this.zone.length());
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
        byte[][] handleTypes = Storage.dnsTypeToHandleTypes(type, includeCNAME);
        ResolutionRequest req = new ResolutionRequest(handle, handleTypes, null, null);
        if (this.dnsConfig.isCertify()) {
            req.certify = true;
        }
        SimpleResponseMessageCallback callback = new SimpleResponseMessageCallback();
        this.server.processRequest(req, callback);
        if (callback.response instanceof ResolutionResponse) {
            HandleValue[] values = ((ResolutionResponse)callback.response).getHandleValues();
            ArrayList<ResourceRecord> res = new ArrayList<ResourceRecord>();
            for (HandleValue value : values) {
                ResourceRecord rr = Storage.handleValueToResourceRecord(name, value);
                if (rr == null) continue;
                res.add(rr);
            }
            return res;
        }
        if (callback.response == null) {
            throw new HandleException(1, "Unexpected null response");
        }
        if (callback.response.responseCode == 100) {
            return null;
        }
        if (callback.response.responseCode == 200) {
            return Collections.emptyList();
        }
        throw new HandleException(1, "Unexpected response: " + callback.response);
    }

    List<ResourceRecord> getWildcardRecords(DomainName wildcard, DomainName name, int type, boolean includeCNAME) throws HandleException {
        List<ResourceRecord> rrs = this.getRecords(wildcard, type, includeCNAME);
        if (rrs == null) {
            return null;
        }
        ArrayList<ResourceRecord> newRRs = new ArrayList<ResourceRecord>(rrs.size());
        for (ResourceRecord rr : rrs) {
            ResourceRecord newRR = new ResourceRecord(name, rr.getTTL(), rr);
            newRRs.add(newRR);
        }
        return newRRs;
    }

    List<ResourceRecord> getRecords(DomainName name, int type) throws HandleException {
        return this.getRecords(name, type, true);
    }

    List<ResourceRecord> getNSRecords(DomainName name) throws HandleException {
        return this.getRecords(name, 2, false);
    }

    List<ResourceRecord> getWildcardNSRecords(DomainName wildcard, DomainName name) throws HandleException {
        return this.getWildcardRecords(wildcard, name, 2, false);
    }

    List<ResourceRecord> getWildcardRecords(DomainName wildcard, DomainName name, int type) throws HandleException {
        return this.getWildcardRecords(wildcard, name, type, true);
    }

    ResourceRecord getSOARecord(DomainName name) throws HandleException {
        List<ResourceRecord> rrs = this.getRecords(name, 6, false);
        if (rrs == null || rrs.size() != 1) {
            return null;
        }
        return rrs.get(0);
    }

    static {
        Field[] allFields;
        dnsTypeToHandleTypeMap = new HashMap<Integer, byte[]>();
        handleTypeToDNSTypeMap = new HashMap<String, Integer>();
        for (Field field : allFields = ResourceRecord.class.getFields()) {
            String name = field.getName();
            try {
                if (!name.startsWith("TYPE_")) continue;
                int type = field.getInt(null);
                dnsTypeToHandleTypeMap.put(type, Util.encodeString("DNS." + name.substring(5)));
                handleTypeToDNSTypeMap.put("DNS." + name.substring(5), type);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        SYMBOLIC_CNAME = Util.encodeString("DNS.CNAME");
        NUMERIC_CNAME = Util.encodeString("DNS.TYPE5");
        HDL_DNS_TYPES_ANY = new byte[][]{Util.encodeString("DNS.")};
        HDL_DNS_TYPES_CNAME = new byte[][]{SYMBOLIC_CNAME, NUMERIC_CNAME};
    }

    private class SimpleResponseMessageCallback
    implements ResponseMessageCallback {
        public AbstractResponse response = null;

        private SimpleResponseMessageCallback() {
        }

        @Override
        public void handleResponse(AbstractResponse response) {
            this.response = response;
        }
    }
}

