/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.tools;

import com.google.gson.Gson;
import com.google.gson.stream.JsonWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import net.cnri.util.SimpleCommandLine;
import net.cnri.util.StreamTable;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.GsonUtility;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleRecord;
import net.handle.hdllib.HandleStorage;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.ScanCallback;
import net.handle.hdllib.Util;
import net.handle.server.HandleStorageFactory;

public class StorageToJson {
    private static void printHelp() {
        System.out.println("First argument is directory of handle server.");
        System.out.println("Second argument is name of the output file.");
    }

    public static void main(String[] argv) throws Exception {
        SimpleCommandLine simpleCommandLine = new SimpleCommandLine(new String[0]);
        simpleCommandLine.parse(argv);
        List operands = simpleCommandLine.getOperands();
        if (operands.size() != 2) {
            StorageToJson.printHelp();
            return;
        }
        String configDirStr = (String)operands.get(0);
        String outFilename = (String)operands.get(1);
        StreamTable configTable = new StreamTable();
        File serverDir = new File(configDirStr);
        if (!serverDir.exists() || !serverDir.isDirectory()) {
            System.err.println("Invalid configuration directory: " + configDirStr + ".");
            return;
        }
        try {
            configTable.readFromFile(new File(serverDir, "config.dct"));
        }
        catch (Exception e) {
            System.err.println("Error reading configuration: " + e);
            return;
        }
        try {
            StreamTable serverConfig = (StreamTable)configTable.get("server_config");
            HandleStorage storage = HandleStorageFactory.getStorage(serverDir, serverConfig, true, true);
            StorageToJson.toJson(storage, outFilename);
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
        }
    }

    private static void toJson(HandleStorage storage, String fileName) throws IOException, HandleException {
        try (JsonWriter writer = new JsonWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), "UTF-8"));){
            writer.setIndent("  ");
            JsonPrefixScanner prefixScanner = new JsonPrefixScanner(writer);
            writer.beginObject();
            writer.name("homedPrefixes").beginArray();
            storage.scanNAs(prefixScanner);
            writer.endArray();
            JsonHandleScanner handleScanner = new JsonHandleScanner(writer, storage);
            writer.name("handleRecords").beginObject();
            storage.scanHandles(handleScanner);
            writer.endObject();
            writer.endObject();
        }
    }

    public static class JsonHandleScanner
    implements ScanCallback {
        private final JsonWriter writer;
        private final HandleStorage storage;

        public JsonHandleScanner(JsonWriter writer, HandleStorage storage) {
            this.writer = writer;
            this.storage = storage;
        }

        @Override
        public void scanHandle(byte[] handleBytes) throws HandleException {
            String handle = Util.decodeString(handleBytes);
            System.out.println("Storing " + handle);
            byte[][] handleRecordBytes = this.storage.getRawHandleValues(handleBytes, null, null);
            Gson gson = GsonUtility.getPrettyGson();
            HandleValue[] values = Encoder.decodeHandleValues(handleRecordBytes);
            HandleRecord handleRecord = new HandleRecord();
            handleRecord.setHandle(handle);
            handleRecord.setValues(values);
            try {
                this.writer.name(handle);
                gson.toJson((Object)handleRecord, HandleRecord.class, this.writer);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static class JsonPrefixScanner
    implements ScanCallback {
        private final JsonWriter writer;

        public JsonPrefixScanner(JsonWriter writer) {
            this.writer = writer;
        }

        @Override
        public void scanHandle(byte[] handleBytes) throws HandleException {
            String handle = Util.decodeString(handleBytes);
            try {
                this.writer.value(handle);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

