/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.tools;

import net.handle.hdllib.Encoder;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleStorage;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.ScanCallback;

public class StorageMigrator {
    private final HandleStorage source;
    private final HandleStorage destination;

    public StorageMigrator(HandleStorage source, HandleStorage destination) {
        this.source = source;
        this.destination = destination;
    }

    public void migrate() throws HandleException {
        this.destination.deleteAllRecords();
        this.source.scanNAs(new MigrateRecordCallBack(this.source, this.destination, true));
        this.source.scanHandles(new MigrateRecordCallBack(this.source, this.destination, false));
    }

    static class MigrateRecordCallBack
    implements ScanCallback {
        private final HandleStorage source;
        private final HandleStorage destination;
        private final boolean isNas;

        MigrateRecordCallBack(HandleStorage source, HandleStorage destination, boolean isNas) {
            this.source = source;
            this.destination = destination;
            this.isNas = isNas;
        }

        @Override
        public void scanHandle(byte[] handle) throws HandleException {
            if (this.isNas) {
                this.destination.setHaveNA(handle, true);
            } else {
                byte[][] rawValues = this.source.getRawHandleValues(handle, null, null);
                HandleValue[] values = MigrateRecordCallBack.handleValuesFromRawValues(rawValues);
                this.destination.createHandle(handle, values);
            }
            System.out.print(".");
        }

        private static HandleValue[] handleValuesFromRawValues(byte[][] values) throws HandleException {
            HandleValue[] retValues = new HandleValue[values.length];
            for (int i = 0; i < retValues.length; ++i) {
                retValues[i] = new HandleValue();
                Encoder.decodeHandleValue(values[i], 0, retValues[i]);
            }
            return retValues;
        }
    }
}

