/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.tools;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Properties;
import net.handle.apps.admintool.view.AuthWindow;
import net.handle.hdllib.AuthenticationInfo;
import net.handle.hdllib.ClientSessionTracker;
import net.handle.hdllib.PublicKeyAuthenticationInfo;
import net.handle.hdllib.Resolver;
import net.handle.hdllib.SessionSetupInfo;
import net.handle.hdllib.Util;
import org.python.util.InteractiveConsole;
import org.python.util.PythonInterpreter;

public class RunJython {
    private static final void printUsageAndExit() {
        System.err.println("usage: hdl-jython [-a | -authgui | -authpriv:<id>:<index>:<privkeyfile>:<passphrase>] [<scriptfile> ...]");
        System.err.println(" if <scriptfile> is omitted then hdl-jython will read jython commands from stdin.");
        System.err.println(" The 'resolver' variable is initialize to an instance of net.handle.hdllib.Resolver");
        System.err.println("   -h    prints this help message");
        System.err.println("   -v    turns on verbose resolution (tracing)");
        System.err.println(" The following arguments will set the 'auth' variable to an instance of AuthenticationInfo");
        System.err.println("   -auth   display GUI to acquire authentication interactively");
        System.err.println("   -authpriv:id:privkeyfile:passphrase  Use private key authentication using the ");
        System.err.println("           given handle, key index, private key file, and private key passphrase");
        System.exit(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) throws Exception {
        AuthenticationInfo auth = null;
        ArrayList<String> additionalArgs = new ArrayList<String>();
        String filename = null;
        boolean verbose = false;
        for (int i = 0; i < argv.length; ++i) {
            String arg = argv[i];
            if (arg == null || arg.trim().length() <= 0) continue;
            if (arg.equals("-h")) {
                RunJython.printUsageAndExit();
                continue;
            }
            if (arg.equals("-v")) {
                verbose = true;
                continue;
            }
            if (auth == null && arg.equals("-authgui")) {
                AuthWindow authWin = new AuthWindow(null, "jython");
                authWin.setVisible(true);
                if (authWin.wasCanceled()) {
                    System.exit(0);
                }
                auth = authWin.getAuthentication();
                authWin.dispose();
                continue;
            }
            if (auth == null && arg.startsWith("-authpriv:")) {
                String[] tokens = arg.substring("-authpriv:".length()).split(":");
                if (tokens.length < 3 || tokens.length > 3) {
                    RunJython.printUsageAndExit();
                    return;
                }
                String authID = tokens[0];
                int keyIndex = Integer.parseInt(tokens[1].trim());
                String privKeyFile = tokens[2];
                String passphrase = tokens.length > 3 ? tokens[3] : null;
                try {
                    ByteArrayOutputStream bout = new ByteArrayOutputStream();
                    byte[] buf = new byte[1024];
                    try (FileInputStream fin = new FileInputStream(privKeyFile);){
                        int r = 0;
                        while ((r = fin.read(buf)) >= 0) {
                            bout.write(buf, 0, r);
                        }
                    }
                    buf = bout.toByteArray();
                    buf = Util.decrypt(buf, passphrase == null ? null : Util.encodeString(passphrase));
                    auth = new PublicKeyAuthenticationInfo(Util.encodeString(authID), keyIndex, Util.getPrivateKeyFromBytes(buf, 0));
                    continue;
                }
                catch (Exception e) {
                    System.err.println("Error building authentication: " + e);
                    e.printStackTrace(System.err);
                    RunJython.printUsageAndExit();
                    return;
                }
            }
            if (filename == null) {
                filename = arg;
                continue;
            }
            additionalArgs.add(arg);
        }
        Properties preProperties = System.getProperties();
        Properties postProperties = new Properties();
        postProperties.put("python.cachedir", System.getProperty("user.home", ".") + "/.hdl_jythoncache");
        PythonInterpreter.initialize((Properties)preProperties, (Properties)postProperties, (String[])additionalArgs.toArray(new String[0]));
        InteractiveConsole python = filename == null ? new InteractiveConsole() : new PythonInterpreter();
        python.setErr((OutputStream)System.err);
        python.setOut((OutputStream)System.out);
        Resolver resolver = new Resolver();
        resolver.getResolver().traceMessages = verbose;
        if (auth != null) {
            ClientSessionTracker tracker = new ClientSessionTracker();
            tracker.setSessionSetupInfo(new SessionSetupInfo());
            resolver.getResolver().setSessionTracker(tracker);
        }
        python.set("resolver", (Object)resolver);
        if (auth != null) {
            python.set("auth", (Object)auth);
        }
        if (filename == null) {
            InteractiveConsole console = python;
            String welcome = "Welcome to hdl-jython console. Initialized variable(s): resolver" + (auth == null ? "" : " and auth");
            console.interact(welcome);
        } else {
            python.execfile(filename);
        }
    }
}

