/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.security.PrivateKey;
import net.handle.hdllib.Util;

public class KeyUtil {
    private static final void printUsage() {
        System.err.println("usage: net.handle.apps.tools.KeyUtil <privatekeyfile>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) throws Exception {
        if (argv.length < 1) {
            KeyUtil.printUsage();
            return;
        }
        PrivateKey privateKey = null;
        File privateKeyFile = null;
        try {
            int i;
            privateKeyFile = new File(argv[0]);
            if (!privateKeyFile.exists() || !privateKeyFile.canRead()) {
                System.err.println("Missing or inaccessible private key file: " + privateKeyFile.getAbsolutePath());
                return;
            }
            byte[] encKeyBytes = new byte[(int)privateKeyFile.length()];
            try (FileInputStream in = new FileInputStream(privateKeyFile);){
                int r;
                for (int n = 0; n < encKeyBytes.length && (r = in.read(encKeyBytes, n, encKeyBytes.length - n)) >= 0; n += r) {
                }
            }
            byte[] keyBytes = null;
            byte[] secKey = null;
            if (Util.requiresSecretKey(encKeyBytes)) {
                secKey = Util.getPassphrase("Enter the passphrase for this private key: ");
            }
            keyBytes = Util.decrypt(encKeyBytes, secKey);
            for (i = 0; secKey != null && i < secKey.length; ++i) {
                secKey[i] = 0;
            }
            privateKey = Util.getPrivateKeyFromBytes(keyBytes, 0);
            for (i = 0; i < keyBytes.length; ++i) {
                keyBytes[i] = 0;
            }
        }
        catch (Exception e) {
            System.err.println("Unable to read private key: " + e);
            return;
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        while (true) {
            System.out.println("\nChoose an operation:");
            System.out.println("  1: Encrypt private key with passphrase");
            System.out.println("  2: Save private key without encryption");
            System.out.println("  3: Exit");
            System.out.println("  --------------------------------------------------------------------------");
            System.out.println("  6: Encrypt private key using encryption compatible with version 6 software");
            System.out.println("  7: Encrypt private key using encryption compatible with version 7 software");
            System.out.println("  (only needed if you will use this key with old versions of the software)");
            System.out.flush();
            String line = in.readLine();
            if (line == null) break;
            if ((line = line.trim()).equals("1")) {
                KeyUtil.encryptKey(privateKey, privateKeyFile, 4);
                continue;
            }
            if (line.equals("2")) {
                KeyUtil.encryptKey(privateKey, privateKeyFile, 1);
                continue;
            }
            if (line.equals("6")) {
                int ancientEncryption = 0;
                KeyUtil.encryptKey(privateKey, privateKeyFile, ancientEncryption);
                continue;
            }
            if (line.equals("7")) {
                KeyUtil.encryptKey(privateKey, privateKeyFile, 2);
                continue;
            }
            if (line.equals("3")) {
                System.exit(0);
                continue;
            }
            System.out.println("Huh?  Please enter 1, 2, 3, 6, or 7");
        }
    }

    private static void encryptKey(PrivateKey privateKey, File privateKeyFile, int encryptionType) throws Exception {
        byte[] keyBytes = Util.getBytesFromPrivateKey(privateKey);
        byte[] encKeyBytes = null;
        if (encryptionType == 1) {
            encKeyBytes = Util.encrypt(keyBytes, null, encryptionType);
        } else {
            byte[] secKey2;
            byte[] secKey = null;
            while (!Util.equals(secKey = Util.getPassphrase("Please enter a new private key passphrase: "), secKey2 = Util.getPassphrase("Please re-enter the private key passphrase: "))) {
                System.out.println("Passphrases do not match!  Try again.\n");
            }
            encKeyBytes = Util.encrypt(keyBytes, secKey, encryptionType);
        }
        FileOutputStream out = new FileOutputStream(privateKeyFile);
        out.write(encKeyBytes);
        out.close();
        System.out.println("Private key saved to file: " + privateKeyFile);
    }
}

