/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.simple;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.PrivateKey;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.ClientSessionTracker;
import net.handle.hdllib.DeleteHandleRequest;
import net.handle.hdllib.HandleResolver;
import net.handle.hdllib.PublicKeyAuthenticationInfo;
import net.handle.hdllib.Util;

public class HDLDelete {
    public static void main(String[] argv) throws Exception {
        String line;
        if (argv.length != 4) {
            System.err.println("usage: java net.handle.apps.simple.HDLDelete <auth handle> <auth index> <privkey> <filename>");
            System.err.println(" <auth handle> is the handle that contains your public key");
            System.err.println(" <auth index> is the index of your public key in that handle");
            System.err.println(" <privkey> is the file containing your private key");
            System.err.println(" <filename> is the file containing the handles to delete");
            System.err.println(" Note:  if <filename> is '-' then the handles to delete will be read as input (stdin)");
            System.exit(-1);
        }
        byte[] key = null;
        try {
            File f = new File(argv[2]);
            try (FileInputStream fs = new FileInputStream(f);){
                key = Util.getBytesFromInputStream(fs);
            }
        }
        catch (Throwable t) {
            System.err.println("Cannot read private key " + argv[2] + ": " + t);
            System.exit(-1);
        }
        HandleResolver resolver = new HandleResolver();
        resolver.setSessionTracker(new ClientSessionTracker());
        PrivateKey privkey = null;
        byte[] secKey = null;
        try {
            if (Util.requiresSecretKey(key)) {
                secKey = Util.getPassphrase("passphrase: ");
            }
            key = Util.decrypt(key, secKey);
            privkey = Util.getPrivateKeyFromBytes(key, 0);
        }
        catch (Throwable t) {
            System.err.println("Can't load private key in " + argv[2] + ": " + t);
            System.exit(-1);
        }
        PublicKeyAuthenticationInfo auth = new PublicKeyAuthenticationInfo(Util.encodeString(argv[0]), Integer.parseInt(argv[1]), privkey);
        BufferedReader rdr = null;
        rdr = argv[3].equals("-") ? new BufferedReader(new InputStreamReader(System.in)) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(argv[3]), "UTF-8"));
        while ((line = rdr.readLine()) != null) {
            try {
                line = line.trim();
                DeleteHandleRequest req = new DeleteHandleRequest(Util.encodeString(line), auth);
                AbstractResponse response = resolver.processRequest(req);
                if (response == null || response.responseCode != 1) {
                    System.out.println("error deleting '" + line + "': " + response);
                    continue;
                }
                System.out.println("deleted " + line);
            }
            catch (Throwable t) {
                System.out.println("error deleting '" + line + "': " + t);
                t.printStackTrace(System.err);
            }
        }
        rdr.close();
    }
}

