/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.servlet_proxy;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Map;
import javax.servlet.ServletContext;
import net.cnri.util.Template;
import net.cnri.util.TemplateException;

public class HTMLFile {
    private final ServletContext context;
    String fileName;
    String dir;
    File file;
    private long lastModified;
    private final Hashtable<Object, Object> dict = new Hashtable();
    String page;
    boolean isResource;
    boolean isServletResource;

    public HTMLFile(String dir, String fileName, ServletContext context) throws IOException {
        this.context = context;
        this.fileName = fileName;
        if (dir.startsWith("servlet:")) {
            this.isServletResource = true;
            this.dir = dir.substring(8);
            this.file = null;
        } else if (dir.startsWith("res:")) {
            this.isResource = true;
            this.dir = dir.substring(4);
            this.file = null;
        } else {
            this.file = new File(fileName);
            if (this.file.isAbsolute()) {
                this.dir = "";
            } else {
                this.dir = dir;
                this.file = new File(new File(dir), fileName);
            }
        }
        this.loadFile();
    }

    private String getPath() {
        return this.dir + "/" + this.fileName;
    }

    private void loadFile() throws IOException {
        InputStream in;
        if (this.isServletResource) {
            in = this.context.getResourceAsStream(this.getPath());
        } else if (this.isResource) {
            in = this.getClass().getResourceAsStream(this.getPath());
        } else {
            this.lastModified = this.file.lastModified();
            System.err.println("loading file: " + this.file.getCanonicalPath());
            in = new FileInputStream(this.file);
        }
        char[] b = new char[1024];
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));){
            int len;
            StringBuffer sb = new StringBuffer();
            while ((len = reader.read(b)) != -1) {
                sb.append(b, 0, len);
            }
            this.page = sb.toString();
        }
    }

    public void setValue(String key, String val) {
        this.dict.put(key, val);
    }

    public void reset() {
        this.dict.clear();
    }

    public void output(OutputStream out) throws IOException {
        if (!this.isResource && !this.isServletResource && this.lastModified != this.file.lastModified()) {
            System.err.println("Reloading " + this.fileName);
            this.loadFile();
        }
        try {
            out.write(Template.subDictIntoString(this.page, this.dict).getBytes("UTF-8"));
        }
        catch (TemplateException e) {
            throw new IOException("Error templatizing page.", e);
        }
    }

    public void output(OutputStream out, Map<?, ?> dictParam) throws IOException {
        if (!this.isResource && !this.isServletResource && this.lastModified != this.file.lastModified()) {
            System.err.println("Reloading " + this.fileName);
            this.loadFile();
        }
        try {
            out.write(Template.subDictIntoString(this.page, dictParam).getBytes("UTF-8"));
        }
        catch (TemplateException e) {
            throw new IOException("Error templatizing page.", e);
        }
    }
}

