/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.servlet_proxy;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.handle.hdllib.Util;
import org.apache.commons.codec.binary.Base64;

public class BasicAuthFilter
implements Filter {
    private static String configUsername = null;
    private static String configPassword = null;

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletResponse response = (HttpServletResponse)res;
        if (!request.isSecure()) {
            request.getServletContext().log("Request sent to HTTP, must be HTTPS");
            response.setStatus(403);
            return;
        }
        if (this.isAuthorized(request)) {
            chain.doFilter(request, (ServletResponse)response);
        } else {
            request.getServletContext().log("Unauthorized request");
            response.setHeader("WWW-Authenticate", "Basic realm=\"admin\"");
            response.setStatus(401);
        }
    }

    public void init(FilterConfig config) throws ServletException {
        configUsername = config.getInitParameter("username");
        configPassword = config.getInitParameter("password");
    }

    private boolean isAuthorized(ServletRequest request) {
        String authHeader = ((HttpServletRequest)request).getHeader("Authorization");
        if (authHeader == null) {
            return false;
        }
        Credentials c = new Credentials(authHeader);
        return BasicAuthFilter.checkPassword(c.getUsername(), c.getPassword());
    }

    public static boolean checkPassword(String userID, String password) {
        return configPassword.equals(password) && configUsername.equals(userID);
    }

    protected class Credentials {
        private final String username;
        private final String password;

        public Credentials(String authHeader) {
            String encodedUsernameAndPassWord = this.getEncodedUserNameAndPassword(authHeader);
            String decodedAuthHeader = Util.decodeString(Base64.decodeBase64((String)encodedUsernameAndPassWord));
            this.username = decodedAuthHeader.substring(0, decodedAuthHeader.indexOf(":"));
            this.password = decodedAuthHeader.substring(decodedAuthHeader.indexOf(":") + 1);
        }

        private String getEncodedUserNameAndPassword(String authHeader) {
            return authHeader.substring(authHeader.indexOf(" ") + 1);
        }

        public String getPassword() {
            return this.password;
        }

        public String getUsername() {
            return this.username;
        }
    }
}

