/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.gui.resolver;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.StringTokenizer;
import java.util.Vector;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.Common;
import net.handle.hdllib.HandleResolver;
import net.handle.hdllib.ResolutionRequest;
import net.handle.hdllib.Util;

public class Main
extends Frame
implements ActionListener,
ItemListener {
    private final HandleResolver resolver = new HandleResolver();
    private final TextField handleField;
    private final Button goButton;
    private final TextArea consoleArea;
    private final TextField indexesField;
    private final TextField typesField;
    private final Choice typesChoice;
    private final Checkbox certifyCheckbox;
    private final Checkbox authCheckbox;
    private static GridBagConstraints c = new GridBagConstraints();

    public Main() {
        super("Handle Resolution Visualizer");
        this.resolver.traceMessages = true;
        this.handleField = new TextField("", 30);
        this.certifyCheckbox = new Checkbox("Certify Responses", false);
        this.authCheckbox = new Checkbox("Authoritative Requests", false);
        this.consoleArea = new TextArea();
        this.consoleArea.setEditable(false);
        this.goButton = new Button("Resolve Handle");
        this.indexesField = new TextField("", 20);
        this.typesField = new TextField("", 20);
        this.typesChoice = new Choice();
        this.typesChoice.addItem("--Common Types--");
        for (int i = 0; i < Common.STD_TYPES.length; ++i) {
            this.typesChoice.addItem(Util.decodeString(Common.STD_TYPES[i]));
        }
        this.setLayout(new GridBagLayout());
        int x = 0;
        int y = 0;
        this.add((Component)new Label("Handle: ", 2), Main.getConstraints(x, y, 0.0, 0.0, 1, 1, true, true));
        this.add((Component)this.handleField, Main.getConstraints(x + 1, y, 1.0, 0.0, 1, 1, true, true));
        this.add((Component)this.goButton, Main.getConstraints(x + 2, y++, 0.0, 0.0, 1, 1, true, true));
        this.add((Component)new Label("Types: ", 2), Main.getConstraints(x, y, 0.0, 0.0, 1, 1, true, true));
        this.add((Component)this.typesField, Main.getConstraints(x + 1, y, 1.0, 0.0, 1, 1, true, true));
        this.add((Component)this.typesChoice, Main.getConstraints(x + 2, y++, 0.0, 0.0, 1, 1, true, true));
        this.add((Component)new Label("Indexes: ", 2), Main.getConstraints(0, y, 0.0, 0.0, 1, 1, true, true));
        this.add((Component)this.indexesField, Main.getConstraints(x + 1, y++, 1.0, 0.0, 2, 1, true, true));
        Panel p = new Panel(new GridBagLayout());
        p.add((Component)this.authCheckbox, Main.getConstraints(0, 0, 1.0, 0.0, 1, 1, false, false));
        p.add((Component)this.certifyCheckbox, Main.getConstraints(1, 0, 1.0, 0.0, 1, 1, false, false));
        this.add((Component)p, Main.getConstraints(x + 1, y++, 1.0, 0.0, 2, 1, true, true));
        this.add((Component)this.consoleArea, Main.getConstraints(x, y++, 1.0, 1.0, 3, 1, true, true));
        this.goButton.addActionListener(this);
        this.handleField.addActionListener(this);
        this.typesField.addActionListener(this);
        this.indexesField.addActionListener(this);
        ConsoleStream consoleStream = new ConsoleStream(this.consoleArea);
        PrintStream consolePrintStream = new PrintStream(consoleStream, true);
        System.setErr(consolePrintStream);
        System.setOut(consolePrintStream);
        this.typesChoice.addItemListener(this);
        Dimension sz = new Dimension(800, 500);
        this.setSize(sz);
        Toolkit tk = Toolkit.getDefaultToolkit();
        if (tk == null) {
            this.setLocation(20, 20);
        } else {
            Dimension ssz = tk.getScreenSize();
            this.setLocation(ssz.width / 2 - sz.width / 2, ssz.height / 2 - sz.height / 2);
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                Main.this.setVisible(false);
                System.exit(0);
            }
        });
    }

    private void typeSelected() {
        int selIdx = this.typesChoice.getSelectedIndex();
        if (selIdx > 0) {
            String selItem = this.typesChoice.getSelectedItem();
            this.typesField.setText((this.typesField.getText().trim() + ' ' + selItem).trim());
            this.typesChoice.select(0);
        }
    }

    private void doResolution() {
        this.consoleArea.setText("");
        try {
            byte[][] types = null;
            String typeStr = this.typesField.getText().trim();
            if (typeStr.length() > 0) {
                StringTokenizer st = new StringTokenizer(typeStr);
                types = new byte[st.countTokens()][];
                for (int i = 0; i < types.length; ++i) {
                    types[i] = Util.encodeString(st.nextToken().trim());
                }
            }
            int[] indexes = null;
            String indexStr = this.indexesField.getText().trim();
            if (indexStr.length() > 0) {
                Vector<Integer> indexVect = new Vector<Integer>();
                StringTokenizer st = new StringTokenizer(indexStr);
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    try {
                        int index = Integer.parseInt(token);
                        if (index < 0) {
                            System.err.println("Invalid index value: " + index + " - indexes must be non-negative");
                            continue;
                        }
                        indexVect.addElement(index);
                    }
                    catch (Exception e) {
                        System.err.println("Invalid index value: " + token);
                    }
                }
                indexes = new int[indexVect.size()];
                for (int i = 0; i < indexes.length; ++i) {
                    indexes[i] = (Integer)indexVect.elementAt(i);
                }
            }
            ResolutionRequest req = new ResolutionRequest(Util.encodeString(this.handleField.getText()), types, indexes, null);
            req.certify = this.certifyCheckbox.getState();
            req.authoritative = this.authCheckbox.getState();
            AbstractResponse response = this.resolver.processRequest(req);
            System.err.println("\nGot Response: \n" + response);
        }
        catch (Throwable t) {
            System.err.println("\nError: " + t);
            t.printStackTrace(System.err);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent evt) {
        this.typeSelected();
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        this.doResolution();
    }

    public static void main(String[] argv) {
        Main m = new Main();
        m.setVisible(true);
    }

    private static GridBagConstraints getDefaultGC() {
        Main.c.gridx = 0;
        Main.c.gridy = 0;
        Main.c.weightx = 1.0;
        Main.c.weighty = 1.0;
        Main.c.anchor = 10;
        Main.c.gridwidth = 1;
        Main.c.gridheight = 1;
        Main.c.fill = 1;
        return c;
    }

    private static GridBagConstraints getConstraints(int x, int y, double weightx, double weighty, int gridwidth, int gridheight, boolean fillHorizontal, boolean fillVertical) {
        GridBagConstraints gc = Main.getDefaultGC();
        gc.weightx = weightx;
        gc.weighty = weighty;
        gc.gridx = x;
        gc.gridy = y;
        gc.gridwidth = gridwidth;
        gc.gridheight = gridheight;
        gc.fill = fillHorizontal && fillVertical ? 1 : (fillHorizontal ? 2 : (fillVertical ? 3 : 0));
        return gc;
    }

    class ConsoleStream
    extends OutputStream {
        private final TextArea console;

        ConsoleStream(TextArea console) {
            this.console = console;
        }

        @Override
        public void write(byte[] buf) {
            this.console.append(new String(buf));
        }

        @Override
        public void write(byte[] buf, int offset, int length) {
            this.console.append(new String(buf, offset, length));
        }

        @Override
        public void write(int ich) {
            this.console.append(String.valueOf((char)ich));
        }
    }
}

