/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.gui.jwidget;

import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import net.handle.apps.gui.jwidget.GenDataJPanel;
import net.handle.awt.AwtUtil;
import net.handle.hdllib.Common;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.Util;

public class SecretKeyDataJPanel
extends GenDataJPanel {
    protected JTextField secretKeyField = new JTextField("", 30);
    protected JCheckBox hashedPassBox;

    public SecretKeyDataJPanel(byte[] type, boolean moreFlag, boolean editFlag) {
        this(type, moreFlag, editFlag, 0);
    }

    public SecretKeyDataJPanel(byte[] type, boolean moreFlag, boolean editFlag, int index) {
        super(moreFlag, editFlag, index);
        String labelStr = " " + Util.decodeString(type) + ": ";
        this.hashedPassBox = new JCheckBox("Use SHA-1 hash of password", false);
        this.secretKeyField.setEditable(editFlag);
        this.panel.add((Component)new JLabel(labelStr, 4), AwtUtil.getConstraints(0, 1, 0.0, 0.0, 1, 1, true, true));
        this.panel.add((Component)this.secretKeyField, AwtUtil.getConstraints(1, 1, 1.0, 0.0, 1, 1, true, false));
        this.panel.add((Component)this.hashedPassBox, AwtUtil.getConstraints(1, 2, 1.0, 0.0, 1, 1, true, true));
        this.handlevalue.setType(type);
        if (this.handlevalue.hasType(Common.STD_TYPE_HSSECKEY)) {
            this.handlevalue.setAnyoneCanRead(false);
        }
    }

    @Override
    public void setValueData(byte[] data) {
        if (data == Common.EMPTY_BYTE_ARRAY || data == null) {
            System.err.println("warning message: Handle value data is empty");
            return;
        }
        String str = Util.looksLikeBinary(data) ? Util.decodeHexString(data, false) : Util.decodeString(data);
        this.secretKeyField.setText(str);
        this.secretKeyField.setScrollOffset(0);
    }

    @Override
    public byte[] getValueData() {
        try {
            return Encoder.encodeSecretKey(Util.encodeString(this.secretKeyField.getText().trim()), this.hashedPassBox.isSelected());
        }
        catch (Exception e) {
            System.err.println("warning message: Exception at getValueData");
            return Common.EMPTY_BYTE_ARRAY;
        }
    }
}

