/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.gui.jwidget;

import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PublicKey;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.handle.apps.gui.jutil.BrowsePanel;
import net.handle.apps.gui.jutil.MyButton;
import net.handle.apps.gui.jwidget.GenDataJPanel;
import net.handle.apps.gui.jwidget.GenerateKeyJPanel;
import net.handle.awt.AwtUtil;
import net.handle.hdllib.Common;
import net.handle.hdllib.Util;

public class PubkeyDataJPanel
extends GenDataJPanel {
    protected JTextArea keyField;
    protected BrowsePanel browser;
    protected MyButton genKeyButton = new MyButton("Generate Key Pair", "click to generate public key and private");
    protected MyButton loadKeyButton;
    protected MyButton saveKeyButton;
    protected MyButton clearButton;
    protected PublicKey pubkey = null;

    public PubkeyDataJPanel(boolean moreFlag, boolean editFlag) {
        this(moreFlag, editFlag, 1);
    }

    public PubkeyDataJPanel(boolean moreFlag, boolean editFlag, int index) {
        super(moreFlag, editFlag, index);
        this.genKeyButton.addActionListener(this);
        this.genKeyButton.setEnabled(editFlag);
        this.loadKeyButton = new MyButton("Load Key", "click to load keyfile");
        this.loadKeyButton.addActionListener(this);
        this.loadKeyButton.setEnabled(editFlag);
        this.saveKeyButton = new MyButton("Save Key", "Click to save the public key to a file");
        this.saveKeyButton.addActionListener(this);
        this.clearButton = new MyButton("Clear", "click to clear key field");
        this.clearButton.addActionListener(this);
        this.clearButton.setEnabled(editFlag);
        this.keyField = new JTextArea(4, 25);
        this.keyField.setEditable(false);
        JScrollPane sp = new JScrollPane(this.keyField);
        int x = 0;
        int y = 0;
        this.panel.add((Component)new JLabel(" Public Key:", 4), AwtUtil.getConstraints(x, y, 0.0, 0.0, 1, 1, true, true));
        this.panel.add((Component)sp, AwtUtil.getConstraints(x + 1, y++, 1.0, 1.0, 4, 1, new Insets(8, 8, 8, 10), true, false));
        this.panel.add((Component)this.genKeyButton, AwtUtil.getConstraints(x + 1, y, 0.0, 1.0, 1, 1, new Insets(8, 8, 8, 5), false, false));
        this.panel.add((Component)this.loadKeyButton, AwtUtil.getConstraints(x + 2, y, 0.0, 1.0, 1, 1, new Insets(8, 8, 8, 5), false, false));
        this.panel.add((Component)this.saveKeyButton, AwtUtil.getConstraints(x + 3, y, 0.0, 1.0, 1, 1, new Insets(8, 8, 8, 5), false, false));
        this.panel.add((Component)this.clearButton, AwtUtil.getConstraints(x + 4, y, 0.0, 1.0, 1, 1, new Insets(8, 8, 8, 5), false, false));
        this.handlevalue.setType(Common.STD_TYPE_HSPUBKEY);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Generate Key Pair")) {
            this.generateKey();
        } else if (e.getActionCommand().equals("More")) {
            this.more();
        } else if (e.getActionCommand().equals("Load Key")) {
            this.loadkey();
        } else if (e.getActionCommand().equals("Save Key")) {
            this.savekey();
        } else if (e.getActionCommand().equals("Clear")) {
            this.clear();
        } else {
            System.err.println("Error Input");
        }
    }

    @Override
    public byte[] getValueData() {
        if (this.pubkey == null) {
            System.err.println("Error: public key is null");
            return null;
        }
        try {
            byte[] buf = Util.getBytesFromPublicKey(this.pubkey);
            return buf;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return Common.EMPTY_BYTE_ARRAY;
        }
    }

    @Override
    public void setValueData(byte[] data) {
        if (data == Common.EMPTY_BYTE_ARRAY) {
            System.err.println("warning message: Handle value data is empty");
            return;
        }
        this.clear();
        this.keyField.setText(Util.decodeHexString(data, true));
        try {
            this.pubkey = Util.getPublicKeyFromBytes(data, 0);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public void clear() {
        this.keyField.setText("");
        this.pubkey = null;
    }

    public void generateKey() {
        GenerateKeyJPanel keyPanel = new GenerateKeyJPanel(new File(""));
        JOptionPane.showOptionDialog(this, keyPanel, "Generate Key Pair: ", 0, -1, null, new Object[]{"Close"}, null);
        this.pubkey = keyPanel.getCurrentPublicKey();
        if (this.pubkey == null) {
            return;
        }
        try {
            byte[] buffer = Util.getBytesFromPublicKey(this.pubkey);
            this.keyField.setText(Util.decodeHexString(buffer, true));
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public void savekey() {
        if (this.pubkey == null) {
            JOptionPane.showMessageDialog(this, "There is no public key to save!", "Error", 0);
            return;
        }
        JFileChooser chooser = new JFileChooser();
        int returnVal = chooser.showSaveDialog(this);
        File keyFile = null;
        if (returnVal == 0) {
            keyFile = chooser.getSelectedFile();
        }
        if (keyFile == null) {
            return;
        }
        try (FileOutputStream out = new FileOutputStream(keyFile);){
            ((OutputStream)out).write(Util.getBytesFromPublicKey(this.pubkey));
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            JOptionPane.showMessageDialog(this, "Error: " + e, "Error", 0);
        }
    }

    public void loadkey() {
        this.browser = new BrowsePanel(" Public Key: ", (File)null, File.separator + "pubkey.bin", null, false);
        if (2 == JOptionPane.showConfirmDialog(null, this.browser, "Load Public Key: ", 2, -1)) {
            return;
        }
        File[] files = new File[1];
        if (!this.browser.getReadFile(files)) {
            return;
        }
        try (FileInputStream in = new FileInputStream(files[0]);){
            byte[] rawKey = new byte[(int)files[0].length()];
            int r = 0;
            for (int n = 0; n < rawKey.length && (r = ((InputStream)in).read(rawKey, n, rawKey.length - n)) > 0; n += r) {
            }
            this.keyField.setText(Util.decodeHexString(rawKey, true));
            this.pubkey = Util.getPublicKeyFromBytes(rawKey, 0);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }
}

