/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.gui.jwidget;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.util.Date;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import net.handle.apps.gui.jutil.CommonDef;
import net.handle.apps.gui.jwidget.AdminDataJPanel;
import net.handle.apps.gui.jwidget.HandleValueJPanel;
import net.handle.apps.gui.jwidget.PubkeyDataJPanel;
import net.handle.apps.gui.jwidget.SiteDataJPanel;
import net.handle.apps.gui.jwidget.TextDataJPanel;
import net.handle.apps.gui.jwidget.VListDataJPanel;
import net.handle.awt.AwtUtil;
import net.handle.hdllib.Common;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.ValueReference;

public class HandleValueTable
extends JPanel
implements ListSelectionListener {
    Object[][] dataObj;
    Object[] header;
    DefaultTableModel tmodel;
    ListSelectionModel smodel;
    JTable table;
    HandleValue[] this_values;

    public HandleValueTable() {
        this((HandleValue[])null);
    }

    public HandleValueTable(HandleValue[] values) {
        super(new GridBagLayout());
        this.this_values = values;
        this.dataObj = this.toObjects(values);
        this.header = CommonDef.HANDLE_VALUE_HEADER;
        this.tmodel = new DefaultTableModel(this.dataObj, this.header);
        this.table = new JTable(this.tmodel);
        this.table.setAutoResizeMode(0);
        this.table.setCellSelectionEnabled(false);
        this.table.setColumnSelectionAllowed(false);
        this.smodel = this.table.getSelectionModel();
        this.smodel.setSelectionMode(0);
        this.smodel.setValueIsAdjusting(true);
        this.smodel.addListSelectionListener(this);
        JScrollPane scroll = new JScrollPane(this.table);
        scroll.setPreferredSize(new Dimension(550, 150));
        scroll.setMinimumSize(new Dimension(200, 100));
        this.add((Component)scroll, AwtUtil.getConstraints(0, 0, 1.0, 1.0, 1, 1, true, true));
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting() || this.smodel.isSelectionEmpty()) {
            return;
        }
        int r = this.smodel.getMinSelectionIndex();
        String typeStr = (String)this.tmodel.getValueAt(r, 1);
        if (typeStr == null) {
            return;
        }
        HandleValue value = this.this_values[r];
        this.viewValue(value);
        this.smodel.clearSelection();
    }

    protected void viewValue(HandleValue value) {
        if (value == null) {
            return;
        }
        JPanel p = null;
        if (value.hasType(Common.STD_TYPE_HSADMIN)) {
            p = new AdminDataJPanel(true, false);
            p.setHandleValue(value);
        } else if (value.hasType(Common.STD_TYPE_HSVALLIST)) {
            p = new VListDataJPanel(true, false);
            ((VListDataJPanel)p).setHandleValue(value);
        } else if (value.hasType(Common.STD_TYPE_HSSITE)) {
            p = new SiteDataJPanel(true, false);
            ((SiteDataJPanel)p).setHandleValue(value);
        } else if (value.hasType(Common.STD_TYPE_HSPUBKEY)) {
            p = new PubkeyDataJPanel(true, false);
            ((PubkeyDataJPanel)p).setHandleValue(value);
        } else if (value.hasType(Common.STD_TYPE_HSSECKEY)) {
            p = new TextDataJPanel(Common.STD_TYPE_HSSECKEY, true, false);
            ((TextDataJPanel)p).setHandleValue(value);
        } else if (value.hasType(Common.STD_TYPE_URL)) {
            p = new TextDataJPanel(Common.STD_TYPE_URL, true, false);
            ((TextDataJPanel)p).setHandleValue(value);
        } else if (value.hasType(Common.STD_TYPE_EMAIL)) {
            p = new TextDataJPanel(Common.STD_TYPE_EMAIL, true, false);
            ((TextDataJPanel)p).setHandleValue(value);
        } else if (value.hasType(Common.STD_TYPE_HSSERV)) {
            p = new TextDataJPanel(Common.STD_TYPE_HSSERV, true, false);
            ((TextDataJPanel)p).setHandleValue(value);
        } else {
            p = new HandleValueJPanel(false);
            ((HandleValueJPanel)p).setHandleValue(value);
        }
        JOptionPane.showMessageDialog(this, p, "View handle Value: ", -1);
    }

    public void setHandleValues(HandleValue[] values) {
        this.dataObj = this.toObjects(values);
        this.tmodel.setDataVector(this.dataObj, this.header);
        this.this_values = values;
    }

    private Object[][] toObjects(HandleValue[] values) {
        if (values == null) {
            return new Object[0][0];
        }
        Object[][] objs = new Object[values.length][this.header.length];
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) continue;
            block11: for (int j = 0; j < this.header.length; ++j) {
                switch (j) {
                    case 0: {
                        objs[i][j] = values[i].getIndex();
                        continue block11;
                    }
                    case 1: {
                        objs[i][j] = values[i].getTypeAsString();
                        continue block11;
                    }
                    case 2: {
                        objs[i][j] = values[i].getDataAsString();
                        continue block11;
                    }
                    case 3: {
                        objs[i][j] = values[i].getPermissionString();
                        continue block11;
                    }
                    case 4: {
                        if (values[i].getTTLType() == 0) {
                            objs[i][j] = "RELATIVE";
                            continue block11;
                        }
                        objs[i][j] = "ABSOLUTE";
                        continue block11;
                    }
                    case 5: {
                        if (values[i].getTTLType() == 0) {
                            objs[i][j] = String.valueOf(values[i].getTTL()) + " secs";
                            continue block11;
                        }
                        objs[i][j] = new Date((long)values[i].getTTL() * 1000L);
                        continue block11;
                    }
                    case 6: {
                        objs[i][j] = new Date((long)values[i].getTimestamp() * 1000L);
                        continue block11;
                    }
                    case 7: {
                        ValueReference[] refs = values[i].getReferences();
                        objs[i][j] = refs == null || refs.length < 1 ? "null" : refs;
                    }
                }
            }
        }
        return objs;
    }
}

