/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.gui.jwidget;

import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Date;
import java.util.Vector;
import javax.swing.JOptionPane;
import net.handle.apps.gui.jutil.MyButton;
import net.handle.apps.gui.jwidget.AdminDataJPanel;
import net.handle.apps.gui.jwidget.CustomDataJPanel;
import net.handle.apps.gui.jwidget.HandleValueEntryJPanel;
import net.handle.apps.gui.jwidget.PubkeyDataJPanel;
import net.handle.apps.gui.jwidget.SecretKeyDataJPanel;
import net.handle.apps.gui.jwidget.SiteDataJPanel;
import net.handle.apps.gui.jwidget.TextDataJPanel;
import net.handle.apps.gui.jwidget.VListDataJPanel;
import net.handle.awt.AwtUtil;
import net.handle.hdllib.Common;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.Util;
import net.handle.hdllib.ValueReference;

public class HandleValueJPanel
extends HandleValueEntryJPanel
implements ActionListener,
ItemListener {
    protected MyButton dataButton;
    protected boolean editFlag;
    int index;

    public HandleValueJPanel(boolean editFlag) {
        this(editFlag, 1);
    }

    public HandleValueJPanel(boolean editFlag, int index) {
        super(editFlag);
        this.editFlag = editFlag;
        if (editFlag) {
            this.typeField.addItemListener(this);
            this.indexField.setText(String.valueOf(index));
        }
        this.dataButton = new MyButton(" Value Data ", "Click to modify the data portion of this value", "Value Data");
        this.dataButton.addActionListener(this);
        this.index = index;
        this.panel1.add((Component)this.dataButton, AwtUtil.getConstraints(4, 0, 1.0, 0.0, 1, 1, new Insets(1, 30, 1, 10), 17, true, true));
    }

    @Override
    public void itemStateChanged(ItemEvent it) {
        if (it.getSource() != this.typeField) {
            return;
        }
        String itemStr = (String)it.getItem();
        byte[] item = Util.encodeString(itemStr);
        this.publicReadCheckbox.setSelected(true);
        if (Util.equalsCI(item, Common.STD_TYPE_HSADMIN)) {
            this.indexField.setText("100");
        } else if (Util.equalsCI(item, Common.STD_TYPE_HSSITE)) {
            this.indexField.setText("1");
        } else if (Util.equalsCI(item, Common.STD_TYPE_HSVALLIST)) {
            this.indexField.setText("200");
        } else if (Util.equalsCI(item, Common.STD_TYPE_HSSECKEY)) {
            this.indexField.setText("300");
            this.publicReadCheckbox.setSelected(false);
        } else if (Util.equalsCI(item, Common.STD_TYPE_HSPUBKEY)) {
            this.indexField.setText("300");
        } else {
            this.indexField.setText("");
        }
        this.indexField.invalidate();
        this.publicReadCheckbox.invalidate();
        this.validate();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.dataButton) {
            String typeStr = (String)this.typeField.getSelectedItem();
            if (Util.equals(Util.encodeString(typeStr), Common.STD_TYPE_HSADMIN)) {
                AdminDataJPanel p = new AdminDataJPanel(false, this.editFlag, this.index);
                if (!this.handlevalue.hasType(Common.STD_TYPE_HSADMIN)) {
                    this.handlevalue.setType(Common.STD_TYPE_HSADMIN);
                    this.handlevalue.setData(Common.EMPTY_BYTE_ARRAY);
                }
                p.setHandleValue(this.handlevalue);
                if (2 == JOptionPane.showConfirmDialog(null, p, "Input Administrator Info: ", 2, -1)) {
                    return;
                }
                this.handlevalue = p.getHandleValue();
            } else if (Util.equals(Util.encodeString(typeStr), Common.STD_TYPE_HSPUBKEY)) {
                PubkeyDataJPanel p = new PubkeyDataJPanel(false, this.editFlag, this.index);
                if (!this.handlevalue.hasType(Common.STD_TYPE_HSPUBKEY)) {
                    this.handlevalue.setType(Common.STD_TYPE_HSPUBKEY);
                    this.handlevalue.setData(Common.EMPTY_BYTE_ARRAY);
                }
                p.setHandleValue(this.handlevalue);
                if (2 == JOptionPane.showConfirmDialog(null, p, "Input Public Key Info: ", 2, -1)) {
                    return;
                }
                this.handlevalue = p.getHandleValue();
            } else if (Util.equals(Util.encodeString(typeStr), Common.STD_TYPE_HSSITE)) {
                SiteDataJPanel p = new SiteDataJPanel(false, this.editFlag, this.index);
                if (!this.handlevalue.hasType(Common.STD_TYPE_HSSITE)) {
                    this.handlevalue.setType(Common.STD_TYPE_HSSITE);
                    this.handlevalue.setData(Common.EMPTY_BYTE_ARRAY);
                }
                p.setHandleValue(this.handlevalue);
                if (2 == JOptionPane.showConfirmDialog(null, p, "Input Site Info: ", 2, -1)) {
                    return;
                }
                this.handlevalue = p.getHandleValue();
            } else if (Util.equals(Util.encodeString(typeStr), Common.STD_TYPE_HSVALLIST)) {
                VListDataJPanel p = new VListDataJPanel(false, this.editFlag, this.index);
                if (!this.handlevalue.hasType(Common.STD_TYPE_HSVALLIST)) {
                    this.handlevalue.setType(Common.STD_TYPE_HSVALLIST);
                    this.handlevalue.setData(Common.EMPTY_BYTE_ARRAY);
                }
                p.setHandleValue(this.handlevalue);
                if (2 == JOptionPane.showConfirmDialog(null, p, "Input Administrator Group Info: ", 2, -1)) {
                    return;
                }
                this.handlevalue = p.getHandleValue();
            } else if (Util.equals(Util.encodeString(typeStr), Common.STD_TYPE_HSSECKEY)) {
                SecretKeyDataJPanel p = new SecretKeyDataJPanel(Common.STD_TYPE_HSSECKEY, false, this.editFlag, this.index);
                if (!this.handlevalue.hasType(Common.STD_TYPE_HSSECKEY)) {
                    this.handlevalue.setType(Common.STD_TYPE_HSSECKEY);
                    this.handlevalue.setData(Common.EMPTY_BYTE_ARRAY);
                }
                p.setHandleValue(this.handlevalue);
                if (2 == JOptionPane.showConfirmDialog(null, p, "Input Secret Key Info: ", 2, -1)) {
                    return;
                }
                this.handlevalue = p.getHandleValue();
            } else if (Util.equals(Util.encodeString(typeStr), Common.STD_TYPE_EMAIL)) {
                TextDataJPanel p = new TextDataJPanel(Common.STD_TYPE_EMAIL, false, this.editFlag, this.index);
                if (!this.handlevalue.hasType(Common.STD_TYPE_EMAIL)) {
                    this.handlevalue.setType(Common.STD_TYPE_EMAIL);
                    this.handlevalue.setData(Common.EMPTY_BYTE_ARRAY);
                }
                p.setHandleValue(this.handlevalue);
                if (2 == JOptionPane.showConfirmDialog(null, p, "Input Email Info: ", 2, -1)) {
                    return;
                }
                this.handlevalue = p.getHandleValue();
            } else if (Util.equals(Util.encodeString(typeStr), Common.STD_TYPE_URL)) {
                TextDataJPanel p = new TextDataJPanel(Common.STD_TYPE_URL, false, this.editFlag, this.index);
                if (!this.handlevalue.hasType(Common.STD_TYPE_URL)) {
                    this.handlevalue.setType(Common.STD_TYPE_URL);
                    this.handlevalue.setData(Common.EMPTY_BYTE_ARRAY);
                }
                p.setHandleValue(this.handlevalue);
                if (2 == JOptionPane.showConfirmDialog(null, p, "Input URL Info: ", 2, -1)) {
                    return;
                }
                this.handlevalue = p.getHandleValue();
            } else if (Util.equals(Util.encodeString(typeStr), Common.STD_TYPE_HSSERV)) {
                TextDataJPanel p = new TextDataJPanel(Common.STD_TYPE_HSSERV, false, this.editFlag, this.index);
                if (!this.handlevalue.hasType(Common.STD_TYPE_HSSERV)) {
                    this.handlevalue.setType(Common.STD_TYPE_HSSERV);
                    this.handlevalue.setData(Common.EMPTY_BYTE_ARRAY);
                }
                p.setHandleValue(this.handlevalue);
                if (2 == JOptionPane.showConfirmDialog(null, p, "Input Service Info: ", 2, -1)) {
                    return;
                }
                this.handlevalue = p.getHandleValue();
            } else {
                System.err.println("warning message: Unknown data type");
                byte[] typeBytes = Util.encodeString(typeStr);
                CustomDataJPanel p = new CustomDataJPanel(typeBytes, false, this.editFlag, this.index);
                p.setHandleValue(this.handlevalue);
                if (2 == JOptionPane.showConfirmDialog(null, p, "Input Data Info: ", 2, -1)) {
                    return;
                }
                this.handlevalue = p.getHandleValue();
            }
        } else {
            System.err.println("Error Input");
        }
    }

    @Override
    public void setHandleValue(HandleValue value) {
        if (value == null) {
            return;
        }
        this.setIndex(value.getIndex());
        String type = Util.decodeString(value.getType());
        this.typeField.setSelectedItem(type);
        switch (value.getTTLType()) {
            case 1: {
                this.ttlTypeChoice.setSelectedIndex(1);
                break;
            }
            case 0: {
                this.ttlTypeChoice.setSelectedIndex(0);
            }
        }
        this.ttlField.setText(String.valueOf(value.getTTL()));
        this.timestampField.setText(new Date((long)value.getTimestamp() * 1000L).toString());
        this.adminReadCheckbox.setSelected(value.getAdminCanRead());
        this.adminWriteCheckbox.setSelected(value.getAdminCanWrite());
        this.publicReadCheckbox.setSelected(value.getAnyoneCanRead());
        this.publicWriteCheckbox.setSelected(value.getAnyoneCanWrite());
        ValueReference[] refs = value.getReferences();
        if (refs != null) {
            for (int i = 0; i < refs.length; ++i) {
                this.referenceList.appendItem(refs[i]);
            }
        }
        this.handlevalue.setType(value.getType());
        this.handlevalue.setTimestamp(value.getTimestamp());
        this.handlevalue.setData(value.getData());
    }

    @Override
    public void setIndex(int index) {
        this.indexField.setText(String.valueOf(index));
    }

    @Override
    public HandleValue getHandleValue() {
        this.handlevalue.setIndex(this.getIndex());
        this.handlevalue.setType(Util.encodeString(String.valueOf(this.typeField.getSelectedItem()).trim()));
        try {
            this.handlevalue.setTTL(Integer.parseInt(this.ttlField.getText().trim()));
            if (this.ttlTypeChoice.getSelectedIndex() == 0) {
                this.handlevalue.setTTLType((byte)0);
            } else {
                this.handlevalue.setTTLType((byte)1);
            }
        }
        catch (Exception e) {
            this.handlevalue.setTTL(-1);
        }
        this.handlevalue.setAdminCanRead(this.adminReadCheckbox.isSelected());
        this.handlevalue.setAdminCanWrite(this.adminWriteCheckbox.isSelected());
        this.handlevalue.setAnyoneCanRead(this.publicReadCheckbox.isSelected());
        this.handlevalue.setAnyoneCanWrite(this.publicWriteCheckbox.isSelected());
        Vector v = this.referenceList.getItems();
        ValueReference[] vr = new ValueReference[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            vr[i] = (ValueReference)v.elementAt(i);
        }
        this.handlevalue.setReferences(vr);
        return this.handlevalue;
    }

    @Override
    public int getIndex() {
        try {
            return Integer.parseInt(this.indexField.getText().trim());
        }
        catch (Exception e) {
            return -1;
        }
    }
}

