/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.gui.jwidget;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.security.PrivateKey;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import net.handle.apps.gui.jutil.HDLToolConfig;
import net.handle.apps.gui.jwidget.PublicKeyJPanel;
import net.handle.apps.gui.jwidget.SecretKeyJPanel;
import net.handle.awt.AwtUtil;
import net.handle.hdllib.AuthenticationInfo;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.PublicKeyAuthenticationInfo;
import net.handle.hdllib.SecretKeyAuthenticationInfo;
import net.handle.hdllib.Util;

public class AuthenJPanel
extends JPanel
implements ItemListener {
    protected JComboBox authTypeChoice = new JComboBox();
    protected SecretKeyJPanel secretKeyPanel;
    protected PublicKeyJPanel publicKeyPanel;
    protected JPanel detailPanel;
    protected CardLayout detailLayout;
    protected final String SECRET = "Secret Key";
    protected final String PUBLIC = "Public Key";
    protected HandleValue[] values = null;

    public AuthenJPanel() {
        super(new GridBagLayout());
        this.authTypeChoice.setToolTipText("Choose authentication type");
        this.authTypeChoice.setEditable(false);
        this.authTypeChoice.addItem("Public Key");
        this.authTypeChoice.addItem("Secret Key");
        this.authTypeChoice.addItemListener(this);
        this.secretKeyPanel = new SecretKeyJPanel();
        this.publicKeyPanel = new PublicKeyJPanel();
        this.detailPanel = new JPanel();
        this.detailLayout = new CardLayout();
        this.detailPanel.setLayout(this.detailLayout);
        this.detailPanel.add((Component)this.publicKeyPanel, "Public Key");
        this.detailPanel.add((Component)this.secretKeyPanel, "Secret Key");
        this.add((Component)new JLabel("  Authentication Type: ", 2), AwtUtil.getConstraints(0, 0, 0.0, 0.0, 1, 1, true, true));
        this.add((Component)this.authTypeChoice, AwtUtil.getConstraints(1, 0, 1.0, 0.0, 1, 1, false, false));
        this.add((Component)this.detailPanel, AwtUtil.getConstraints(0, 1, 1.0, 1.0, 2, 1, true, true));
    }

    @Override
    public void itemStateChanged(ItemEvent evt) {
        Object src = evt.getSource();
        if (src == this.authTypeChoice) {
            this.authTypeSelected();
        }
    }

    protected void authTypeSelected() {
        this.detailLayout.show(this.detailPanel, (String)this.authTypeChoice.getSelectedItem());
    }

    public void setAuthInfo(AuthenticationInfo authInfo) {
        if (authInfo == null) {
            return;
        }
        if (authInfo instanceof SecretKeyAuthenticationInfo) {
            SecretKeyAuthenticationInfo secAuth = (SecretKeyAuthenticationInfo)authInfo;
            this.authTypeChoice.setSelectedItem("Secret Key");
            this.authTypeSelected();
            this.secretKeyPanel.setUserIdHandle(Util.decodeString(secAuth.getUserIdHandle()));
            this.secretKeyPanel.setUserIdIndex(secAuth.getUserIdIndex());
        } else if (authInfo instanceof PublicKeyAuthenticationInfo) {
            PublicKeyAuthenticationInfo pubAuth = (PublicKeyAuthenticationInfo)authInfo;
            this.authTypeChoice.setSelectedItem("Public Key");
            this.authTypeSelected();
            this.publicKeyPanel.setUserIdHandle(Util.decodeString(pubAuth.getUserIdHandle()));
            this.publicKeyPanel.setUserIdIndex(pubAuth.getUserIdIndex());
        }
    }

    public AuthenticationInfo getAuthInfo() {
        if (((String)this.authTypeChoice.getSelectedItem()).equals("Secret Key")) {
            try {
                String hdl = this.secretKeyPanel.getUserIdHandle();
                byte[] userIdHandle = Util.encodeString(hdl);
                int userIdIndex = this.secretKeyPanel.getUserIdIndex();
                byte[] secretKey = Util.encodeString(new String(this.secretKeyPanel.getSecretKey()));
                HDLToolConfig.table.put("SecHandle", hdl);
                HDLToolConfig.table.put("SecIndex", String.valueOf(userIdIndex));
                HDLToolConfig.table.put("ShadowPass", this.secretKeyPanel.isHashedPasswordEnabled());
                HDLToolConfig.save();
                return new SecretKeyAuthenticationInfo(userIdHandle, userIdIndex, secretKey, this.secretKeyPanel.isHashedPasswordEnabled());
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, e.getMessage(), "Warning: ", 2);
                return null;
            }
        }
        if (((String)this.authTypeChoice.getSelectedItem()).equals("Public Key")) {
            try {
                String hdl = this.publicKeyPanel.getUserIdHandle();
                byte[] userIdHandle = Util.encodeString(hdl);
                int userIdIndex = this.publicKeyPanel.getUserIdIndex();
                PrivateKey privKey = this.publicKeyPanel.getPrivKey();
                if (privKey != null) {
                    HDLToolConfig.table.put("PubHandle", hdl);
                    HDLToolConfig.table.put("PubIndex", String.valueOf(userIdIndex));
                    HDLToolConfig.table.put("PrivKey", this.publicKeyPanel.getPrivKeyPath());
                    HDLToolConfig.save();
                    return new PublicKeyAuthenticationInfo(userIdHandle, userIdIndex, privKey);
                }
                return null;
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Invalid input, got exception: " + e, "Warning: ", 2);
                return null;
            }
        }
        return null;
    }

    public PrivateKey getPrivKey() {
        return this.publicKeyPanel.getPrivKey();
    }
}

